package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNetworkAclEntries invokes the vpc.UpdateNetworkAclEntries API synchronously
// api document: https://help.aliyun.com/api/vpc/updatenetworkaclentries.html
func (client *Client) UpdateNetworkAclEntries(request *UpdateNetworkAclEntriesRequest) (response *UpdateNetworkAclEntriesResponse, err error) {
	response = CreateUpdateNetworkAclEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNetworkAclEntriesWithChan invokes the vpc.UpdateNetworkAclEntries API asynchronously
// api document: https://help.aliyun.com/api/vpc/updatenetworkaclentries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateNetworkAclEntriesWithChan(request *UpdateNetworkAclEntriesRequest) (<-chan *UpdateNetworkAclEntriesResponse, <-chan error) {
	responseChan := make(chan *UpdateNetworkAclEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNetworkAclEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNetworkAclEntriesWithCallback invokes the vpc.UpdateNetworkAclEntries API asynchronously
// api document: https://help.aliyun.com/api/vpc/updatenetworkaclentries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateNetworkAclEntriesWithCallback(request *UpdateNetworkAclEntriesRequest, callback func(response *UpdateNetworkAclEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNetworkAclEntriesResponse
		var err error
		defer close(result)
		response, err = client.UpdateNetworkAclEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNetworkAclEntriesRequest is the request struct for api UpdateNetworkAclEntries
type UpdateNetworkAclEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer                            `position:"Query" name:"ResourceOwnerId"`
	EgressAclEntries        *[]UpdateNetworkAclEntriesEgressAclEntries  `position:"Query" name:"EgressAclEntries"  type:"Repeated"`
	ClientToken             string                                      `position:"Query" name:"ClientToken"`
	NetworkAclId            string                                      `position:"Query" name:"NetworkAclId"`
	UpdateIngressAclEntries requests.Boolean                            `position:"Query" name:"UpdateIngressAclEntries"`
	ResourceOwnerAccount    string                                      `position:"Query" name:"ResourceOwnerAccount"`
	UpdateEgressAclEntries  requests.Boolean                            `position:"Query" name:"UpdateEgressAclEntries"`
	OwnerId                 requests.Integer                            `position:"Query" name:"OwnerId"`
	IngressAclEntries       *[]UpdateNetworkAclEntriesIngressAclEntries `position:"Query" name:"IngressAclEntries"  type:"Repeated"`
}

// UpdateNetworkAclEntriesEgressAclEntries is a repeated param struct in UpdateNetworkAclEntriesRequest
type UpdateNetworkAclEntriesEgressAclEntries struct {
	NetworkAclEntryName string `name:"NetworkAclEntryName"`
	NetworkAclEntryId   string `name:"NetworkAclEntryId"`
	Policy              string `name:"Policy"`
	Protocol            string `name:"Protocol"`
	DestinationCidrIp   string `name:"DestinationCidrIp"`
	Port                string `name:"Port"`
	EntryType           string `name:"EntryType"`
	Description         string `name:"Description"`
}

// UpdateNetworkAclEntriesIngressAclEntries is a repeated param struct in UpdateNetworkAclEntriesRequest
type UpdateNetworkAclEntriesIngressAclEntries struct {
	NetworkAclEntryName string `name:"NetworkAclEntryName"`
	NetworkAclEntryId   string `name:"NetworkAclEntryId"`
	Policy              string `name:"Policy"`
	Protocol            string `name:"Protocol"`
	SourceCidrIp        string `name:"SourceCidrIp"`
	Port                string `name:"Port"`
	EntryType           string `name:"EntryType"`
	Description         string `name:"Description"`
}

// UpdateNetworkAclEntriesResponse is the response struct for api UpdateNetworkAclEntries
type UpdateNetworkAclEntriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateNetworkAclEntriesRequest creates a request to invoke UpdateNetworkAclEntries API
func CreateUpdateNetworkAclEntriesRequest() (request *UpdateNetworkAclEntriesRequest) {
	request = &UpdateNetworkAclEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateNetworkAclEntries", "vpc", "openAPI")
	return
}

// CreateUpdateNetworkAclEntriesResponse creates a response to parse from UpdateNetworkAclEntries response
func CreateUpdateNetworkAclEntriesResponse() (response *UpdateNetworkAclEntriesResponse) {
	response = &UpdateNetworkAclEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
