/*
Copyright 2017 Heptio Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"log"
  "os"

	"github.com/spf13/cobra/doc"
	"github.com/heptio/ark/pkg/cmd/ark"
)

func main() {
  cmdName := os.Args[1]
	outputDir := os.Args[2]

  cmd := ark.NewCommand(cmdName)
	// Remove auto-generated timestamps
	cmd.DisableAutoGenTag = true

	err := doc.GenMarkdownTree(cmd, outputDir)
	if err != nil {
		log.Fatal(err)
	}
}
