---
layout: "api"
page_title: "/sys/leases - HTTP API"
sidebar_title: "<code>/sys/leases</code>"
sidebar_current: "api-http-system-leases"
description: |-
  The `/sys/leases` endpoints are used to view and manage leases.
---

# `/sys/leases`

The `/sys/leases` endpoints are used to view and manage leases in Vault.

## Read Lease

This endpoint retrieve lease metadata.

| Method   | Path                          |
| :---------------------------- | :--------------------- |
| `PUT`    | `/sys/leases/lookup`          |

### Parameters

- `lease_id` `(string: <required>)` – Specifies the ID of the lease to lookup.

### Sample Payload

```json
{
  "lease_id": "aws/creds/deploy/abcd-1234..."
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request PUT \
    --data @payload.json \
    http://127.0.0.1:8200/v1/sys/leases/lookup
```

### Sample Response

```json
{
  "id": "auth/token/create/25c75065466dfc5f920525feafe47502c4c9915c",
  "issue_time": "2017-04-30T10:18:11.228946471-04:00",
  "expire_time": "2017-04-30T11:18:11.228946708-04:00",
  "last_renewal_time": null,
  "renewable": true,
  "ttl": 3558
}
```

## List Leases

This endpoint returns a list of lease ids.

**This endpoint requires 'sudo' capability.**

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `LIST`   | `/sys/leases/lookup/:prefix` |


### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request LIST \
    http://127.0.0.1:8200/v1/sys/leases/lookup/aws/creds/deploy/
```

### Sample Response

```json
{
  "data":{
    "keys":[
      "abcd-1234...",
      "efgh-1234...",
      "ijkl-1234..."
    ]
  }
}
```

## Renew Lease

This endpoint renews a lease, requesting to extend the lease.  Token leases 
cannot be renewed using this endpoint, use instead the auth/token/renew endpoint.

| Method   | Path                          |
| :---------------------------- | :--------------------- |
| `PUT`    | `/sys/leases/renew`           |

### Parameters

- `lease_id` `(string: <required>)` – Specifies the ID of the lease to extend.
  This can be specified as part of the URL or as part of the request body.

- `increment` `(int: 0)` – Specifies the requested amount of time (in seconds)
  to extend the lease.

### Sample Payload

```json
{
  "lease_id": "aws/creds/deploy/abcd-1234...",
  "increment": 1800
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request PUT \
    --data @payload.json \
    http://127.0.0.1:8200/v1/sys/leases/renew
```

### Sample Response

```json
{
  "lease_id": "aws/creds/deploy/abcd-1234...",
  "renewable": true,
  "lease_duration": 2764790
}
```

## Revoke Lease

This endpoint revokes a lease immediately.

| Method   | Path                          |
| :---------------------------- | :--------------------- |
| `PUT`    | `/sys/leases/revoke`          |

### Parameters

- `lease_id` `(string: <required>)` – Specifies the ID of the lease to revoke.

### Sample Payload

```json
{
  "lease_id": "postgresql/creds/readonly/abcd-1234..."
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request PUT \
    --data @payload.json \
    http://127.0.0.1:8200/v1/sys/leases/revoke
```

## Revoke Force

This endpoint revokes all secrets or tokens generated under a given prefix
immediately. Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors
encountered during revocation. This is _potentially very dangerous_ and should
only be used in specific emergency situations where errors in the backend or the
connected backend service prevent normal revocation.

By ignoring these errors, Vault abdicates responsibility for ensuring that the
issued credentials or secrets are properly revoked and/or cleaned up. Access to
this endpoint should be tightly controlled.

**This endpoint requires 'sudo' capability.**

| Method   | Path                                |
| :---------------------------------- | :--------------------- |
| `PUT`    | `/sys/leases/revoke-force/:prefix`  |

### Parameters

- `prefix` `(string: <required>)` – Specifies the prefix to revoke. This is
  specified as part of the URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request PUT \
    http://127.0.0.1:8200/v1/sys/leases/revoke-force/aws/creds
```

## Revoke Prefix

This endpoint revokes all secrets (via a lease ID prefix) or tokens (via the
tokens' path property) generated under a given prefix immediately. This requires
`sudo` capability and access to it should be tightly controlled as it can be
used to revoke very large numbers of secrets/tokens at once.

**This endpoint requires 'sudo' capability.**

| Method   | Path                                |
| :---------------------------------- | :--------------------- |
| `PUT`    | `/sys/leases/revoke-prefix/:prefix` |

### Parameters

- `prefix` `(string: <required>)` – Specifies the prefix to revoke. This is
  specified as part of the URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request PUT \
    http://127.0.0.1:8200/v1/sys/leases/revoke-prefix/aws/creds
```


## Tidy Leases

This endpoint cleans up the dangling storage entries for leases. Generally,
running this is not needed unless upgrade notes or support personnel suggest it.
This may perform a lot of I/O to the storage method so should be used sparingly.

| Method | Path               |
|:-------|:-------------------|
| `POST` | `/sys/leases/tidy` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    http://127.0.0.1:8200/v1/sys/leases/tidy
```