package mozillaEvaluationWorker

// saved TLS configurations, used as backup if
// online version is not available
var ServerSideTLSConfiguration = `{
    "configurations": {
        "modern": {
            "openssl_ciphersuites": "ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA256",
            "ciphersuites": [
                "ECDHE-ECDSA-AES256-GCM-SHA384",
                "ECDHE-RSA-AES256-GCM-SHA384",
                "ECDHE-ECDSA-CHACHA20-POLY1305",
                "ECDHE-RSA-CHACHA20-POLY1305",
                "ECDHE-ECDSA-AES128-GCM-SHA256",
                "ECDHE-RSA-AES128-GCM-SHA256",
                "ECDHE-ECDSA-AES256-SHA384",
                "ECDHE-RSA-AES256-SHA384",
                "ECDHE-ECDSA-AES128-SHA256",
                "ECDHE-RSA-AES128-SHA256"
            ],
            "tls_versions": ["TLSv1.2" ],
            "tls_curves": [ "prime256v1", "secp384r1", "secp521r1" ],
            "certificate_types": ["ecdsa"],
            "certificate_curves": ["prime256v1", "secp384r1", "secp521r1"],
            "certificate_signatures": ["sha256WithRSAEncryption", "ecdsa-with-SHA256", "ecdsa-with-SHA384", "ecdsa-with-SHA512"],
            "rsa_key_size": 2048,
            "dh_param_size": null,
            "ecdh_param_size": 256,
            "hsts_min_age": 15768000,
            "oldest_clients": [ "Firefox 27", "Chrome 30", "IE 11 on Windows 7", "Edge 1", "Opera 17", "Safari 9", "Android 5.0", "Java 8"]
        },
        "intermediate": {
            "openssl_ciphersuites": "ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA256:ECDHE-ECDSA-AES128-SHA:ECDHE-RSA-AES256-SHA384:ECDHE-RSA-AES128-SHA:ECDHE-ECDSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES128-SHA:DHE-RSA-AES256-SHA256:DHE-RSA-AES256-SHA:ECDHE-ECDSA-DES-CBC3-SHA:ECDHE-RSA-DES-CBC3-SHA:EDH-RSA-DES-CBC3-SHA:AES128-GCM-SHA256:AES256-GCM-SHA384:AES128-SHA256:AES256-SHA256:AES128-SHA:AES256-SHA:DES-CBC3-SHA:!DSS",
            "ciphersuites": [
                "ECDHE-ECDSA-CHACHA20-POLY1305",
                "ECDHE-RSA-CHACHA20-POLY1305",
                "ECDHE-ECDSA-AES128-GCM-SHA256",
                "ECDHE-RSA-AES128-GCM-SHA256",
                "ECDHE-ECDSA-AES256-GCM-SHA384",
                "ECDHE-RSA-AES256-GCM-SHA384",
                "DHE-RSA-AES128-GCM-SHA256",
                "DHE-RSA-AES256-GCM-SHA384",
                "ECDHE-ECDSA-AES128-SHA256",
                "ECDHE-RSA-AES128-SHA256",
                "ECDHE-ECDSA-AES128-SHA",
                "ECDHE-RSA-AES256-SHA384",
                "ECDHE-RSA-AES128-SHA",
                "ECDHE-ECDSA-AES256-SHA384",
                "ECDHE-ECDSA-AES256-SHA",
                "ECDHE-RSA-AES256-SHA",
                "DHE-RSA-AES128-SHA256",
                "DHE-RSA-AES128-SHA",
                "DHE-RSA-AES256-SHA256",
                "DHE-RSA-AES256-SHA",
                "ECDHE-ECDSA-DES-CBC3-SHA",
                "ECDHE-RSA-DES-CBC3-SHA",
                "EDH-RSA-DES-CBC3-SHA",
                "AES128-GCM-SHA256",
                "AES256-GCM-SHA384",
                "AES128-SHA256",
                "AES256-SHA256",
                "AES128-SHA",
                "AES256-SHA",
                "DES-CBC3-SHA"
            ],
            "tls_versions": ["TLSv1.2", "TLSv1.1", "TLSv1" ],
            "tls_curves": [ "secp256r1", "secp384r1", "secp521r1" ],
            "certificate_types": ["rsa"],
            "certificate_curves": null,
            "certificate_signatures": ["sha256WithRSAEncryption"],
            "rsa_key_size": 2048,
            "dh_param_size": 2048,
            "ecdh_param_size": 256,
            "hsts_min_age": 15768000,
            "oldest_clients": [ "Firefox 1", "Chrome 1", "IE 7", "Opera 5", "Safari 1", "Windows XP IE8", "Android 2.3", "Java 7" ]
        },
        "old": {
            "openssl_ciphersuites": "ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256:DHE-DSS-AES128-GCM-SHA256:kEDH+AESGCM:ECDHE-RSA-AES128-SHA256:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA:ECDHE-ECDSA-AES128-SHA:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES256-SHA:ECDHE-ECDSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES128-SHA:DHE-DSS-AES128-SHA256:DHE-RSA-AES256-SHA256:DHE-DSS-AES256-SHA:DHE-RSA-AES256-SHA:ECDHE-RSA-DES-CBC3-SHA:ECDHE-ECDSA-DES-CBC3-SHA:EDH-RSA-DES-CBC3-SHA:AES128-GCM-SHA256:AES256-GCM-SHA384:AES128-SHA256:AES256-SHA256:AES128-SHA:AES256-SHA:AES:DES-CBC3-SHA:HIGH:SEED:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!PSK:!RSAPSK:!aDH:!aECDH:!EDH-DSS-DES-CBC3-SHA:!KRB5-DES-CBC3-SHA:!SRP",
            "ciphersuites": [
                "ECDHE-ECDSA-CHACHA20-POLY1305",
                "ECDHE-RSA-CHACHA20-POLY1305",
                "ECDHE-RSA-AES128-GCM-SHA256",
                "ECDHE-ECDSA-AES128-GCM-SHA256",
                "ECDHE-RSA-AES256-GCM-SHA384",
                "ECDHE-ECDSA-AES256-GCM-SHA384",
                "DHE-RSA-AES128-GCM-SHA256",
                "DHE-DSS-AES128-GCM-SHA256",
                "DHE-DSS-AES256-GCM-SHA384",
                "DHE-RSA-AES256-GCM-SHA384",
                "ECDHE-RSA-AES128-SHA256",
                "ECDHE-ECDSA-AES128-SHA256",
                "ECDHE-RSA-AES128-SHA",
                "ECDHE-ECDSA-AES128-SHA",
                "ECDHE-RSA-AES256-SHA384",
                "ECDHE-ECDSA-AES256-SHA384",
                "ECDHE-RSA-AES256-SHA",
                "ECDHE-ECDSA-AES256-SHA",
                "DHE-RSA-AES128-SHA256",
                "DHE-RSA-AES128-SHA",
                "DHE-DSS-AES128-SHA256",
                "DHE-RSA-AES256-SHA256",
                "DHE-DSS-AES256-SHA",
                "DHE-RSA-AES256-SHA",
                "ECDHE-RSA-DES-CBC3-SHA",
                "ECDHE-ECDSA-DES-CBC3-SHA",
                "EDH-RSA-DES-CBC3-SHA",
                "AES128-GCM-SHA256",
                "AES256-GCM-SHA384",
                "AES128-SHA256",
                "AES256-SHA256",
                "AES128-SHA",
                "AES256-SHA",
                "DHE-DSS-AES256-SHA256",
                "DHE-DSS-AES128-SHA",
                "DES-CBC3-SHA",
                "DHE-RSA-CHACHA20-POLY1305",
                "ECDHE-RSA-CAMELLIA256-SHA384",
                "ECDHE-ECDSA-CAMELLIA256-SHA384",
                "DHE-RSA-CAMELLIA256-SHA256",
                "DHE-DSS-CAMELLIA256-SHA256",
                "DHE-RSA-CAMELLIA256-SHA",
                "DHE-DSS-CAMELLIA256-SHA",
                "CAMELLIA256-SHA256",
                "CAMELLIA256-SHA",
                "ECDHE-RSA-CAMELLIA128-SHA256",
                "ECDHE-ECDSA-CAMELLIA128-SHA256",
                "DHE-RSA-CAMELLIA128-SHA256",
                "DHE-DSS-CAMELLIA128-SHA256",
                "DHE-RSA-CAMELLIA128-SHA",
                "DHE-DSS-CAMELLIA128-SHA",
                "CAMELLIA128-SHA256",
                "CAMELLIA128-SHA",
                "DHE-RSA-SEED-SHA",
                "DHE-DSS-SEED-SHA",
                "SEED-SHA"
            ],
            "tls_versions": ["TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3" ],
            "tls_curves": [ "secp256r1", "secp384r1", "secp521r1" ],
            "certificate_types": ["rsa"],
            "certificate_curves": null,
            "certificate_signatures": ["sha1WithRSAEncryption"],
            "rsa_key_size": 2048,
            "dh_param_size": 1024,
            "ecdh_param_size": 160,
            "hsts_min_age": 15768000,
            "oldest_clients": [ "Firefox 1", "Chrome 1", "Windows XP IE 6", "Opera 4", "Safari 1", "Java 6" ]
        }
    },
    "version": 4.0
}`
