// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package network

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2019-09-01/network"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type Access = original.Access

const (
	Allow Access = original.Allow
	Deny  Access = original.Deny
)

type ApplicationGatewayBackendHealthServerHealth = original.ApplicationGatewayBackendHealthServerHealth

const (
	Down     ApplicationGatewayBackendHealthServerHealth = original.Down
	Draining ApplicationGatewayBackendHealthServerHealth = original.Draining
	Partial  ApplicationGatewayBackendHealthServerHealth = original.Partial
	Unknown  ApplicationGatewayBackendHealthServerHealth = original.Unknown
	Up       ApplicationGatewayBackendHealthServerHealth = original.Up
)

type ApplicationGatewayCookieBasedAffinity = original.ApplicationGatewayCookieBasedAffinity

const (
	Disabled ApplicationGatewayCookieBasedAffinity = original.Disabled
	Enabled  ApplicationGatewayCookieBasedAffinity = original.Enabled
)

type ApplicationGatewayCustomErrorStatusCode = original.ApplicationGatewayCustomErrorStatusCode

const (
	HTTPStatus403 ApplicationGatewayCustomErrorStatusCode = original.HTTPStatus403
	HTTPStatus502 ApplicationGatewayCustomErrorStatusCode = original.HTTPStatus502
)

type ApplicationGatewayFirewallMode = original.ApplicationGatewayFirewallMode

const (
	Detection  ApplicationGatewayFirewallMode = original.Detection
	Prevention ApplicationGatewayFirewallMode = original.Prevention
)

type ApplicationGatewayOperationalState = original.ApplicationGatewayOperationalState

const (
	Running  ApplicationGatewayOperationalState = original.Running
	Starting ApplicationGatewayOperationalState = original.Starting
	Stopped  ApplicationGatewayOperationalState = original.Stopped
	Stopping ApplicationGatewayOperationalState = original.Stopping
)

type ApplicationGatewayProtocol = original.ApplicationGatewayProtocol

const (
	HTTP  ApplicationGatewayProtocol = original.HTTP
	HTTPS ApplicationGatewayProtocol = original.HTTPS
)

type ApplicationGatewayRedirectType = original.ApplicationGatewayRedirectType

const (
	Found     ApplicationGatewayRedirectType = original.Found
	Permanent ApplicationGatewayRedirectType = original.Permanent
	SeeOther  ApplicationGatewayRedirectType = original.SeeOther
	Temporary ApplicationGatewayRedirectType = original.Temporary
)

type ApplicationGatewayRequestRoutingRuleType = original.ApplicationGatewayRequestRoutingRuleType

const (
	Basic            ApplicationGatewayRequestRoutingRuleType = original.Basic
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = original.PathBasedRouting
)

type ApplicationGatewaySkuName = original.ApplicationGatewaySkuName

const (
	StandardLarge  ApplicationGatewaySkuName = original.StandardLarge
	StandardMedium ApplicationGatewaySkuName = original.StandardMedium
	StandardSmall  ApplicationGatewaySkuName = original.StandardSmall
	StandardV2     ApplicationGatewaySkuName = original.StandardV2
	WAFLarge       ApplicationGatewaySkuName = original.WAFLarge
	WAFMedium      ApplicationGatewaySkuName = original.WAFMedium
	WAFV2          ApplicationGatewaySkuName = original.WAFV2
)

type ApplicationGatewaySslCipherSuite = original.ApplicationGatewaySslCipherSuite

const (
	TLSDHEDSSWITH3DESEDECBCSHA       ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITH3DESEDECBCSHA
	TLSDHEDSSWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA
	TLSDHEDSSWITHAES128CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA256
	TLSDHEDSSWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA
	TLSDHEDSSWITHAES256CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA256
	TLSDHERSAWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128CBCSHA
	TLSDHERSAWITHAES128GCMSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128GCMSHA256
	TLSDHERSAWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256CBCSHA
	TLSDHERSAWITHAES256GCMSHA384     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256GCMSHA384
	TLSECDHEECDSAWITHAES128CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA
	TLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA256
	TLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128GCMSHA256
	TLSECDHEECDSAWITHAES256CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA
	TLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA384
	TLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256GCMSHA384
	TLSECDHERSAWITHAES128CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA
	TLSECDHERSAWITHAES128CBCSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA256
	TLSECDHERSAWITHAES128GCMSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128GCMSHA256
	TLSECDHERSAWITHAES256CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA
	TLSECDHERSAWITHAES256CBCSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA384
	TLSECDHERSAWITHAES256GCMSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256GCMSHA384
	TLSRSAWITH3DESEDECBCSHA          ApplicationGatewaySslCipherSuite = original.TLSRSAWITH3DESEDECBCSHA
	TLSRSAWITHAES128CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA
	TLSRSAWITHAES128CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA256
	TLSRSAWITHAES128GCMSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128GCMSHA256
	TLSRSAWITHAES256CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA
	TLSRSAWITHAES256CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA256
	TLSRSAWITHAES256GCMSHA384        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256GCMSHA384
)

type ApplicationGatewaySslPolicyName = original.ApplicationGatewaySslPolicyName

const (
	AppGwSslPolicy20150501  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20150501
	AppGwSslPolicy20170401  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401
	AppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401S
)

type ApplicationGatewaySslPolicyType = original.ApplicationGatewaySslPolicyType

const (
	Custom     ApplicationGatewaySslPolicyType = original.Custom
	Predefined ApplicationGatewaySslPolicyType = original.Predefined
)

type ApplicationGatewaySslProtocol = original.ApplicationGatewaySslProtocol

const (
	TLSv10 ApplicationGatewaySslProtocol = original.TLSv10
	TLSv11 ApplicationGatewaySslProtocol = original.TLSv11
	TLSv12 ApplicationGatewaySslProtocol = original.TLSv12
)

type ApplicationGatewayTier = original.ApplicationGatewayTier

const (
	ApplicationGatewayTierStandard   ApplicationGatewayTier = original.ApplicationGatewayTierStandard
	ApplicationGatewayTierStandardV2 ApplicationGatewayTier = original.ApplicationGatewayTierStandardV2
	ApplicationGatewayTierWAF        ApplicationGatewayTier = original.ApplicationGatewayTierWAF
	ApplicationGatewayTierWAFV2      ApplicationGatewayTier = original.ApplicationGatewayTierWAFV2
)

type AssociationType = original.AssociationType

const (
	Associated AssociationType = original.Associated
	Contains   AssociationType = original.Contains
)

type AuthenticationMethod = original.AuthenticationMethod

const (
	EAPMSCHAPv2 AuthenticationMethod = original.EAPMSCHAPv2
	EAPTLS      AuthenticationMethod = original.EAPTLS
)

type AuthorizationUseStatus = original.AuthorizationUseStatus

const (
	Available AuthorizationUseStatus = original.Available
	InUse     AuthorizationUseStatus = original.InUse
)

type AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolType

const (
	AzureFirewallApplicationRuleProtocolTypeHTTP  AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolTypeHTTP
	AzureFirewallApplicationRuleProtocolTypeHTTPS AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolTypeHTTPS
	AzureFirewallApplicationRuleProtocolTypeMssql AzureFirewallApplicationRuleProtocolType = original.AzureFirewallApplicationRuleProtocolTypeMssql
)

type AzureFirewallNatRCActionType = original.AzureFirewallNatRCActionType

const (
	Dnat AzureFirewallNatRCActionType = original.Dnat
	Snat AzureFirewallNatRCActionType = original.Snat
)

type AzureFirewallNetworkRuleProtocol = original.AzureFirewallNetworkRuleProtocol

const (
	Any  AzureFirewallNetworkRuleProtocol = original.Any
	ICMP AzureFirewallNetworkRuleProtocol = original.ICMP
	TCP  AzureFirewallNetworkRuleProtocol = original.TCP
	UDP  AzureFirewallNetworkRuleProtocol = original.UDP
)

type AzureFirewallRCActionType = original.AzureFirewallRCActionType

const (
	AzureFirewallRCActionTypeAllow AzureFirewallRCActionType = original.AzureFirewallRCActionTypeAllow
	AzureFirewallRCActionTypeDeny  AzureFirewallRCActionType = original.AzureFirewallRCActionTypeDeny
)

type AzureFirewallSkuName = original.AzureFirewallSkuName

const (
	AZFWHub  AzureFirewallSkuName = original.AZFWHub
	AZFWVNet AzureFirewallSkuName = original.AZFWVNet
)

type AzureFirewallSkuTier = original.AzureFirewallSkuTier

const (
	Standard AzureFirewallSkuTier = original.Standard
)

type AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelMode

const (
	AzureFirewallThreatIntelModeAlert AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelModeAlert
	AzureFirewallThreatIntelModeDeny  AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelModeDeny
	AzureFirewallThreatIntelModeOff   AzureFirewallThreatIntelMode = original.AzureFirewallThreatIntelModeOff
)

type BgpPeerState = original.BgpPeerState

const (
	BgpPeerStateConnected  BgpPeerState = original.BgpPeerStateConnected
	BgpPeerStateConnecting BgpPeerState = original.BgpPeerStateConnecting
	BgpPeerStateIdle       BgpPeerState = original.BgpPeerStateIdle
	BgpPeerStateStopped    BgpPeerState = original.BgpPeerStateStopped
	BgpPeerStateUnknown    BgpPeerState = original.BgpPeerStateUnknown
)

type CircuitConnectionStatus = original.CircuitConnectionStatus

const (
	Connected    CircuitConnectionStatus = original.Connected
	Connecting   CircuitConnectionStatus = original.Connecting
	Disconnected CircuitConnectionStatus = original.Disconnected
)

type ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatus

const (
	ConnectionMonitorSourceStatusActive   ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatusActive
	ConnectionMonitorSourceStatusInactive ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatusInactive
	ConnectionMonitorSourceStatusUnknown  ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatusUnknown
)

type ConnectionState = original.ConnectionState

const (
	ConnectionStateReachable   ConnectionState = original.ConnectionStateReachable
	ConnectionStateUnknown     ConnectionState = original.ConnectionStateUnknown
	ConnectionStateUnreachable ConnectionState = original.ConnectionStateUnreachable
)

type ConnectionStatus = original.ConnectionStatus

const (
	ConnectionStatusConnected    ConnectionStatus = original.ConnectionStatusConnected
	ConnectionStatusDegraded     ConnectionStatus = original.ConnectionStatusDegraded
	ConnectionStatusDisconnected ConnectionStatus = original.ConnectionStatusDisconnected
	ConnectionStatusUnknown      ConnectionStatus = original.ConnectionStatusUnknown
)

type DdosCustomPolicyProtocol = original.DdosCustomPolicyProtocol

const (
	DdosCustomPolicyProtocolSyn DdosCustomPolicyProtocol = original.DdosCustomPolicyProtocolSyn
	DdosCustomPolicyProtocolTCP DdosCustomPolicyProtocol = original.DdosCustomPolicyProtocolTCP
	DdosCustomPolicyProtocolUDP DdosCustomPolicyProtocol = original.DdosCustomPolicyProtocolUDP
)

type DdosCustomPolicyTriggerSensitivityOverride = original.DdosCustomPolicyTriggerSensitivityOverride

const (
	Default DdosCustomPolicyTriggerSensitivityOverride = original.Default
	High    DdosCustomPolicyTriggerSensitivityOverride = original.High
	Low     DdosCustomPolicyTriggerSensitivityOverride = original.Low
	Relaxed DdosCustomPolicyTriggerSensitivityOverride = original.Relaxed
)

type DdosSettingsProtectionCoverage = original.DdosSettingsProtectionCoverage

const (
	DdosSettingsProtectionCoverageBasic    DdosSettingsProtectionCoverage = original.DdosSettingsProtectionCoverageBasic
	DdosSettingsProtectionCoverageStandard DdosSettingsProtectionCoverage = original.DdosSettingsProtectionCoverageStandard
)

type DhGroup = original.DhGroup

const (
	DHGroup1    DhGroup = original.DHGroup1
	DHGroup14   DhGroup = original.DHGroup14
	DHGroup2    DhGroup = original.DHGroup2
	DHGroup2048 DhGroup = original.DHGroup2048
	DHGroup24   DhGroup = original.DHGroup24
	ECP256      DhGroup = original.ECP256
	ECP384      DhGroup = original.ECP384
	None        DhGroup = original.None
)

type Direction = original.Direction

const (
	Inbound  Direction = original.Inbound
	Outbound Direction = original.Outbound
)

type EffectiveRouteSource = original.EffectiveRouteSource

const (
	EffectiveRouteSourceDefault               EffectiveRouteSource = original.EffectiveRouteSourceDefault
	EffectiveRouteSourceUnknown               EffectiveRouteSource = original.EffectiveRouteSourceUnknown
	EffectiveRouteSourceUser                  EffectiveRouteSource = original.EffectiveRouteSourceUser
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = original.EffectiveRouteSourceVirtualNetworkGateway
)

type EffectiveRouteState = original.EffectiveRouteState

const (
	Active  EffectiveRouteState = original.Active
	Invalid EffectiveRouteState = original.Invalid
)

type EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocol

const (
	EffectiveSecurityRuleProtocolAll EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocolAll
	EffectiveSecurityRuleProtocolTCP EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocolTCP
	EffectiveSecurityRuleProtocolUDP EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocolUDP
)

type EvaluationState = original.EvaluationState

const (
	Completed  EvaluationState = original.Completed
	InProgress EvaluationState = original.InProgress
	NotStarted EvaluationState = original.NotStarted
)

type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState

const (
	Configured       ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configured
	Configuring      ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configuring
	NotConfigured    ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.NotConfigured
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ValidationNeeded
)

type ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringState

const (
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateDisabled
	ExpressRouteCircuitPeeringStateEnabled  ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateEnabled
)

type ExpressRouteCircuitSkuFamily = original.ExpressRouteCircuitSkuFamily

const (
	MeteredData   ExpressRouteCircuitSkuFamily = original.MeteredData
	UnlimitedData ExpressRouteCircuitSkuFamily = original.UnlimitedData
)

type ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTier

const (
	ExpressRouteCircuitSkuTierBasic    ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierBasic
	ExpressRouteCircuitSkuTierLocal    ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierLocal
	ExpressRouteCircuitSkuTierPremium  ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierPremium
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierStandard
)

type ExpressRouteLinkAdminState = original.ExpressRouteLinkAdminState

const (
	ExpressRouteLinkAdminStateDisabled ExpressRouteLinkAdminState = original.ExpressRouteLinkAdminStateDisabled
	ExpressRouteLinkAdminStateEnabled  ExpressRouteLinkAdminState = original.ExpressRouteLinkAdminStateEnabled
)

type ExpressRouteLinkConnectorType = original.ExpressRouteLinkConnectorType

const (
	LC ExpressRouteLinkConnectorType = original.LC
	SC ExpressRouteLinkConnectorType = original.SC
)

type ExpressRouteLinkMacSecCipher = original.ExpressRouteLinkMacSecCipher

const (
	GcmAes128 ExpressRouteLinkMacSecCipher = original.GcmAes128
	GcmAes256 ExpressRouteLinkMacSecCipher = original.GcmAes256
)

type ExpressRoutePeeringState = original.ExpressRoutePeeringState

const (
	ExpressRoutePeeringStateDisabled ExpressRoutePeeringState = original.ExpressRoutePeeringStateDisabled
	ExpressRoutePeeringStateEnabled  ExpressRoutePeeringState = original.ExpressRoutePeeringStateEnabled
)

type ExpressRoutePeeringType = original.ExpressRoutePeeringType

const (
	AzurePrivatePeering ExpressRoutePeeringType = original.AzurePrivatePeering
	AzurePublicPeering  ExpressRoutePeeringType = original.AzurePublicPeering
	MicrosoftPeering    ExpressRoutePeeringType = original.MicrosoftPeering
)

type ExpressRoutePortsEncapsulation = original.ExpressRoutePortsEncapsulation

const (
	Dot1Q ExpressRoutePortsEncapsulation = original.Dot1Q
	QinQ  ExpressRoutePortsEncapsulation = original.QinQ
)

type FirewallPolicyFilterRuleActionType = original.FirewallPolicyFilterRuleActionType

const (
	FirewallPolicyFilterRuleActionTypeAllow FirewallPolicyFilterRuleActionType = original.FirewallPolicyFilterRuleActionTypeAllow
	FirewallPolicyFilterRuleActionTypeDeny  FirewallPolicyFilterRuleActionType = original.FirewallPolicyFilterRuleActionTypeDeny
)

type FirewallPolicyNatRuleActionType = original.FirewallPolicyNatRuleActionType

const (
	DNAT FirewallPolicyNatRuleActionType = original.DNAT
)

type FirewallPolicyRuleConditionApplicationProtocolType = original.FirewallPolicyRuleConditionApplicationProtocolType

const (
	FirewallPolicyRuleConditionApplicationProtocolTypeHTTP  FirewallPolicyRuleConditionApplicationProtocolType = original.FirewallPolicyRuleConditionApplicationProtocolTypeHTTP
	FirewallPolicyRuleConditionApplicationProtocolTypeHTTPS FirewallPolicyRuleConditionApplicationProtocolType = original.FirewallPolicyRuleConditionApplicationProtocolTypeHTTPS
)

type FirewallPolicyRuleConditionNetworkProtocol = original.FirewallPolicyRuleConditionNetworkProtocol

const (
	FirewallPolicyRuleConditionNetworkProtocolAny  FirewallPolicyRuleConditionNetworkProtocol = original.FirewallPolicyRuleConditionNetworkProtocolAny
	FirewallPolicyRuleConditionNetworkProtocolICMP FirewallPolicyRuleConditionNetworkProtocol = original.FirewallPolicyRuleConditionNetworkProtocolICMP
	FirewallPolicyRuleConditionNetworkProtocolTCP  FirewallPolicyRuleConditionNetworkProtocol = original.FirewallPolicyRuleConditionNetworkProtocolTCP
	FirewallPolicyRuleConditionNetworkProtocolUDP  FirewallPolicyRuleConditionNetworkProtocol = original.FirewallPolicyRuleConditionNetworkProtocolUDP
)

type FlowLogFormatType = original.FlowLogFormatType

const (
	JSON FlowLogFormatType = original.JSON
)

type HTTPMethod = original.HTTPMethod

const (
	Get HTTPMethod = original.Get
)

type HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatus

const (
	HubVirtualNetworkConnectionStatusConnected    HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusConnected
	HubVirtualNetworkConnectionStatusConnecting   HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusConnecting
	HubVirtualNetworkConnectionStatusNotConnected HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusNotConnected
	HubVirtualNetworkConnectionStatusUnknown      HubVirtualNetworkConnectionStatus = original.HubVirtualNetworkConnectionStatusUnknown
)

type IPAllocationMethod = original.IPAllocationMethod

const (
	Dynamic IPAllocationMethod = original.Dynamic
	Static  IPAllocationMethod = original.Static
)

type IPFlowProtocol = original.IPFlowProtocol

const (
	IPFlowProtocolTCP IPFlowProtocol = original.IPFlowProtocolTCP
	IPFlowProtocolUDP IPFlowProtocol = original.IPFlowProtocolUDP
)

type IPVersion = original.IPVersion

const (
	IPv4 IPVersion = original.IPv4
	IPv6 IPVersion = original.IPv6
)

type IkeEncryption = original.IkeEncryption

const (
	AES128    IkeEncryption = original.AES128
	AES192    IkeEncryption = original.AES192
	AES256    IkeEncryption = original.AES256
	DES       IkeEncryption = original.DES
	DES3      IkeEncryption = original.DES3
	GCMAES128 IkeEncryption = original.GCMAES128
	GCMAES256 IkeEncryption = original.GCMAES256
)

type IkeIntegrity = original.IkeIntegrity

const (
	IkeIntegrityGCMAES128 IkeIntegrity = original.IkeIntegrityGCMAES128
	IkeIntegrityGCMAES256 IkeIntegrity = original.IkeIntegrityGCMAES256
	IkeIntegrityMD5       IkeIntegrity = original.IkeIntegrityMD5
	IkeIntegritySHA1      IkeIntegrity = original.IkeIntegritySHA1
	IkeIntegritySHA256    IkeIntegrity = original.IkeIntegritySHA256
	IkeIntegritySHA384    IkeIntegrity = original.IkeIntegritySHA384
)

type IpsecEncryption = original.IpsecEncryption

const (
	IpsecEncryptionAES128    IpsecEncryption = original.IpsecEncryptionAES128
	IpsecEncryptionAES192    IpsecEncryption = original.IpsecEncryptionAES192
	IpsecEncryptionAES256    IpsecEncryption = original.IpsecEncryptionAES256
	IpsecEncryptionDES       IpsecEncryption = original.IpsecEncryptionDES
	IpsecEncryptionDES3      IpsecEncryption = original.IpsecEncryptionDES3
	IpsecEncryptionGCMAES128 IpsecEncryption = original.IpsecEncryptionGCMAES128
	IpsecEncryptionGCMAES192 IpsecEncryption = original.IpsecEncryptionGCMAES192
	IpsecEncryptionGCMAES256 IpsecEncryption = original.IpsecEncryptionGCMAES256
	IpsecEncryptionNone      IpsecEncryption = original.IpsecEncryptionNone
)

type IpsecIntegrity = original.IpsecIntegrity

const (
	IpsecIntegrityGCMAES128 IpsecIntegrity = original.IpsecIntegrityGCMAES128
	IpsecIntegrityGCMAES192 IpsecIntegrity = original.IpsecIntegrityGCMAES192
	IpsecIntegrityGCMAES256 IpsecIntegrity = original.IpsecIntegrityGCMAES256
	IpsecIntegrityMD5       IpsecIntegrity = original.IpsecIntegrityMD5
	IpsecIntegritySHA1      IpsecIntegrity = original.IpsecIntegritySHA1
	IpsecIntegritySHA256    IpsecIntegrity = original.IpsecIntegritySHA256
)

type IssueType = original.IssueType

const (
	IssueTypeAgentStopped        IssueType = original.IssueTypeAgentStopped
	IssueTypeDNSResolution       IssueType = original.IssueTypeDNSResolution
	IssueTypeGuestFirewall       IssueType = original.IssueTypeGuestFirewall
	IssueTypeNetworkSecurityRule IssueType = original.IssueTypeNetworkSecurityRule
	IssueTypePlatform            IssueType = original.IssueTypePlatform
	IssueTypePortThrottled       IssueType = original.IssueTypePortThrottled
	IssueTypeSocketBind          IssueType = original.IssueTypeSocketBind
	IssueTypeUnknown             IssueType = original.IssueTypeUnknown
	IssueTypeUserDefinedRoute    IssueType = original.IssueTypeUserDefinedRoute
)

type LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocol

const (
	LoadBalancerOutboundRuleProtocolAll LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocolAll
	LoadBalancerOutboundRuleProtocolTCP LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocolTCP
	LoadBalancerOutboundRuleProtocolUDP LoadBalancerOutboundRuleProtocol = original.LoadBalancerOutboundRuleProtocolUDP
)

type LoadBalancerSkuName = original.LoadBalancerSkuName

const (
	LoadBalancerSkuNameBasic    LoadBalancerSkuName = original.LoadBalancerSkuNameBasic
	LoadBalancerSkuNameStandard LoadBalancerSkuName = original.LoadBalancerSkuNameStandard
)

type LoadDistribution = original.LoadDistribution

const (
	LoadDistributionDefault          LoadDistribution = original.LoadDistributionDefault
	LoadDistributionSourceIP         LoadDistribution = original.LoadDistributionSourceIP
	LoadDistributionSourceIPProtocol LoadDistribution = original.LoadDistributionSourceIPProtocol
)

type ManagedRuleEnabledState = original.ManagedRuleEnabledState

const (
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = original.ManagedRuleEnabledStateDisabled
)

type NatGatewaySkuName = original.NatGatewaySkuName

const (
	NatGatewaySkuNameStandard NatGatewaySkuName = original.NatGatewaySkuNameStandard
)

type NextHopType = original.NextHopType

const (
	NextHopTypeHyperNetGateway       NextHopType = original.NextHopTypeHyperNetGateway
	NextHopTypeInternet              NextHopType = original.NextHopTypeInternet
	NextHopTypeNone                  NextHopType = original.NextHopTypeNone
	NextHopTypeVirtualAppliance      NextHopType = original.NextHopTypeVirtualAppliance
	NextHopTypeVirtualNetworkGateway NextHopType = original.NextHopTypeVirtualNetworkGateway
	NextHopTypeVnetLocal             NextHopType = original.NextHopTypeVnetLocal
)

type OfficeTrafficCategory = original.OfficeTrafficCategory

const (
	OfficeTrafficCategoryAll              OfficeTrafficCategory = original.OfficeTrafficCategoryAll
	OfficeTrafficCategoryNone             OfficeTrafficCategory = original.OfficeTrafficCategoryNone
	OfficeTrafficCategoryOptimize         OfficeTrafficCategory = original.OfficeTrafficCategoryOptimize
	OfficeTrafficCategoryOptimizeAndAllow OfficeTrafficCategory = original.OfficeTrafficCategoryOptimizeAndAllow
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type Origin = original.Origin

const (
	OriginInbound  Origin = original.OriginInbound
	OriginLocal    Origin = original.OriginLocal
	OriginOutbound Origin = original.OriginOutbound
)

type OwaspCrsExclusionEntryMatchVariable = original.OwaspCrsExclusionEntryMatchVariable

const (
	RequestArgNames    OwaspCrsExclusionEntryMatchVariable = original.RequestArgNames
	RequestCookieNames OwaspCrsExclusionEntryMatchVariable = original.RequestCookieNames
	RequestHeaderNames OwaspCrsExclusionEntryMatchVariable = original.RequestHeaderNames
)

type OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperator

const (
	OwaspCrsExclusionEntrySelectorMatchOperatorContains   OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorContains
	OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith   OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith
	OwaspCrsExclusionEntrySelectorMatchOperatorEquals     OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorEquals
	OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny  OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorEqualsAny
	OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith OwaspCrsExclusionEntrySelectorMatchOperator = original.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith
)

type PcError = original.PcError

const (
	AgentStopped    PcError = original.AgentStopped
	CaptureFailed   PcError = original.CaptureFailed
	InternalError   PcError = original.InternalError
	LocalFileFailed PcError = original.LocalFileFailed
	StorageFailed   PcError = original.StorageFailed
)

type PcProtocol = original.PcProtocol

const (
	PcProtocolAny PcProtocol = original.PcProtocolAny
	PcProtocolTCP PcProtocol = original.PcProtocolTCP
	PcProtocolUDP PcProtocol = original.PcProtocolUDP
)

type PcStatus = original.PcStatus

const (
	PcStatusError      PcStatus = original.PcStatusError
	PcStatusNotStarted PcStatus = original.PcStatusNotStarted
	PcStatusRunning    PcStatus = original.PcStatusRunning
	PcStatusStopped    PcStatus = original.PcStatusStopped
	PcStatusUnknown    PcStatus = original.PcStatusUnknown
)

type PfsGroup = original.PfsGroup

const (
	PfsGroupECP256  PfsGroup = original.PfsGroupECP256
	PfsGroupECP384  PfsGroup = original.PfsGroupECP384
	PfsGroupNone    PfsGroup = original.PfsGroupNone
	PfsGroupPFS1    PfsGroup = original.PfsGroupPFS1
	PfsGroupPFS14   PfsGroup = original.PfsGroupPFS14
	PfsGroupPFS2    PfsGroup = original.PfsGroupPFS2
	PfsGroupPFS2048 PfsGroup = original.PfsGroupPFS2048
	PfsGroupPFS24   PfsGroup = original.PfsGroupPFS24
	PfsGroupPFSMM   PfsGroup = original.PfsGroupPFSMM
)

type ProbeProtocol = original.ProbeProtocol

const (
	ProbeProtocolHTTP  ProbeProtocol = original.ProbeProtocolHTTP
	ProbeProtocolHTTPS ProbeProtocol = original.ProbeProtocolHTTPS
	ProbeProtocolTCP   ProbeProtocol = original.ProbeProtocolTCP
)

type ProcessorArchitecture = original.ProcessorArchitecture

const (
	Amd64 ProcessorArchitecture = original.Amd64
	X86   ProcessorArchitecture = original.X86
)

type Protocol = original.Protocol

const (
	ProtocolHTTP  Protocol = original.ProtocolHTTP
	ProtocolHTTPS Protocol = original.ProtocolHTTPS
	ProtocolIcmp  Protocol = original.ProtocolIcmp
	ProtocolTCP   Protocol = original.ProtocolTCP
)

type ProvisioningState = original.ProvisioningState

const (
	Deleting  ProvisioningState = original.Deleting
	Failed    ProvisioningState = original.Failed
	Succeeded ProvisioningState = original.Succeeded
	Updating  ProvisioningState = original.Updating
)

type PublicIPAddressSkuName = original.PublicIPAddressSkuName

const (
	PublicIPAddressSkuNameBasic    PublicIPAddressSkuName = original.PublicIPAddressSkuNameBasic
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = original.PublicIPAddressSkuNameStandard
)

type PublicIPPrefixSkuName = original.PublicIPPrefixSkuName

const (
	PublicIPPrefixSkuNameStandard PublicIPPrefixSkuName = original.PublicIPPrefixSkuNameStandard
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone                       ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssignedUserAssigned
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = original.ResourceIdentityTypeUserAssigned
)

type RouteNextHopType = original.RouteNextHopType

const (
	RouteNextHopTypeInternet              RouteNextHopType = original.RouteNextHopTypeInternet
	RouteNextHopTypeNone                  RouteNextHopType = original.RouteNextHopTypeNone
	RouteNextHopTypeVirtualAppliance      RouteNextHopType = original.RouteNextHopTypeVirtualAppliance
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = original.RouteNextHopTypeVirtualNetworkGateway
	RouteNextHopTypeVnetLocal             RouteNextHopType = original.RouteNextHopTypeVnetLocal
)

type RuleConditionType = original.RuleConditionType

const (
	RuleConditionTypeApplicationRuleCondition    RuleConditionType = original.RuleConditionTypeApplicationRuleCondition
	RuleConditionTypeFirewallPolicyRuleCondition RuleConditionType = original.RuleConditionTypeFirewallPolicyRuleCondition
	RuleConditionTypeNetworkRuleCondition        RuleConditionType = original.RuleConditionTypeNetworkRuleCondition
)

type RuleType = original.RuleType

const (
	RuleTypeFirewallPolicyFilterRule RuleType = original.RuleTypeFirewallPolicyFilterRule
	RuleTypeFirewallPolicyNatRule    RuleType = original.RuleTypeFirewallPolicyNatRule
	RuleTypeFirewallPolicyRule       RuleType = original.RuleTypeFirewallPolicyRule
)

type SecurityRuleAccess = original.SecurityRuleAccess

const (
	SecurityRuleAccessAllow SecurityRuleAccess = original.SecurityRuleAccessAllow
	SecurityRuleAccessDeny  SecurityRuleAccess = original.SecurityRuleAccessDeny
)

type SecurityRuleDirection = original.SecurityRuleDirection

const (
	SecurityRuleDirectionInbound  SecurityRuleDirection = original.SecurityRuleDirectionInbound
	SecurityRuleDirectionOutbound SecurityRuleDirection = original.SecurityRuleDirectionOutbound
)

type SecurityRuleProtocol = original.SecurityRuleProtocol

const (
	SecurityRuleProtocolAh       SecurityRuleProtocol = original.SecurityRuleProtocolAh
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = original.SecurityRuleProtocolAsterisk
	SecurityRuleProtocolEsp      SecurityRuleProtocol = original.SecurityRuleProtocolEsp
	SecurityRuleProtocolIcmp     SecurityRuleProtocol = original.SecurityRuleProtocolIcmp
	SecurityRuleProtocolTCP      SecurityRuleProtocol = original.SecurityRuleProtocolTCP
	SecurityRuleProtocolUDP      SecurityRuleProtocol = original.SecurityRuleProtocolUDP
)

type ServiceProviderProvisioningState = original.ServiceProviderProvisioningState

const (
	Deprovisioning ServiceProviderProvisioningState = original.Deprovisioning
	NotProvisioned ServiceProviderProvisioningState = original.NotProvisioned
	Provisioned    ServiceProviderProvisioningState = original.Provisioned
	Provisioning   ServiceProviderProvisioningState = original.Provisioning
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityWarning Severity = original.SeverityWarning
)

type TransportProtocol = original.TransportProtocol

const (
	TransportProtocolAll TransportProtocol = original.TransportProtocolAll
	TransportProtocolTCP TransportProtocol = original.TransportProtocolTCP
	TransportProtocolUDP TransportProtocol = original.TransportProtocolUDP
)

type TunnelConnectionStatus = original.TunnelConnectionStatus

const (
	TunnelConnectionStatusConnected    TunnelConnectionStatus = original.TunnelConnectionStatusConnected
	TunnelConnectionStatusConnecting   TunnelConnectionStatus = original.TunnelConnectionStatusConnecting
	TunnelConnectionStatusNotConnected TunnelConnectionStatus = original.TunnelConnectionStatusNotConnected
	TunnelConnectionStatusUnknown      TunnelConnectionStatus = original.TunnelConnectionStatusUnknown
)

type VerbosityLevel = original.VerbosityLevel

const (
	Full    VerbosityLevel = original.Full
	Minimum VerbosityLevel = original.Minimum
	Normal  VerbosityLevel = original.Normal
)

type VirtualNetworkGatewayConnectionProtocol = original.VirtualNetworkGatewayConnectionProtocol

const (
	IKEv1 VirtualNetworkGatewayConnectionProtocol = original.IKEv1
	IKEv2 VirtualNetworkGatewayConnectionProtocol = original.IKEv2
)

type VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatus

const (
	VirtualNetworkGatewayConnectionStatusConnected    VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnected
	VirtualNetworkGatewayConnectionStatusConnecting   VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnecting
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusNotConnected
	VirtualNetworkGatewayConnectionStatusUnknown      VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusUnknown
)

type VirtualNetworkGatewayConnectionType = original.VirtualNetworkGatewayConnectionType

const (
	ExpressRoute VirtualNetworkGatewayConnectionType = original.ExpressRoute
	IPsec        VirtualNetworkGatewayConnectionType = original.IPsec
	Vnet2Vnet    VirtualNetworkGatewayConnectionType = original.Vnet2Vnet
	VPNClient    VirtualNetworkGatewayConnectionType = original.VPNClient
)

type VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuName

const (
	VirtualNetworkGatewaySkuNameBasic            VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameBasic
	VirtualNetworkGatewaySkuNameErGw1AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw1AZ
	VirtualNetworkGatewaySkuNameErGw2AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw2AZ
	VirtualNetworkGatewaySkuNameErGw3AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw3AZ
	VirtualNetworkGatewaySkuNameHighPerformance  VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameHighPerformance
	VirtualNetworkGatewaySkuNameStandard         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameStandard
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameUltraPerformance
	VirtualNetworkGatewaySkuNameVpnGw1           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1
	VirtualNetworkGatewaySkuNameVpnGw1AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1AZ
	VirtualNetworkGatewaySkuNameVpnGw2           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2
	VirtualNetworkGatewaySkuNameVpnGw2AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2AZ
	VirtualNetworkGatewaySkuNameVpnGw3           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3
	VirtualNetworkGatewaySkuNameVpnGw3AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3AZ
	VirtualNetworkGatewaySkuNameVpnGw4           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw4
	VirtualNetworkGatewaySkuNameVpnGw4AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw4AZ
	VirtualNetworkGatewaySkuNameVpnGw5           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw5
	VirtualNetworkGatewaySkuNameVpnGw5AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw5AZ
)

type VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTier

const (
	VirtualNetworkGatewaySkuTierBasic            VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierBasic
	VirtualNetworkGatewaySkuTierErGw1AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw1AZ
	VirtualNetworkGatewaySkuTierErGw2AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw2AZ
	VirtualNetworkGatewaySkuTierErGw3AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw3AZ
	VirtualNetworkGatewaySkuTierHighPerformance  VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierHighPerformance
	VirtualNetworkGatewaySkuTierStandard         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierStandard
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierUltraPerformance
	VirtualNetworkGatewaySkuTierVpnGw1           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1
	VirtualNetworkGatewaySkuTierVpnGw1AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1AZ
	VirtualNetworkGatewaySkuTierVpnGw2           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2
	VirtualNetworkGatewaySkuTierVpnGw2AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2AZ
	VirtualNetworkGatewaySkuTierVpnGw3           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3
	VirtualNetworkGatewaySkuTierVpnGw3AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3AZ
	VirtualNetworkGatewaySkuTierVpnGw4           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw4
	VirtualNetworkGatewaySkuTierVpnGw4AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw4AZ
	VirtualNetworkGatewaySkuTierVpnGw5           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw5
	VirtualNetworkGatewaySkuTierVpnGw5AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw5AZ
)

type VirtualNetworkGatewayType = original.VirtualNetworkGatewayType

const (
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeExpressRoute
	VirtualNetworkGatewayTypeVpn          VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeVpn
)

type VirtualNetworkPeeringState = original.VirtualNetworkPeeringState

const (
	VirtualNetworkPeeringStateConnected    VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateConnected
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateDisconnected
	VirtualNetworkPeeringStateInitiated    VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateInitiated
)

type VirtualWanSecurityProviderType = original.VirtualWanSecurityProviderType

const (
	External VirtualWanSecurityProviderType = original.External
	Native   VirtualWanSecurityProviderType = original.Native
)

type VpnAuthenticationType = original.VpnAuthenticationType

const (
	AAD         VpnAuthenticationType = original.AAD
	Certificate VpnAuthenticationType = original.Certificate
	Radius      VpnAuthenticationType = original.Radius
)

type VpnClientProtocol = original.VpnClientProtocol

const (
	IkeV2   VpnClientProtocol = original.IkeV2
	OpenVPN VpnClientProtocol = original.OpenVPN
	SSTP    VpnClientProtocol = original.SSTP
)

type VpnConnectionStatus = original.VpnConnectionStatus

const (
	VpnConnectionStatusConnected    VpnConnectionStatus = original.VpnConnectionStatusConnected
	VpnConnectionStatusConnecting   VpnConnectionStatus = original.VpnConnectionStatusConnecting
	VpnConnectionStatusNotConnected VpnConnectionStatus = original.VpnConnectionStatusNotConnected
	VpnConnectionStatusUnknown      VpnConnectionStatus = original.VpnConnectionStatusUnknown
)

type VpnGatewayGeneration = original.VpnGatewayGeneration

const (
	VpnGatewayGenerationGeneration1 VpnGatewayGeneration = original.VpnGatewayGenerationGeneration1
	VpnGatewayGenerationGeneration2 VpnGatewayGeneration = original.VpnGatewayGenerationGeneration2
	VpnGatewayGenerationNone        VpnGatewayGeneration = original.VpnGatewayGenerationNone
)

type VpnGatewayTunnelingProtocol = original.VpnGatewayTunnelingProtocol

const (
	VpnGatewayTunnelingProtocolIkeV2   VpnGatewayTunnelingProtocol = original.VpnGatewayTunnelingProtocolIkeV2
	VpnGatewayTunnelingProtocolOpenVPN VpnGatewayTunnelingProtocol = original.VpnGatewayTunnelingProtocolOpenVPN
)

type VpnType = original.VpnType

const (
	PolicyBased VpnType = original.PolicyBased
	RouteBased  VpnType = original.RouteBased
)

type WebApplicationFirewallAction = original.WebApplicationFirewallAction

const (
	WebApplicationFirewallActionAllow WebApplicationFirewallAction = original.WebApplicationFirewallActionAllow
	WebApplicationFirewallActionBlock WebApplicationFirewallAction = original.WebApplicationFirewallActionBlock
	WebApplicationFirewallActionLog   WebApplicationFirewallAction = original.WebApplicationFirewallActionLog
)

type WebApplicationFirewallEnabledState = original.WebApplicationFirewallEnabledState

const (
	WebApplicationFirewallEnabledStateDisabled WebApplicationFirewallEnabledState = original.WebApplicationFirewallEnabledStateDisabled
	WebApplicationFirewallEnabledStateEnabled  WebApplicationFirewallEnabledState = original.WebApplicationFirewallEnabledStateEnabled
)

type WebApplicationFirewallMatchVariable = original.WebApplicationFirewallMatchVariable

const (
	PostArgs       WebApplicationFirewallMatchVariable = original.PostArgs
	QueryString    WebApplicationFirewallMatchVariable = original.QueryString
	RemoteAddr     WebApplicationFirewallMatchVariable = original.RemoteAddr
	RequestBody    WebApplicationFirewallMatchVariable = original.RequestBody
	RequestCookies WebApplicationFirewallMatchVariable = original.RequestCookies
	RequestHeaders WebApplicationFirewallMatchVariable = original.RequestHeaders
	RequestMethod  WebApplicationFirewallMatchVariable = original.RequestMethod
	RequestURI     WebApplicationFirewallMatchVariable = original.RequestURI
)

type WebApplicationFirewallMode = original.WebApplicationFirewallMode

const (
	WebApplicationFirewallModeDetection  WebApplicationFirewallMode = original.WebApplicationFirewallModeDetection
	WebApplicationFirewallModePrevention WebApplicationFirewallMode = original.WebApplicationFirewallModePrevention
)

type WebApplicationFirewallOperator = original.WebApplicationFirewallOperator

const (
	WebApplicationFirewallOperatorBeginsWith         WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorBeginsWith
	WebApplicationFirewallOperatorContains           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorContains
	WebApplicationFirewallOperatorEndsWith           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorEndsWith
	WebApplicationFirewallOperatorEqual              WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorEqual
	WebApplicationFirewallOperatorGeoMatch           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorGeoMatch
	WebApplicationFirewallOperatorGreaterThan        WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorGreaterThan
	WebApplicationFirewallOperatorGreaterThanOrEqual WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorGreaterThanOrEqual
	WebApplicationFirewallOperatorIPMatch            WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorIPMatch
	WebApplicationFirewallOperatorLessThan           WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorLessThan
	WebApplicationFirewallOperatorLessThanOrEqual    WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorLessThanOrEqual
	WebApplicationFirewallOperatorRegex              WebApplicationFirewallOperator = original.WebApplicationFirewallOperatorRegex
)

type WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceState

const (
	WebApplicationFirewallPolicyResourceStateCreating  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateCreating
	WebApplicationFirewallPolicyResourceStateDeleting  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateDeleting
	WebApplicationFirewallPolicyResourceStateDisabled  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateDisabled
	WebApplicationFirewallPolicyResourceStateDisabling WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateDisabling
	WebApplicationFirewallPolicyResourceStateEnabled   WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateEnabled
	WebApplicationFirewallPolicyResourceStateEnabling  WebApplicationFirewallPolicyResourceState = original.WebApplicationFirewallPolicyResourceStateEnabling
)

type WebApplicationFirewallRuleType = original.WebApplicationFirewallRuleType

const (
	WebApplicationFirewallRuleTypeInvalid   WebApplicationFirewallRuleType = original.WebApplicationFirewallRuleTypeInvalid
	WebApplicationFirewallRuleTypeMatchRule WebApplicationFirewallRuleType = original.WebApplicationFirewallRuleTypeMatchRule
)

type WebApplicationFirewallTransform = original.WebApplicationFirewallTransform

const (
	HTMLEntityDecode WebApplicationFirewallTransform = original.HTMLEntityDecode
	Lowercase        WebApplicationFirewallTransform = original.Lowercase
	RemoveNulls      WebApplicationFirewallTransform = original.RemoveNulls
	Trim             WebApplicationFirewallTransform = original.Trim
	URLDecode        WebApplicationFirewallTransform = original.URLDecode
	URLEncode        WebApplicationFirewallTransform = original.URLEncode
)

type AadAuthenticationParameters = original.AadAuthenticationParameters
type AddressSpace = original.AddressSpace
type ApplicationGateway = original.ApplicationGateway
type ApplicationGatewayAuthenticationCertificate = original.ApplicationGatewayAuthenticationCertificate
type ApplicationGatewayAuthenticationCertificatePropertiesFormat = original.ApplicationGatewayAuthenticationCertificatePropertiesFormat
type ApplicationGatewayAutoscaleConfiguration = original.ApplicationGatewayAutoscaleConfiguration
type ApplicationGatewayAvailableSslOptions = original.ApplicationGatewayAvailableSslOptions
type ApplicationGatewayAvailableSslOptionsPropertiesFormat = original.ApplicationGatewayAvailableSslOptionsPropertiesFormat
type ApplicationGatewayAvailableSslPredefinedPolicies = original.ApplicationGatewayAvailableSslPredefinedPolicies
type ApplicationGatewayAvailableSslPredefinedPoliciesIterator = original.ApplicationGatewayAvailableSslPredefinedPoliciesIterator
type ApplicationGatewayAvailableSslPredefinedPoliciesPage = original.ApplicationGatewayAvailableSslPredefinedPoliciesPage
type ApplicationGatewayAvailableWafRuleSetsResult = original.ApplicationGatewayAvailableWafRuleSetsResult
type ApplicationGatewayBackendAddress = original.ApplicationGatewayBackendAddress
type ApplicationGatewayBackendAddressPool = original.ApplicationGatewayBackendAddressPool
type ApplicationGatewayBackendAddressPoolPropertiesFormat = original.ApplicationGatewayBackendAddressPoolPropertiesFormat
type ApplicationGatewayBackendHTTPSettings = original.ApplicationGatewayBackendHTTPSettings
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat = original.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
type ApplicationGatewayBackendHealth = original.ApplicationGatewayBackendHealth
type ApplicationGatewayBackendHealthHTTPSettings = original.ApplicationGatewayBackendHealthHTTPSettings
type ApplicationGatewayBackendHealthOnDemand = original.ApplicationGatewayBackendHealthOnDemand
type ApplicationGatewayBackendHealthPool = original.ApplicationGatewayBackendHealthPool
type ApplicationGatewayBackendHealthServer = original.ApplicationGatewayBackendHealthServer
type ApplicationGatewayConnectionDraining = original.ApplicationGatewayConnectionDraining
type ApplicationGatewayCustomError = original.ApplicationGatewayCustomError
type ApplicationGatewayFirewallDisabledRuleGroup = original.ApplicationGatewayFirewallDisabledRuleGroup
type ApplicationGatewayFirewallExclusion = original.ApplicationGatewayFirewallExclusion
type ApplicationGatewayFirewallRule = original.ApplicationGatewayFirewallRule
type ApplicationGatewayFirewallRuleGroup = original.ApplicationGatewayFirewallRuleGroup
type ApplicationGatewayFirewallRuleSet = original.ApplicationGatewayFirewallRuleSet
type ApplicationGatewayFirewallRuleSetPropertiesFormat = original.ApplicationGatewayFirewallRuleSetPropertiesFormat
type ApplicationGatewayFrontendIPConfiguration = original.ApplicationGatewayFrontendIPConfiguration
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat = original.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
type ApplicationGatewayFrontendPort = original.ApplicationGatewayFrontendPort
type ApplicationGatewayFrontendPortPropertiesFormat = original.ApplicationGatewayFrontendPortPropertiesFormat
type ApplicationGatewayHTTPListener = original.ApplicationGatewayHTTPListener
type ApplicationGatewayHTTPListenerPropertiesFormat = original.ApplicationGatewayHTTPListenerPropertiesFormat
type ApplicationGatewayHeaderConfiguration = original.ApplicationGatewayHeaderConfiguration
type ApplicationGatewayIPConfiguration = original.ApplicationGatewayIPConfiguration
type ApplicationGatewayIPConfigurationPropertiesFormat = original.ApplicationGatewayIPConfigurationPropertiesFormat
type ApplicationGatewayListResult = original.ApplicationGatewayListResult
type ApplicationGatewayListResultIterator = original.ApplicationGatewayListResultIterator
type ApplicationGatewayListResultPage = original.ApplicationGatewayListResultPage
type ApplicationGatewayOnDemandProbe = original.ApplicationGatewayOnDemandProbe
type ApplicationGatewayPathRule = original.ApplicationGatewayPathRule
type ApplicationGatewayPathRulePropertiesFormat = original.ApplicationGatewayPathRulePropertiesFormat
type ApplicationGatewayProbe = original.ApplicationGatewayProbe
type ApplicationGatewayProbeHealthResponseMatch = original.ApplicationGatewayProbeHealthResponseMatch
type ApplicationGatewayProbePropertiesFormat = original.ApplicationGatewayProbePropertiesFormat
type ApplicationGatewayPropertiesFormat = original.ApplicationGatewayPropertiesFormat
type ApplicationGatewayRedirectConfiguration = original.ApplicationGatewayRedirectConfiguration
type ApplicationGatewayRedirectConfigurationPropertiesFormat = original.ApplicationGatewayRedirectConfigurationPropertiesFormat
type ApplicationGatewayRequestRoutingRule = original.ApplicationGatewayRequestRoutingRule
type ApplicationGatewayRequestRoutingRulePropertiesFormat = original.ApplicationGatewayRequestRoutingRulePropertiesFormat
type ApplicationGatewayRewriteRule = original.ApplicationGatewayRewriteRule
type ApplicationGatewayRewriteRuleActionSet = original.ApplicationGatewayRewriteRuleActionSet
type ApplicationGatewayRewriteRuleCondition = original.ApplicationGatewayRewriteRuleCondition
type ApplicationGatewayRewriteRuleSet = original.ApplicationGatewayRewriteRuleSet
type ApplicationGatewayRewriteRuleSetPropertiesFormat = original.ApplicationGatewayRewriteRuleSetPropertiesFormat
type ApplicationGatewaySku = original.ApplicationGatewaySku
type ApplicationGatewaySslCertificate = original.ApplicationGatewaySslCertificate
type ApplicationGatewaySslCertificatePropertiesFormat = original.ApplicationGatewaySslCertificatePropertiesFormat
type ApplicationGatewaySslPolicy = original.ApplicationGatewaySslPolicy
type ApplicationGatewaySslPredefinedPolicy = original.ApplicationGatewaySslPredefinedPolicy
type ApplicationGatewaySslPredefinedPolicyPropertiesFormat = original.ApplicationGatewaySslPredefinedPolicyPropertiesFormat
type ApplicationGatewayTrustedRootCertificate = original.ApplicationGatewayTrustedRootCertificate
type ApplicationGatewayTrustedRootCertificatePropertiesFormat = original.ApplicationGatewayTrustedRootCertificatePropertiesFormat
type ApplicationGatewayURLPathMap = original.ApplicationGatewayURLPathMap
type ApplicationGatewayURLPathMapPropertiesFormat = original.ApplicationGatewayURLPathMapPropertiesFormat
type ApplicationGatewayWebApplicationFirewallConfiguration = original.ApplicationGatewayWebApplicationFirewallConfiguration
type ApplicationGatewaysBackendHealthFuture = original.ApplicationGatewaysBackendHealthFuture
type ApplicationGatewaysBackendHealthOnDemandFuture = original.ApplicationGatewaysBackendHealthOnDemandFuture
type ApplicationGatewaysClient = original.ApplicationGatewaysClient
type ApplicationGatewaysCreateOrUpdateFuture = original.ApplicationGatewaysCreateOrUpdateFuture
type ApplicationGatewaysDeleteFuture = original.ApplicationGatewaysDeleteFuture
type ApplicationGatewaysStartFuture = original.ApplicationGatewaysStartFuture
type ApplicationGatewaysStopFuture = original.ApplicationGatewaysStopFuture
type ApplicationRuleCondition = original.ApplicationRuleCondition
type ApplicationSecurityGroup = original.ApplicationSecurityGroup
type ApplicationSecurityGroupListResult = original.ApplicationSecurityGroupListResult
type ApplicationSecurityGroupListResultIterator = original.ApplicationSecurityGroupListResultIterator
type ApplicationSecurityGroupListResultPage = original.ApplicationSecurityGroupListResultPage
type ApplicationSecurityGroupPropertiesFormat = original.ApplicationSecurityGroupPropertiesFormat
type ApplicationSecurityGroupsClient = original.ApplicationSecurityGroupsClient
type ApplicationSecurityGroupsCreateOrUpdateFuture = original.ApplicationSecurityGroupsCreateOrUpdateFuture
type ApplicationSecurityGroupsDeleteFuture = original.ApplicationSecurityGroupsDeleteFuture
type AuthorizationListResult = original.AuthorizationListResult
type AuthorizationListResultIterator = original.AuthorizationListResultIterator
type AuthorizationListResultPage = original.AuthorizationListResultPage
type AuthorizationPropertiesFormat = original.AuthorizationPropertiesFormat
type AutoApprovedPrivateLinkService = original.AutoApprovedPrivateLinkService
type AutoApprovedPrivateLinkServicesResult = original.AutoApprovedPrivateLinkServicesResult
type AutoApprovedPrivateLinkServicesResultIterator = original.AutoApprovedPrivateLinkServicesResultIterator
type AutoApprovedPrivateLinkServicesResultPage = original.AutoApprovedPrivateLinkServicesResultPage
type Availability = original.Availability
type AvailableDelegation = original.AvailableDelegation
type AvailableDelegationsClient = original.AvailableDelegationsClient
type AvailableDelegationsResult = original.AvailableDelegationsResult
type AvailableDelegationsResultIterator = original.AvailableDelegationsResultIterator
type AvailableDelegationsResultPage = original.AvailableDelegationsResultPage
type AvailableEndpointServicesClient = original.AvailableEndpointServicesClient
type AvailablePrivateEndpointType = original.AvailablePrivateEndpointType
type AvailablePrivateEndpointTypesClient = original.AvailablePrivateEndpointTypesClient
type AvailablePrivateEndpointTypesResult = original.AvailablePrivateEndpointTypesResult
type AvailablePrivateEndpointTypesResultIterator = original.AvailablePrivateEndpointTypesResultIterator
type AvailablePrivateEndpointTypesResultPage = original.AvailablePrivateEndpointTypesResultPage
type AvailableProvidersList = original.AvailableProvidersList
type AvailableProvidersListCity = original.AvailableProvidersListCity
type AvailableProvidersListCountry = original.AvailableProvidersListCountry
type AvailableProvidersListParameters = original.AvailableProvidersListParameters
type AvailableProvidersListState = original.AvailableProvidersListState
type AvailableResourceGroupDelegationsClient = original.AvailableResourceGroupDelegationsClient
type AvailableServiceAlias = original.AvailableServiceAlias
type AvailableServiceAliasesClient = original.AvailableServiceAliasesClient
type AvailableServiceAliasesResult = original.AvailableServiceAliasesResult
type AvailableServiceAliasesResultIterator = original.AvailableServiceAliasesResultIterator
type AvailableServiceAliasesResultPage = original.AvailableServiceAliasesResultPage
type AzureAsyncOperationResult = original.AzureAsyncOperationResult
type AzureFirewall = original.AzureFirewall
type AzureFirewallApplicationRule = original.AzureFirewallApplicationRule
type AzureFirewallApplicationRuleCollection = original.AzureFirewallApplicationRuleCollection
type AzureFirewallApplicationRuleCollectionPropertiesFormat = original.AzureFirewallApplicationRuleCollectionPropertiesFormat
type AzureFirewallApplicationRuleProtocol = original.AzureFirewallApplicationRuleProtocol
type AzureFirewallFqdnTag = original.AzureFirewallFqdnTag
type AzureFirewallFqdnTagListResult = original.AzureFirewallFqdnTagListResult
type AzureFirewallFqdnTagListResultIterator = original.AzureFirewallFqdnTagListResultIterator
type AzureFirewallFqdnTagListResultPage = original.AzureFirewallFqdnTagListResultPage
type AzureFirewallFqdnTagPropertiesFormat = original.AzureFirewallFqdnTagPropertiesFormat
type AzureFirewallFqdnTagsClient = original.AzureFirewallFqdnTagsClient
type AzureFirewallIPConfiguration = original.AzureFirewallIPConfiguration
type AzureFirewallIPConfigurationPropertiesFormat = original.AzureFirewallIPConfigurationPropertiesFormat
type AzureFirewallListResult = original.AzureFirewallListResult
type AzureFirewallListResultIterator = original.AzureFirewallListResultIterator
type AzureFirewallListResultPage = original.AzureFirewallListResultPage
type AzureFirewallNatRCAction = original.AzureFirewallNatRCAction
type AzureFirewallNatRule = original.AzureFirewallNatRule
type AzureFirewallNatRuleCollection = original.AzureFirewallNatRuleCollection
type AzureFirewallNatRuleCollectionProperties = original.AzureFirewallNatRuleCollectionProperties
type AzureFirewallNetworkRule = original.AzureFirewallNetworkRule
type AzureFirewallNetworkRuleCollection = original.AzureFirewallNetworkRuleCollection
type AzureFirewallNetworkRuleCollectionPropertiesFormat = original.AzureFirewallNetworkRuleCollectionPropertiesFormat
type AzureFirewallPropertiesFormat = original.AzureFirewallPropertiesFormat
type AzureFirewallPublicIPAddress = original.AzureFirewallPublicIPAddress
type AzureFirewallRCAction = original.AzureFirewallRCAction
type AzureFirewallSku = original.AzureFirewallSku
type AzureFirewallsClient = original.AzureFirewallsClient
type AzureFirewallsCreateOrUpdateFuture = original.AzureFirewallsCreateOrUpdateFuture
type AzureFirewallsDeleteFuture = original.AzureFirewallsDeleteFuture
type AzureReachabilityReport = original.AzureReachabilityReport
type AzureReachabilityReportItem = original.AzureReachabilityReportItem
type AzureReachabilityReportLatencyInfo = original.AzureReachabilityReportLatencyInfo
type AzureReachabilityReportLocation = original.AzureReachabilityReportLocation
type AzureReachabilityReportParameters = original.AzureReachabilityReportParameters
type BGPCommunity = original.BGPCommunity
type BackendAddressPool = original.BackendAddressPool
type BackendAddressPoolPropertiesFormat = original.BackendAddressPoolPropertiesFormat
type BaseClient = original.BaseClient
type BasicFirewallPolicyRule = original.BasicFirewallPolicyRule
type BasicFirewallPolicyRuleCondition = original.BasicFirewallPolicyRuleCondition
type BastionHost = original.BastionHost
type BastionHostIPConfiguration = original.BastionHostIPConfiguration
type BastionHostIPConfigurationPropertiesFormat = original.BastionHostIPConfigurationPropertiesFormat
type BastionHostListResult = original.BastionHostListResult
type BastionHostListResultIterator = original.BastionHostListResultIterator
type BastionHostListResultPage = original.BastionHostListResultPage
type BastionHostPropertiesFormat = original.BastionHostPropertiesFormat
type BastionHostsClient = original.BastionHostsClient
type BastionHostsCreateOrUpdateFuture = original.BastionHostsCreateOrUpdateFuture
type BastionHostsDeleteFuture = original.BastionHostsDeleteFuture
type BgpPeerStatus = original.BgpPeerStatus
type BgpPeerStatusListResult = original.BgpPeerStatusListResult
type BgpServiceCommunitiesClient = original.BgpServiceCommunitiesClient
type BgpServiceCommunity = original.BgpServiceCommunity
type BgpServiceCommunityListResult = original.BgpServiceCommunityListResult
type BgpServiceCommunityListResultIterator = original.BgpServiceCommunityListResultIterator
type BgpServiceCommunityListResultPage = original.BgpServiceCommunityListResultPage
type BgpServiceCommunityPropertiesFormat = original.BgpServiceCommunityPropertiesFormat
type BgpSettings = original.BgpSettings
type CheckPrivateLinkServiceVisibilityRequest = original.CheckPrivateLinkServiceVisibilityRequest
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type ConfigurationDiagnosticParameters = original.ConfigurationDiagnosticParameters
type ConfigurationDiagnosticProfile = original.ConfigurationDiagnosticProfile
type ConfigurationDiagnosticResponse = original.ConfigurationDiagnosticResponse
type ConfigurationDiagnosticResult = original.ConfigurationDiagnosticResult
type ConnectionMonitor = original.ConnectionMonitor
type ConnectionMonitorDestination = original.ConnectionMonitorDestination
type ConnectionMonitorListResult = original.ConnectionMonitorListResult
type ConnectionMonitorParameters = original.ConnectionMonitorParameters
type ConnectionMonitorQueryResult = original.ConnectionMonitorQueryResult
type ConnectionMonitorResult = original.ConnectionMonitorResult
type ConnectionMonitorResultProperties = original.ConnectionMonitorResultProperties
type ConnectionMonitorSource = original.ConnectionMonitorSource
type ConnectionMonitorsClient = original.ConnectionMonitorsClient
type ConnectionMonitorsCreateOrUpdateFuture = original.ConnectionMonitorsCreateOrUpdateFuture
type ConnectionMonitorsDeleteFuture = original.ConnectionMonitorsDeleteFuture
type ConnectionMonitorsQueryFuture = original.ConnectionMonitorsQueryFuture
type ConnectionMonitorsStartFuture = original.ConnectionMonitorsStartFuture
type ConnectionMonitorsStopFuture = original.ConnectionMonitorsStopFuture
type ConnectionResetSharedKey = original.ConnectionResetSharedKey
type ConnectionSharedKey = original.ConnectionSharedKey
type ConnectionStateSnapshot = original.ConnectionStateSnapshot
type ConnectivityDestination = original.ConnectivityDestination
type ConnectivityHop = original.ConnectivityHop
type ConnectivityInformation = original.ConnectivityInformation
type ConnectivityIssue = original.ConnectivityIssue
type ConnectivityParameters = original.ConnectivityParameters
type ConnectivitySource = original.ConnectivitySource
type Container = original.Container
type ContainerNetworkInterface = original.ContainerNetworkInterface
type ContainerNetworkInterfaceConfiguration = original.ContainerNetworkInterfaceConfiguration
type ContainerNetworkInterfaceConfigurationPropertiesFormat = original.ContainerNetworkInterfaceConfigurationPropertiesFormat
type ContainerNetworkInterfaceIPConfiguration = original.ContainerNetworkInterfaceIPConfiguration
type ContainerNetworkInterfaceIPConfigurationPropertiesFormat = original.ContainerNetworkInterfaceIPConfigurationPropertiesFormat
type ContainerNetworkInterfacePropertiesFormat = original.ContainerNetworkInterfacePropertiesFormat
type DNSNameAvailabilityResult = original.DNSNameAvailabilityResult
type DdosCustomPoliciesClient = original.DdosCustomPoliciesClient
type DdosCustomPoliciesCreateOrUpdateFuture = original.DdosCustomPoliciesCreateOrUpdateFuture
type DdosCustomPoliciesDeleteFuture = original.DdosCustomPoliciesDeleteFuture
type DdosCustomPolicy = original.DdosCustomPolicy
type DdosCustomPolicyPropertiesFormat = original.DdosCustomPolicyPropertiesFormat
type DdosProtectionPlan = original.DdosProtectionPlan
type DdosProtectionPlanListResult = original.DdosProtectionPlanListResult
type DdosProtectionPlanListResultIterator = original.DdosProtectionPlanListResultIterator
type DdosProtectionPlanListResultPage = original.DdosProtectionPlanListResultPage
type DdosProtectionPlanPropertiesFormat = original.DdosProtectionPlanPropertiesFormat
type DdosProtectionPlansClient = original.DdosProtectionPlansClient
type DdosProtectionPlansCreateOrUpdateFuture = original.DdosProtectionPlansCreateOrUpdateFuture
type DdosProtectionPlansDeleteFuture = original.DdosProtectionPlansDeleteFuture
type DdosSettings = original.DdosSettings
type DefaultSecurityRulesClient = original.DefaultSecurityRulesClient
type Delegation = original.Delegation
type DeviceProperties = original.DeviceProperties
type DhcpOptions = original.DhcpOptions
type Dimension = original.Dimension
type EffectiveNetworkSecurityGroup = original.EffectiveNetworkSecurityGroup
type EffectiveNetworkSecurityGroupAssociation = original.EffectiveNetworkSecurityGroupAssociation
type EffectiveNetworkSecurityGroupListResult = original.EffectiveNetworkSecurityGroupListResult
type EffectiveNetworkSecurityRule = original.EffectiveNetworkSecurityRule
type EffectiveRoute = original.EffectiveRoute
type EffectiveRouteListResult = original.EffectiveRouteListResult
type EndpointServiceResult = original.EndpointServiceResult
type EndpointServicesListResult = original.EndpointServicesListResult
type EndpointServicesListResultIterator = original.EndpointServicesListResultIterator
type EndpointServicesListResultPage = original.EndpointServicesListResultPage
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type ErrorResponse = original.ErrorResponse
type EvaluatedNetworkSecurityGroup = original.EvaluatedNetworkSecurityGroup
type ExpressRouteCircuit = original.ExpressRouteCircuit
type ExpressRouteCircuitArpTable = original.ExpressRouteCircuitArpTable
type ExpressRouteCircuitAuthorization = original.ExpressRouteCircuitAuthorization
type ExpressRouteCircuitAuthorizationsClient = original.ExpressRouteCircuitAuthorizationsClient
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture = original.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture
type ExpressRouteCircuitAuthorizationsDeleteFuture = original.ExpressRouteCircuitAuthorizationsDeleteFuture
type ExpressRouteCircuitConnection = original.ExpressRouteCircuitConnection
type ExpressRouteCircuitConnectionListResult = original.ExpressRouteCircuitConnectionListResult
type ExpressRouteCircuitConnectionListResultIterator = original.ExpressRouteCircuitConnectionListResultIterator
type ExpressRouteCircuitConnectionListResultPage = original.ExpressRouteCircuitConnectionListResultPage
type ExpressRouteCircuitConnectionPropertiesFormat = original.ExpressRouteCircuitConnectionPropertiesFormat
type ExpressRouteCircuitConnectionsClient = original.ExpressRouteCircuitConnectionsClient
type ExpressRouteCircuitConnectionsCreateOrUpdateFuture = original.ExpressRouteCircuitConnectionsCreateOrUpdateFuture
type ExpressRouteCircuitConnectionsDeleteFuture = original.ExpressRouteCircuitConnectionsDeleteFuture
type ExpressRouteCircuitListResult = original.ExpressRouteCircuitListResult
type ExpressRouteCircuitListResultIterator = original.ExpressRouteCircuitListResultIterator
type ExpressRouteCircuitListResultPage = original.ExpressRouteCircuitListResultPage
type ExpressRouteCircuitPeering = original.ExpressRouteCircuitPeering
type ExpressRouteCircuitPeeringConfig = original.ExpressRouteCircuitPeeringConfig
type ExpressRouteCircuitPeeringID = original.ExpressRouteCircuitPeeringID
type ExpressRouteCircuitPeeringListResult = original.ExpressRouteCircuitPeeringListResult
type ExpressRouteCircuitPeeringListResultIterator = original.ExpressRouteCircuitPeeringListResultIterator
type ExpressRouteCircuitPeeringListResultPage = original.ExpressRouteCircuitPeeringListResultPage
type ExpressRouteCircuitPeeringPropertiesFormat = original.ExpressRouteCircuitPeeringPropertiesFormat
type ExpressRouteCircuitPeeringsClient = original.ExpressRouteCircuitPeeringsClient
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture = original.ExpressRouteCircuitPeeringsCreateOrUpdateFuture
type ExpressRouteCircuitPeeringsDeleteFuture = original.ExpressRouteCircuitPeeringsDeleteFuture
type ExpressRouteCircuitPropertiesFormat = original.ExpressRouteCircuitPropertiesFormat
type ExpressRouteCircuitReference = original.ExpressRouteCircuitReference
type ExpressRouteCircuitRoutesTable = original.ExpressRouteCircuitRoutesTable
type ExpressRouteCircuitRoutesTableSummary = original.ExpressRouteCircuitRoutesTableSummary
type ExpressRouteCircuitServiceProviderProperties = original.ExpressRouteCircuitServiceProviderProperties
type ExpressRouteCircuitSku = original.ExpressRouteCircuitSku
type ExpressRouteCircuitStats = original.ExpressRouteCircuitStats
type ExpressRouteCircuitsArpTableListResult = original.ExpressRouteCircuitsArpTableListResult
type ExpressRouteCircuitsClient = original.ExpressRouteCircuitsClient
type ExpressRouteCircuitsCreateOrUpdateFuture = original.ExpressRouteCircuitsCreateOrUpdateFuture
type ExpressRouteCircuitsDeleteFuture = original.ExpressRouteCircuitsDeleteFuture
type ExpressRouteCircuitsListArpTableFuture = original.ExpressRouteCircuitsListArpTableFuture
type ExpressRouteCircuitsListRoutesTableFuture = original.ExpressRouteCircuitsListRoutesTableFuture
type ExpressRouteCircuitsListRoutesTableSummaryFuture = original.ExpressRouteCircuitsListRoutesTableSummaryFuture
type ExpressRouteCircuitsRoutesTableListResult = original.ExpressRouteCircuitsRoutesTableListResult
type ExpressRouteCircuitsRoutesTableSummaryListResult = original.ExpressRouteCircuitsRoutesTableSummaryListResult
type ExpressRouteConnection = original.ExpressRouteConnection
type ExpressRouteConnectionID = original.ExpressRouteConnectionID
type ExpressRouteConnectionList = original.ExpressRouteConnectionList
type ExpressRouteConnectionProperties = original.ExpressRouteConnectionProperties
type ExpressRouteConnectionsClient = original.ExpressRouteConnectionsClient
type ExpressRouteConnectionsCreateOrUpdateFuture = original.ExpressRouteConnectionsCreateOrUpdateFuture
type ExpressRouteConnectionsDeleteFuture = original.ExpressRouteConnectionsDeleteFuture
type ExpressRouteCrossConnection = original.ExpressRouteCrossConnection
type ExpressRouteCrossConnectionListResult = original.ExpressRouteCrossConnectionListResult
type ExpressRouteCrossConnectionListResultIterator = original.ExpressRouteCrossConnectionListResultIterator
type ExpressRouteCrossConnectionListResultPage = original.ExpressRouteCrossConnectionListResultPage
type ExpressRouteCrossConnectionPeering = original.ExpressRouteCrossConnectionPeering
type ExpressRouteCrossConnectionPeeringList = original.ExpressRouteCrossConnectionPeeringList
type ExpressRouteCrossConnectionPeeringListIterator = original.ExpressRouteCrossConnectionPeeringListIterator
type ExpressRouteCrossConnectionPeeringListPage = original.ExpressRouteCrossConnectionPeeringListPage
type ExpressRouteCrossConnectionPeeringProperties = original.ExpressRouteCrossConnectionPeeringProperties
type ExpressRouteCrossConnectionPeeringsClient = original.ExpressRouteCrossConnectionPeeringsClient
type ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture = original.ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture
type ExpressRouteCrossConnectionPeeringsDeleteFuture = original.ExpressRouteCrossConnectionPeeringsDeleteFuture
type ExpressRouteCrossConnectionProperties = original.ExpressRouteCrossConnectionProperties
type ExpressRouteCrossConnectionRoutesTableSummary = original.ExpressRouteCrossConnectionRoutesTableSummary
type ExpressRouteCrossConnectionsClient = original.ExpressRouteCrossConnectionsClient
type ExpressRouteCrossConnectionsCreateOrUpdateFuture = original.ExpressRouteCrossConnectionsCreateOrUpdateFuture
type ExpressRouteCrossConnectionsListArpTableFuture = original.ExpressRouteCrossConnectionsListArpTableFuture
type ExpressRouteCrossConnectionsListRoutesTableFuture = original.ExpressRouteCrossConnectionsListRoutesTableFuture
type ExpressRouteCrossConnectionsListRoutesTableSummaryFuture = original.ExpressRouteCrossConnectionsListRoutesTableSummaryFuture
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult = original.ExpressRouteCrossConnectionsRoutesTableSummaryListResult
type ExpressRouteGateway = original.ExpressRouteGateway
type ExpressRouteGatewayList = original.ExpressRouteGatewayList
type ExpressRouteGatewayProperties = original.ExpressRouteGatewayProperties
type ExpressRouteGatewayPropertiesAutoScaleConfiguration = original.ExpressRouteGatewayPropertiesAutoScaleConfiguration
type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds = original.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
type ExpressRouteGatewaysClient = original.ExpressRouteGatewaysClient
type ExpressRouteGatewaysCreateOrUpdateFuture = original.ExpressRouteGatewaysCreateOrUpdateFuture
type ExpressRouteGatewaysDeleteFuture = original.ExpressRouteGatewaysDeleteFuture
type ExpressRouteLink = original.ExpressRouteLink
type ExpressRouteLinkListResult = original.ExpressRouteLinkListResult
type ExpressRouteLinkListResultIterator = original.ExpressRouteLinkListResultIterator
type ExpressRouteLinkListResultPage = original.ExpressRouteLinkListResultPage
type ExpressRouteLinkMacSecConfig = original.ExpressRouteLinkMacSecConfig
type ExpressRouteLinkPropertiesFormat = original.ExpressRouteLinkPropertiesFormat
type ExpressRouteLinksClient = original.ExpressRouteLinksClient
type ExpressRoutePort = original.ExpressRoutePort
type ExpressRoutePortListResult = original.ExpressRoutePortListResult
type ExpressRoutePortListResultIterator = original.ExpressRoutePortListResultIterator
type ExpressRoutePortListResultPage = original.ExpressRoutePortListResultPage
type ExpressRoutePortPropertiesFormat = original.ExpressRoutePortPropertiesFormat
type ExpressRoutePortsClient = original.ExpressRoutePortsClient
type ExpressRoutePortsCreateOrUpdateFuture = original.ExpressRoutePortsCreateOrUpdateFuture
type ExpressRoutePortsDeleteFuture = original.ExpressRoutePortsDeleteFuture
type ExpressRoutePortsLocation = original.ExpressRoutePortsLocation
type ExpressRoutePortsLocationBandwidths = original.ExpressRoutePortsLocationBandwidths
type ExpressRoutePortsLocationListResult = original.ExpressRoutePortsLocationListResult
type ExpressRoutePortsLocationListResultIterator = original.ExpressRoutePortsLocationListResultIterator
type ExpressRoutePortsLocationListResultPage = original.ExpressRoutePortsLocationListResultPage
type ExpressRoutePortsLocationPropertiesFormat = original.ExpressRoutePortsLocationPropertiesFormat
type ExpressRoutePortsLocationsClient = original.ExpressRoutePortsLocationsClient
type ExpressRouteServiceProvider = original.ExpressRouteServiceProvider
type ExpressRouteServiceProviderBandwidthsOffered = original.ExpressRouteServiceProviderBandwidthsOffered
type ExpressRouteServiceProviderListResult = original.ExpressRouteServiceProviderListResult
type ExpressRouteServiceProviderListResultIterator = original.ExpressRouteServiceProviderListResultIterator
type ExpressRouteServiceProviderListResultPage = original.ExpressRouteServiceProviderListResultPage
type ExpressRouteServiceProviderPropertiesFormat = original.ExpressRouteServiceProviderPropertiesFormat
type ExpressRouteServiceProvidersClient = original.ExpressRouteServiceProvidersClient
type FirewallPoliciesClient = original.FirewallPoliciesClient
type FirewallPoliciesCreateOrUpdateFuture = original.FirewallPoliciesCreateOrUpdateFuture
type FirewallPoliciesDeleteFuture = original.FirewallPoliciesDeleteFuture
type FirewallPolicy = original.FirewallPolicy
type FirewallPolicyFilterRule = original.FirewallPolicyFilterRule
type FirewallPolicyFilterRuleAction = original.FirewallPolicyFilterRuleAction
type FirewallPolicyListResult = original.FirewallPolicyListResult
type FirewallPolicyListResultIterator = original.FirewallPolicyListResultIterator
type FirewallPolicyListResultPage = original.FirewallPolicyListResultPage
type FirewallPolicyNatRule = original.FirewallPolicyNatRule
type FirewallPolicyNatRuleAction = original.FirewallPolicyNatRuleAction
type FirewallPolicyPropertiesFormat = original.FirewallPolicyPropertiesFormat
type FirewallPolicyRule = original.FirewallPolicyRule
type FirewallPolicyRuleCondition = original.FirewallPolicyRuleCondition
type FirewallPolicyRuleConditionApplicationProtocol = original.FirewallPolicyRuleConditionApplicationProtocol
type FirewallPolicyRuleGroup = original.FirewallPolicyRuleGroup
type FirewallPolicyRuleGroupListResult = original.FirewallPolicyRuleGroupListResult
type FirewallPolicyRuleGroupListResultIterator = original.FirewallPolicyRuleGroupListResultIterator
type FirewallPolicyRuleGroupListResultPage = original.FirewallPolicyRuleGroupListResultPage
type FirewallPolicyRuleGroupProperties = original.FirewallPolicyRuleGroupProperties
type FirewallPolicyRuleGroupsClient = original.FirewallPolicyRuleGroupsClient
type FirewallPolicyRuleGroupsCreateOrUpdateFuture = original.FirewallPolicyRuleGroupsCreateOrUpdateFuture
type FirewallPolicyRuleGroupsDeleteFuture = original.FirewallPolicyRuleGroupsDeleteFuture
type FlowLogFormatParameters = original.FlowLogFormatParameters
type FlowLogInformation = original.FlowLogInformation
type FlowLogProperties = original.FlowLogProperties
type FlowLogStatusParameters = original.FlowLogStatusParameters
type FrontendIPConfiguration = original.FrontendIPConfiguration
type FrontendIPConfigurationPropertiesFormat = original.FrontendIPConfigurationPropertiesFormat
type GatewayRoute = original.GatewayRoute
type GatewayRouteListResult = original.GatewayRouteListResult
type GeneratevirtualwanvpnserverconfigurationvpnprofileFuture = original.GeneratevirtualwanvpnserverconfigurationvpnprofileFuture
type GetVpnSitesConfigurationRequest = original.GetVpnSitesConfigurationRequest
type HTTPConfiguration = original.HTTPConfiguration
type HTTPHeader = original.HTTPHeader
type HubIPAddresses = original.HubIPAddresses
type HubVirtualNetworkConnection = original.HubVirtualNetworkConnection
type HubVirtualNetworkConnectionProperties = original.HubVirtualNetworkConnectionProperties
type HubVirtualNetworkConnectionsClient = original.HubVirtualNetworkConnectionsClient
type IPAddressAvailabilityResult = original.IPAddressAvailabilityResult
type IPConfiguration = original.IPConfiguration
type IPConfigurationProfile = original.IPConfigurationProfile
type IPConfigurationProfilePropertiesFormat = original.IPConfigurationProfilePropertiesFormat
type IPConfigurationPropertiesFormat = original.IPConfigurationPropertiesFormat
type IPGroup = original.IPGroup
type IPGroupListResult = original.IPGroupListResult
type IPGroupListResultIterator = original.IPGroupListResultIterator
type IPGroupListResultPage = original.IPGroupListResultPage
type IPGroupPropertiesFormat = original.IPGroupPropertiesFormat
type IPGroupsClient = original.IPGroupsClient
type IPGroupsCreateOrUpdateFuture = original.IPGroupsCreateOrUpdateFuture
type IPGroupsDeleteFuture = original.IPGroupsDeleteFuture
type IPTag = original.IPTag
type InboundNatPool = original.InboundNatPool
type InboundNatPoolPropertiesFormat = original.InboundNatPoolPropertiesFormat
type InboundNatRule = original.InboundNatRule
type InboundNatRuleListResult = original.InboundNatRuleListResult
type InboundNatRuleListResultIterator = original.InboundNatRuleListResultIterator
type InboundNatRuleListResultPage = original.InboundNatRuleListResultPage
type InboundNatRulePropertiesFormat = original.InboundNatRulePropertiesFormat
type InboundNatRulesClient = original.InboundNatRulesClient
type InboundNatRulesCreateOrUpdateFuture = original.InboundNatRulesCreateOrUpdateFuture
type InboundNatRulesDeleteFuture = original.InboundNatRulesDeleteFuture
type IntentPolicy = original.IntentPolicy
type IntentPolicyConfiguration = original.IntentPolicyConfiguration
type Interface = original.Interface
type InterfaceAssociation = original.InterfaceAssociation
type InterfaceDNSSettings = original.InterfaceDNSSettings
type InterfaceIPConfiguration = original.InterfaceIPConfiguration
type InterfaceIPConfigurationListResult = original.InterfaceIPConfigurationListResult
type InterfaceIPConfigurationListResultIterator = original.InterfaceIPConfigurationListResultIterator
type InterfaceIPConfigurationListResultPage = original.InterfaceIPConfigurationListResultPage
type InterfaceIPConfigurationPrivateLinkConnectionProperties = original.InterfaceIPConfigurationPrivateLinkConnectionProperties
type InterfaceIPConfigurationPropertiesFormat = original.InterfaceIPConfigurationPropertiesFormat
type InterfaceIPConfigurationsClient = original.InterfaceIPConfigurationsClient
type InterfaceListResult = original.InterfaceListResult
type InterfaceListResultIterator = original.InterfaceListResultIterator
type InterfaceListResultPage = original.InterfaceListResultPage
type InterfaceLoadBalancerListResult = original.InterfaceLoadBalancerListResult
type InterfaceLoadBalancerListResultIterator = original.InterfaceLoadBalancerListResultIterator
type InterfaceLoadBalancerListResultPage = original.InterfaceLoadBalancerListResultPage
type InterfaceLoadBalancersClient = original.InterfaceLoadBalancersClient
type InterfacePropertiesFormat = original.InterfacePropertiesFormat
type InterfaceTapConfiguration = original.InterfaceTapConfiguration
type InterfaceTapConfigurationListResult = original.InterfaceTapConfigurationListResult
type InterfaceTapConfigurationListResultIterator = original.InterfaceTapConfigurationListResultIterator
type InterfaceTapConfigurationListResultPage = original.InterfaceTapConfigurationListResultPage
type InterfaceTapConfigurationPropertiesFormat = original.InterfaceTapConfigurationPropertiesFormat
type InterfaceTapConfigurationsClient = original.InterfaceTapConfigurationsClient
type InterfaceTapConfigurationsCreateOrUpdateFuture = original.InterfaceTapConfigurationsCreateOrUpdateFuture
type InterfaceTapConfigurationsDeleteFuture = original.InterfaceTapConfigurationsDeleteFuture
type InterfacesClient = original.InterfacesClient
type InterfacesCreateOrUpdateFuture = original.InterfacesCreateOrUpdateFuture
type InterfacesDeleteFuture = original.InterfacesDeleteFuture
type InterfacesGetEffectiveRouteTableFuture = original.InterfacesGetEffectiveRouteTableFuture
type InterfacesListEffectiveNetworkSecurityGroupsFuture = original.InterfacesListEffectiveNetworkSecurityGroupsFuture
type IpsecPolicy = original.IpsecPolicy
type Ipv6ExpressRouteCircuitPeeringConfig = original.Ipv6ExpressRouteCircuitPeeringConfig
type ListHubVirtualNetworkConnectionsResult = original.ListHubVirtualNetworkConnectionsResult
type ListHubVirtualNetworkConnectionsResultIterator = original.ListHubVirtualNetworkConnectionsResultIterator
type ListHubVirtualNetworkConnectionsResultPage = original.ListHubVirtualNetworkConnectionsResultPage
type ListP2SVpnGatewaysResult = original.ListP2SVpnGatewaysResult
type ListP2SVpnGatewaysResultIterator = original.ListP2SVpnGatewaysResultIterator
type ListP2SVpnGatewaysResultPage = original.ListP2SVpnGatewaysResultPage
type ListString = original.ListString
type ListVirtualHubRouteTableV2sResult = original.ListVirtualHubRouteTableV2sResult
type ListVirtualHubRouteTableV2sResultIterator = original.ListVirtualHubRouteTableV2sResultIterator
type ListVirtualHubRouteTableV2sResultPage = original.ListVirtualHubRouteTableV2sResultPage
type ListVirtualHubsResult = original.ListVirtualHubsResult
type ListVirtualHubsResultIterator = original.ListVirtualHubsResultIterator
type ListVirtualHubsResultPage = original.ListVirtualHubsResultPage
type ListVirtualWANsResult = original.ListVirtualWANsResult
type ListVirtualWANsResultIterator = original.ListVirtualWANsResultIterator
type ListVirtualWANsResultPage = original.ListVirtualWANsResultPage
type ListVpnConnectionsResult = original.ListVpnConnectionsResult
type ListVpnConnectionsResultIterator = original.ListVpnConnectionsResultIterator
type ListVpnConnectionsResultPage = original.ListVpnConnectionsResultPage
type ListVpnGatewaysResult = original.ListVpnGatewaysResult
type ListVpnGatewaysResultIterator = original.ListVpnGatewaysResultIterator
type ListVpnGatewaysResultPage = original.ListVpnGatewaysResultPage
type ListVpnServerConfigurationsResult = original.ListVpnServerConfigurationsResult
type ListVpnServerConfigurationsResultIterator = original.ListVpnServerConfigurationsResultIterator
type ListVpnServerConfigurationsResultPage = original.ListVpnServerConfigurationsResultPage
type ListVpnSiteLinkConnectionsResult = original.ListVpnSiteLinkConnectionsResult
type ListVpnSiteLinkConnectionsResultIterator = original.ListVpnSiteLinkConnectionsResultIterator
type ListVpnSiteLinkConnectionsResultPage = original.ListVpnSiteLinkConnectionsResultPage
type ListVpnSiteLinksResult = original.ListVpnSiteLinksResult
type ListVpnSiteLinksResultIterator = original.ListVpnSiteLinksResultIterator
type ListVpnSiteLinksResultPage = original.ListVpnSiteLinksResultPage
type ListVpnSitesResult = original.ListVpnSitesResult
type ListVpnSitesResultIterator = original.ListVpnSitesResultIterator
type ListVpnSitesResultPage = original.ListVpnSitesResultPage
type LoadBalancer = original.LoadBalancer
type LoadBalancerBackendAddressPoolListResult = original.LoadBalancerBackendAddressPoolListResult
type LoadBalancerBackendAddressPoolListResultIterator = original.LoadBalancerBackendAddressPoolListResultIterator
type LoadBalancerBackendAddressPoolListResultPage = original.LoadBalancerBackendAddressPoolListResultPage
type LoadBalancerBackendAddressPoolsClient = original.LoadBalancerBackendAddressPoolsClient
type LoadBalancerFrontendIPConfigurationListResult = original.LoadBalancerFrontendIPConfigurationListResult
type LoadBalancerFrontendIPConfigurationListResultIterator = original.LoadBalancerFrontendIPConfigurationListResultIterator
type LoadBalancerFrontendIPConfigurationListResultPage = original.LoadBalancerFrontendIPConfigurationListResultPage
type LoadBalancerFrontendIPConfigurationsClient = original.LoadBalancerFrontendIPConfigurationsClient
type LoadBalancerListResult = original.LoadBalancerListResult
type LoadBalancerListResultIterator = original.LoadBalancerListResultIterator
type LoadBalancerListResultPage = original.LoadBalancerListResultPage
type LoadBalancerLoadBalancingRuleListResult = original.LoadBalancerLoadBalancingRuleListResult
type LoadBalancerLoadBalancingRuleListResultIterator = original.LoadBalancerLoadBalancingRuleListResultIterator
type LoadBalancerLoadBalancingRuleListResultPage = original.LoadBalancerLoadBalancingRuleListResultPage
type LoadBalancerLoadBalancingRulesClient = original.LoadBalancerLoadBalancingRulesClient
type LoadBalancerNetworkInterfacesClient = original.LoadBalancerNetworkInterfacesClient
type LoadBalancerOutboundRuleListResult = original.LoadBalancerOutboundRuleListResult
type LoadBalancerOutboundRuleListResultIterator = original.LoadBalancerOutboundRuleListResultIterator
type LoadBalancerOutboundRuleListResultPage = original.LoadBalancerOutboundRuleListResultPage
type LoadBalancerOutboundRulesClient = original.LoadBalancerOutboundRulesClient
type LoadBalancerProbeListResult = original.LoadBalancerProbeListResult
type LoadBalancerProbeListResultIterator = original.LoadBalancerProbeListResultIterator
type LoadBalancerProbeListResultPage = original.LoadBalancerProbeListResultPage
type LoadBalancerProbesClient = original.LoadBalancerProbesClient
type LoadBalancerPropertiesFormat = original.LoadBalancerPropertiesFormat
type LoadBalancerSku = original.LoadBalancerSku
type LoadBalancersClient = original.LoadBalancersClient
type LoadBalancersCreateOrUpdateFuture = original.LoadBalancersCreateOrUpdateFuture
type LoadBalancersDeleteFuture = original.LoadBalancersDeleteFuture
type LoadBalancingRule = original.LoadBalancingRule
type LoadBalancingRulePropertiesFormat = original.LoadBalancingRulePropertiesFormat
type LocalNetworkGateway = original.LocalNetworkGateway
type LocalNetworkGatewayListResult = original.LocalNetworkGatewayListResult
type LocalNetworkGatewayListResultIterator = original.LocalNetworkGatewayListResultIterator
type LocalNetworkGatewayListResultPage = original.LocalNetworkGatewayListResultPage
type LocalNetworkGatewayPropertiesFormat = original.LocalNetworkGatewayPropertiesFormat
type LocalNetworkGatewaysClient = original.LocalNetworkGatewaysClient
type LocalNetworkGatewaysCreateOrUpdateFuture = original.LocalNetworkGatewaysCreateOrUpdateFuture
type LocalNetworkGatewaysDeleteFuture = original.LocalNetworkGatewaysDeleteFuture
type LogSpecification = original.LogSpecification
type ManagedRuleGroupOverride = original.ManagedRuleGroupOverride
type ManagedRuleOverride = original.ManagedRuleOverride
type ManagedRuleSet = original.ManagedRuleSet
type ManagedRulesDefinition = original.ManagedRulesDefinition
type ManagedServiceIdentity = original.ManagedServiceIdentity
type ManagedServiceIdentityUserAssignedIdentitiesValue = original.ManagedServiceIdentityUserAssignedIdentitiesValue
type MatchCondition = original.MatchCondition
type MatchVariable = original.MatchVariable
type MatchedRule = original.MatchedRule
type MetricSpecification = original.MetricSpecification
type NatGateway = original.NatGateway
type NatGatewayListResult = original.NatGatewayListResult
type NatGatewayListResultIterator = original.NatGatewayListResultIterator
type NatGatewayListResultPage = original.NatGatewayListResultPage
type NatGatewayPropertiesFormat = original.NatGatewayPropertiesFormat
type NatGatewaySku = original.NatGatewaySku
type NatGatewaysClient = original.NatGatewaysClient
type NatGatewaysCreateOrUpdateFuture = original.NatGatewaysCreateOrUpdateFuture
type NatGatewaysDeleteFuture = original.NatGatewaysDeleteFuture
type NextHopParameters = original.NextHopParameters
type NextHopResult = original.NextHopResult
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationPropertiesFormat = original.OperationPropertiesFormat
type OperationPropertiesFormatServiceSpecification = original.OperationPropertiesFormatServiceSpecification
type OperationsClient = original.OperationsClient
type OutboundRule = original.OutboundRule
type OutboundRulePropertiesFormat = original.OutboundRulePropertiesFormat
type OwaspCrsExclusionEntry = original.OwaspCrsExclusionEntry
type P2SConnectionConfiguration = original.P2SConnectionConfiguration
type P2SConnectionConfigurationProperties = original.P2SConnectionConfigurationProperties
type P2SVpnConnectionHealth = original.P2SVpnConnectionHealth
type P2SVpnConnectionHealthRequest = original.P2SVpnConnectionHealthRequest
type P2SVpnGateway = original.P2SVpnGateway
type P2SVpnGatewayProperties = original.P2SVpnGatewayProperties
type P2SVpnProfileParameters = original.P2SVpnProfileParameters
type P2sVpnGatewaysClient = original.P2sVpnGatewaysClient
type P2sVpnGatewaysCreateOrUpdateFuture = original.P2sVpnGatewaysCreateOrUpdateFuture
type P2sVpnGatewaysDeleteFuture = original.P2sVpnGatewaysDeleteFuture
type P2sVpnGatewaysGenerateVpnProfileFuture = original.P2sVpnGatewaysGenerateVpnProfileFuture
type P2sVpnGatewaysGetP2sVpnConnectionHealthDetailedFuture = original.P2sVpnGatewaysGetP2sVpnConnectionHealthDetailedFuture
type P2sVpnGatewaysGetP2sVpnConnectionHealthFuture = original.P2sVpnGatewaysGetP2sVpnConnectionHealthFuture
type PacketCapture = original.PacketCapture
type PacketCaptureFilter = original.PacketCaptureFilter
type PacketCaptureListResult = original.PacketCaptureListResult
type PacketCaptureParameters = original.PacketCaptureParameters
type PacketCaptureQueryStatusResult = original.PacketCaptureQueryStatusResult
type PacketCaptureResult = original.PacketCaptureResult
type PacketCaptureResultProperties = original.PacketCaptureResultProperties
type PacketCaptureStorageLocation = original.PacketCaptureStorageLocation
type PacketCapturesClient = original.PacketCapturesClient
type PacketCapturesCreateFuture = original.PacketCapturesCreateFuture
type PacketCapturesDeleteFuture = original.PacketCapturesDeleteFuture
type PacketCapturesGetStatusFuture = original.PacketCapturesGetStatusFuture
type PacketCapturesStopFuture = original.PacketCapturesStopFuture
type PatchRouteFilter = original.PatchRouteFilter
type PatchRouteFilterRule = original.PatchRouteFilterRule
type PeerExpressRouteCircuitConnection = original.PeerExpressRouteCircuitConnection
type PeerExpressRouteCircuitConnectionListResult = original.PeerExpressRouteCircuitConnectionListResult
type PeerExpressRouteCircuitConnectionListResultIterator = original.PeerExpressRouteCircuitConnectionListResultIterator
type PeerExpressRouteCircuitConnectionListResultPage = original.PeerExpressRouteCircuitConnectionListResultPage
type PeerExpressRouteCircuitConnectionPropertiesFormat = original.PeerExpressRouteCircuitConnectionPropertiesFormat
type PeerExpressRouteCircuitConnectionsClient = original.PeerExpressRouteCircuitConnectionsClient
type PolicySettings = original.PolicySettings
type PrepareNetworkPoliciesRequest = original.PrepareNetworkPoliciesRequest
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointListResult = original.PrivateEndpointListResult
type PrivateEndpointListResultIterator = original.PrivateEndpointListResultIterator
type PrivateEndpointListResultPage = original.PrivateEndpointListResultPage
type PrivateEndpointProperties = original.PrivateEndpointProperties
type PrivateEndpointsClient = original.PrivateEndpointsClient
type PrivateEndpointsCreateOrUpdateFuture = original.PrivateEndpointsCreateOrUpdateFuture
type PrivateEndpointsDeleteFuture = original.PrivateEndpointsDeleteFuture
type PrivateLinkService = original.PrivateLinkService
type PrivateLinkServiceConnection = original.PrivateLinkServiceConnection
type PrivateLinkServiceConnectionProperties = original.PrivateLinkServiceConnectionProperties
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type PrivateLinkServiceIPConfiguration = original.PrivateLinkServiceIPConfiguration
type PrivateLinkServiceIPConfigurationProperties = original.PrivateLinkServiceIPConfigurationProperties
type PrivateLinkServiceListResult = original.PrivateLinkServiceListResult
type PrivateLinkServiceListResultIterator = original.PrivateLinkServiceListResultIterator
type PrivateLinkServiceListResultPage = original.PrivateLinkServiceListResultPage
type PrivateLinkServiceProperties = original.PrivateLinkServiceProperties
type PrivateLinkServicePropertiesAutoApproval = original.PrivateLinkServicePropertiesAutoApproval
type PrivateLinkServicePropertiesVisibility = original.PrivateLinkServicePropertiesVisibility
type PrivateLinkServiceVisibility = original.PrivateLinkServiceVisibility
type PrivateLinkServicesClient = original.PrivateLinkServicesClient
type PrivateLinkServicesCreateOrUpdateFuture = original.PrivateLinkServicesCreateOrUpdateFuture
type PrivateLinkServicesDeleteFuture = original.PrivateLinkServicesDeleteFuture
type PrivateLinkServicesDeletePrivateEndpointConnectionFuture = original.PrivateLinkServicesDeletePrivateEndpointConnectionFuture
type Probe = original.Probe
type ProbePropertiesFormat = original.ProbePropertiesFormat
type Profile = original.Profile
type ProfileListResult = original.ProfileListResult
type ProfileListResultIterator = original.ProfileListResultIterator
type ProfileListResultPage = original.ProfileListResultPage
type ProfilePropertiesFormat = original.ProfilePropertiesFormat
type ProfilesClient = original.ProfilesClient
type ProfilesDeleteFuture = original.ProfilesDeleteFuture
type ProtocolConfiguration = original.ProtocolConfiguration
type ProtocolCustomSettingsFormat = original.ProtocolCustomSettingsFormat
type PublicIPAddress = original.PublicIPAddress
type PublicIPAddressDNSSettings = original.PublicIPAddressDNSSettings
type PublicIPAddressListResult = original.PublicIPAddressListResult
type PublicIPAddressListResultIterator = original.PublicIPAddressListResultIterator
type PublicIPAddressListResultPage = original.PublicIPAddressListResultPage
type PublicIPAddressPropertiesFormat = original.PublicIPAddressPropertiesFormat
type PublicIPAddressSku = original.PublicIPAddressSku
type PublicIPAddressesClient = original.PublicIPAddressesClient
type PublicIPAddressesCreateOrUpdateFuture = original.PublicIPAddressesCreateOrUpdateFuture
type PublicIPAddressesDeleteFuture = original.PublicIPAddressesDeleteFuture
type PublicIPPrefix = original.PublicIPPrefix
type PublicIPPrefixListResult = original.PublicIPPrefixListResult
type PublicIPPrefixListResultIterator = original.PublicIPPrefixListResultIterator
type PublicIPPrefixListResultPage = original.PublicIPPrefixListResultPage
type PublicIPPrefixPropertiesFormat = original.PublicIPPrefixPropertiesFormat
type PublicIPPrefixSku = original.PublicIPPrefixSku
type PublicIPPrefixesClient = original.PublicIPPrefixesClient
type PublicIPPrefixesCreateOrUpdateFuture = original.PublicIPPrefixesCreateOrUpdateFuture
type PublicIPPrefixesDeleteFuture = original.PublicIPPrefixesDeleteFuture
type QueryTroubleshootingParameters = original.QueryTroubleshootingParameters
type ReferencedPublicIPAddress = original.ReferencedPublicIPAddress
type Resource = original.Resource
type ResourceNavigationLink = original.ResourceNavigationLink
type ResourceNavigationLinkFormat = original.ResourceNavigationLinkFormat
type ResourceNavigationLinksClient = original.ResourceNavigationLinksClient
type ResourceNavigationLinksListResult = original.ResourceNavigationLinksListResult
type ResourceSet = original.ResourceSet
type RetentionPolicyParameters = original.RetentionPolicyParameters
type Route = original.Route
type RouteFilter = original.RouteFilter
type RouteFilterListResult = original.RouteFilterListResult
type RouteFilterListResultIterator = original.RouteFilterListResultIterator
type RouteFilterListResultPage = original.RouteFilterListResultPage
type RouteFilterPropertiesFormat = original.RouteFilterPropertiesFormat
type RouteFilterRule = original.RouteFilterRule
type RouteFilterRuleListResult = original.RouteFilterRuleListResult
type RouteFilterRuleListResultIterator = original.RouteFilterRuleListResultIterator
type RouteFilterRuleListResultPage = original.RouteFilterRuleListResultPage
type RouteFilterRulePropertiesFormat = original.RouteFilterRulePropertiesFormat
type RouteFilterRulesClient = original.RouteFilterRulesClient
type RouteFilterRulesCreateOrUpdateFuture = original.RouteFilterRulesCreateOrUpdateFuture
type RouteFilterRulesDeleteFuture = original.RouteFilterRulesDeleteFuture
type RouteFiltersClient = original.RouteFiltersClient
type RouteFiltersCreateOrUpdateFuture = original.RouteFiltersCreateOrUpdateFuture
type RouteFiltersDeleteFuture = original.RouteFiltersDeleteFuture
type RouteListResult = original.RouteListResult
type RouteListResultIterator = original.RouteListResultIterator
type RouteListResultPage = original.RouteListResultPage
type RoutePropertiesFormat = original.RoutePropertiesFormat
type RouteTable = original.RouteTable
type RouteTableListResult = original.RouteTableListResult
type RouteTableListResultIterator = original.RouteTableListResultIterator
type RouteTableListResultPage = original.RouteTableListResultPage
type RouteTablePropertiesFormat = original.RouteTablePropertiesFormat
type RouteTablesClient = original.RouteTablesClient
type RouteTablesCreateOrUpdateFuture = original.RouteTablesCreateOrUpdateFuture
type RouteTablesDeleteFuture = original.RouteTablesDeleteFuture
type RoutesClient = original.RoutesClient
type RoutesCreateOrUpdateFuture = original.RoutesCreateOrUpdateFuture
type RoutesDeleteFuture = original.RoutesDeleteFuture
type RuleCondition = original.RuleCondition
type SecurityGroup = original.SecurityGroup
type SecurityGroupListResult = original.SecurityGroupListResult
type SecurityGroupListResultIterator = original.SecurityGroupListResultIterator
type SecurityGroupListResultPage = original.SecurityGroupListResultPage
type SecurityGroupNetworkInterface = original.SecurityGroupNetworkInterface
type SecurityGroupPropertiesFormat = original.SecurityGroupPropertiesFormat
type SecurityGroupResult = original.SecurityGroupResult
type SecurityGroupViewParameters = original.SecurityGroupViewParameters
type SecurityGroupViewResult = original.SecurityGroupViewResult
type SecurityGroupsClient = original.SecurityGroupsClient
type SecurityGroupsCreateOrUpdateFuture = original.SecurityGroupsCreateOrUpdateFuture
type SecurityGroupsDeleteFuture = original.SecurityGroupsDeleteFuture
type SecurityRule = original.SecurityRule
type SecurityRuleAssociations = original.SecurityRuleAssociations
type SecurityRuleListResult = original.SecurityRuleListResult
type SecurityRuleListResultIterator = original.SecurityRuleListResultIterator
type SecurityRuleListResultPage = original.SecurityRuleListResultPage
type SecurityRulePropertiesFormat = original.SecurityRulePropertiesFormat
type SecurityRulesClient = original.SecurityRulesClient
type SecurityRulesCreateOrUpdateFuture = original.SecurityRulesCreateOrUpdateFuture
type SecurityRulesDeleteFuture = original.SecurityRulesDeleteFuture
type SecurityRulesEvaluationResult = original.SecurityRulesEvaluationResult
type ServiceAssociationLink = original.ServiceAssociationLink
type ServiceAssociationLinkPropertiesFormat = original.ServiceAssociationLinkPropertiesFormat
type ServiceAssociationLinksClient = original.ServiceAssociationLinksClient
type ServiceAssociationLinksListResult = original.ServiceAssociationLinksListResult
type ServiceDelegationPropertiesFormat = original.ServiceDelegationPropertiesFormat
type ServiceEndpointPoliciesClient = original.ServiceEndpointPoliciesClient
type ServiceEndpointPoliciesCreateOrUpdateFuture = original.ServiceEndpointPoliciesCreateOrUpdateFuture
type ServiceEndpointPoliciesDeleteFuture = original.ServiceEndpointPoliciesDeleteFuture
type ServiceEndpointPolicy = original.ServiceEndpointPolicy
type ServiceEndpointPolicyDefinition = original.ServiceEndpointPolicyDefinition
type ServiceEndpointPolicyDefinitionListResult = original.ServiceEndpointPolicyDefinitionListResult
type ServiceEndpointPolicyDefinitionListResultIterator = original.ServiceEndpointPolicyDefinitionListResultIterator
type ServiceEndpointPolicyDefinitionListResultPage = original.ServiceEndpointPolicyDefinitionListResultPage
type ServiceEndpointPolicyDefinitionPropertiesFormat = original.ServiceEndpointPolicyDefinitionPropertiesFormat
type ServiceEndpointPolicyDefinitionsClient = original.ServiceEndpointPolicyDefinitionsClient
type ServiceEndpointPolicyDefinitionsCreateOrUpdateFuture = original.ServiceEndpointPolicyDefinitionsCreateOrUpdateFuture
type ServiceEndpointPolicyDefinitionsDeleteFuture = original.ServiceEndpointPolicyDefinitionsDeleteFuture
type ServiceEndpointPolicyListResult = original.ServiceEndpointPolicyListResult
type ServiceEndpointPolicyListResultIterator = original.ServiceEndpointPolicyListResultIterator
type ServiceEndpointPolicyListResultPage = original.ServiceEndpointPolicyListResultPage
type ServiceEndpointPolicyPropertiesFormat = original.ServiceEndpointPolicyPropertiesFormat
type ServiceEndpointPropertiesFormat = original.ServiceEndpointPropertiesFormat
type ServiceTagInformation = original.ServiceTagInformation
type ServiceTagInformationPropertiesFormat = original.ServiceTagInformationPropertiesFormat
type ServiceTagsClient = original.ServiceTagsClient
type ServiceTagsListResult = original.ServiceTagsListResult
type String = original.String
type SubResource = original.SubResource
type Subnet = original.Subnet
type SubnetAssociation = original.SubnetAssociation
type SubnetListResult = original.SubnetListResult
type SubnetListResultIterator = original.SubnetListResultIterator
type SubnetListResultPage = original.SubnetListResultPage
type SubnetPropertiesFormat = original.SubnetPropertiesFormat
type SubnetsClient = original.SubnetsClient
type SubnetsCreateOrUpdateFuture = original.SubnetsCreateOrUpdateFuture
type SubnetsDeleteFuture = original.SubnetsDeleteFuture
type SubnetsPrepareNetworkPoliciesFuture = original.SubnetsPrepareNetworkPoliciesFuture
type SubnetsUnprepareNetworkPoliciesFuture = original.SubnetsUnprepareNetworkPoliciesFuture
type TagsObject = original.TagsObject
type Topology = original.Topology
type TopologyAssociation = original.TopologyAssociation
type TopologyParameters = original.TopologyParameters
type TopologyResource = original.TopologyResource
type TrafficAnalyticsConfigurationProperties = original.TrafficAnalyticsConfigurationProperties
type TrafficAnalyticsProperties = original.TrafficAnalyticsProperties
type TrafficSelectorPolicy = original.TrafficSelectorPolicy
type TroubleshootingDetails = original.TroubleshootingDetails
type TroubleshootingParameters = original.TroubleshootingParameters
type TroubleshootingProperties = original.TroubleshootingProperties
type TroubleshootingRecommendedActions = original.TroubleshootingRecommendedActions
type TroubleshootingResult = original.TroubleshootingResult
type TunnelConnectionHealth = original.TunnelConnectionHealth
type UnprepareNetworkPoliciesRequest = original.UnprepareNetworkPoliciesRequest
type Usage = original.Usage
type UsageName = original.UsageName
type UsagesClient = original.UsagesClient
type UsagesListResult = original.UsagesListResult
type UsagesListResultIterator = original.UsagesListResultIterator
type UsagesListResultPage = original.UsagesListResultPage
type VerificationIPFlowParameters = original.VerificationIPFlowParameters
type VerificationIPFlowResult = original.VerificationIPFlowResult
type VirtualHub = original.VirtualHub
type VirtualHubID = original.VirtualHubID
type VirtualHubProperties = original.VirtualHubProperties
type VirtualHubRoute = original.VirtualHubRoute
type VirtualHubRouteTable = original.VirtualHubRouteTable
type VirtualHubRouteTableV2 = original.VirtualHubRouteTableV2
type VirtualHubRouteTableV2Properties = original.VirtualHubRouteTableV2Properties
type VirtualHubRouteTableV2sClient = original.VirtualHubRouteTableV2sClient
type VirtualHubRouteTableV2sCreateOrUpdateFuture = original.VirtualHubRouteTableV2sCreateOrUpdateFuture
type VirtualHubRouteTableV2sDeleteFuture = original.VirtualHubRouteTableV2sDeleteFuture
type VirtualHubRouteV2 = original.VirtualHubRouteV2
type VirtualHubsClient = original.VirtualHubsClient
type VirtualHubsCreateOrUpdateFuture = original.VirtualHubsCreateOrUpdateFuture
type VirtualHubsDeleteFuture = original.VirtualHubsDeleteFuture
type VirtualNetwork = original.VirtualNetwork
type VirtualNetworkBgpCommunities = original.VirtualNetworkBgpCommunities
type VirtualNetworkConnectionGatewayReference = original.VirtualNetworkConnectionGatewayReference
type VirtualNetworkGateway = original.VirtualNetworkGateway
type VirtualNetworkGatewayConnection = original.VirtualNetworkGatewayConnection
type VirtualNetworkGatewayConnectionListEntity = original.VirtualNetworkGatewayConnectionListEntity
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat = original.VirtualNetworkGatewayConnectionListEntityPropertiesFormat
type VirtualNetworkGatewayConnectionListResult = original.VirtualNetworkGatewayConnectionListResult
type VirtualNetworkGatewayConnectionListResultIterator = original.VirtualNetworkGatewayConnectionListResultIterator
type VirtualNetworkGatewayConnectionListResultPage = original.VirtualNetworkGatewayConnectionListResultPage
type VirtualNetworkGatewayConnectionPropertiesFormat = original.VirtualNetworkGatewayConnectionPropertiesFormat
type VirtualNetworkGatewayConnectionsClient = original.VirtualNetworkGatewayConnectionsClient
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture = original.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture
type VirtualNetworkGatewayConnectionsDeleteFuture = original.VirtualNetworkGatewayConnectionsDeleteFuture
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsResetSharedKeyFuture
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsSetSharedKeyFuture
type VirtualNetworkGatewayConnectionsStartPacketCaptureFuture = original.VirtualNetworkGatewayConnectionsStartPacketCaptureFuture
type VirtualNetworkGatewayConnectionsStopPacketCaptureFuture = original.VirtualNetworkGatewayConnectionsStopPacketCaptureFuture
type VirtualNetworkGatewayConnectionsUpdateTagsFuture = original.VirtualNetworkGatewayConnectionsUpdateTagsFuture
type VirtualNetworkGatewayIPConfiguration = original.VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat = original.VirtualNetworkGatewayIPConfigurationPropertiesFormat
type VirtualNetworkGatewayListConnectionsResult = original.VirtualNetworkGatewayListConnectionsResult
type VirtualNetworkGatewayListConnectionsResultIterator = original.VirtualNetworkGatewayListConnectionsResultIterator
type VirtualNetworkGatewayListConnectionsResultPage = original.VirtualNetworkGatewayListConnectionsResultPage
type VirtualNetworkGatewayListResult = original.VirtualNetworkGatewayListResult
type VirtualNetworkGatewayListResultIterator = original.VirtualNetworkGatewayListResultIterator
type VirtualNetworkGatewayListResultPage = original.VirtualNetworkGatewayListResultPage
type VirtualNetworkGatewayPropertiesFormat = original.VirtualNetworkGatewayPropertiesFormat
type VirtualNetworkGatewaySku = original.VirtualNetworkGatewaySku
type VirtualNetworkGatewaysClient = original.VirtualNetworkGatewaysClient
type VirtualNetworkGatewaysCreateOrUpdateFuture = original.VirtualNetworkGatewaysCreateOrUpdateFuture
type VirtualNetworkGatewaysDeleteFuture = original.VirtualNetworkGatewaysDeleteFuture
type VirtualNetworkGatewaysGenerateVpnProfileFuture = original.VirtualNetworkGatewaysGenerateVpnProfileFuture
type VirtualNetworkGatewaysGeneratevpnclientpackageFuture = original.VirtualNetworkGatewaysGeneratevpnclientpackageFuture
type VirtualNetworkGatewaysGetAdvertisedRoutesFuture = original.VirtualNetworkGatewaysGetAdvertisedRoutesFuture
type VirtualNetworkGatewaysGetBgpPeerStatusFuture = original.VirtualNetworkGatewaysGetBgpPeerStatusFuture
type VirtualNetworkGatewaysGetLearnedRoutesFuture = original.VirtualNetworkGatewaysGetLearnedRoutesFuture
type VirtualNetworkGatewaysGetVpnProfilePackageURLFuture = original.VirtualNetworkGatewaysGetVpnProfilePackageURLFuture
type VirtualNetworkGatewaysGetVpnclientConnectionHealthFuture = original.VirtualNetworkGatewaysGetVpnclientConnectionHealthFuture
type VirtualNetworkGatewaysGetVpnclientIpsecParametersFuture = original.VirtualNetworkGatewaysGetVpnclientIpsecParametersFuture
type VirtualNetworkGatewaysResetFuture = original.VirtualNetworkGatewaysResetFuture
type VirtualNetworkGatewaysResetVpnClientSharedKeyFuture = original.VirtualNetworkGatewaysResetVpnClientSharedKeyFuture
type VirtualNetworkGatewaysSetVpnclientIpsecParametersFuture = original.VirtualNetworkGatewaysSetVpnclientIpsecParametersFuture
type VirtualNetworkGatewaysStartPacketCaptureFuture = original.VirtualNetworkGatewaysStartPacketCaptureFuture
type VirtualNetworkGatewaysStopPacketCaptureFuture = original.VirtualNetworkGatewaysStopPacketCaptureFuture
type VirtualNetworkGatewaysUpdateTagsFuture = original.VirtualNetworkGatewaysUpdateTagsFuture
type VirtualNetworkListResult = original.VirtualNetworkListResult
type VirtualNetworkListResultIterator = original.VirtualNetworkListResultIterator
type VirtualNetworkListResultPage = original.VirtualNetworkListResultPage
type VirtualNetworkListUsageResult = original.VirtualNetworkListUsageResult
type VirtualNetworkListUsageResultIterator = original.VirtualNetworkListUsageResultIterator
type VirtualNetworkListUsageResultPage = original.VirtualNetworkListUsageResultPage
type VirtualNetworkPeering = original.VirtualNetworkPeering
type VirtualNetworkPeeringListResult = original.VirtualNetworkPeeringListResult
type VirtualNetworkPeeringListResultIterator = original.VirtualNetworkPeeringListResultIterator
type VirtualNetworkPeeringListResultPage = original.VirtualNetworkPeeringListResultPage
type VirtualNetworkPeeringPropertiesFormat = original.VirtualNetworkPeeringPropertiesFormat
type VirtualNetworkPeeringsClient = original.VirtualNetworkPeeringsClient
type VirtualNetworkPeeringsCreateOrUpdateFuture = original.VirtualNetworkPeeringsCreateOrUpdateFuture
type VirtualNetworkPeeringsDeleteFuture = original.VirtualNetworkPeeringsDeleteFuture
type VirtualNetworkPropertiesFormat = original.VirtualNetworkPropertiesFormat
type VirtualNetworkTap = original.VirtualNetworkTap
type VirtualNetworkTapListResult = original.VirtualNetworkTapListResult
type VirtualNetworkTapListResultIterator = original.VirtualNetworkTapListResultIterator
type VirtualNetworkTapListResultPage = original.VirtualNetworkTapListResultPage
type VirtualNetworkTapPropertiesFormat = original.VirtualNetworkTapPropertiesFormat
type VirtualNetworkTapsClient = original.VirtualNetworkTapsClient
type VirtualNetworkTapsCreateOrUpdateFuture = original.VirtualNetworkTapsCreateOrUpdateFuture
type VirtualNetworkTapsDeleteFuture = original.VirtualNetworkTapsDeleteFuture
type VirtualNetworkUsage = original.VirtualNetworkUsage
type VirtualNetworkUsageName = original.VirtualNetworkUsageName
type VirtualNetworksClient = original.VirtualNetworksClient
type VirtualNetworksCreateOrUpdateFuture = original.VirtualNetworksCreateOrUpdateFuture
type VirtualNetworksDeleteFuture = original.VirtualNetworksDeleteFuture
type VirtualRouter = original.VirtualRouter
type VirtualRouterListResult = original.VirtualRouterListResult
type VirtualRouterListResultIterator = original.VirtualRouterListResultIterator
type VirtualRouterListResultPage = original.VirtualRouterListResultPage
type VirtualRouterPeering = original.VirtualRouterPeering
type VirtualRouterPeeringListResult = original.VirtualRouterPeeringListResult
type VirtualRouterPeeringListResultIterator = original.VirtualRouterPeeringListResultIterator
type VirtualRouterPeeringListResultPage = original.VirtualRouterPeeringListResultPage
type VirtualRouterPeeringProperties = original.VirtualRouterPeeringProperties
type VirtualRouterPeeringsClient = original.VirtualRouterPeeringsClient
type VirtualRouterPeeringsCreateOrUpdateFuture = original.VirtualRouterPeeringsCreateOrUpdateFuture
type VirtualRouterPeeringsDeleteFuture = original.VirtualRouterPeeringsDeleteFuture
type VirtualRouterPropertiesFormat = original.VirtualRouterPropertiesFormat
type VirtualRoutersClient = original.VirtualRoutersClient
type VirtualRoutersCreateOrUpdateFuture = original.VirtualRoutersCreateOrUpdateFuture
type VirtualRoutersDeleteFuture = original.VirtualRoutersDeleteFuture
type VirtualWAN = original.VirtualWAN
type VirtualWanProperties = original.VirtualWanProperties
type VirtualWanSecurityProvider = original.VirtualWanSecurityProvider
type VirtualWanSecurityProviders = original.VirtualWanSecurityProviders
type VirtualWanVpnProfileParameters = original.VirtualWanVpnProfileParameters
type VirtualWansClient = original.VirtualWansClient
type VirtualWansCreateOrUpdateFuture = original.VirtualWansCreateOrUpdateFuture
type VirtualWansDeleteFuture = original.VirtualWansDeleteFuture
type VpnClientConfiguration = original.VpnClientConfiguration
type VpnClientConnectionHealth = original.VpnClientConnectionHealth
type VpnClientConnectionHealthDetail = original.VpnClientConnectionHealthDetail
type VpnClientConnectionHealthDetailListResult = original.VpnClientConnectionHealthDetailListResult
type VpnClientIPsecParameters = original.VpnClientIPsecParameters
type VpnClientParameters = original.VpnClientParameters
type VpnClientRevokedCertificate = original.VpnClientRevokedCertificate
type VpnClientRevokedCertificatePropertiesFormat = original.VpnClientRevokedCertificatePropertiesFormat
type VpnClientRootCertificate = original.VpnClientRootCertificate
type VpnClientRootCertificatePropertiesFormat = original.VpnClientRootCertificatePropertiesFormat
type VpnConnection = original.VpnConnection
type VpnConnectionProperties = original.VpnConnectionProperties
type VpnConnectionsClient = original.VpnConnectionsClient
type VpnConnectionsCreateOrUpdateFuture = original.VpnConnectionsCreateOrUpdateFuture
type VpnConnectionsDeleteFuture = original.VpnConnectionsDeleteFuture
type VpnDeviceScriptParameters = original.VpnDeviceScriptParameters
type VpnGateway = original.VpnGateway
type VpnGatewayProperties = original.VpnGatewayProperties
type VpnGatewaysClient = original.VpnGatewaysClient
type VpnGatewaysCreateOrUpdateFuture = original.VpnGatewaysCreateOrUpdateFuture
type VpnGatewaysDeleteFuture = original.VpnGatewaysDeleteFuture
type VpnGatewaysResetFuture = original.VpnGatewaysResetFuture
type VpnLinkBgpSettings = original.VpnLinkBgpSettings
type VpnLinkConnectionsClient = original.VpnLinkConnectionsClient
type VpnLinkProviderProperties = original.VpnLinkProviderProperties
type VpnPacketCaptureStartParameters = original.VpnPacketCaptureStartParameters
type VpnPacketCaptureStopParameters = original.VpnPacketCaptureStopParameters
type VpnProfileResponse = original.VpnProfileResponse
type VpnServerConfigRadiusClientRootCertificate = original.VpnServerConfigRadiusClientRootCertificate
type VpnServerConfigRadiusServerRootCertificate = original.VpnServerConfigRadiusServerRootCertificate
type VpnServerConfigVpnClientRevokedCertificate = original.VpnServerConfigVpnClientRevokedCertificate
type VpnServerConfigVpnClientRootCertificate = original.VpnServerConfigVpnClientRootCertificate
type VpnServerConfiguration = original.VpnServerConfiguration
type VpnServerConfigurationProperties = original.VpnServerConfigurationProperties
type VpnServerConfigurationsAssociatedWithVirtualWanClient = original.VpnServerConfigurationsAssociatedWithVirtualWanClient
type VpnServerConfigurationsAssociatedWithVirtualWanListFuture = original.VpnServerConfigurationsAssociatedWithVirtualWanListFuture
type VpnServerConfigurationsClient = original.VpnServerConfigurationsClient
type VpnServerConfigurationsCreateOrUpdateFuture = original.VpnServerConfigurationsCreateOrUpdateFuture
type VpnServerConfigurationsDeleteFuture = original.VpnServerConfigurationsDeleteFuture
type VpnServerConfigurationsResponse = original.VpnServerConfigurationsResponse
type VpnSite = original.VpnSite
type VpnSiteID = original.VpnSiteID
type VpnSiteLink = original.VpnSiteLink
type VpnSiteLinkConnection = original.VpnSiteLinkConnection
type VpnSiteLinkConnectionProperties = original.VpnSiteLinkConnectionProperties
type VpnSiteLinkConnectionsClient = original.VpnSiteLinkConnectionsClient
type VpnSiteLinkProperties = original.VpnSiteLinkProperties
type VpnSiteLinksClient = original.VpnSiteLinksClient
type VpnSiteProperties = original.VpnSiteProperties
type VpnSitesClient = original.VpnSitesClient
type VpnSitesConfigurationClient = original.VpnSitesConfigurationClient
type VpnSitesConfigurationDownloadFuture = original.VpnSitesConfigurationDownloadFuture
type VpnSitesCreateOrUpdateFuture = original.VpnSitesCreateOrUpdateFuture
type VpnSitesDeleteFuture = original.VpnSitesDeleteFuture
type Watcher = original.Watcher
type WatcherListResult = original.WatcherListResult
type WatcherPropertiesFormat = original.WatcherPropertiesFormat
type WatchersCheckConnectivityFuture = original.WatchersCheckConnectivityFuture
type WatchersClient = original.WatchersClient
type WatchersDeleteFuture = original.WatchersDeleteFuture
type WatchersGetAzureReachabilityReportFuture = original.WatchersGetAzureReachabilityReportFuture
type WatchersGetFlowLogStatusFuture = original.WatchersGetFlowLogStatusFuture
type WatchersGetNetworkConfigurationDiagnosticFuture = original.WatchersGetNetworkConfigurationDiagnosticFuture
type WatchersGetNextHopFuture = original.WatchersGetNextHopFuture
type WatchersGetTroubleshootingFuture = original.WatchersGetTroubleshootingFuture
type WatchersGetTroubleshootingResultFuture = original.WatchersGetTroubleshootingResultFuture
type WatchersGetVMSecurityRulesFuture = original.WatchersGetVMSecurityRulesFuture
type WatchersListAvailableProvidersFuture = original.WatchersListAvailableProvidersFuture
type WatchersSetFlowLogConfigurationFuture = original.WatchersSetFlowLogConfigurationFuture
type WatchersVerifyIPFlowFuture = original.WatchersVerifyIPFlowFuture
type WebApplicationFirewallCustomRule = original.WebApplicationFirewallCustomRule
type WebApplicationFirewallPoliciesClient = original.WebApplicationFirewallPoliciesClient
type WebApplicationFirewallPoliciesDeleteFuture = original.WebApplicationFirewallPoliciesDeleteFuture
type WebApplicationFirewallPolicy = original.WebApplicationFirewallPolicy
type WebApplicationFirewallPolicyListResult = original.WebApplicationFirewallPolicyListResult
type WebApplicationFirewallPolicyListResultIterator = original.WebApplicationFirewallPolicyListResultIterator
type WebApplicationFirewallPolicyListResultPage = original.WebApplicationFirewallPolicyListResultPage
type WebApplicationFirewallPolicyPropertiesFormat = original.WebApplicationFirewallPolicyPropertiesFormat

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page ApplicationGatewayAvailableSslPredefinedPoliciesPage) ApplicationGatewayAvailableSslPredefinedPoliciesIterator {
	return original.NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page)
}
func NewApplicationGatewayAvailableSslPredefinedPoliciesPage(getNextPage func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)) ApplicationGatewayAvailableSslPredefinedPoliciesPage {
	return original.NewApplicationGatewayAvailableSslPredefinedPoliciesPage(getNextPage)
}
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return original.NewApplicationGatewayListResultIterator(page)
}
func NewApplicationGatewayListResultPage(getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return original.NewApplicationGatewayListResultPage(getNextPage)
}
func NewApplicationGatewaysClient(subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClient(subscriptionID)
}
func NewApplicationGatewaysClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationSecurityGroupListResultIterator(page ApplicationSecurityGroupListResultPage) ApplicationSecurityGroupListResultIterator {
	return original.NewApplicationSecurityGroupListResultIterator(page)
}
func NewApplicationSecurityGroupListResultPage(getNextPage func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)) ApplicationSecurityGroupListResultPage {
	return original.NewApplicationSecurityGroupListResultPage(getNextPage)
}
func NewApplicationSecurityGroupsClient(subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClient(subscriptionID)
}
func NewApplicationSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return original.NewAuthorizationListResultIterator(page)
}
func NewAuthorizationListResultPage(getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return original.NewAuthorizationListResultPage(getNextPage)
}
func NewAutoApprovedPrivateLinkServicesResultIterator(page AutoApprovedPrivateLinkServicesResultPage) AutoApprovedPrivateLinkServicesResultIterator {
	return original.NewAutoApprovedPrivateLinkServicesResultIterator(page)
}
func NewAutoApprovedPrivateLinkServicesResultPage(getNextPage func(context.Context, AutoApprovedPrivateLinkServicesResult) (AutoApprovedPrivateLinkServicesResult, error)) AutoApprovedPrivateLinkServicesResultPage {
	return original.NewAutoApprovedPrivateLinkServicesResultPage(getNextPage)
}
func NewAvailableDelegationsClient(subscriptionID string) AvailableDelegationsClient {
	return original.NewAvailableDelegationsClient(subscriptionID)
}
func NewAvailableDelegationsClientWithBaseURI(baseURI string, subscriptionID string) AvailableDelegationsClient {
	return original.NewAvailableDelegationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableDelegationsResultIterator(page AvailableDelegationsResultPage) AvailableDelegationsResultIterator {
	return original.NewAvailableDelegationsResultIterator(page)
}
func NewAvailableDelegationsResultPage(getNextPage func(context.Context, AvailableDelegationsResult) (AvailableDelegationsResult, error)) AvailableDelegationsResultPage {
	return original.NewAvailableDelegationsResultPage(getNextPage)
}
func NewAvailableEndpointServicesClient(subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClient(subscriptionID)
}
func NewAvailableEndpointServicesClientWithBaseURI(baseURI string, subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailablePrivateEndpointTypesClient(subscriptionID string) AvailablePrivateEndpointTypesClient {
	return original.NewAvailablePrivateEndpointTypesClient(subscriptionID)
}
func NewAvailablePrivateEndpointTypesClientWithBaseURI(baseURI string, subscriptionID string) AvailablePrivateEndpointTypesClient {
	return original.NewAvailablePrivateEndpointTypesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailablePrivateEndpointTypesResultIterator(page AvailablePrivateEndpointTypesResultPage) AvailablePrivateEndpointTypesResultIterator {
	return original.NewAvailablePrivateEndpointTypesResultIterator(page)
}
func NewAvailablePrivateEndpointTypesResultPage(getNextPage func(context.Context, AvailablePrivateEndpointTypesResult) (AvailablePrivateEndpointTypesResult, error)) AvailablePrivateEndpointTypesResultPage {
	return original.NewAvailablePrivateEndpointTypesResultPage(getNextPage)
}
func NewAvailableResourceGroupDelegationsClient(subscriptionID string) AvailableResourceGroupDelegationsClient {
	return original.NewAvailableResourceGroupDelegationsClient(subscriptionID)
}
func NewAvailableResourceGroupDelegationsClientWithBaseURI(baseURI string, subscriptionID string) AvailableResourceGroupDelegationsClient {
	return original.NewAvailableResourceGroupDelegationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableServiceAliasesClient(subscriptionID string) AvailableServiceAliasesClient {
	return original.NewAvailableServiceAliasesClient(subscriptionID)
}
func NewAvailableServiceAliasesClientWithBaseURI(baseURI string, subscriptionID string) AvailableServiceAliasesClient {
	return original.NewAvailableServiceAliasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableServiceAliasesResultIterator(page AvailableServiceAliasesResultPage) AvailableServiceAliasesResultIterator {
	return original.NewAvailableServiceAliasesResultIterator(page)
}
func NewAvailableServiceAliasesResultPage(getNextPage func(context.Context, AvailableServiceAliasesResult) (AvailableServiceAliasesResult, error)) AvailableServiceAliasesResultPage {
	return original.NewAvailableServiceAliasesResultPage(getNextPage)
}
func NewAzureFirewallFqdnTagListResultIterator(page AzureFirewallFqdnTagListResultPage) AzureFirewallFqdnTagListResultIterator {
	return original.NewAzureFirewallFqdnTagListResultIterator(page)
}
func NewAzureFirewallFqdnTagListResultPage(getNextPage func(context.Context, AzureFirewallFqdnTagListResult) (AzureFirewallFqdnTagListResult, error)) AzureFirewallFqdnTagListResultPage {
	return original.NewAzureFirewallFqdnTagListResultPage(getNextPage)
}
func NewAzureFirewallFqdnTagsClient(subscriptionID string) AzureFirewallFqdnTagsClient {
	return original.NewAzureFirewallFqdnTagsClient(subscriptionID)
}
func NewAzureFirewallFqdnTagsClientWithBaseURI(baseURI string, subscriptionID string) AzureFirewallFqdnTagsClient {
	return original.NewAzureFirewallFqdnTagsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAzureFirewallListResultIterator(page AzureFirewallListResultPage) AzureFirewallListResultIterator {
	return original.NewAzureFirewallListResultIterator(page)
}
func NewAzureFirewallListResultPage(getNextPage func(context.Context, AzureFirewallListResult) (AzureFirewallListResult, error)) AzureFirewallListResultPage {
	return original.NewAzureFirewallListResultPage(getNextPage)
}
func NewAzureFirewallsClient(subscriptionID string) AzureFirewallsClient {
	return original.NewAzureFirewallsClient(subscriptionID)
}
func NewAzureFirewallsClientWithBaseURI(baseURI string, subscriptionID string) AzureFirewallsClient {
	return original.NewAzureFirewallsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBastionHostListResultIterator(page BastionHostListResultPage) BastionHostListResultIterator {
	return original.NewBastionHostListResultIterator(page)
}
func NewBastionHostListResultPage(getNextPage func(context.Context, BastionHostListResult) (BastionHostListResult, error)) BastionHostListResultPage {
	return original.NewBastionHostListResultPage(getNextPage)
}
func NewBastionHostsClient(subscriptionID string) BastionHostsClient {
	return original.NewBastionHostsClient(subscriptionID)
}
func NewBastionHostsClientWithBaseURI(baseURI string, subscriptionID string) BastionHostsClient {
	return original.NewBastionHostsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBgpServiceCommunitiesClient(subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClient(subscriptionID)
}
func NewBgpServiceCommunitiesClientWithBaseURI(baseURI string, subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBgpServiceCommunityListResultIterator(page BgpServiceCommunityListResultPage) BgpServiceCommunityListResultIterator {
	return original.NewBgpServiceCommunityListResultIterator(page)
}
func NewBgpServiceCommunityListResultPage(getNextPage func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)) BgpServiceCommunityListResultPage {
	return original.NewBgpServiceCommunityListResultPage(getNextPage)
}
func NewConnectionMonitorsClient(subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClient(subscriptionID)
}
func NewConnectionMonitorsClientWithBaseURI(baseURI string, subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDdosCustomPoliciesClient(subscriptionID string) DdosCustomPoliciesClient {
	return original.NewDdosCustomPoliciesClient(subscriptionID)
}
func NewDdosCustomPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DdosCustomPoliciesClient {
	return original.NewDdosCustomPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDdosProtectionPlanListResultIterator(page DdosProtectionPlanListResultPage) DdosProtectionPlanListResultIterator {
	return original.NewDdosProtectionPlanListResultIterator(page)
}
func NewDdosProtectionPlanListResultPage(getNextPage func(context.Context, DdosProtectionPlanListResult) (DdosProtectionPlanListResult, error)) DdosProtectionPlanListResultPage {
	return original.NewDdosProtectionPlanListResultPage(getNextPage)
}
func NewDdosProtectionPlansClient(subscriptionID string) DdosProtectionPlansClient {
	return original.NewDdosProtectionPlansClient(subscriptionID)
}
func NewDdosProtectionPlansClientWithBaseURI(baseURI string, subscriptionID string) DdosProtectionPlansClient {
	return original.NewDdosProtectionPlansClientWithBaseURI(baseURI, subscriptionID)
}
func NewDefaultSecurityRulesClient(subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClient(subscriptionID)
}
func NewDefaultSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEndpointServicesListResultIterator(page EndpointServicesListResultPage) EndpointServicesListResultIterator {
	return original.NewEndpointServicesListResultIterator(page)
}
func NewEndpointServicesListResultPage(getNextPage func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)) EndpointServicesListResultPage {
	return original.NewEndpointServicesListResultPage(getNextPage)
}
func NewExpressRouteCircuitAuthorizationsClient(subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClient(subscriptionID)
}
func NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitConnectionListResultIterator(page ExpressRouteCircuitConnectionListResultPage) ExpressRouteCircuitConnectionListResultIterator {
	return original.NewExpressRouteCircuitConnectionListResultIterator(page)
}
func NewExpressRouteCircuitConnectionListResultPage(getNextPage func(context.Context, ExpressRouteCircuitConnectionListResult) (ExpressRouteCircuitConnectionListResult, error)) ExpressRouteCircuitConnectionListResultPage {
	return original.NewExpressRouteCircuitConnectionListResultPage(getNextPage)
}
func NewExpressRouteCircuitConnectionsClient(subscriptionID string) ExpressRouteCircuitConnectionsClient {
	return original.NewExpressRouteCircuitConnectionsClient(subscriptionID)
}
func NewExpressRouteCircuitConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitConnectionsClient {
	return original.NewExpressRouteCircuitConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return original.NewExpressRouteCircuitListResultIterator(page)
}
func NewExpressRouteCircuitListResultPage(getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return original.NewExpressRouteCircuitListResultPage(getNextPage)
}
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return original.NewExpressRouteCircuitPeeringListResultIterator(page)
}
func NewExpressRouteCircuitPeeringListResultPage(getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return original.NewExpressRouteCircuitPeeringListResultPage(getNextPage)
}
func NewExpressRouteCircuitPeeringsClient(subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClient(subscriptionID)
}
func NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitsClient(subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClient(subscriptionID)
}
func NewExpressRouteCircuitsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteConnectionsClient(subscriptionID string) ExpressRouteConnectionsClient {
	return original.NewExpressRouteConnectionsClient(subscriptionID)
}
func NewExpressRouteConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteConnectionsClient {
	return original.NewExpressRouteConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCrossConnectionListResultIterator(page ExpressRouteCrossConnectionListResultPage) ExpressRouteCrossConnectionListResultIterator {
	return original.NewExpressRouteCrossConnectionListResultIterator(page)
}
func NewExpressRouteCrossConnectionListResultPage(getNextPage func(context.Context, ExpressRouteCrossConnectionListResult) (ExpressRouteCrossConnectionListResult, error)) ExpressRouteCrossConnectionListResultPage {
	return original.NewExpressRouteCrossConnectionListResultPage(getNextPage)
}
func NewExpressRouteCrossConnectionPeeringListIterator(page ExpressRouteCrossConnectionPeeringListPage) ExpressRouteCrossConnectionPeeringListIterator {
	return original.NewExpressRouteCrossConnectionPeeringListIterator(page)
}
func NewExpressRouteCrossConnectionPeeringListPage(getNextPage func(context.Context, ExpressRouteCrossConnectionPeeringList) (ExpressRouteCrossConnectionPeeringList, error)) ExpressRouteCrossConnectionPeeringListPage {
	return original.NewExpressRouteCrossConnectionPeeringListPage(getNextPage)
}
func NewExpressRouteCrossConnectionPeeringsClient(subscriptionID string) ExpressRouteCrossConnectionPeeringsClient {
	return original.NewExpressRouteCrossConnectionPeeringsClient(subscriptionID)
}
func NewExpressRouteCrossConnectionPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCrossConnectionPeeringsClient {
	return original.NewExpressRouteCrossConnectionPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCrossConnectionsClient(subscriptionID string) ExpressRouteCrossConnectionsClient {
	return original.NewExpressRouteCrossConnectionsClient(subscriptionID)
}
func NewExpressRouteCrossConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCrossConnectionsClient {
	return original.NewExpressRouteCrossConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteGatewaysClient(subscriptionID string) ExpressRouteGatewaysClient {
	return original.NewExpressRouteGatewaysClient(subscriptionID)
}
func NewExpressRouteGatewaysClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteGatewaysClient {
	return original.NewExpressRouteGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteLinkListResultIterator(page ExpressRouteLinkListResultPage) ExpressRouteLinkListResultIterator {
	return original.NewExpressRouteLinkListResultIterator(page)
}
func NewExpressRouteLinkListResultPage(getNextPage func(context.Context, ExpressRouteLinkListResult) (ExpressRouteLinkListResult, error)) ExpressRouteLinkListResultPage {
	return original.NewExpressRouteLinkListResultPage(getNextPage)
}
func NewExpressRouteLinksClient(subscriptionID string) ExpressRouteLinksClient {
	return original.NewExpressRouteLinksClient(subscriptionID)
}
func NewExpressRouteLinksClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteLinksClient {
	return original.NewExpressRouteLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRoutePortListResultIterator(page ExpressRoutePortListResultPage) ExpressRoutePortListResultIterator {
	return original.NewExpressRoutePortListResultIterator(page)
}
func NewExpressRoutePortListResultPage(getNextPage func(context.Context, ExpressRoutePortListResult) (ExpressRoutePortListResult, error)) ExpressRoutePortListResultPage {
	return original.NewExpressRoutePortListResultPage(getNextPage)
}
func NewExpressRoutePortsClient(subscriptionID string) ExpressRoutePortsClient {
	return original.NewExpressRoutePortsClient(subscriptionID)
}
func NewExpressRoutePortsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRoutePortsClient {
	return original.NewExpressRoutePortsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRoutePortsLocationListResultIterator(page ExpressRoutePortsLocationListResultPage) ExpressRoutePortsLocationListResultIterator {
	return original.NewExpressRoutePortsLocationListResultIterator(page)
}
func NewExpressRoutePortsLocationListResultPage(getNextPage func(context.Context, ExpressRoutePortsLocationListResult) (ExpressRoutePortsLocationListResult, error)) ExpressRoutePortsLocationListResultPage {
	return original.NewExpressRoutePortsLocationListResultPage(getNextPage)
}
func NewExpressRoutePortsLocationsClient(subscriptionID string) ExpressRoutePortsLocationsClient {
	return original.NewExpressRoutePortsLocationsClient(subscriptionID)
}
func NewExpressRoutePortsLocationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRoutePortsLocationsClient {
	return original.NewExpressRoutePortsLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return original.NewExpressRouteServiceProviderListResultIterator(page)
}
func NewExpressRouteServiceProviderListResultPage(getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return original.NewExpressRouteServiceProviderListResultPage(getNextPage)
}
func NewExpressRouteServiceProvidersClient(subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClient(subscriptionID)
}
func NewExpressRouteServiceProvidersClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPoliciesClient(subscriptionID string) FirewallPoliciesClient {
	return original.NewFirewallPoliciesClient(subscriptionID)
}
func NewFirewallPoliciesClientWithBaseURI(baseURI string, subscriptionID string) FirewallPoliciesClient {
	return original.NewFirewallPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallPolicyListResultIterator(page FirewallPolicyListResultPage) FirewallPolicyListResultIterator {
	return original.NewFirewallPolicyListResultIterator(page)
}
func NewFirewallPolicyListResultPage(getNextPage func(context.Context, FirewallPolicyListResult) (FirewallPolicyListResult, error)) FirewallPolicyListResultPage {
	return original.NewFirewallPolicyListResultPage(getNextPage)
}
func NewFirewallPolicyRuleGroupListResultIterator(page FirewallPolicyRuleGroupListResultPage) FirewallPolicyRuleGroupListResultIterator {
	return original.NewFirewallPolicyRuleGroupListResultIterator(page)
}
func NewFirewallPolicyRuleGroupListResultPage(getNextPage func(context.Context, FirewallPolicyRuleGroupListResult) (FirewallPolicyRuleGroupListResult, error)) FirewallPolicyRuleGroupListResultPage {
	return original.NewFirewallPolicyRuleGroupListResultPage(getNextPage)
}
func NewFirewallPolicyRuleGroupsClient(subscriptionID string) FirewallPolicyRuleGroupsClient {
	return original.NewFirewallPolicyRuleGroupsClient(subscriptionID)
}
func NewFirewallPolicyRuleGroupsClientWithBaseURI(baseURI string, subscriptionID string) FirewallPolicyRuleGroupsClient {
	return original.NewFirewallPolicyRuleGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHubVirtualNetworkConnectionsClient(subscriptionID string) HubVirtualNetworkConnectionsClient {
	return original.NewHubVirtualNetworkConnectionsClient(subscriptionID)
}
func NewHubVirtualNetworkConnectionsClientWithBaseURI(baseURI string, subscriptionID string) HubVirtualNetworkConnectionsClient {
	return original.NewHubVirtualNetworkConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIPGroupListResultIterator(page IPGroupListResultPage) IPGroupListResultIterator {
	return original.NewIPGroupListResultIterator(page)
}
func NewIPGroupListResultPage(getNextPage func(context.Context, IPGroupListResult) (IPGroupListResult, error)) IPGroupListResultPage {
	return original.NewIPGroupListResultPage(getNextPage)
}
func NewIPGroupsClient(subscriptionID string) IPGroupsClient {
	return original.NewIPGroupsClient(subscriptionID)
}
func NewIPGroupsClientWithBaseURI(baseURI string, subscriptionID string) IPGroupsClient {
	return original.NewIPGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInboundNatRuleListResultIterator(page InboundNatRuleListResultPage) InboundNatRuleListResultIterator {
	return original.NewInboundNatRuleListResultIterator(page)
}
func NewInboundNatRuleListResultPage(getNextPage func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)) InboundNatRuleListResultPage {
	return original.NewInboundNatRuleListResultPage(getNextPage)
}
func NewInboundNatRulesClient(subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClient(subscriptionID)
}
func NewInboundNatRulesClientWithBaseURI(baseURI string, subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceIPConfigurationListResultIterator(page InterfaceIPConfigurationListResultPage) InterfaceIPConfigurationListResultIterator {
	return original.NewInterfaceIPConfigurationListResultIterator(page)
}
func NewInterfaceIPConfigurationListResultPage(getNextPage func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)) InterfaceIPConfigurationListResultPage {
	return original.NewInterfaceIPConfigurationListResultPage(getNextPage)
}
func NewInterfaceIPConfigurationsClient(subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClient(subscriptionID)
}
func NewInterfaceIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return original.NewInterfaceListResultIterator(page)
}
func NewInterfaceListResultPage(getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return original.NewInterfaceListResultPage(getNextPage)
}
func NewInterfaceLoadBalancerListResultIterator(page InterfaceLoadBalancerListResultPage) InterfaceLoadBalancerListResultIterator {
	return original.NewInterfaceLoadBalancerListResultIterator(page)
}
func NewInterfaceLoadBalancerListResultPage(getNextPage func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)) InterfaceLoadBalancerListResultPage {
	return original.NewInterfaceLoadBalancerListResultPage(getNextPage)
}
func NewInterfaceLoadBalancersClient(subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClient(subscriptionID)
}
func NewInterfaceLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceTapConfigurationListResultIterator(page InterfaceTapConfigurationListResultPage) InterfaceTapConfigurationListResultIterator {
	return original.NewInterfaceTapConfigurationListResultIterator(page)
}
func NewInterfaceTapConfigurationListResultPage(getNextPage func(context.Context, InterfaceTapConfigurationListResult) (InterfaceTapConfigurationListResult, error)) InterfaceTapConfigurationListResultPage {
	return original.NewInterfaceTapConfigurationListResultPage(getNextPage)
}
func NewInterfaceTapConfigurationsClient(subscriptionID string) InterfaceTapConfigurationsClient {
	return original.NewInterfaceTapConfigurationsClient(subscriptionID)
}
func NewInterfaceTapConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) InterfaceTapConfigurationsClient {
	return original.NewInterfaceTapConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfacesClient(subscriptionID string) InterfacesClient {
	return original.NewInterfacesClient(subscriptionID)
}
func NewInterfacesClientWithBaseURI(baseURI string, subscriptionID string) InterfacesClient {
	return original.NewInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewListHubVirtualNetworkConnectionsResultIterator(page ListHubVirtualNetworkConnectionsResultPage) ListHubVirtualNetworkConnectionsResultIterator {
	return original.NewListHubVirtualNetworkConnectionsResultIterator(page)
}
func NewListHubVirtualNetworkConnectionsResultPage(getNextPage func(context.Context, ListHubVirtualNetworkConnectionsResult) (ListHubVirtualNetworkConnectionsResult, error)) ListHubVirtualNetworkConnectionsResultPage {
	return original.NewListHubVirtualNetworkConnectionsResultPage(getNextPage)
}
func NewListP2SVpnGatewaysResultIterator(page ListP2SVpnGatewaysResultPage) ListP2SVpnGatewaysResultIterator {
	return original.NewListP2SVpnGatewaysResultIterator(page)
}
func NewListP2SVpnGatewaysResultPage(getNextPage func(context.Context, ListP2SVpnGatewaysResult) (ListP2SVpnGatewaysResult, error)) ListP2SVpnGatewaysResultPage {
	return original.NewListP2SVpnGatewaysResultPage(getNextPage)
}
func NewListVirtualHubRouteTableV2sResultIterator(page ListVirtualHubRouteTableV2sResultPage) ListVirtualHubRouteTableV2sResultIterator {
	return original.NewListVirtualHubRouteTableV2sResultIterator(page)
}
func NewListVirtualHubRouteTableV2sResultPage(getNextPage func(context.Context, ListVirtualHubRouteTableV2sResult) (ListVirtualHubRouteTableV2sResult, error)) ListVirtualHubRouteTableV2sResultPage {
	return original.NewListVirtualHubRouteTableV2sResultPage(getNextPage)
}
func NewListVirtualHubsResultIterator(page ListVirtualHubsResultPage) ListVirtualHubsResultIterator {
	return original.NewListVirtualHubsResultIterator(page)
}
func NewListVirtualHubsResultPage(getNextPage func(context.Context, ListVirtualHubsResult) (ListVirtualHubsResult, error)) ListVirtualHubsResultPage {
	return original.NewListVirtualHubsResultPage(getNextPage)
}
func NewListVirtualWANsResultIterator(page ListVirtualWANsResultPage) ListVirtualWANsResultIterator {
	return original.NewListVirtualWANsResultIterator(page)
}
func NewListVirtualWANsResultPage(getNextPage func(context.Context, ListVirtualWANsResult) (ListVirtualWANsResult, error)) ListVirtualWANsResultPage {
	return original.NewListVirtualWANsResultPage(getNextPage)
}
func NewListVpnConnectionsResultIterator(page ListVpnConnectionsResultPage) ListVpnConnectionsResultIterator {
	return original.NewListVpnConnectionsResultIterator(page)
}
func NewListVpnConnectionsResultPage(getNextPage func(context.Context, ListVpnConnectionsResult) (ListVpnConnectionsResult, error)) ListVpnConnectionsResultPage {
	return original.NewListVpnConnectionsResultPage(getNextPage)
}
func NewListVpnGatewaysResultIterator(page ListVpnGatewaysResultPage) ListVpnGatewaysResultIterator {
	return original.NewListVpnGatewaysResultIterator(page)
}
func NewListVpnGatewaysResultPage(getNextPage func(context.Context, ListVpnGatewaysResult) (ListVpnGatewaysResult, error)) ListVpnGatewaysResultPage {
	return original.NewListVpnGatewaysResultPage(getNextPage)
}
func NewListVpnServerConfigurationsResultIterator(page ListVpnServerConfigurationsResultPage) ListVpnServerConfigurationsResultIterator {
	return original.NewListVpnServerConfigurationsResultIterator(page)
}
func NewListVpnServerConfigurationsResultPage(getNextPage func(context.Context, ListVpnServerConfigurationsResult) (ListVpnServerConfigurationsResult, error)) ListVpnServerConfigurationsResultPage {
	return original.NewListVpnServerConfigurationsResultPage(getNextPage)
}
func NewListVpnSiteLinkConnectionsResultIterator(page ListVpnSiteLinkConnectionsResultPage) ListVpnSiteLinkConnectionsResultIterator {
	return original.NewListVpnSiteLinkConnectionsResultIterator(page)
}
func NewListVpnSiteLinkConnectionsResultPage(getNextPage func(context.Context, ListVpnSiteLinkConnectionsResult) (ListVpnSiteLinkConnectionsResult, error)) ListVpnSiteLinkConnectionsResultPage {
	return original.NewListVpnSiteLinkConnectionsResultPage(getNextPage)
}
func NewListVpnSiteLinksResultIterator(page ListVpnSiteLinksResultPage) ListVpnSiteLinksResultIterator {
	return original.NewListVpnSiteLinksResultIterator(page)
}
func NewListVpnSiteLinksResultPage(getNextPage func(context.Context, ListVpnSiteLinksResult) (ListVpnSiteLinksResult, error)) ListVpnSiteLinksResultPage {
	return original.NewListVpnSiteLinksResultPage(getNextPage)
}
func NewListVpnSitesResultIterator(page ListVpnSitesResultPage) ListVpnSitesResultIterator {
	return original.NewListVpnSitesResultIterator(page)
}
func NewListVpnSitesResultPage(getNextPage func(context.Context, ListVpnSitesResult) (ListVpnSitesResult, error)) ListVpnSitesResultPage {
	return original.NewListVpnSitesResultPage(getNextPage)
}
func NewLoadBalancerBackendAddressPoolListResultIterator(page LoadBalancerBackendAddressPoolListResultPage) LoadBalancerBackendAddressPoolListResultIterator {
	return original.NewLoadBalancerBackendAddressPoolListResultIterator(page)
}
func NewLoadBalancerBackendAddressPoolListResultPage(getNextPage func(context.Context, LoadBalancerBackendAddressPoolListResult) (LoadBalancerBackendAddressPoolListResult, error)) LoadBalancerBackendAddressPoolListResultPage {
	return original.NewLoadBalancerBackendAddressPoolListResultPage(getNextPage)
}
func NewLoadBalancerBackendAddressPoolsClient(subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClient(subscriptionID)
}
func NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationListResultIterator(page LoadBalancerFrontendIPConfigurationListResultPage) LoadBalancerFrontendIPConfigurationListResultIterator {
	return original.NewLoadBalancerFrontendIPConfigurationListResultIterator(page)
}
func NewLoadBalancerFrontendIPConfigurationListResultPage(getNextPage func(context.Context, LoadBalancerFrontendIPConfigurationListResult) (LoadBalancerFrontendIPConfigurationListResult, error)) LoadBalancerFrontendIPConfigurationListResultPage {
	return original.NewLoadBalancerFrontendIPConfigurationListResultPage(getNextPage)
}
func NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerListResultIterator(page LoadBalancerListResultPage) LoadBalancerListResultIterator {
	return original.NewLoadBalancerListResultIterator(page)
}
func NewLoadBalancerListResultPage(getNextPage func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)) LoadBalancerListResultPage {
	return original.NewLoadBalancerListResultPage(getNextPage)
}
func NewLoadBalancerLoadBalancingRuleListResultIterator(page LoadBalancerLoadBalancingRuleListResultPage) LoadBalancerLoadBalancingRuleListResultIterator {
	return original.NewLoadBalancerLoadBalancingRuleListResultIterator(page)
}
func NewLoadBalancerLoadBalancingRuleListResultPage(getNextPage func(context.Context, LoadBalancerLoadBalancingRuleListResult) (LoadBalancerLoadBalancingRuleListResult, error)) LoadBalancerLoadBalancingRuleListResultPage {
	return original.NewLoadBalancerLoadBalancingRuleListResultPage(getNextPage)
}
func NewLoadBalancerLoadBalancingRulesClient(subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClient(subscriptionID)
}
func NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClient(subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClient(subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerOutboundRuleListResultIterator(page LoadBalancerOutboundRuleListResultPage) LoadBalancerOutboundRuleListResultIterator {
	return original.NewLoadBalancerOutboundRuleListResultIterator(page)
}
func NewLoadBalancerOutboundRuleListResultPage(getNextPage func(context.Context, LoadBalancerOutboundRuleListResult) (LoadBalancerOutboundRuleListResult, error)) LoadBalancerOutboundRuleListResultPage {
	return original.NewLoadBalancerOutboundRuleListResultPage(getNextPage)
}
func NewLoadBalancerOutboundRulesClient(subscriptionID string) LoadBalancerOutboundRulesClient {
	return original.NewLoadBalancerOutboundRulesClient(subscriptionID)
}
func NewLoadBalancerOutboundRulesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerOutboundRulesClient {
	return original.NewLoadBalancerOutboundRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerProbeListResultIterator(page LoadBalancerProbeListResultPage) LoadBalancerProbeListResultIterator {
	return original.NewLoadBalancerProbeListResultIterator(page)
}
func NewLoadBalancerProbeListResultPage(getNextPage func(context.Context, LoadBalancerProbeListResult) (LoadBalancerProbeListResult, error)) LoadBalancerProbeListResultPage {
	return original.NewLoadBalancerProbeListResultPage(getNextPage)
}
func NewLoadBalancerProbesClient(subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClient(subscriptionID)
}
func NewLoadBalancerProbesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancersClient(subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClient(subscriptionID)
}
func NewLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocalNetworkGatewayListResultIterator(page LocalNetworkGatewayListResultPage) LocalNetworkGatewayListResultIterator {
	return original.NewLocalNetworkGatewayListResultIterator(page)
}
func NewLocalNetworkGatewayListResultPage(getNextPage func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)) LocalNetworkGatewayListResultPage {
	return original.NewLocalNetworkGatewayListResultPage(getNextPage)
}
func NewLocalNetworkGatewaysClient(subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClient(subscriptionID)
}
func NewLocalNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewNatGatewayListResultIterator(page NatGatewayListResultPage) NatGatewayListResultIterator {
	return original.NewNatGatewayListResultIterator(page)
}
func NewNatGatewayListResultPage(getNextPage func(context.Context, NatGatewayListResult) (NatGatewayListResult, error)) NatGatewayListResultPage {
	return original.NewNatGatewayListResultPage(getNextPage)
}
func NewNatGatewaysClient(subscriptionID string) NatGatewaysClient {
	return original.NewNatGatewaysClient(subscriptionID)
}
func NewNatGatewaysClientWithBaseURI(baseURI string, subscriptionID string) NatGatewaysClient {
	return original.NewNatGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewP2sVpnGatewaysClient(subscriptionID string) P2sVpnGatewaysClient {
	return original.NewP2sVpnGatewaysClient(subscriptionID)
}
func NewP2sVpnGatewaysClientWithBaseURI(baseURI string, subscriptionID string) P2sVpnGatewaysClient {
	return original.NewP2sVpnGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewPacketCapturesClient(subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClient(subscriptionID)
}
func NewPacketCapturesClientWithBaseURI(baseURI string, subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPeerExpressRouteCircuitConnectionListResultIterator(page PeerExpressRouteCircuitConnectionListResultPage) PeerExpressRouteCircuitConnectionListResultIterator {
	return original.NewPeerExpressRouteCircuitConnectionListResultIterator(page)
}
func NewPeerExpressRouteCircuitConnectionListResultPage(getNextPage func(context.Context, PeerExpressRouteCircuitConnectionListResult) (PeerExpressRouteCircuitConnectionListResult, error)) PeerExpressRouteCircuitConnectionListResultPage {
	return original.NewPeerExpressRouteCircuitConnectionListResultPage(getNextPage)
}
func NewPeerExpressRouteCircuitConnectionsClient(subscriptionID string) PeerExpressRouteCircuitConnectionsClient {
	return original.NewPeerExpressRouteCircuitConnectionsClient(subscriptionID)
}
func NewPeerExpressRouteCircuitConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PeerExpressRouteCircuitConnectionsClient {
	return original.NewPeerExpressRouteCircuitConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(getNextPage)
}
func NewPrivateEndpointListResultIterator(page PrivateEndpointListResultPage) PrivateEndpointListResultIterator {
	return original.NewPrivateEndpointListResultIterator(page)
}
func NewPrivateEndpointListResultPage(getNextPage func(context.Context, PrivateEndpointListResult) (PrivateEndpointListResult, error)) PrivateEndpointListResultPage {
	return original.NewPrivateEndpointListResultPage(getNextPage)
}
func NewPrivateEndpointsClient(subscriptionID string) PrivateEndpointsClient {
	return original.NewPrivateEndpointsClient(subscriptionID)
}
func NewPrivateEndpointsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointsClient {
	return original.NewPrivateEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkServiceListResultIterator(page PrivateLinkServiceListResultPage) PrivateLinkServiceListResultIterator {
	return original.NewPrivateLinkServiceListResultIterator(page)
}
func NewPrivateLinkServiceListResultPage(getNextPage func(context.Context, PrivateLinkServiceListResult) (PrivateLinkServiceListResult, error)) PrivateLinkServiceListResultPage {
	return original.NewPrivateLinkServiceListResultPage(getNextPage)
}
func NewPrivateLinkServicesClient(subscriptionID string) PrivateLinkServicesClient {
	return original.NewPrivateLinkServicesClient(subscriptionID)
}
func NewPrivateLinkServicesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkServicesClient {
	return original.NewPrivateLinkServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return original.NewProfileListResultIterator(page)
}
func NewProfileListResultPage(getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return original.NewProfileListResultPage(getNextPage)
}
func NewProfilesClient(subscriptionID string) ProfilesClient {
	return original.NewProfilesClient(subscriptionID)
}
func NewProfilesClientWithBaseURI(baseURI string, subscriptionID string) ProfilesClient {
	return original.NewProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicIPAddressListResultIterator(page PublicIPAddressListResultPage) PublicIPAddressListResultIterator {
	return original.NewPublicIPAddressListResultIterator(page)
}
func NewPublicIPAddressListResultPage(getNextPage func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)) PublicIPAddressListResultPage {
	return original.NewPublicIPAddressListResultPage(getNextPage)
}
func NewPublicIPAddressesClient(subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClient(subscriptionID)
}
func NewPublicIPAddressesClientWithBaseURI(baseURI string, subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicIPPrefixListResultIterator(page PublicIPPrefixListResultPage) PublicIPPrefixListResultIterator {
	return original.NewPublicIPPrefixListResultIterator(page)
}
func NewPublicIPPrefixListResultPage(getNextPage func(context.Context, PublicIPPrefixListResult) (PublicIPPrefixListResult, error)) PublicIPPrefixListResultPage {
	return original.NewPublicIPPrefixListResultPage(getNextPage)
}
func NewPublicIPPrefixesClient(subscriptionID string) PublicIPPrefixesClient {
	return original.NewPublicIPPrefixesClient(subscriptionID)
}
func NewPublicIPPrefixesClientWithBaseURI(baseURI string, subscriptionID string) PublicIPPrefixesClient {
	return original.NewPublicIPPrefixesClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceNavigationLinksClient(subscriptionID string) ResourceNavigationLinksClient {
	return original.NewResourceNavigationLinksClient(subscriptionID)
}
func NewResourceNavigationLinksClientWithBaseURI(baseURI string, subscriptionID string) ResourceNavigationLinksClient {
	return original.NewResourceNavigationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFilterListResultIterator(page RouteFilterListResultPage) RouteFilterListResultIterator {
	return original.NewRouteFilterListResultIterator(page)
}
func NewRouteFilterListResultPage(getNextPage func(context.Context, RouteFilterListResult) (RouteFilterListResult, error)) RouteFilterListResultPage {
	return original.NewRouteFilterListResultPage(getNextPage)
}
func NewRouteFilterRuleListResultIterator(page RouteFilterRuleListResultPage) RouteFilterRuleListResultIterator {
	return original.NewRouteFilterRuleListResultIterator(page)
}
func NewRouteFilterRuleListResultPage(getNextPage func(context.Context, RouteFilterRuleListResult) (RouteFilterRuleListResult, error)) RouteFilterRuleListResultPage {
	return original.NewRouteFilterRuleListResultPage(getNextPage)
}
func NewRouteFilterRulesClient(subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClient(subscriptionID)
}
func NewRouteFilterRulesClientWithBaseURI(baseURI string, subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFiltersClient(subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClient(subscriptionID)
}
func NewRouteFiltersClientWithBaseURI(baseURI string, subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return original.NewRouteListResultIterator(page)
}
func NewRouteListResultPage(getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return original.NewRouteListResultPage(getNextPage)
}
func NewRouteTableListResultIterator(page RouteTableListResultPage) RouteTableListResultIterator {
	return original.NewRouteTableListResultIterator(page)
}
func NewRouteTableListResultPage(getNextPage func(context.Context, RouteTableListResult) (RouteTableListResult, error)) RouteTableListResultPage {
	return original.NewRouteTableListResultPage(getNextPage)
}
func NewRouteTablesClient(subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClient(subscriptionID)
}
func NewRouteTablesClientWithBaseURI(baseURI string, subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoutesClient(subscriptionID string) RoutesClient {
	return original.NewRoutesClient(subscriptionID)
}
func NewRoutesClientWithBaseURI(baseURI string, subscriptionID string) RoutesClient {
	return original.NewRoutesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityGroupListResultIterator(page SecurityGroupListResultPage) SecurityGroupListResultIterator {
	return original.NewSecurityGroupListResultIterator(page)
}
func NewSecurityGroupListResultPage(getNextPage func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)) SecurityGroupListResultPage {
	return original.NewSecurityGroupListResultPage(getNextPage)
}
func NewSecurityGroupsClient(subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClient(subscriptionID)
}
func NewSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityRuleListResultIterator(page SecurityRuleListResultPage) SecurityRuleListResultIterator {
	return original.NewSecurityRuleListResultIterator(page)
}
func NewSecurityRuleListResultPage(getNextPage func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)) SecurityRuleListResultPage {
	return original.NewSecurityRuleListResultPage(getNextPage)
}
func NewSecurityRulesClient(subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClient(subscriptionID)
}
func NewSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceAssociationLinksClient(subscriptionID string) ServiceAssociationLinksClient {
	return original.NewServiceAssociationLinksClient(subscriptionID)
}
func NewServiceAssociationLinksClientWithBaseURI(baseURI string, subscriptionID string) ServiceAssociationLinksClient {
	return original.NewServiceAssociationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceEndpointPoliciesClient(subscriptionID string) ServiceEndpointPoliciesClient {
	return original.NewServiceEndpointPoliciesClient(subscriptionID)
}
func NewServiceEndpointPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ServiceEndpointPoliciesClient {
	return original.NewServiceEndpointPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceEndpointPolicyDefinitionListResultIterator(page ServiceEndpointPolicyDefinitionListResultPage) ServiceEndpointPolicyDefinitionListResultIterator {
	return original.NewServiceEndpointPolicyDefinitionListResultIterator(page)
}
func NewServiceEndpointPolicyDefinitionListResultPage(getNextPage func(context.Context, ServiceEndpointPolicyDefinitionListResult) (ServiceEndpointPolicyDefinitionListResult, error)) ServiceEndpointPolicyDefinitionListResultPage {
	return original.NewServiceEndpointPolicyDefinitionListResultPage(getNextPage)
}
func NewServiceEndpointPolicyDefinitionsClient(subscriptionID string) ServiceEndpointPolicyDefinitionsClient {
	return original.NewServiceEndpointPolicyDefinitionsClient(subscriptionID)
}
func NewServiceEndpointPolicyDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) ServiceEndpointPolicyDefinitionsClient {
	return original.NewServiceEndpointPolicyDefinitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceEndpointPolicyListResultIterator(page ServiceEndpointPolicyListResultPage) ServiceEndpointPolicyListResultIterator {
	return original.NewServiceEndpointPolicyListResultIterator(page)
}
func NewServiceEndpointPolicyListResultPage(getNextPage func(context.Context, ServiceEndpointPolicyListResult) (ServiceEndpointPolicyListResult, error)) ServiceEndpointPolicyListResultPage {
	return original.NewServiceEndpointPolicyListResultPage(getNextPage)
}
func NewServiceTagsClient(subscriptionID string) ServiceTagsClient {
	return original.NewServiceTagsClient(subscriptionID)
}
func NewServiceTagsClientWithBaseURI(baseURI string, subscriptionID string) ServiceTagsClient {
	return original.NewServiceTagsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubnetListResultIterator(page SubnetListResultPage) SubnetListResultIterator {
	return original.NewSubnetListResultIterator(page)
}
func NewSubnetListResultPage(getNextPage func(context.Context, SubnetListResult) (SubnetListResult, error)) SubnetListResultPage {
	return original.NewSubnetListResultPage(getNextPage)
}
func NewSubnetsClient(subscriptionID string) SubnetsClient {
	return original.NewSubnetsClient(subscriptionID)
}
func NewSubnetsClientWithBaseURI(baseURI string, subscriptionID string) SubnetsClient {
	return original.NewSubnetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return original.NewUsagesListResultIterator(page)
}
func NewUsagesListResultPage(getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return original.NewUsagesListResultPage(getNextPage)
}
func NewVirtualHubRouteTableV2sClient(subscriptionID string) VirtualHubRouteTableV2sClient {
	return original.NewVirtualHubRouteTableV2sClient(subscriptionID)
}
func NewVirtualHubRouteTableV2sClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubRouteTableV2sClient {
	return original.NewVirtualHubRouteTableV2sClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualHubsClient(subscriptionID string) VirtualHubsClient {
	return original.NewVirtualHubsClient(subscriptionID)
}
func NewVirtualHubsClientWithBaseURI(baseURI string, subscriptionID string) VirtualHubsClient {
	return original.NewVirtualHubsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkGatewayConnectionListResultIterator(page VirtualNetworkGatewayConnectionListResultPage) VirtualNetworkGatewayConnectionListResultIterator {
	return original.NewVirtualNetworkGatewayConnectionListResultIterator(page)
}
func NewVirtualNetworkGatewayConnectionListResultPage(getNextPage func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)) VirtualNetworkGatewayConnectionListResultPage {
	return original.NewVirtualNetworkGatewayConnectionListResultPage(getNextPage)
}
func NewVirtualNetworkGatewayConnectionsClient(subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClient(subscriptionID)
}
func NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkGatewayListConnectionsResultIterator(page VirtualNetworkGatewayListConnectionsResultPage) VirtualNetworkGatewayListConnectionsResultIterator {
	return original.NewVirtualNetworkGatewayListConnectionsResultIterator(page)
}
func NewVirtualNetworkGatewayListConnectionsResultPage(getNextPage func(context.Context, VirtualNetworkGatewayListConnectionsResult) (VirtualNetworkGatewayListConnectionsResult, error)) VirtualNetworkGatewayListConnectionsResultPage {
	return original.NewVirtualNetworkGatewayListConnectionsResultPage(getNextPage)
}
func NewVirtualNetworkGatewayListResultIterator(page VirtualNetworkGatewayListResultPage) VirtualNetworkGatewayListResultIterator {
	return original.NewVirtualNetworkGatewayListResultIterator(page)
}
func NewVirtualNetworkGatewayListResultPage(getNextPage func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)) VirtualNetworkGatewayListResultPage {
	return original.NewVirtualNetworkGatewayListResultPage(getNextPage)
}
func NewVirtualNetworkGatewaysClient(subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClient(subscriptionID)
}
func NewVirtualNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkListResultIterator(page VirtualNetworkListResultPage) VirtualNetworkListResultIterator {
	return original.NewVirtualNetworkListResultIterator(page)
}
func NewVirtualNetworkListResultPage(getNextPage func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)) VirtualNetworkListResultPage {
	return original.NewVirtualNetworkListResultPage(getNextPage)
}
func NewVirtualNetworkListUsageResultIterator(page VirtualNetworkListUsageResultPage) VirtualNetworkListUsageResultIterator {
	return original.NewVirtualNetworkListUsageResultIterator(page)
}
func NewVirtualNetworkListUsageResultPage(getNextPage func(context.Context, VirtualNetworkListUsageResult) (VirtualNetworkListUsageResult, error)) VirtualNetworkListUsageResultPage {
	return original.NewVirtualNetworkListUsageResultPage(getNextPage)
}
func NewVirtualNetworkPeeringListResultIterator(page VirtualNetworkPeeringListResultPage) VirtualNetworkPeeringListResultIterator {
	return original.NewVirtualNetworkPeeringListResultIterator(page)
}
func NewVirtualNetworkPeeringListResultPage(getNextPage func(context.Context, VirtualNetworkPeeringListResult) (VirtualNetworkPeeringListResult, error)) VirtualNetworkPeeringListResultPage {
	return original.NewVirtualNetworkPeeringListResultPage(getNextPage)
}
func NewVirtualNetworkPeeringsClient(subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClient(subscriptionID)
}
func NewVirtualNetworkPeeringsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkTapListResultIterator(page VirtualNetworkTapListResultPage) VirtualNetworkTapListResultIterator {
	return original.NewVirtualNetworkTapListResultIterator(page)
}
func NewVirtualNetworkTapListResultPage(getNextPage func(context.Context, VirtualNetworkTapListResult) (VirtualNetworkTapListResult, error)) VirtualNetworkTapListResultPage {
	return original.NewVirtualNetworkTapListResultPage(getNextPage)
}
func NewVirtualNetworkTapsClient(subscriptionID string) VirtualNetworkTapsClient {
	return original.NewVirtualNetworkTapsClient(subscriptionID)
}
func NewVirtualNetworkTapsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkTapsClient {
	return original.NewVirtualNetworkTapsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworksClient(subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClient(subscriptionID)
}
func NewVirtualNetworksClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualRouterListResultIterator(page VirtualRouterListResultPage) VirtualRouterListResultIterator {
	return original.NewVirtualRouterListResultIterator(page)
}
func NewVirtualRouterListResultPage(getNextPage func(context.Context, VirtualRouterListResult) (VirtualRouterListResult, error)) VirtualRouterListResultPage {
	return original.NewVirtualRouterListResultPage(getNextPage)
}
func NewVirtualRouterPeeringListResultIterator(page VirtualRouterPeeringListResultPage) VirtualRouterPeeringListResultIterator {
	return original.NewVirtualRouterPeeringListResultIterator(page)
}
func NewVirtualRouterPeeringListResultPage(getNextPage func(context.Context, VirtualRouterPeeringListResult) (VirtualRouterPeeringListResult, error)) VirtualRouterPeeringListResultPage {
	return original.NewVirtualRouterPeeringListResultPage(getNextPage)
}
func NewVirtualRouterPeeringsClient(subscriptionID string) VirtualRouterPeeringsClient {
	return original.NewVirtualRouterPeeringsClient(subscriptionID)
}
func NewVirtualRouterPeeringsClientWithBaseURI(baseURI string, subscriptionID string) VirtualRouterPeeringsClient {
	return original.NewVirtualRouterPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualRoutersClient(subscriptionID string) VirtualRoutersClient {
	return original.NewVirtualRoutersClient(subscriptionID)
}
func NewVirtualRoutersClientWithBaseURI(baseURI string, subscriptionID string) VirtualRoutersClient {
	return original.NewVirtualRoutersClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualWansClient(subscriptionID string) VirtualWansClient {
	return original.NewVirtualWansClient(subscriptionID)
}
func NewVirtualWansClientWithBaseURI(baseURI string, subscriptionID string) VirtualWansClient {
	return original.NewVirtualWansClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnConnectionsClient(subscriptionID string) VpnConnectionsClient {
	return original.NewVpnConnectionsClient(subscriptionID)
}
func NewVpnConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VpnConnectionsClient {
	return original.NewVpnConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnGatewaysClient(subscriptionID string) VpnGatewaysClient {
	return original.NewVpnGatewaysClient(subscriptionID)
}
func NewVpnGatewaysClientWithBaseURI(baseURI string, subscriptionID string) VpnGatewaysClient {
	return original.NewVpnGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnLinkConnectionsClient(subscriptionID string) VpnLinkConnectionsClient {
	return original.NewVpnLinkConnectionsClient(subscriptionID)
}
func NewVpnLinkConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VpnLinkConnectionsClient {
	return original.NewVpnLinkConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnServerConfigurationsAssociatedWithVirtualWanClient(subscriptionID string) VpnServerConfigurationsAssociatedWithVirtualWanClient {
	return original.NewVpnServerConfigurationsAssociatedWithVirtualWanClient(subscriptionID)
}
func NewVpnServerConfigurationsAssociatedWithVirtualWanClientWithBaseURI(baseURI string, subscriptionID string) VpnServerConfigurationsAssociatedWithVirtualWanClient {
	return original.NewVpnServerConfigurationsAssociatedWithVirtualWanClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnServerConfigurationsClient(subscriptionID string) VpnServerConfigurationsClient {
	return original.NewVpnServerConfigurationsClient(subscriptionID)
}
func NewVpnServerConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) VpnServerConfigurationsClient {
	return original.NewVpnServerConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSiteLinkConnectionsClient(subscriptionID string) VpnSiteLinkConnectionsClient {
	return original.NewVpnSiteLinkConnectionsClient(subscriptionID)
}
func NewVpnSiteLinkConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VpnSiteLinkConnectionsClient {
	return original.NewVpnSiteLinkConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSiteLinksClient(subscriptionID string) VpnSiteLinksClient {
	return original.NewVpnSiteLinksClient(subscriptionID)
}
func NewVpnSiteLinksClientWithBaseURI(baseURI string, subscriptionID string) VpnSiteLinksClient {
	return original.NewVpnSiteLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSitesClient(subscriptionID string) VpnSitesClient {
	return original.NewVpnSitesClient(subscriptionID)
}
func NewVpnSitesClientWithBaseURI(baseURI string, subscriptionID string) VpnSitesClient {
	return original.NewVpnSitesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVpnSitesConfigurationClient(subscriptionID string) VpnSitesConfigurationClient {
	return original.NewVpnSitesConfigurationClient(subscriptionID)
}
func NewVpnSitesConfigurationClientWithBaseURI(baseURI string, subscriptionID string) VpnSitesConfigurationClient {
	return original.NewVpnSitesConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewWatchersClient(subscriptionID string) WatchersClient {
	return original.NewWatchersClient(subscriptionID)
}
func NewWatchersClientWithBaseURI(baseURI string, subscriptionID string) WatchersClient {
	return original.NewWatchersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebApplicationFirewallPoliciesClient(subscriptionID string) WebApplicationFirewallPoliciesClient {
	return original.NewWebApplicationFirewallPoliciesClient(subscriptionID)
}
func NewWebApplicationFirewallPoliciesClientWithBaseURI(baseURI string, subscriptionID string) WebApplicationFirewallPoliciesClient {
	return original.NewWebApplicationFirewallPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebApplicationFirewallPolicyListResultIterator(page WebApplicationFirewallPolicyListResultPage) WebApplicationFirewallPolicyListResultIterator {
	return original.NewWebApplicationFirewallPolicyListResultIterator(page)
}
func NewWebApplicationFirewallPolicyListResultPage(getNextPage func(context.Context, WebApplicationFirewallPolicyListResult) (WebApplicationFirewallPolicyListResult, error)) WebApplicationFirewallPolicyListResultPage {
	return original.NewWebApplicationFirewallPolicyListResultPage(getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessValues() []Access {
	return original.PossibleAccessValues()
}
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return original.PossibleApplicationGatewayBackendHealthServerHealthValues()
}
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return original.PossibleApplicationGatewayCookieBasedAffinityValues()
}
func PossibleApplicationGatewayCustomErrorStatusCodeValues() []ApplicationGatewayCustomErrorStatusCode {
	return original.PossibleApplicationGatewayCustomErrorStatusCodeValues()
}
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return original.PossibleApplicationGatewayFirewallModeValues()
}
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return original.PossibleApplicationGatewayOperationalStateValues()
}
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return original.PossibleApplicationGatewayProtocolValues()
}
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return original.PossibleApplicationGatewayRedirectTypeValues()
}
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return original.PossibleApplicationGatewayRequestRoutingRuleTypeValues()
}
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return original.PossibleApplicationGatewaySkuNameValues()
}
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return original.PossibleApplicationGatewaySslCipherSuiteValues()
}
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return original.PossibleApplicationGatewaySslPolicyNameValues()
}
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return original.PossibleApplicationGatewaySslPolicyTypeValues()
}
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return original.PossibleApplicationGatewaySslProtocolValues()
}
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return original.PossibleApplicationGatewayTierValues()
}
func PossibleAssociationTypeValues() []AssociationType {
	return original.PossibleAssociationTypeValues()
}
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return original.PossibleAuthenticationMethodValues()
}
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return original.PossibleAuthorizationUseStatusValues()
}
func PossibleAzureFirewallApplicationRuleProtocolTypeValues() []AzureFirewallApplicationRuleProtocolType {
	return original.PossibleAzureFirewallApplicationRuleProtocolTypeValues()
}
func PossibleAzureFirewallNatRCActionTypeValues() []AzureFirewallNatRCActionType {
	return original.PossibleAzureFirewallNatRCActionTypeValues()
}
func PossibleAzureFirewallNetworkRuleProtocolValues() []AzureFirewallNetworkRuleProtocol {
	return original.PossibleAzureFirewallNetworkRuleProtocolValues()
}
func PossibleAzureFirewallRCActionTypeValues() []AzureFirewallRCActionType {
	return original.PossibleAzureFirewallRCActionTypeValues()
}
func PossibleAzureFirewallSkuNameValues() []AzureFirewallSkuName {
	return original.PossibleAzureFirewallSkuNameValues()
}
func PossibleAzureFirewallSkuTierValues() []AzureFirewallSkuTier {
	return original.PossibleAzureFirewallSkuTierValues()
}
func PossibleAzureFirewallThreatIntelModeValues() []AzureFirewallThreatIntelMode {
	return original.PossibleAzureFirewallThreatIntelModeValues()
}
func PossibleBgpPeerStateValues() []BgpPeerState {
	return original.PossibleBgpPeerStateValues()
}
func PossibleCircuitConnectionStatusValues() []CircuitConnectionStatus {
	return original.PossibleCircuitConnectionStatusValues()
}
func PossibleConnectionMonitorSourceStatusValues() []ConnectionMonitorSourceStatus {
	return original.PossibleConnectionMonitorSourceStatusValues()
}
func PossibleConnectionStateValues() []ConnectionState {
	return original.PossibleConnectionStateValues()
}
func PossibleConnectionStatusValues() []ConnectionStatus {
	return original.PossibleConnectionStatusValues()
}
func PossibleDdosCustomPolicyProtocolValues() []DdosCustomPolicyProtocol {
	return original.PossibleDdosCustomPolicyProtocolValues()
}
func PossibleDdosCustomPolicyTriggerSensitivityOverrideValues() []DdosCustomPolicyTriggerSensitivityOverride {
	return original.PossibleDdosCustomPolicyTriggerSensitivityOverrideValues()
}
func PossibleDdosSettingsProtectionCoverageValues() []DdosSettingsProtectionCoverage {
	return original.PossibleDdosSettingsProtectionCoverageValues()
}
func PossibleDhGroupValues() []DhGroup {
	return original.PossibleDhGroupValues()
}
func PossibleDirectionValues() []Direction {
	return original.PossibleDirectionValues()
}
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return original.PossibleEffectiveRouteSourceValues()
}
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return original.PossibleEffectiveRouteStateValues()
}
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return original.PossibleEffectiveSecurityRuleProtocolValues()
}
func PossibleEvaluationStateValues() []EvaluationState {
	return original.PossibleEvaluationStateValues()
}
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return original.PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues()
}
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return original.PossibleExpressRouteCircuitPeeringStateValues()
}
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return original.PossibleExpressRouteCircuitSkuFamilyValues()
}
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return original.PossibleExpressRouteCircuitSkuTierValues()
}
func PossibleExpressRouteLinkAdminStateValues() []ExpressRouteLinkAdminState {
	return original.PossibleExpressRouteLinkAdminStateValues()
}
func PossibleExpressRouteLinkConnectorTypeValues() []ExpressRouteLinkConnectorType {
	return original.PossibleExpressRouteLinkConnectorTypeValues()
}
func PossibleExpressRouteLinkMacSecCipherValues() []ExpressRouteLinkMacSecCipher {
	return original.PossibleExpressRouteLinkMacSecCipherValues()
}
func PossibleExpressRoutePeeringStateValues() []ExpressRoutePeeringState {
	return original.PossibleExpressRoutePeeringStateValues()
}
func PossibleExpressRoutePeeringTypeValues() []ExpressRoutePeeringType {
	return original.PossibleExpressRoutePeeringTypeValues()
}
func PossibleExpressRoutePortsEncapsulationValues() []ExpressRoutePortsEncapsulation {
	return original.PossibleExpressRoutePortsEncapsulationValues()
}
func PossibleFirewallPolicyFilterRuleActionTypeValues() []FirewallPolicyFilterRuleActionType {
	return original.PossibleFirewallPolicyFilterRuleActionTypeValues()
}
func PossibleFirewallPolicyNatRuleActionTypeValues() []FirewallPolicyNatRuleActionType {
	return original.PossibleFirewallPolicyNatRuleActionTypeValues()
}
func PossibleFirewallPolicyRuleConditionApplicationProtocolTypeValues() []FirewallPolicyRuleConditionApplicationProtocolType {
	return original.PossibleFirewallPolicyRuleConditionApplicationProtocolTypeValues()
}
func PossibleFirewallPolicyRuleConditionNetworkProtocolValues() []FirewallPolicyRuleConditionNetworkProtocol {
	return original.PossibleFirewallPolicyRuleConditionNetworkProtocolValues()
}
func PossibleFlowLogFormatTypeValues() []FlowLogFormatType {
	return original.PossibleFlowLogFormatTypeValues()
}
func PossibleHTTPMethodValues() []HTTPMethod {
	return original.PossibleHTTPMethodValues()
}
func PossibleHubVirtualNetworkConnectionStatusValues() []HubVirtualNetworkConnectionStatus {
	return original.PossibleHubVirtualNetworkConnectionStatusValues()
}
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return original.PossibleIPAllocationMethodValues()
}
func PossibleIPFlowProtocolValues() []IPFlowProtocol {
	return original.PossibleIPFlowProtocolValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleIkeEncryptionValues() []IkeEncryption {
	return original.PossibleIkeEncryptionValues()
}
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return original.PossibleIkeIntegrityValues()
}
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return original.PossibleIpsecEncryptionValues()
}
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return original.PossibleIpsecIntegrityValues()
}
func PossibleIssueTypeValues() []IssueType {
	return original.PossibleIssueTypeValues()
}
func PossibleLoadBalancerOutboundRuleProtocolValues() []LoadBalancerOutboundRuleProtocol {
	return original.PossibleLoadBalancerOutboundRuleProtocolValues()
}
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return original.PossibleLoadBalancerSkuNameValues()
}
func PossibleLoadDistributionValues() []LoadDistribution {
	return original.PossibleLoadDistributionValues()
}
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return original.PossibleManagedRuleEnabledStateValues()
}
func PossibleNatGatewaySkuNameValues() []NatGatewaySkuName {
	return original.PossibleNatGatewaySkuNameValues()
}
func PossibleNextHopTypeValues() []NextHopType {
	return original.PossibleNextHopTypeValues()
}
func PossibleOfficeTrafficCategoryValues() []OfficeTrafficCategory {
	return original.PossibleOfficeTrafficCategoryValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossibleOwaspCrsExclusionEntryMatchVariableValues() []OwaspCrsExclusionEntryMatchVariable {
	return original.PossibleOwaspCrsExclusionEntryMatchVariableValues()
}
func PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues() []OwaspCrsExclusionEntrySelectorMatchOperator {
	return original.PossibleOwaspCrsExclusionEntrySelectorMatchOperatorValues()
}
func PossiblePcErrorValues() []PcError {
	return original.PossiblePcErrorValues()
}
func PossiblePcProtocolValues() []PcProtocol {
	return original.PossiblePcProtocolValues()
}
func PossiblePcStatusValues() []PcStatus {
	return original.PossiblePcStatusValues()
}
func PossiblePfsGroupValues() []PfsGroup {
	return original.PossiblePfsGroupValues()
}
func PossibleProbeProtocolValues() []ProbeProtocol {
	return original.PossibleProbeProtocolValues()
}
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return original.PossibleProcessorArchitectureValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return original.PossiblePublicIPAddressSkuNameValues()
}
func PossiblePublicIPPrefixSkuNameValues() []PublicIPPrefixSkuName {
	return original.PossiblePublicIPPrefixSkuNameValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return original.PossibleRouteNextHopTypeValues()
}
func PossibleRuleConditionTypeValues() []RuleConditionType {
	return original.PossibleRuleConditionTypeValues()
}
func PossibleRuleTypeValues() []RuleType {
	return original.PossibleRuleTypeValues()
}
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return original.PossibleSecurityRuleAccessValues()
}
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return original.PossibleSecurityRuleDirectionValues()
}
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return original.PossibleSecurityRuleProtocolValues()
}
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return original.PossibleServiceProviderProvisioningStateValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleTransportProtocolValues() []TransportProtocol {
	return original.PossibleTransportProtocolValues()
}
func PossibleTunnelConnectionStatusValues() []TunnelConnectionStatus {
	return original.PossibleTunnelConnectionStatusValues()
}
func PossibleVerbosityLevelValues() []VerbosityLevel {
	return original.PossibleVerbosityLevelValues()
}
func PossibleVirtualNetworkGatewayConnectionProtocolValues() []VirtualNetworkGatewayConnectionProtocol {
	return original.PossibleVirtualNetworkGatewayConnectionProtocolValues()
}
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return original.PossibleVirtualNetworkGatewayConnectionStatusValues()
}
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return original.PossibleVirtualNetworkGatewayConnectionTypeValues()
}
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return original.PossibleVirtualNetworkGatewaySkuNameValues()
}
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return original.PossibleVirtualNetworkGatewaySkuTierValues()
}
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return original.PossibleVirtualNetworkGatewayTypeValues()
}
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return original.PossibleVirtualNetworkPeeringStateValues()
}
func PossibleVirtualWanSecurityProviderTypeValues() []VirtualWanSecurityProviderType {
	return original.PossibleVirtualWanSecurityProviderTypeValues()
}
func PossibleVpnAuthenticationTypeValues() []VpnAuthenticationType {
	return original.PossibleVpnAuthenticationTypeValues()
}
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return original.PossibleVpnClientProtocolValues()
}
func PossibleVpnConnectionStatusValues() []VpnConnectionStatus {
	return original.PossibleVpnConnectionStatusValues()
}
func PossibleVpnGatewayGenerationValues() []VpnGatewayGeneration {
	return original.PossibleVpnGatewayGenerationValues()
}
func PossibleVpnGatewayTunnelingProtocolValues() []VpnGatewayTunnelingProtocol {
	return original.PossibleVpnGatewayTunnelingProtocolValues()
}
func PossibleVpnTypeValues() []VpnType {
	return original.PossibleVpnTypeValues()
}
func PossibleWebApplicationFirewallActionValues() []WebApplicationFirewallAction {
	return original.PossibleWebApplicationFirewallActionValues()
}
func PossibleWebApplicationFirewallEnabledStateValues() []WebApplicationFirewallEnabledState {
	return original.PossibleWebApplicationFirewallEnabledStateValues()
}
func PossibleWebApplicationFirewallMatchVariableValues() []WebApplicationFirewallMatchVariable {
	return original.PossibleWebApplicationFirewallMatchVariableValues()
}
func PossibleWebApplicationFirewallModeValues() []WebApplicationFirewallMode {
	return original.PossibleWebApplicationFirewallModeValues()
}
func PossibleWebApplicationFirewallOperatorValues() []WebApplicationFirewallOperator {
	return original.PossibleWebApplicationFirewallOperatorValues()
}
func PossibleWebApplicationFirewallPolicyResourceStateValues() []WebApplicationFirewallPolicyResourceState {
	return original.PossibleWebApplicationFirewallPolicyResourceStateValues()
}
func PossibleWebApplicationFirewallRuleTypeValues() []WebApplicationFirewallRuleType {
	return original.PossibleWebApplicationFirewallRuleTypeValues()
}
func PossibleWebApplicationFirewallTransformValues() []WebApplicationFirewallTransform {
	return original.PossibleWebApplicationFirewallTransformValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
