package servicebusapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/servicebus/mgmt/2015-08-01/servicebus"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result servicebus.OperationListResultPage, err error)
}

var _ OperationsClientAPI = (*servicebus.OperationsClient)(nil)

// NamespacesClientAPI contains the set of methods on the NamespacesClient type.
type NamespacesClientAPI interface {
	CheckNameAvailabilityMethod(ctx context.Context, parameters servicebus.CheckNameAvailability) (result servicebus.CheckNameAvailabilityResult, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, namespaceName string, parameters servicebus.NamespaceCreateOrUpdateParameters) (result servicebus.NamespacesCreateOrUpdateFuture, err error)
	CreateOrUpdateAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, authorizationRuleName string, parameters servicebus.SharedAccessAuthorizationRuleCreateOrUpdateParameters) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	Delete(ctx context.Context, resourceGroupName string, namespaceName string) (result servicebus.NamespacesDeleteFuture, err error)
	DeleteAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, authorizationRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, namespaceName string) (result servicebus.NamespaceResource, err error)
	GetAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, authorizationRuleName string) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	ListAuthorizationRules(ctx context.Context, resourceGroupName string, namespaceName string) (result servicebus.SharedAccessAuthorizationRuleListResultPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result servicebus.NamespaceListResultPage, err error)
	ListBySubscription(ctx context.Context) (result servicebus.NamespaceListResultPage, err error)
	ListKeys(ctx context.Context, resourceGroupName string, namespaceName string, authorizationRuleName string) (result servicebus.ResourceListKeys, err error)
	RegenerateKeys(ctx context.Context, resourceGroupName string, namespaceName string, authorizationRuleName string, parameters servicebus.RegenerateKeysParameters) (result servicebus.ResourceListKeys, err error)
	Update(ctx context.Context, resourceGroupName string, namespaceName string, parameters servicebus.NamespaceUpdateParameters) (result servicebus.NamespaceResource, err error)
}

var _ NamespacesClientAPI = (*servicebus.NamespacesClient)(nil)

// QueuesClientAPI contains the set of methods on the QueuesClient type.
type QueuesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, parameters servicebus.QueueCreateOrUpdateParameters) (result servicebus.QueueResource, err error)
	CreateOrUpdateAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, authorizationRuleName string, parameters servicebus.SharedAccessAuthorizationRuleCreateOrUpdateParameters) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	Delete(ctx context.Context, resourceGroupName string, namespaceName string, queueName string) (result autorest.Response, err error)
	DeleteAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, authorizationRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, namespaceName string, queueName string) (result servicebus.QueueResource, err error)
	GetAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, authorizationRuleName string) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	ListAll(ctx context.Context, resourceGroupName string, namespaceName string) (result servicebus.QueueListResultPage, err error)
	ListAuthorizationRules(ctx context.Context, resourceGroupName string, namespaceName string, queueName string) (result servicebus.SharedAccessAuthorizationRuleListResultPage, err error)
	ListKeys(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, authorizationRuleName string) (result servicebus.ResourceListKeys, err error)
	PostAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, authorizationRuleName string) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	RegenerateKeys(ctx context.Context, resourceGroupName string, namespaceName string, queueName string, authorizationRuleName string, parameters servicebus.RegenerateKeysParameters) (result servicebus.ResourceListKeys, err error)
}

var _ QueuesClientAPI = (*servicebus.QueuesClient)(nil)

// TopicsClientAPI contains the set of methods on the TopicsClient type.
type TopicsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, parameters servicebus.TopicCreateOrUpdateParameters) (result servicebus.TopicResource, err error)
	CreateOrUpdateAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, authorizationRuleName string, parameters servicebus.SharedAccessAuthorizationRuleCreateOrUpdateParameters) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	Delete(ctx context.Context, resourceGroupName string, namespaceName string, topicName string) (result autorest.Response, err error)
	DeleteAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, authorizationRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, namespaceName string, topicName string) (result servicebus.TopicResource, err error)
	GetAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, authorizationRuleName string) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	ListAll(ctx context.Context, resourceGroupName string, namespaceName string) (result servicebus.TopicListResultPage, err error)
	ListAuthorizationRules(ctx context.Context, resourceGroupName string, namespaceName string, topicName string) (result servicebus.SharedAccessAuthorizationRuleListResultPage, err error)
	ListKeys(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, authorizationRuleName string) (result servicebus.ResourceListKeys, err error)
	PostAuthorizationRule(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, authorizationRuleName string) (result servicebus.SharedAccessAuthorizationRuleResource, err error)
	RegenerateKeys(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, authorizationRuleName string, parameters servicebus.RegenerateKeysParameters) (result servicebus.ResourceListKeys, err error)
}

var _ TopicsClientAPI = (*servicebus.TopicsClient)(nil)

// SubscriptionsClientAPI contains the set of methods on the SubscriptionsClient type.
type SubscriptionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, subscriptionName string, parameters servicebus.SubscriptionCreateOrUpdateParameters) (result servicebus.SubscriptionResource, err error)
	Delete(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, subscriptionName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, namespaceName string, topicName string, subscriptionName string) (result servicebus.SubscriptionResource, err error)
	ListAll(ctx context.Context, resourceGroupName string, namespaceName string, topicName string) (result servicebus.SubscriptionListResultPage, err error)
}

var _ SubscriptionsClientAPI = (*servicebus.SubscriptionsClient)(nil)
