// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/ad_group_bid_modifier.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents an ad group bid modifier.
type AdGroupBidModifier struct {
	// The resource name of the ad group bid modifier.
	// Ad group bid modifier resource names have the form:
	//
	// `customers/{customer_id}/adGroupBidModifiers/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ad group to which this criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,2,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The ID of the criterion to bid modify.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,3,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. The range is 1.0 - 6.0 for PreferredContent.
	// Use 0 to opt out of a Device type.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The base ad group from which this draft/trial adgroup bid modifier was
	// created. If ad_group is a base ad group then this field will be equal to
	// ad_group. If the ad group was created in the draft or trial and has no
	// corresponding base ad group, then this field will be null.
	// This field is readonly.
	BaseAdGroup *wrappers.StringValue `protobuf:"bytes,9,opt,name=base_ad_group,json=baseAdGroup,proto3" json:"base_ad_group,omitempty"`
	// Bid modifier source.
	BidModifierSource enums.BidModifierSourceEnum_BidModifierSource `protobuf:"varint,10,opt,name=bid_modifier_source,json=bidModifierSource,proto3,enum=google.ads.googleads.v3.enums.BidModifierSourceEnum_BidModifierSource" json:"bid_modifier_source,omitempty"`
	// The criterion of this ad group bid modifier.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupBidModifier_HotelDateSelectionType
	//	*AdGroupBidModifier_HotelAdvanceBookingWindow
	//	*AdGroupBidModifier_HotelLengthOfStay
	//	*AdGroupBidModifier_HotelCheckInDay
	//	*AdGroupBidModifier_Device
	//	*AdGroupBidModifier_PreferredContent
	Criterion            isAdGroupBidModifier_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AdGroupBidModifier) Reset()         { *m = AdGroupBidModifier{} }
func (m *AdGroupBidModifier) String() string { return proto.CompactTextString(m) }
func (*AdGroupBidModifier) ProtoMessage()    {}
func (*AdGroupBidModifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_d9b50cb17f277d0c, []int{0}
}

func (m *AdGroupBidModifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupBidModifier.Unmarshal(m, b)
}
func (m *AdGroupBidModifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupBidModifier.Marshal(b, m, deterministic)
}
func (m *AdGroupBidModifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupBidModifier.Merge(m, src)
}
func (m *AdGroupBidModifier) XXX_Size() int {
	return xxx_messageInfo_AdGroupBidModifier.Size(m)
}
func (m *AdGroupBidModifier) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupBidModifier.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupBidModifier proto.InternalMessageInfo

func (m *AdGroupBidModifier) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupBidModifier) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupBidModifier) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupBidModifier) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupBidModifier) GetBaseAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.BaseAdGroup
	}
	return nil
}

func (m *AdGroupBidModifier) GetBidModifierSource() enums.BidModifierSourceEnum_BidModifierSource {
	if m != nil {
		return m.BidModifierSource
	}
	return enums.BidModifierSourceEnum_UNSPECIFIED
}

type isAdGroupBidModifier_Criterion interface {
	isAdGroupBidModifier_Criterion()
}

type AdGroupBidModifier_HotelDateSelectionType struct {
	HotelDateSelectionType *common.HotelDateSelectionTypeInfo `protobuf:"bytes,5,opt,name=hotel_date_selection_type,json=hotelDateSelectionType,proto3,oneof"`
}

type AdGroupBidModifier_HotelAdvanceBookingWindow struct {
	HotelAdvanceBookingWindow *common.HotelAdvanceBookingWindowInfo `protobuf:"bytes,6,opt,name=hotel_advance_booking_window,json=hotelAdvanceBookingWindow,proto3,oneof"`
}

type AdGroupBidModifier_HotelLengthOfStay struct {
	HotelLengthOfStay *common.HotelLengthOfStayInfo `protobuf:"bytes,7,opt,name=hotel_length_of_stay,json=hotelLengthOfStay,proto3,oneof"`
}

type AdGroupBidModifier_HotelCheckInDay struct {
	HotelCheckInDay *common.HotelCheckInDayInfo `protobuf:"bytes,8,opt,name=hotel_check_in_day,json=hotelCheckInDay,proto3,oneof"`
}

type AdGroupBidModifier_Device struct {
	Device *common.DeviceInfo `protobuf:"bytes,11,opt,name=device,proto3,oneof"`
}

type AdGroupBidModifier_PreferredContent struct {
	PreferredContent *common.PreferredContentInfo `protobuf:"bytes,12,opt,name=preferred_content,json=preferredContent,proto3,oneof"`
}

func (*AdGroupBidModifier_HotelDateSelectionType) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelAdvanceBookingWindow) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelLengthOfStay) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelCheckInDay) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_Device) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_PreferredContent) isAdGroupBidModifier_Criterion() {}

func (m *AdGroupBidModifier) GetCriterion() isAdGroupBidModifier_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelDateSelectionType() *common.HotelDateSelectionTypeInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelDateSelectionType); ok {
		return x.HotelDateSelectionType
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelAdvanceBookingWindow() *common.HotelAdvanceBookingWindowInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelAdvanceBookingWindow); ok {
		return x.HotelAdvanceBookingWindow
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelLengthOfStay() *common.HotelLengthOfStayInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelLengthOfStay); ok {
		return x.HotelLengthOfStay
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelCheckInDay() *common.HotelCheckInDayInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelCheckInDay); ok {
		return x.HotelCheckInDay
	}
	return nil
}

func (m *AdGroupBidModifier) GetDevice() *common.DeviceInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_Device); ok {
		return x.Device
	}
	return nil
}

func (m *AdGroupBidModifier) GetPreferredContent() *common.PreferredContentInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_PreferredContent); ok {
		return x.PreferredContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupBidModifier) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupBidModifier_HotelDateSelectionType)(nil),
		(*AdGroupBidModifier_HotelAdvanceBookingWindow)(nil),
		(*AdGroupBidModifier_HotelLengthOfStay)(nil),
		(*AdGroupBidModifier_HotelCheckInDay)(nil),
		(*AdGroupBidModifier_Device)(nil),
		(*AdGroupBidModifier_PreferredContent)(nil),
	}
}

func init() {
	proto.RegisterType((*AdGroupBidModifier)(nil), "google.ads.googleads.v3.resources.AdGroupBidModifier")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/ad_group_bid_modifier.proto", fileDescriptor_d9b50cb17f277d0c)
}

var fileDescriptor_d9b50cb17f277d0c = []byte{
	// 739 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x95, 0xdf, 0x6e, 0xdb, 0x36,
	0x14, 0xc6, 0x67, 0x67, 0x4b, 0x62, 0xda, 0xd9, 0x16, 0x6d, 0xd8, 0x94, 0x2c, 0x18, 0x92, 0x0d,
	0x01, 0x82, 0x0d, 0x93, 0x80, 0x38, 0x5b, 0x00, 0x0d, 0xd9, 0x22, 0xc7, 0x6d, 0xe2, 0xa2, 0x7f,
	0x02, 0xbb, 0x70, 0x81, 0xc2, 0x00, 0x41, 0x89, 0xb4, 0x2c, 0xc4, 0x22, 0x05, 0x92, 0xb2, 0x61,
	0x04, 0x01, 0x7a, 0xd1, 0x27, 0x69, 0xef, 0xfa, 0x28, 0x7d, 0x94, 0x3c, 0x45, 0x21, 0x91, 0x52,
	0xdc, 0xd8, 0x6e, 0x7c, 0x77, 0xcc, 0x73, 0x7e, 0xdf, 0x77, 0x78, 0x28, 0xd2, 0xe0, 0x24, 0x60,
	0x2c, 0x18, 0x12, 0x1b, 0x61, 0x61, 0xab, 0x30, 0x8d, 0x46, 0x75, 0x9b, 0x13, 0xc1, 0x12, 0xee,
	0x13, 0x61, 0x23, 0x0c, 0x03, 0xce, 0x92, 0x18, 0x7a, 0x21, 0x86, 0x11, 0xc3, 0x61, 0x3f, 0x24,
	0xdc, 0x8a, 0x39, 0x93, 0xcc, 0xd8, 0x53, 0x8c, 0x85, 0xb0, 0xb0, 0x0a, 0xdc, 0x1a, 0xd5, 0xad,
	0x02, 0xdf, 0xfe, 0x6b, 0x91, 0x83, 0xcf, 0xa2, 0x88, 0x51, 0xdb, 0xe7, 0xa1, 0x24, 0x3c, 0x44,
	0x4a, 0x71, 0xfb, 0x78, 0x51, 0x39, 0xa1, 0x49, 0x24, 0xec, 0xe9, 0x1e, 0xa0, 0xb2, 0xd0, 0xe0,
	0x56, 0x0e, 0xc6, 0x61, 0xd1, 0xbc, 0x4e, 0xfd, 0xaa, 0x53, 0xd9, 0x2f, 0x2f, 0xe9, 0xdb, 0x63,
	0x8e, 0xe2, 0x98, 0x70, 0xa1, 0xf3, 0x3b, 0x53, 0x28, 0xa2, 0x94, 0x49, 0x24, 0x43, 0x46, 0x75,
	0xf6, 0xb7, 0xf7, 0x15, 0x60, 0xb8, 0xf8, 0x3c, 0x1d, 0x41, 0x23, 0xc4, 0xcf, 0xb4, 0xb9, 0xf1,
	0x3b, 0xd8, 0xc8, 0x6d, 0x20, 0x45, 0x11, 0x31, 0x4b, 0xbb, 0xa5, 0x83, 0x4a, 0xbb, 0x96, 0x2f,
	0x3e, 0x47, 0x11, 0x31, 0x8e, 0xc1, 0x7a, 0x3e, 0x3e, 0xb3, 0xbc, 0x5b, 0x3a, 0xa8, 0x1e, 0xee,
	0xe8, 0x39, 0x59, 0x79, 0x33, 0x56, 0x47, 0xf2, 0x90, 0x06, 0x5d, 0x34, 0x4c, 0x48, 0x7b, 0x0d,
	0x29, 0x23, 0xe3, 0x3f, 0x50, 0xd3, 0x83, 0x61, 0x14, 0x86, 0xd8, 0x5c, 0xc9, 0xe0, 0x5f, 0x66,
	0xe0, 0x16, 0x95, 0xff, 0x1c, 0x29, 0xb6, 0x5a, 0x00, 0x2d, 0x6c, 0xfc, 0x0f, 0x6a, 0xd3, 0xa3,
	0x32, 0xbf, 0x5e, 0x60, 0xde, 0x64, 0x89, 0x37, 0x24, 0x5a, 0xc0, 0x9b, 0xda, 0xde, 0x29, 0xd8,
	0xf0, 0x90, 0x20, 0xb0, 0x68, 0xbf, 0xb2, 0x44, 0xfb, 0xd5, 0x14, 0xd1, 0xb3, 0x32, 0x46, 0xe0,
	0x87, 0x39, 0xa7, 0x65, 0x82, 0xdd, 0xd2, 0xc1, 0xb7, 0x87, 0x8f, 0xad, 0x45, 0x5f, 0x4e, 0x76,
	0xce, 0xd6, 0xd4, 0xa4, 0x3b, 0x19, 0xf7, 0x88, 0x26, 0xd1, 0xec, 0x6a, 0x7b, 0xd3, 0xbb, 0xbf,
	0x64, 0x8c, 0xc1, 0xd6, 0x80, 0x49, 0x32, 0x84, 0x18, 0x49, 0x02, 0x05, 0x19, 0x12, 0x3f, 0x3d,
	0x4e, 0x28, 0x27, 0x31, 0x31, 0xbf, 0xc9, 0x76, 0xe1, 0x2c, 0x74, 0x57, 0x1f, 0xa5, 0x75, 0x91,
	0x0a, 0x34, 0x91, 0x24, 0x9d, 0x1c, 0x7f, 0x39, 0x89, 0x49, 0x8b, 0xf6, 0xd9, 0xc5, 0x57, 0xed,
	0x9f, 0x06, 0x73, 0xb3, 0xc6, 0x9b, 0x12, 0xd8, 0x51, 0xce, 0x08, 0x8f, 0x10, 0xf5, 0x09, 0xf4,
	0x18, 0xbb, 0x0a, 0x69, 0x00, 0xc7, 0x21, 0xc5, 0x6c, 0x6c, 0xae, 0x66, 0xe6, 0x27, 0x4b, 0x99,
	0xbb, 0x4a, 0xa2, 0xa1, 0x14, 0x5e, 0x65, 0x02, 0xda, 0x5f, 0x6d, 0x6f, 0x5e, 0x81, 0x31, 0x00,
	0x3f, 0xaa, 0x0e, 0x86, 0x84, 0x06, 0x72, 0x00, 0x59, 0x1f, 0x0a, 0x89, 0x26, 0xe6, 0x5a, 0xe6,
	0xfc, 0xf7, 0x52, 0xce, 0x4f, 0x33, 0xf4, 0x45, 0xbf, 0x23, 0xd1, 0x44, 0x3b, 0x6e, 0x0e, 0xee,
	0x27, 0x0c, 0x0f, 0x18, 0xca, 0xc9, 0x1f, 0x10, 0xff, 0x0a, 0x86, 0x14, 0x62, 0x34, 0x31, 0xd7,
	0x33, 0x9f, 0xfa, 0x52, 0x3e, 0x67, 0x29, 0xd8, 0xa2, 0xcd, 0xc2, 0xe5, 0xbb, 0xc1, 0xe7, 0xcb,
	0x46, 0x13, 0xac, 0x62, 0x32, 0x0a, 0x7d, 0x62, 0x56, 0x33, 0xdd, 0x3f, 0x1e, 0xd2, 0x6d, 0x66,
	0xd5, 0x5a, 0x4e, 0xb3, 0x86, 0x0f, 0x36, 0x63, 0x4e, 0xfa, 0x84, 0x73, 0x82, 0xa1, 0xcf, 0xa8,
	0x24, 0x54, 0x9a, 0xb5, 0x4c, 0xf0, 0xe8, 0x21, 0xc1, 0xcb, 0x1c, 0x3c, 0x53, 0x9c, 0x96, 0xfe,
	0x3e, 0xbe, 0xb7, 0xee, 0xf0, 0x5b, 0x97, 0x81, 0x3f, 0xef, 0x24, 0x74, 0x14, 0x87, 0x22, 0x95,
	0xb2, 0xe7, 0xbc, 0x1f, 0xa7, 0x7e, 0x22, 0x24, 0x8b, 0x08, 0x17, 0xf6, 0x75, 0x1e, 0xde, 0xd8,
	0x68, 0xa6, 0x50, 0xd8, 0xd7, 0x73, 0x5f, 0xe0, 0x9b, 0x46, 0x15, 0x54, 0x8a, 0x2b, 0xdf, 0x78,
	0x5b, 0x06, 0xfb, 0x3e, 0x8b, 0xac, 0x07, 0x1f, 0xe4, 0xc6, 0xcf, 0xb3, 0xcd, 0x5c, 0xa6, 0x97,
	0xf9, 0xb2, 0xf4, 0xfa, 0x89, 0xa6, 0x03, 0x36, 0x44, 0x34, 0xb0, 0x18, 0x0f, 0xec, 0x80, 0xd0,
	0xec, 0xaa, 0xdb, 0x77, 0x3b, 0xfa, 0xc2, 0x9f, 0xc5, 0xbf, 0x45, 0xf4, 0xae, 0xbc, 0x72, 0xee,
	0xba, 0x1f, 0xca, 0x7b, 0xe7, 0x4a, 0xd2, 0xc5, 0xc2, 0x52, 0x61, 0x1a, 0x75, 0xeb, 0x56, 0x3b,
	0xaf, 0xfc, 0x98, 0xd7, 0xf4, 0x5c, 0x2c, 0x7a, 0x45, 0x4d, 0xaf, 0x5b, 0xef, 0x15, 0x35, 0xb7,
	0xe5, 0x7d, 0x95, 0x70, 0x1c, 0x17, 0x0b, 0xc7, 0x29, 0xaa, 0x1c, 0xa7, 0x5b, 0x77, 0x9c, 0xa2,
	0xce, 0x5b, 0xcd, 0x9a, 0xad, 0x7f, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x6a, 0xf7, 0x63, 0xec, 0xd8,
	0x06, 0x00, 0x00,
}
