// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/feed_mapping.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A feed mapping.
type FeedMapping struct {
	// The resource name of the feed mapping.
	// Feed mapping resource names have the form:
	//
	// `customers/{customer_id}/feedMappings/{feed_id}~{feed_mapping_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The feed of this feed mapping.
	Feed *wrappers.StringValue `protobuf:"bytes,2,opt,name=feed,proto3" json:"feed,omitempty"`
	// Feed attributes to field mappings. These mappings are a one-to-many
	// relationship meaning that 1 feed attribute can be used to populate
	// multiple placeholder fields, but 1 placeholder field can only draw
	// data from 1 feed attribute. Ad Customizer is an exception, 1 placeholder
	// field can be mapped to multiple feed attributes. Required.
	AttributeFieldMappings []*AttributeFieldMapping `protobuf:"bytes,5,rep,name=attribute_field_mappings,json=attributeFieldMappings,proto3" json:"attribute_field_mappings,omitempty"`
	// Status of the feed mapping.
	// This field is read-only.
	Status enums.FeedMappingStatusEnum_FeedMappingStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.FeedMappingStatusEnum_FeedMappingStatus" json:"status,omitempty"`
	// Feed mapping target. Can be either a placeholder or a criterion. For a
	// given feed, the active FeedMappings must have unique targets. Required.
	//
	// Types that are valid to be assigned to Target:
	//	*FeedMapping_PlaceholderType
	//	*FeedMapping_CriterionType
	Target               isFeedMapping_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FeedMapping) Reset()         { *m = FeedMapping{} }
func (m *FeedMapping) String() string { return proto.CompactTextString(m) }
func (*FeedMapping) ProtoMessage()    {}
func (*FeedMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_686021db801e5474, []int{0}
}

func (m *FeedMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedMapping.Unmarshal(m, b)
}
func (m *FeedMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedMapping.Marshal(b, m, deterministic)
}
func (m *FeedMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedMapping.Merge(m, src)
}
func (m *FeedMapping) XXX_Size() int {
	return xxx_messageInfo_FeedMapping.Size(m)
}
func (m *FeedMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedMapping.DiscardUnknown(m)
}

var xxx_messageInfo_FeedMapping proto.InternalMessageInfo

func (m *FeedMapping) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *FeedMapping) GetFeed() *wrappers.StringValue {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *FeedMapping) GetAttributeFieldMappings() []*AttributeFieldMapping {
	if m != nil {
		return m.AttributeFieldMappings
	}
	return nil
}

func (m *FeedMapping) GetStatus() enums.FeedMappingStatusEnum_FeedMappingStatus {
	if m != nil {
		return m.Status
	}
	return enums.FeedMappingStatusEnum_UNSPECIFIED
}

type isFeedMapping_Target interface {
	isFeedMapping_Target()
}

type FeedMapping_PlaceholderType struct {
	PlaceholderType enums.PlaceholderTypeEnum_PlaceholderType `protobuf:"varint,3,opt,name=placeholder_type,json=placeholderType,proto3,enum=google.ads.googleads.v3.enums.PlaceholderTypeEnum_PlaceholderType,oneof"`
}

type FeedMapping_CriterionType struct {
	CriterionType enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType `protobuf:"varint,4,opt,name=criterion_type,json=criterionType,proto3,enum=google.ads.googleads.v3.enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType,oneof"`
}

func (*FeedMapping_PlaceholderType) isFeedMapping_Target() {}

func (*FeedMapping_CriterionType) isFeedMapping_Target() {}

func (m *FeedMapping) GetTarget() isFeedMapping_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *FeedMapping) GetPlaceholderType() enums.PlaceholderTypeEnum_PlaceholderType {
	if x, ok := m.GetTarget().(*FeedMapping_PlaceholderType); ok {
		return x.PlaceholderType
	}
	return enums.PlaceholderTypeEnum_UNSPECIFIED
}

func (m *FeedMapping) GetCriterionType() enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType {
	if x, ok := m.GetTarget().(*FeedMapping_CriterionType); ok {
		return x.CriterionType
	}
	return enums.FeedMappingCriterionTypeEnum_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeedMapping) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeedMapping_PlaceholderType)(nil),
		(*FeedMapping_CriterionType)(nil),
	}
}

// Maps from feed attribute id to a placeholder or criterion field id.
type AttributeFieldMapping struct {
	// Feed attribute from which to map.
	FeedAttributeId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=feed_attribute_id,json=feedAttributeId,proto3" json:"feed_attribute_id,omitempty"`
	// The placeholder field ID. If a placeholder field enum is not published in
	// the current API version, then this field will be populated and the field
	// oneof will be empty.
	// This field is read-only.
	FieldId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Placeholder or criterion field to be populated using data from
	// the above feed attribute. Required.
	//
	// Types that are valid to be assigned to Field:
	//	*AttributeFieldMapping_SitelinkField
	//	*AttributeFieldMapping_CallField
	//	*AttributeFieldMapping_AppField
	//	*AttributeFieldMapping_LocationField
	//	*AttributeFieldMapping_AffiliateLocationField
	//	*AttributeFieldMapping_CalloutField
	//	*AttributeFieldMapping_StructuredSnippetField
	//	*AttributeFieldMapping_MessageField
	//	*AttributeFieldMapping_PriceField
	//	*AttributeFieldMapping_PromotionField
	//	*AttributeFieldMapping_AdCustomizerField
	//	*AttributeFieldMapping_DsaPageFeedField
	//	*AttributeFieldMapping_LocationExtensionTargetingField
	//	*AttributeFieldMapping_EducationField
	//	*AttributeFieldMapping_FlightField
	//	*AttributeFieldMapping_CustomField
	//	*AttributeFieldMapping_HotelField
	//	*AttributeFieldMapping_RealEstateField
	//	*AttributeFieldMapping_TravelField
	//	*AttributeFieldMapping_LocalField
	//	*AttributeFieldMapping_JobField
	Field                isAttributeFieldMapping_Field `protobuf_oneof:"field"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AttributeFieldMapping) Reset()         { *m = AttributeFieldMapping{} }
func (m *AttributeFieldMapping) String() string { return proto.CompactTextString(m) }
func (*AttributeFieldMapping) ProtoMessage()    {}
func (*AttributeFieldMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_686021db801e5474, []int{1}
}

func (m *AttributeFieldMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeFieldMapping.Unmarshal(m, b)
}
func (m *AttributeFieldMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeFieldMapping.Marshal(b, m, deterministic)
}
func (m *AttributeFieldMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeFieldMapping.Merge(m, src)
}
func (m *AttributeFieldMapping) XXX_Size() int {
	return xxx_messageInfo_AttributeFieldMapping.Size(m)
}
func (m *AttributeFieldMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeFieldMapping.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeFieldMapping proto.InternalMessageInfo

func (m *AttributeFieldMapping) GetFeedAttributeId() *wrappers.Int64Value {
	if m != nil {
		return m.FeedAttributeId
	}
	return nil
}

func (m *AttributeFieldMapping) GetFieldId() *wrappers.Int64Value {
	if m != nil {
		return m.FieldId
	}
	return nil
}

type isAttributeFieldMapping_Field interface {
	isAttributeFieldMapping_Field()
}

type AttributeFieldMapping_SitelinkField struct {
	SitelinkField enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField `protobuf:"varint,3,opt,name=sitelink_field,json=sitelinkField,proto3,enum=google.ads.googleads.v3.enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField,oneof"`
}

type AttributeFieldMapping_CallField struct {
	CallField enums.CallPlaceholderFieldEnum_CallPlaceholderField `protobuf:"varint,4,opt,name=call_field,json=callField,proto3,enum=google.ads.googleads.v3.enums.CallPlaceholderFieldEnum_CallPlaceholderField,oneof"`
}

type AttributeFieldMapping_AppField struct {
	AppField enums.AppPlaceholderFieldEnum_AppPlaceholderField `protobuf:"varint,5,opt,name=app_field,json=appField,proto3,enum=google.ads.googleads.v3.enums.AppPlaceholderFieldEnum_AppPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocationField struct {
	LocationField enums.LocationPlaceholderFieldEnum_LocationPlaceholderField `protobuf:"varint,6,opt,name=location_field,json=locationField,proto3,enum=google.ads.googleads.v3.enums.LocationPlaceholderFieldEnum_LocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_AffiliateLocationField struct {
	AffiliateLocationField enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField `protobuf:"varint,7,opt,name=affiliate_location_field,json=affiliateLocationField,proto3,enum=google.ads.googleads.v3.enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_CalloutField struct {
	CalloutField enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField `protobuf:"varint,8,opt,name=callout_field,json=calloutField,proto3,enum=google.ads.googleads.v3.enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField,oneof"`
}

type AttributeFieldMapping_StructuredSnippetField struct {
	StructuredSnippetField enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField `protobuf:"varint,9,opt,name=structured_snippet_field,json=structuredSnippetField,proto3,enum=google.ads.googleads.v3.enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField,oneof"`
}

type AttributeFieldMapping_MessageField struct {
	MessageField enums.MessagePlaceholderFieldEnum_MessagePlaceholderField `protobuf:"varint,10,opt,name=message_field,json=messageField,proto3,enum=google.ads.googleads.v3.enums.MessagePlaceholderFieldEnum_MessagePlaceholderField,oneof"`
}

type AttributeFieldMapping_PriceField struct {
	PriceField enums.PricePlaceholderFieldEnum_PricePlaceholderField `protobuf:"varint,11,opt,name=price_field,json=priceField,proto3,enum=google.ads.googleads.v3.enums.PricePlaceholderFieldEnum_PricePlaceholderField,oneof"`
}

type AttributeFieldMapping_PromotionField struct {
	PromotionField enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField `protobuf:"varint,12,opt,name=promotion_field,json=promotionField,proto3,enum=google.ads.googleads.v3.enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField,oneof"`
}

type AttributeFieldMapping_AdCustomizerField struct {
	AdCustomizerField enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField `protobuf:"varint,13,opt,name=ad_customizer_field,json=adCustomizerField,proto3,enum=google.ads.googleads.v3.enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField,oneof"`
}

type AttributeFieldMapping_DsaPageFeedField struct {
	DsaPageFeedField enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField `protobuf:"varint,14,opt,name=dsa_page_feed_field,json=dsaPageFeedField,proto3,enum=google.ads.googleads.v3.enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField,oneof"`
}

type AttributeFieldMapping_LocationExtensionTargetingField struct {
	LocationExtensionTargetingField enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField `protobuf:"varint,15,opt,name=location_extension_targeting_field,json=locationExtensionTargetingField,proto3,enum=google.ads.googleads.v3.enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField,oneof"`
}

type AttributeFieldMapping_EducationField struct {
	EducationField enums.EducationPlaceholderFieldEnum_EducationPlaceholderField `protobuf:"varint,16,opt,name=education_field,json=educationField,proto3,enum=google.ads.googleads.v3.enums.EducationPlaceholderFieldEnum_EducationPlaceholderField,oneof"`
}

type AttributeFieldMapping_FlightField struct {
	FlightField enums.FlightPlaceholderFieldEnum_FlightPlaceholderField `protobuf:"varint,17,opt,name=flight_field,json=flightField,proto3,enum=google.ads.googleads.v3.enums.FlightPlaceholderFieldEnum_FlightPlaceholderField,oneof"`
}

type AttributeFieldMapping_CustomField struct {
	CustomField enums.CustomPlaceholderFieldEnum_CustomPlaceholderField `protobuf:"varint,18,opt,name=custom_field,json=customField,proto3,enum=google.ads.googleads.v3.enums.CustomPlaceholderFieldEnum_CustomPlaceholderField,oneof"`
}

type AttributeFieldMapping_HotelField struct {
	HotelField enums.HotelPlaceholderFieldEnum_HotelPlaceholderField `protobuf:"varint,19,opt,name=hotel_field,json=hotelField,proto3,enum=google.ads.googleads.v3.enums.HotelPlaceholderFieldEnum_HotelPlaceholderField,oneof"`
}

type AttributeFieldMapping_RealEstateField struct {
	RealEstateField enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField `protobuf:"varint,20,opt,name=real_estate_field,json=realEstateField,proto3,enum=google.ads.googleads.v3.enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField,oneof"`
}

type AttributeFieldMapping_TravelField struct {
	TravelField enums.TravelPlaceholderFieldEnum_TravelPlaceholderField `protobuf:"varint,21,opt,name=travel_field,json=travelField,proto3,enum=google.ads.googleads.v3.enums.TravelPlaceholderFieldEnum_TravelPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocalField struct {
	LocalField enums.LocalPlaceholderFieldEnum_LocalPlaceholderField `protobuf:"varint,22,opt,name=local_field,json=localField,proto3,enum=google.ads.googleads.v3.enums.LocalPlaceholderFieldEnum_LocalPlaceholderField,oneof"`
}

type AttributeFieldMapping_JobField struct {
	JobField enums.JobPlaceholderFieldEnum_JobPlaceholderField `protobuf:"varint,23,opt,name=job_field,json=jobField,proto3,enum=google.ads.googleads.v3.enums.JobPlaceholderFieldEnum_JobPlaceholderField,oneof"`
}

func (*AttributeFieldMapping_SitelinkField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CallField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AppField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AffiliateLocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CalloutField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_StructuredSnippetField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_MessageField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PriceField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PromotionField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AdCustomizerField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_DsaPageFeedField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationExtensionTargetingField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_EducationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_FlightField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CustomField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_HotelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_RealEstateField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_TravelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocalField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_JobField) isAttributeFieldMapping_Field() {}

func (m *AttributeFieldMapping) GetField() isAttributeFieldMapping_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *AttributeFieldMapping) GetSitelinkField() enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_SitelinkField); ok {
		return x.SitelinkField
	}
	return enums.SitelinkPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCallField() enums.CallPlaceholderFieldEnum_CallPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CallField); ok {
		return x.CallField
	}
	return enums.CallPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAppField() enums.AppPlaceholderFieldEnum_AppPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AppField); ok {
		return x.AppField
	}
	return enums.AppPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocationField() enums.LocationPlaceholderFieldEnum_LocationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocationField); ok {
		return x.LocationField
	}
	return enums.LocationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAffiliateLocationField() enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AffiliateLocationField); ok {
		return x.AffiliateLocationField
	}
	return enums.AffiliateLocationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCalloutField() enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CalloutField); ok {
		return x.CalloutField
	}
	return enums.CalloutPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetStructuredSnippetField() enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_StructuredSnippetField); ok {
		return x.StructuredSnippetField
	}
	return enums.StructuredSnippetPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetMessageField() enums.MessagePlaceholderFieldEnum_MessagePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_MessageField); ok {
		return x.MessageField
	}
	return enums.MessagePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetPriceField() enums.PricePlaceholderFieldEnum_PricePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_PriceField); ok {
		return x.PriceField
	}
	return enums.PricePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetPromotionField() enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_PromotionField); ok {
		return x.PromotionField
	}
	return enums.PromotionPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAdCustomizerField() enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AdCustomizerField); ok {
		return x.AdCustomizerField
	}
	return enums.AdCustomizerPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetDsaPageFeedField() enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField {
	if x, ok := m.GetField().(*AttributeFieldMapping_DsaPageFeedField); ok {
		return x.DsaPageFeedField
	}
	return enums.DsaPageFeedCriterionFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocationExtensionTargetingField() enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocationExtensionTargetingField); ok {
		return x.LocationExtensionTargetingField
	}
	return enums.LocationExtensionTargetingCriterionFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetEducationField() enums.EducationPlaceholderFieldEnum_EducationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_EducationField); ok {
		return x.EducationField
	}
	return enums.EducationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetFlightField() enums.FlightPlaceholderFieldEnum_FlightPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_FlightField); ok {
		return x.FlightField
	}
	return enums.FlightPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCustomField() enums.CustomPlaceholderFieldEnum_CustomPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CustomField); ok {
		return x.CustomField
	}
	return enums.CustomPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetHotelField() enums.HotelPlaceholderFieldEnum_HotelPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_HotelField); ok {
		return x.HotelField
	}
	return enums.HotelPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetRealEstateField() enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_RealEstateField); ok {
		return x.RealEstateField
	}
	return enums.RealEstatePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetTravelField() enums.TravelPlaceholderFieldEnum_TravelPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_TravelField); ok {
		return x.TravelField
	}
	return enums.TravelPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocalField() enums.LocalPlaceholderFieldEnum_LocalPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocalField); ok {
		return x.LocalField
	}
	return enums.LocalPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetJobField() enums.JobPlaceholderFieldEnum_JobPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_JobField); ok {
		return x.JobField
	}
	return enums.JobPlaceholderFieldEnum_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AttributeFieldMapping) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AttributeFieldMapping_SitelinkField)(nil),
		(*AttributeFieldMapping_CallField)(nil),
		(*AttributeFieldMapping_AppField)(nil),
		(*AttributeFieldMapping_LocationField)(nil),
		(*AttributeFieldMapping_AffiliateLocationField)(nil),
		(*AttributeFieldMapping_CalloutField)(nil),
		(*AttributeFieldMapping_StructuredSnippetField)(nil),
		(*AttributeFieldMapping_MessageField)(nil),
		(*AttributeFieldMapping_PriceField)(nil),
		(*AttributeFieldMapping_PromotionField)(nil),
		(*AttributeFieldMapping_AdCustomizerField)(nil),
		(*AttributeFieldMapping_DsaPageFeedField)(nil),
		(*AttributeFieldMapping_LocationExtensionTargetingField)(nil),
		(*AttributeFieldMapping_EducationField)(nil),
		(*AttributeFieldMapping_FlightField)(nil),
		(*AttributeFieldMapping_CustomField)(nil),
		(*AttributeFieldMapping_HotelField)(nil),
		(*AttributeFieldMapping_RealEstateField)(nil),
		(*AttributeFieldMapping_TravelField)(nil),
		(*AttributeFieldMapping_LocalField)(nil),
		(*AttributeFieldMapping_JobField)(nil),
	}
}

func init() {
	proto.RegisterType((*FeedMapping)(nil), "google.ads.googleads.v3.resources.FeedMapping")
	proto.RegisterType((*AttributeFieldMapping)(nil), "google.ads.googleads.v3.resources.AttributeFieldMapping")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/feed_mapping.proto", fileDescriptor_686021db801e5474)
}

var fileDescriptor_686021db801e5474 = []byte{
	// 1360 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x98, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0xc7, 0xed, 0xb4, 0x49, 0x93, 0xd9, 0x7c, 0x6e, 0x69, 0x58, 0x4a, 0x05, 0x69, 0xa1, 0x52,
	0xae, 0xbc, 0x55, 0x52, 0x15, 0xd8, 0xf2, 0xa1, 0x4d, 0x48, 0xeb, 0x56, 0x6d, 0xb5, 0x72, 0xa2,
	0xa8, 0x82, 0x88, 0xd5, 0xec, 0x7a, 0x76, 0xeb, 0xe2, 0xf5, 0x18, 0xcf, 0xb8, 0x50, 0xaa, 0x5c,
	0x70, 0x03, 0x77, 0xf0, 0x0e, 0xbd, 0xe4, 0x35, 0xb8, 0xe3, 0x9a, 0xa7, 0xe8, 0x3b, 0x20, 0xa1,
	0x99, 0x63, 0xcf, 0x3a, 0xe9, 0xd8, 0x63, 0xf6, 0x6e, 0x76, 0xce, 0xfc, 0xcf, 0xef, 0xf8, 0xcc,
	0x99, 0xaf, 0x45, 0xb7, 0xc7, 0x94, 0x8e, 0x43, 0xd2, 0xc6, 0x3e, 0x6b, 0x43, 0x53, 0xb4, 0x5e,
	0xec, 0xb6, 0x13, 0xc2, 0x68, 0x9a, 0x0c, 0x09, 0x6b, 0x8f, 0x08, 0xf1, 0xfb, 0x13, 0x1c, 0xc7,
	0x41, 0x34, 0x76, 0xe2, 0x84, 0x72, 0xda, 0xbc, 0x0e, 0x43, 0x1d, 0xec, 0x33, 0x47, 0xa9, 0x9c,
	0x17, 0xbb, 0x8e, 0x52, 0x5d, 0xdd, 0x2f, 0x73, 0x4c, 0xa2, 0x74, 0xc2, 0xda, 0xd8, 0xef, 0x0f,
	0x53, 0xc6, 0xe9, 0x24, 0xf8, 0x99, 0x24, 0xfd, 0x38, 0xc4, 0x43, 0xf2, 0x8c, 0x86, 0x3e, 0x49,
	0xfa, 0xa3, 0x80, 0x84, 0x3e, 0x70, 0xae, 0xba, 0x06, 0x27, 0xa3, 0x51, 0x10, 0x06, 0x98, 0x93,
	0x7e, 0x48, 0x87, 0x98, 0x07, 0x34, 0x2a, 0xf5, 0xf4, 0x99, 0xc1, 0x53, 0x1c, 0x97, 0x4a, 0x3b,
	0xd5, 0xd2, 0x21, 0x0e, 0xc3, 0x52, 0xed, 0x17, 0x66, 0x2d, 0x4d, 0x79, 0xa9, 0xfc, 0x73, 0x83,
	0x5c, 0x66, 0xb0, 0x54, 0xdd, 0xad, 0x56, 0xfb, 0x0c, 0xf7, 0x63, 0x3c, 0x26, 0x7d, 0x39, 0xc1,
	0xc3, 0x24, 0xe0, 0x24, 0x11, 0x29, 0x2c, 0xba, 0xf8, 0xaa, 0xda, 0x05, 0xf1, 0x53, 0x43, 0xde,
	0x0d, 0x0e, 0x8a, 0xb5, 0x55, 0x08, 0x81, 0xbf, 0x8c, 0x49, 0xe6, 0xe0, 0x93, 0xff, 0xe1, 0x80,
	0x71, 0xcc, 0x53, 0x56, 0x2f, 0x77, 0xa3, 0x30, 0x18, 0x3f, 0x2b, 0xcf, 0xfc, 0xdd, 0x6a, 0xf5,
	0x33, 0xca, 0x49, 0x38, 0x6b, 0xb1, 0x3d, 0xa7, 0x83, 0x59, 0xb9, 0xa2, 0xce, 0xcb, 0xb9, 0x3d,
	0xb3, 0x58, 0x4e, 0x16, 0xf9, 0x89, 0x93, 0x88, 0xc9, 0x44, 0xe3, 0x64, 0x4c, 0xf8, 0xd9, 0xe4,
	0x17, 0x3d, 0x7e, 0x59, 0xd3, 0xe3, 0x8c, 0xf5, 0x3f, 0x21, 0x8c, 0x89, 0x0a, 0x2c, 0x93, 0xdf,
	0xae, 0x96, 0x17, 0x65, 0x85, 0x92, 0x31, 0xe4, 0x30, 0x4e, 0x82, 0x21, 0x99, 0xb5, 0x60, 0xe3,
	0x84, 0x4e, 0x68, 0xe5, 0x27, 0x1b, 0x56, 0x5d, 0x42, 0x70, 0xd8, 0x27, 0xa2, 0x52, 0xcb, 0x63,
	0x30, 0x64, 0x9d, 0x05, 0x9c, 0x84, 0x41, 0xf4, 0xfd, 0xac, 0xdb, 0x26, 0xe3, 0x49, 0x3a, 0xe4,
	0x69, 0x42, 0xfc, 0x3e, 0x8b, 0x82, 0x38, 0x26, 0x33, 0x6f, 0x40, 0x3c, 0xc1, 0x2f, 0x2a, 0xd6,
	0xc1, 0x7b, 0xb9, 0x3a, 0x0e, 0xd4, 0x79, 0x92, 0x99, 0x3e, 0xc8, 0x4c, 0xf2, 0xd7, 0x20, 0x1d,
	0xb5, 0x7f, 0x4c, 0x70, 0x1c, 0x93, 0x24, 0x5f, 0xbd, 0xd7, 0x0a, 0x52, 0x1c, 0x45, 0x94, 0xcb,
	0x3a, 0xcb, 0xac, 0x37, 0xfe, 0x98, 0x47, 0x8d, 0x7b, 0x84, 0xf8, 0x8f, 0x61, 0xe1, 0x37, 0x3f,
	0x42, 0x2b, 0xb9, 0xff, 0x7e, 0x84, 0x27, 0xa4, 0x65, 0x6f, 0xd9, 0xdb, 0x4b, 0xde, 0x72, 0xde,
	0xf9, 0x04, 0x4f, 0x48, 0xf3, 0x16, 0xba, 0x28, 0x76, 0x8b, 0xd6, 0xdc, 0x96, 0xbd, 0xdd, 0xd8,
	0xb9, 0x96, 0x1d, 0x5c, 0x4e, 0x1e, 0x81, 0x73, 0xc8, 0x93, 0x20, 0x1a, 0x1f, 0xe3, 0x30, 0x25,
	0x9e, 0x1c, 0xd9, 0x4c, 0x50, 0x0b, 0x73, 0x9e, 0x04, 0x83, 0x94, 0x13, 0xf8, 0xb0, 0x7c, 0xab,
	0x61, 0xad, 0xf9, 0xad, 0x0b, 0xdb, 0x8d, 0x9d, 0x4f, 0x1d, 0xe3, 0x49, 0xe8, 0x74, 0x73, 0x17,
	0xf7, 0x84, 0x87, 0x2c, 0x64, 0x6f, 0x13, 0xeb, 0xba, 0x59, 0xf3, 0x3b, 0xb4, 0x00, 0xdb, 0x58,
	0x6b, 0x61, 0xcb, 0xde, 0x5e, 0xdd, 0xb9, 0x57, 0x4a, 0x90, 0x53, 0xe0, 0x14, 0xd2, 0x70, 0x28,
	0x75, 0x07, 0x51, 0x3a, 0x79, 0xbb, 0xd7, 0xcb, 0xbc, 0x36, 0x29, 0x5a, 0x3f, 0xbf, 0x6c, 0x5a,
	0x17, 0x24, 0x69, 0xcf, 0x40, 0xea, 0x4d, 0x65, 0x47, 0x2f, 0x63, 0x22, 0x39, 0xe7, 0xfa, 0x5c,
	0xcb, 0x5b, 0x8b, 0xcf, 0x76, 0x35, 0x4f, 0xd1, 0xea, 0xd9, 0x8d, 0xbd, 0x75, 0x51, 0xe2, 0x8e,
	0xea, 0x7f, 0xd8, 0x7e, 0xae, 0x57, 0xdc, 0x32, 0xa3, 0x6b, 0x79, 0x2b, 0xc3, 0x62, 0x47, 0xe7,
	0xdb, 0x37, 0xdd, 0xa7, 0xe8, 0xe3, 0xa9, 0xff, 0xac, 0x15, 0x07, 0xcc, 0x19, 0xd2, 0x49, 0xbb,
	0x58, 0x45, 0xb7, 0xe0, 0x3c, 0x25, 0x09, 0x6b, 0xbf, 0xca, 0x9b, 0xa7, 0xf2, 0x84, 0xc9, 0x67,
	0xa7, 0xfd, 0xaa, 0x78, 0xde, 0x9c, 0xee, 0x2d, 0xa2, 0x05, 0xd8, 0x41, 0x6f, 0xfc, 0xb3, 0x89,
	0xae, 0x68, 0x27, 0xba, 0x79, 0x1f, 0x6d, 0x48, 0xd1, 0xb4, 0x92, 0x02, 0x5f, 0xd6, 0x67, 0x63,
	0xe7, 0xfd, 0xb7, 0x6a, 0xf0, 0x41, 0xc4, 0xef, 0xdc, 0x86, 0x12, 0x5c, 0x13, 0x2a, 0xe5, 0xf2,
	0x81, 0xdf, 0xbc, 0x83, 0x16, 0xa1, 0x06, 0x83, 0xbc, 0x86, 0x2b, 0xf5, 0x97, 0xe4, 0xe0, 0x07,
	0xbe, 0x98, 0x00, 0xb5, 0x63, 0xc8, 0xbe, 0x6c, 0xbe, 0x4d, 0x13, 0x70, 0x98, 0x89, 0x0a, 0x73,
	0x2c, 0x3f, 0x4c, 0x4e, 0x40, 0x99, 0x51, 0x4c, 0x40, 0x4e, 0x93, 0x1d, 0xcd, 0x09, 0x42, 0xf2,
	0x8a, 0x04, 0x68, 0x98, 0xfb, 0x47, 0x06, 0xf4, 0x3e, 0x0e, 0x43, 0x2d, 0x56, 0x67, 0x70, 0x2d,
	0x6f, 0x49, 0x10, 0x00, 0x17, 0xa0, 0x25, 0x71, 0x99, 0x03, 0xda, 0xbc, 0xa4, 0x3d, 0x34, 0xd0,
	0xba, 0x71, 0xac, 0x85, 0x69, 0xfa, 0x5d, 0xcb, 0x5b, 0xc4, 0x71, 0x0c, 0xa8, 0x53, 0xb4, 0xaa,
	0x0e, 0x40, 0xe0, 0x2d, 0xd4, 0x4a, 0xec, 0xa3, 0x4c, 0xa4, 0x85, 0x96, 0x19, 0x45, 0x62, 0x73,
	0x1a, 0xe0, 0x5f, 0xdb, 0xa8, 0xa5, 0xb9, 0x01, 0x43, 0x24, 0x97, 0x64, 0x24, 0x23, 0xd3, 0x97,
	0xe7, 0xf2, 0xca, 0x90, 0x8c, 0xa3, 0x5c, 0xcb, 0xdb, 0xc4, 0xe7, 0x07, 0x41, 0x90, 0x2f, 0xd1,
	0x4a, 0x7e, 0xc9, 0x85, 0xc0, 0x16, 0x65, 0x60, 0x5e, 0x8d, 0x02, 0xa0, 0x29, 0x2f, 0xad, 0x01,
	0x8d, 0xcd, 0xb5, 0xbc, 0xe5, 0x0c, 0x35, 0xcd, 0x8f, 0xe6, 0xa8, 0x83, 0x30, 0x96, 0x6a, 0xe5,
	0xe7, 0x50, 0xc9, 0x0f, 0x41, 0xad, 0x5f, 0x0b, 0xa6, 0x51, 0x22, 0x3f, 0xec, 0xfc, 0x20, 0x95,
	0x9f, 0xfc, 0x12, 0x04, 0x81, 0xa1, 0x5a, 0xf9, 0x79, 0x0c, 0x1a, 0x6d, 0x38, 0x25, 0x36, 0x91,
	0x9f, 0x0c, 0x05, 0xe8, 0x1f, 0x50, 0x03, 0xae, 0x42, 0x00, 0x6e, 0x48, 0xf0, 0x13, 0xd3, 0x21,
	0x20, 0x14, 0x5a, 0xac, 0xd6, 0xe2, 0x5a, 0x1e, 0x92, 0x10, 0x40, 0xfe, 0x62, 0xa3, 0xb5, 0xe9,
	0x0d, 0x0a, 0xb8, 0xcb, 0x92, 0x7b, 0x6c, 0xe4, 0x66, 0xaa, 0x12, 0x76, 0x89, 0xd5, 0xb5, 0xbc,
	0x55, 0x05, 0x84, 0x18, 0x7e, 0xb7, 0xd1, 0xe5, 0xb3, 0xaf, 0x4f, 0x88, 0x63, 0x45, 0xc6, 0x71,
	0x62, 0x5a, 0x31, 0xfe, 0xbe, 0x12, 0xea, 0x17, 0x4b, 0xc5, 0x00, 0xd7, 0xf2, 0x36, 0x70, 0xc1,
	0x0e, 0x01, 0xfd, 0x66, 0xa3, 0xcb, 0x67, 0xdf, 0x62, 0x10, 0xd0, 0x6a, 0xad, 0xc4, 0x7c, 0xcd,
	0x70, 0x4f, 0x4c, 0x29, 0x21, 0xbe, 0x3a, 0x09, 0xa7, 0xd1, 0x94, 0x5a, 0x5d, 0xcb, 0x5b, 0xf7,
	0xa7, 0x46, 0x88, 0xe4, 0x2f, 0x1b, 0xdd, 0xa8, 0x7c, 0x24, 0x40, 0x60, 0x6b, 0x32, 0x30, 0x5e,
	0x73, 0x97, 0x3b, 0xc8, 0xfd, 0x1c, 0xe5, 0x6e, 0x34, 0x71, 0xd6, 0x1d, 0xec, 0x5a, 0xde, 0x87,
	0x61, 0xe9, 0xd8, 0x69, 0x91, 0x4d, 0x1f, 0xa6, 0x10, 0xf2, 0x7a, 0xad, 0x5c, 0x1e, 0xe4, 0x2a,
	0xed, 0xcc, 0x96, 0x5a, 0x45, 0x91, 0x29, 0x20, 0xc4, 0x90, 0xa2, 0xe5, 0xec, 0x81, 0x09, 0xfc,
	0x0d, 0xc9, 0xef, 0x99, 0xae, 0x3c, 0x52, 0xa2, 0x85, 0xeb, 0x4d, 0xae, 0xe5, 0x35, 0x80, 0xa3,
	0xb0, 0xd9, 0x7f, 0x02, 0x80, 0x6d, 0xd6, 0xc2, 0x42, 0x41, 0xea, 0xf7, 0x5a, 0xad, 0x49, 0x60,
	0x81, 0xa3, 0x76, 0x12, 0x78, 0x10, 0x03, 0xf5, 0x72, 0xad, 0x9d, 0xc4, 0x15, 0x0a, 0x2d, 0x54,
	0x6b, 0x11, 0x3b, 0x89, 0x84, 0x00, 0xf2, 0x57, 0x1b, 0x6d, 0x14, 0x9f, 0x52, 0x40, 0x7e, 0x47,
	0x92, 0x9f, 0x1a, 0xc8, 0x1e, 0xc1, 0xe1, 0x81, 0x94, 0x69, 0xf1, 0xe5, 0x66, 0x71, 0xbd, 0x4d,
	0x94, 0x55, 0xa5, 0x3c, 0x7b, 0x05, 0x41, 0x08, 0x57, 0x6a, 0xa5, 0xfc, 0x48, 0x4a, 0xb4, 0x78,
	0xbd, 0x49, 0xa4, 0x1c, 0x38, 0x2a, 0xe5, 0xf0, 0x5f, 0x00, 0x50, 0x37, 0x6b, 0xa5, 0x5c, 0xac,
	0xb2, 0xb0, 0xf4, 0xd6, 0xa1, 0x4d, 0xb9, 0x84, 0xa8, 0x9b, 0xd5, 0x73, 0x3a, 0xc8, 0x80, 0xef,
	0xd6, 0xba, 0x59, 0x3d, 0xa4, 0x03, 0x2d, 0x4e, 0xd3, 0x2f, 0x6e, 0x56, 0xcf, 0xe9, 0x40, 0xb6,
	0xf7, 0x2e, 0xa1, 0x79, 0x89, 0xd9, 0xfb, 0xd7, 0x46, 0x37, 0x87, 0x74, 0x62, 0x7e, 0x65, 0xed,
	0xad, 0x17, 0x6e, 0xf2, 0x3d, 0x71, 0x1d, 0xee, 0xd9, 0xdf, 0x3c, 0xcc, 0x64, 0x63, 0x1a, 0xe2,
	0x68, 0xec, 0xd0, 0x64, 0xdc, 0x1e, 0x93, 0x48, 0x5e, 0x96, 0xdb, 0xd3, 0x77, 0x40, 0xc5, 0x7f,
	0x9f, 0x77, 0x55, 0xeb, 0xf5, 0xdc, 0x85, 0xfb, 0xdd, 0xee, 0x9f, 0x73, 0xd7, 0xef, 0x83, 0xcb,
	0xae, 0xcf, 0x1c, 0x68, 0x8a, 0xd6, 0xf1, 0xae, 0xe3, 0xe5, 0x23, 0xff, 0xce, 0xc7, 0x9c, 0x74,
	0x7d, 0x76, 0xa2, 0xc6, 0x9c, 0x1c, 0xef, 0x9e, 0xa8, 0x31, 0x6f, 0xe6, 0x6e, 0x82, 0xa1, 0xd3,
	0xe9, 0xfa, 0xac, 0xd3, 0x51, 0xa3, 0x3a, 0x9d, 0xe3, 0xdd, 0x4e, 0x47, 0x8d, 0x1b, 0x2c, 0xc8,
	0x60, 0x77, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x8b, 0x7d, 0x27, 0x51, 0xa7, 0x15, 0x00, 0x00,
}
