// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/v2/data.proto

package bigtable

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies the complete (requested) contents of a single row of a table.
// Rows which exceed 256MiB in size cannot be read in full.
type Row struct {
	// The unique key which identifies this row within its table. This is the same
	// key that's used to identify the row in, for example, a MutateRowRequest.
	// May contain any non-empty byte string up to 4KiB in length.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// May be empty, but only if the entire row is empty.
	// The mutual ordering of column families is not specified.
	Families             []*Family `protobuf:"bytes,2,rep,name=families,proto3" json:"families,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Row) Reset()         { *m = Row{} }
func (m *Row) String() string { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()    {}
func (*Row) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{0}
}

func (m *Row) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Row.Unmarshal(m, b)
}
func (m *Row) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Row.Marshal(b, m, deterministic)
}
func (m *Row) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Row.Merge(m, src)
}
func (m *Row) XXX_Size() int {
	return xxx_messageInfo_Row.Size(m)
}
func (m *Row) XXX_DiscardUnknown() {
	xxx_messageInfo_Row.DiscardUnknown(m)
}

var xxx_messageInfo_Row proto.InternalMessageInfo

func (m *Row) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Row) GetFamilies() []*Family {
	if m != nil {
		return m.Families
	}
	return nil
}

// Specifies (some of) the contents of a single row/column family intersection
// of a table.
type Family struct {
	// The unique key which identifies this family within its row. This is the
	// same key that's used to identify the family in, for example, a RowFilter
	// which sets its "family_name_regex_filter" field.
	// Must match `[-_.a-zA-Z0-9]+`, except that AggregatingRowProcessors may
	// produce cells in a sentinel family with an empty name.
	// Must be no greater than 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Must not be empty. Sorted in order of increasing "qualifier".
	Columns              []*Column `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Family) Reset()         { *m = Family{} }
func (m *Family) String() string { return proto.CompactTextString(m) }
func (*Family) ProtoMessage()    {}
func (*Family) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{1}
}

func (m *Family) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Family.Unmarshal(m, b)
}
func (m *Family) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Family.Marshal(b, m, deterministic)
}
func (m *Family) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Family.Merge(m, src)
}
func (m *Family) XXX_Size() int {
	return xxx_messageInfo_Family.Size(m)
}
func (m *Family) XXX_DiscardUnknown() {
	xxx_messageInfo_Family.DiscardUnknown(m)
}

var xxx_messageInfo_Family proto.InternalMessageInfo

func (m *Family) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Family) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

// Specifies (some of) the contents of a single row/column intersection of a
// table.
type Column struct {
	// The unique key which identifies this column within its family. This is the
	// same key that's used to identify the column in, for example, a RowFilter
	// which sets its `column_qualifier_regex_filter` field.
	// May contain any byte string, including the empty string, up to 16kiB in
	// length.
	Qualifier []byte `protobuf:"bytes,1,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// Must not be empty. Sorted in order of decreasing "timestamp_micros".
	Cells                []*Cell  `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Column) Reset()         { *m = Column{} }
func (m *Column) String() string { return proto.CompactTextString(m) }
func (*Column) ProtoMessage()    {}
func (*Column) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{2}
}

func (m *Column) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Column.Unmarshal(m, b)
}
func (m *Column) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Column.Marshal(b, m, deterministic)
}
func (m *Column) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Column.Merge(m, src)
}
func (m *Column) XXX_Size() int {
	return xxx_messageInfo_Column.Size(m)
}
func (m *Column) XXX_DiscardUnknown() {
	xxx_messageInfo_Column.DiscardUnknown(m)
}

var xxx_messageInfo_Column proto.InternalMessageInfo

func (m *Column) GetQualifier() []byte {
	if m != nil {
		return m.Qualifier
	}
	return nil
}

func (m *Column) GetCells() []*Cell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// Specifies (some of) the contents of a single row/column/timestamp of a table.
type Cell struct {
	// The cell's stored timestamp, which also uniquely identifies it within
	// its column.
	// Values are always expressed in microseconds, but individual tables may set
	// a coarser granularity to further restrict the allowed values. For
	// example, a table which specifies millisecond granularity will only allow
	// values of `timestamp_micros` which are multiples of 1000.
	TimestampMicros int64 `protobuf:"varint,1,opt,name=timestamp_micros,json=timestampMicros,proto3" json:"timestamp_micros,omitempty"`
	// The value stored in the cell.
	// May contain any byte string, including the empty string, up to 100MiB in
	// length.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Labels applied to the cell by a [RowFilter][google.bigtable.v2.RowFilter].
	Labels               []string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cell) Reset()         { *m = Cell{} }
func (m *Cell) String() string { return proto.CompactTextString(m) }
func (*Cell) ProtoMessage()    {}
func (*Cell) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{3}
}

func (m *Cell) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cell.Unmarshal(m, b)
}
func (m *Cell) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cell.Marshal(b, m, deterministic)
}
func (m *Cell) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cell.Merge(m, src)
}
func (m *Cell) XXX_Size() int {
	return xxx_messageInfo_Cell.Size(m)
}
func (m *Cell) XXX_DiscardUnknown() {
	xxx_messageInfo_Cell.DiscardUnknown(m)
}

var xxx_messageInfo_Cell proto.InternalMessageInfo

func (m *Cell) GetTimestampMicros() int64 {
	if m != nil {
		return m.TimestampMicros
	}
	return 0
}

func (m *Cell) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Cell) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Specifies a contiguous range of rows.
type RowRange struct {
	// The row key at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartKey:
	//	*RowRange_StartKeyClosed
	//	*RowRange_StartKeyOpen
	StartKey isRowRange_StartKey `protobuf_oneof:"start_key"`
	// The row key at which to end the range.
	// If neither field is set, interpreted as the infinite row key, exclusive.
	//
	// Types that are valid to be assigned to EndKey:
	//	*RowRange_EndKeyOpen
	//	*RowRange_EndKeyClosed
	EndKey               isRowRange_EndKey `protobuf_oneof:"end_key"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RowRange) Reset()         { *m = RowRange{} }
func (m *RowRange) String() string { return proto.CompactTextString(m) }
func (*RowRange) ProtoMessage()    {}
func (*RowRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{4}
}

func (m *RowRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowRange.Unmarshal(m, b)
}
func (m *RowRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowRange.Marshal(b, m, deterministic)
}
func (m *RowRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowRange.Merge(m, src)
}
func (m *RowRange) XXX_Size() int {
	return xxx_messageInfo_RowRange.Size(m)
}
func (m *RowRange) XXX_DiscardUnknown() {
	xxx_messageInfo_RowRange.DiscardUnknown(m)
}

var xxx_messageInfo_RowRange proto.InternalMessageInfo

type isRowRange_StartKey interface {
	isRowRange_StartKey()
}

type RowRange_StartKeyClosed struct {
	StartKeyClosed []byte `protobuf:"bytes,1,opt,name=start_key_closed,json=startKeyClosed,proto3,oneof"`
}

type RowRange_StartKeyOpen struct {
	StartKeyOpen []byte `protobuf:"bytes,2,opt,name=start_key_open,json=startKeyOpen,proto3,oneof"`
}

func (*RowRange_StartKeyClosed) isRowRange_StartKey() {}

func (*RowRange_StartKeyOpen) isRowRange_StartKey() {}

func (m *RowRange) GetStartKey() isRowRange_StartKey {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RowRange) GetStartKeyClosed() []byte {
	if x, ok := m.GetStartKey().(*RowRange_StartKeyClosed); ok {
		return x.StartKeyClosed
	}
	return nil
}

func (m *RowRange) GetStartKeyOpen() []byte {
	if x, ok := m.GetStartKey().(*RowRange_StartKeyOpen); ok {
		return x.StartKeyOpen
	}
	return nil
}

type isRowRange_EndKey interface {
	isRowRange_EndKey()
}

type RowRange_EndKeyOpen struct {
	EndKeyOpen []byte `protobuf:"bytes,3,opt,name=end_key_open,json=endKeyOpen,proto3,oneof"`
}

type RowRange_EndKeyClosed struct {
	EndKeyClosed []byte `protobuf:"bytes,4,opt,name=end_key_closed,json=endKeyClosed,proto3,oneof"`
}

func (*RowRange_EndKeyOpen) isRowRange_EndKey() {}

func (*RowRange_EndKeyClosed) isRowRange_EndKey() {}

func (m *RowRange) GetEndKey() isRowRange_EndKey {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RowRange) GetEndKeyOpen() []byte {
	if x, ok := m.GetEndKey().(*RowRange_EndKeyOpen); ok {
		return x.EndKeyOpen
	}
	return nil
}

func (m *RowRange) GetEndKeyClosed() []byte {
	if x, ok := m.GetEndKey().(*RowRange_EndKeyClosed); ok {
		return x.EndKeyClosed
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RowRange) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RowRange_StartKeyClosed)(nil),
		(*RowRange_StartKeyOpen)(nil),
		(*RowRange_EndKeyOpen)(nil),
		(*RowRange_EndKeyClosed)(nil),
	}
}

// Specifies a non-contiguous set of rows.
type RowSet struct {
	// Single rows included in the set.
	RowKeys [][]byte `protobuf:"bytes,1,rep,name=row_keys,json=rowKeys,proto3" json:"row_keys,omitempty"`
	// Contiguous row ranges included in the set.
	RowRanges            []*RowRange `protobuf:"bytes,2,rep,name=row_ranges,json=rowRanges,proto3" json:"row_ranges,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RowSet) Reset()         { *m = RowSet{} }
func (m *RowSet) String() string { return proto.CompactTextString(m) }
func (*RowSet) ProtoMessage()    {}
func (*RowSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{5}
}

func (m *RowSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowSet.Unmarshal(m, b)
}
func (m *RowSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowSet.Marshal(b, m, deterministic)
}
func (m *RowSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowSet.Merge(m, src)
}
func (m *RowSet) XXX_Size() int {
	return xxx_messageInfo_RowSet.Size(m)
}
func (m *RowSet) XXX_DiscardUnknown() {
	xxx_messageInfo_RowSet.DiscardUnknown(m)
}

var xxx_messageInfo_RowSet proto.InternalMessageInfo

func (m *RowSet) GetRowKeys() [][]byte {
	if m != nil {
		return m.RowKeys
	}
	return nil
}

func (m *RowSet) GetRowRanges() []*RowRange {
	if m != nil {
		return m.RowRanges
	}
	return nil
}

// Specifies a contiguous range of columns within a single column family.
// The range spans from &lt;column_family&gt;:&lt;start_qualifier&gt; to
// &lt;column_family&gt;:&lt;end_qualifier&gt;, where both bounds can be either
// inclusive or exclusive.
type ColumnRange struct {
	// The name of the column family within which this range falls.
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The column qualifier at which to start the range (within `column_family`).
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartQualifier:
	//	*ColumnRange_StartQualifierClosed
	//	*ColumnRange_StartQualifierOpen
	StartQualifier isColumnRange_StartQualifier `protobuf_oneof:"start_qualifier"`
	// The column qualifier at which to end the range (within `column_family`).
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndQualifier:
	//	*ColumnRange_EndQualifierClosed
	//	*ColumnRange_EndQualifierOpen
	EndQualifier         isColumnRange_EndQualifier `protobuf_oneof:"end_qualifier"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ColumnRange) Reset()         { *m = ColumnRange{} }
func (m *ColumnRange) String() string { return proto.CompactTextString(m) }
func (*ColumnRange) ProtoMessage()    {}
func (*ColumnRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{6}
}

func (m *ColumnRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ColumnRange.Unmarshal(m, b)
}
func (m *ColumnRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ColumnRange.Marshal(b, m, deterministic)
}
func (m *ColumnRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ColumnRange.Merge(m, src)
}
func (m *ColumnRange) XXX_Size() int {
	return xxx_messageInfo_ColumnRange.Size(m)
}
func (m *ColumnRange) XXX_DiscardUnknown() {
	xxx_messageInfo_ColumnRange.DiscardUnknown(m)
}

var xxx_messageInfo_ColumnRange proto.InternalMessageInfo

func (m *ColumnRange) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

type isColumnRange_StartQualifier interface {
	isColumnRange_StartQualifier()
}

type ColumnRange_StartQualifierClosed struct {
	StartQualifierClosed []byte `protobuf:"bytes,2,opt,name=start_qualifier_closed,json=startQualifierClosed,proto3,oneof"`
}

type ColumnRange_StartQualifierOpen struct {
	StartQualifierOpen []byte `protobuf:"bytes,3,opt,name=start_qualifier_open,json=startQualifierOpen,proto3,oneof"`
}

func (*ColumnRange_StartQualifierClosed) isColumnRange_StartQualifier() {}

func (*ColumnRange_StartQualifierOpen) isColumnRange_StartQualifier() {}

func (m *ColumnRange) GetStartQualifier() isColumnRange_StartQualifier {
	if m != nil {
		return m.StartQualifier
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierClosed() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierClosed); ok {
		return x.StartQualifierClosed
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierOpen() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierOpen); ok {
		return x.StartQualifierOpen
	}
	return nil
}

type isColumnRange_EndQualifier interface {
	isColumnRange_EndQualifier()
}

type ColumnRange_EndQualifierClosed struct {
	EndQualifierClosed []byte `protobuf:"bytes,4,opt,name=end_qualifier_closed,json=endQualifierClosed,proto3,oneof"`
}

type ColumnRange_EndQualifierOpen struct {
	EndQualifierOpen []byte `protobuf:"bytes,5,opt,name=end_qualifier_open,json=endQualifierOpen,proto3,oneof"`
}

func (*ColumnRange_EndQualifierClosed) isColumnRange_EndQualifier() {}

func (*ColumnRange_EndQualifierOpen) isColumnRange_EndQualifier() {}

func (m *ColumnRange) GetEndQualifier() isColumnRange_EndQualifier {
	if m != nil {
		return m.EndQualifier
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierClosed() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierClosed); ok {
		return x.EndQualifierClosed
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierOpen() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierOpen); ok {
		return x.EndQualifierOpen
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ColumnRange) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ColumnRange_StartQualifierClosed)(nil),
		(*ColumnRange_StartQualifierOpen)(nil),
		(*ColumnRange_EndQualifierClosed)(nil),
		(*ColumnRange_EndQualifierOpen)(nil),
	}
}

// Specified a contiguous range of microsecond timestamps.
type TimestampRange struct {
	// Inclusive lower bound. If left empty, interpreted as 0.
	StartTimestampMicros int64 `protobuf:"varint,1,opt,name=start_timestamp_micros,json=startTimestampMicros,proto3" json:"start_timestamp_micros,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndTimestampMicros   int64    `protobuf:"varint,2,opt,name=end_timestamp_micros,json=endTimestampMicros,proto3" json:"end_timestamp_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimestampRange) Reset()         { *m = TimestampRange{} }
func (m *TimestampRange) String() string { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()    {}
func (*TimestampRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{7}
}

func (m *TimestampRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampRange.Unmarshal(m, b)
}
func (m *TimestampRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampRange.Marshal(b, m, deterministic)
}
func (m *TimestampRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampRange.Merge(m, src)
}
func (m *TimestampRange) XXX_Size() int {
	return xxx_messageInfo_TimestampRange.Size(m)
}
func (m *TimestampRange) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampRange.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampRange proto.InternalMessageInfo

func (m *TimestampRange) GetStartTimestampMicros() int64 {
	if m != nil {
		return m.StartTimestampMicros
	}
	return 0
}

func (m *TimestampRange) GetEndTimestampMicros() int64 {
	if m != nil {
		return m.EndTimestampMicros
	}
	return 0
}

// Specifies a contiguous range of raw byte values.
type ValueRange struct {
	// The value at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartValue:
	//	*ValueRange_StartValueClosed
	//	*ValueRange_StartValueOpen
	StartValue isValueRange_StartValue `protobuf_oneof:"start_value"`
	// The value at which to end the range.
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndValue:
	//	*ValueRange_EndValueClosed
	//	*ValueRange_EndValueOpen
	EndValue             isValueRange_EndValue `protobuf_oneof:"end_value"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ValueRange) Reset()         { *m = ValueRange{} }
func (m *ValueRange) String() string { return proto.CompactTextString(m) }
func (*ValueRange) ProtoMessage()    {}
func (*ValueRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{8}
}

func (m *ValueRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueRange.Unmarshal(m, b)
}
func (m *ValueRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueRange.Marshal(b, m, deterministic)
}
func (m *ValueRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueRange.Merge(m, src)
}
func (m *ValueRange) XXX_Size() int {
	return xxx_messageInfo_ValueRange.Size(m)
}
func (m *ValueRange) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueRange.DiscardUnknown(m)
}

var xxx_messageInfo_ValueRange proto.InternalMessageInfo

type isValueRange_StartValue interface {
	isValueRange_StartValue()
}

type ValueRange_StartValueClosed struct {
	StartValueClosed []byte `protobuf:"bytes,1,opt,name=start_value_closed,json=startValueClosed,proto3,oneof"`
}

type ValueRange_StartValueOpen struct {
	StartValueOpen []byte `protobuf:"bytes,2,opt,name=start_value_open,json=startValueOpen,proto3,oneof"`
}

func (*ValueRange_StartValueClosed) isValueRange_StartValue() {}

func (*ValueRange_StartValueOpen) isValueRange_StartValue() {}

func (m *ValueRange) GetStartValue() isValueRange_StartValue {
	if m != nil {
		return m.StartValue
	}
	return nil
}

func (m *ValueRange) GetStartValueClosed() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueClosed); ok {
		return x.StartValueClosed
	}
	return nil
}

func (m *ValueRange) GetStartValueOpen() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueOpen); ok {
		return x.StartValueOpen
	}
	return nil
}

type isValueRange_EndValue interface {
	isValueRange_EndValue()
}

type ValueRange_EndValueClosed struct {
	EndValueClosed []byte `protobuf:"bytes,3,opt,name=end_value_closed,json=endValueClosed,proto3,oneof"`
}

type ValueRange_EndValueOpen struct {
	EndValueOpen []byte `protobuf:"bytes,4,opt,name=end_value_open,json=endValueOpen,proto3,oneof"`
}

func (*ValueRange_EndValueClosed) isValueRange_EndValue() {}

func (*ValueRange_EndValueOpen) isValueRange_EndValue() {}

func (m *ValueRange) GetEndValue() isValueRange_EndValue {
	if m != nil {
		return m.EndValue
	}
	return nil
}

func (m *ValueRange) GetEndValueClosed() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueClosed); ok {
		return x.EndValueClosed
	}
	return nil
}

func (m *ValueRange) GetEndValueOpen() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueOpen); ok {
		return x.EndValueOpen
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueRange) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueRange_StartValueClosed)(nil),
		(*ValueRange_StartValueOpen)(nil),
		(*ValueRange_EndValueClosed)(nil),
		(*ValueRange_EndValueOpen)(nil),
	}
}

// Takes a row as input and produces an alternate view of the row based on
// specified rules. For example, a RowFilter might trim down a row to include
// just the cells from columns matching a given regular expression, or might
// return all the cells of a row but not their values. More complicated filters
// can be composed out of these components to express requests such as, "within
// every column of a particular family, give just the two most recent cells
// which are older than timestamp X."
//
// There are two broad categories of RowFilters (true filters and transformers),
// as well as two ways to compose simple filters into more complex ones
// (chains and interleaves). They work as follows:
//
// * True filters alter the input row by excluding some of its cells wholesale
// from the output row. An example of a true filter is the `value_regex_filter`,
// which excludes cells whose values don't match the specified pattern. All
// regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
// in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
// important point to keep in mind is that `RE2(.)` is equivalent by default to
// `RE2([^\n])`, meaning that it does not match newlines. When attempting to
// match an arbitrary byte, you should therefore use the escape sequence `\C`,
// which may need to be further escaped as `\\C` in your client language.
//
// * Transformers alter the input row by changing the values of some of its
// cells in the output, without excluding them completely. Currently, the only
// supported transformer is the `strip_value_transformer`, which replaces every
// cell's value with the empty string.
//
// * Chains and interleaves are described in more detail in the
// RowFilter.Chain and RowFilter.Interleave documentation.
//
// The total serialized size of a RowFilter message must not
// exceed 4096 bytes, and RowFilters may not be nested within each other
// (in Chains or Interleaves) to a depth of more than 20.
type RowFilter struct {
	// Which of the possible RowFilter types to apply. If none are set, this
	// RowFilter returns all cells in the input row.
	//
	// Types that are valid to be assigned to Filter:
	//	*RowFilter_Chain_
	//	*RowFilter_Interleave_
	//	*RowFilter_Condition_
	//	*RowFilter_Sink
	//	*RowFilter_PassAllFilter
	//	*RowFilter_BlockAllFilter
	//	*RowFilter_RowKeyRegexFilter
	//	*RowFilter_RowSampleFilter
	//	*RowFilter_FamilyNameRegexFilter
	//	*RowFilter_ColumnQualifierRegexFilter
	//	*RowFilter_ColumnRangeFilter
	//	*RowFilter_TimestampRangeFilter
	//	*RowFilter_ValueRegexFilter
	//	*RowFilter_ValueRangeFilter
	//	*RowFilter_CellsPerRowOffsetFilter
	//	*RowFilter_CellsPerRowLimitFilter
	//	*RowFilter_CellsPerColumnLimitFilter
	//	*RowFilter_StripValueTransformer
	//	*RowFilter_ApplyLabelTransformer
	Filter               isRowFilter_Filter `protobuf_oneof:"filter"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *RowFilter) Reset()         { *m = RowFilter{} }
func (m *RowFilter) String() string { return proto.CompactTextString(m) }
func (*RowFilter) ProtoMessage()    {}
func (*RowFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{9}
}

func (m *RowFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowFilter.Unmarshal(m, b)
}
func (m *RowFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowFilter.Marshal(b, m, deterministic)
}
func (m *RowFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowFilter.Merge(m, src)
}
func (m *RowFilter) XXX_Size() int {
	return xxx_messageInfo_RowFilter.Size(m)
}
func (m *RowFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_RowFilter.DiscardUnknown(m)
}

var xxx_messageInfo_RowFilter proto.InternalMessageInfo

type isRowFilter_Filter interface {
	isRowFilter_Filter()
}

type RowFilter_Chain_ struct {
	Chain *RowFilter_Chain `protobuf:"bytes,1,opt,name=chain,proto3,oneof"`
}

type RowFilter_Interleave_ struct {
	Interleave *RowFilter_Interleave `protobuf:"bytes,2,opt,name=interleave,proto3,oneof"`
}

type RowFilter_Condition_ struct {
	Condition *RowFilter_Condition `protobuf:"bytes,3,opt,name=condition,proto3,oneof"`
}

type RowFilter_Sink struct {
	Sink bool `protobuf:"varint,16,opt,name=sink,proto3,oneof"`
}

type RowFilter_PassAllFilter struct {
	PassAllFilter bool `protobuf:"varint,17,opt,name=pass_all_filter,json=passAllFilter,proto3,oneof"`
}

type RowFilter_BlockAllFilter struct {
	BlockAllFilter bool `protobuf:"varint,18,opt,name=block_all_filter,json=blockAllFilter,proto3,oneof"`
}

type RowFilter_RowKeyRegexFilter struct {
	RowKeyRegexFilter []byte `protobuf:"bytes,4,opt,name=row_key_regex_filter,json=rowKeyRegexFilter,proto3,oneof"`
}

type RowFilter_RowSampleFilter struct {
	RowSampleFilter float64 `protobuf:"fixed64,14,opt,name=row_sample_filter,json=rowSampleFilter,proto3,oneof"`
}

type RowFilter_FamilyNameRegexFilter struct {
	FamilyNameRegexFilter string `protobuf:"bytes,5,opt,name=family_name_regex_filter,json=familyNameRegexFilter,proto3,oneof"`
}

type RowFilter_ColumnQualifierRegexFilter struct {
	ColumnQualifierRegexFilter []byte `protobuf:"bytes,6,opt,name=column_qualifier_regex_filter,json=columnQualifierRegexFilter,proto3,oneof"`
}

type RowFilter_ColumnRangeFilter struct {
	ColumnRangeFilter *ColumnRange `protobuf:"bytes,7,opt,name=column_range_filter,json=columnRangeFilter,proto3,oneof"`
}

type RowFilter_TimestampRangeFilter struct {
	TimestampRangeFilter *TimestampRange `protobuf:"bytes,8,opt,name=timestamp_range_filter,json=timestampRangeFilter,proto3,oneof"`
}

type RowFilter_ValueRegexFilter struct {
	ValueRegexFilter []byte `protobuf:"bytes,9,opt,name=value_regex_filter,json=valueRegexFilter,proto3,oneof"`
}

type RowFilter_ValueRangeFilter struct {
	ValueRangeFilter *ValueRange `protobuf:"bytes,15,opt,name=value_range_filter,json=valueRangeFilter,proto3,oneof"`
}

type RowFilter_CellsPerRowOffsetFilter struct {
	CellsPerRowOffsetFilter int32 `protobuf:"varint,10,opt,name=cells_per_row_offset_filter,json=cellsPerRowOffsetFilter,proto3,oneof"`
}

type RowFilter_CellsPerRowLimitFilter struct {
	CellsPerRowLimitFilter int32 `protobuf:"varint,11,opt,name=cells_per_row_limit_filter,json=cellsPerRowLimitFilter,proto3,oneof"`
}

type RowFilter_CellsPerColumnLimitFilter struct {
	CellsPerColumnLimitFilter int32 `protobuf:"varint,12,opt,name=cells_per_column_limit_filter,json=cellsPerColumnLimitFilter,proto3,oneof"`
}

type RowFilter_StripValueTransformer struct {
	StripValueTransformer bool `protobuf:"varint,13,opt,name=strip_value_transformer,json=stripValueTransformer,proto3,oneof"`
}

type RowFilter_ApplyLabelTransformer struct {
	ApplyLabelTransformer string `protobuf:"bytes,19,opt,name=apply_label_transformer,json=applyLabelTransformer,proto3,oneof"`
}

func (*RowFilter_Chain_) isRowFilter_Filter() {}

func (*RowFilter_Interleave_) isRowFilter_Filter() {}

func (*RowFilter_Condition_) isRowFilter_Filter() {}

func (*RowFilter_Sink) isRowFilter_Filter() {}

func (*RowFilter_PassAllFilter) isRowFilter_Filter() {}

func (*RowFilter_BlockAllFilter) isRowFilter_Filter() {}

func (*RowFilter_RowKeyRegexFilter) isRowFilter_Filter() {}

func (*RowFilter_RowSampleFilter) isRowFilter_Filter() {}

func (*RowFilter_FamilyNameRegexFilter) isRowFilter_Filter() {}

func (*RowFilter_ColumnQualifierRegexFilter) isRowFilter_Filter() {}

func (*RowFilter_ColumnRangeFilter) isRowFilter_Filter() {}

func (*RowFilter_TimestampRangeFilter) isRowFilter_Filter() {}

func (*RowFilter_ValueRegexFilter) isRowFilter_Filter() {}

func (*RowFilter_ValueRangeFilter) isRowFilter_Filter() {}

func (*RowFilter_CellsPerRowOffsetFilter) isRowFilter_Filter() {}

func (*RowFilter_CellsPerRowLimitFilter) isRowFilter_Filter() {}

func (*RowFilter_CellsPerColumnLimitFilter) isRowFilter_Filter() {}

func (*RowFilter_StripValueTransformer) isRowFilter_Filter() {}

func (*RowFilter_ApplyLabelTransformer) isRowFilter_Filter() {}

func (m *RowFilter) GetFilter() isRowFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *RowFilter) GetChain() *RowFilter_Chain {
	if x, ok := m.GetFilter().(*RowFilter_Chain_); ok {
		return x.Chain
	}
	return nil
}

func (m *RowFilter) GetInterleave() *RowFilter_Interleave {
	if x, ok := m.GetFilter().(*RowFilter_Interleave_); ok {
		return x.Interleave
	}
	return nil
}

func (m *RowFilter) GetCondition() *RowFilter_Condition {
	if x, ok := m.GetFilter().(*RowFilter_Condition_); ok {
		return x.Condition
	}
	return nil
}

func (m *RowFilter) GetSink() bool {
	if x, ok := m.GetFilter().(*RowFilter_Sink); ok {
		return x.Sink
	}
	return false
}

func (m *RowFilter) GetPassAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_PassAllFilter); ok {
		return x.PassAllFilter
	}
	return false
}

func (m *RowFilter) GetBlockAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_BlockAllFilter); ok {
		return x.BlockAllFilter
	}
	return false
}

func (m *RowFilter) GetRowKeyRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_RowKeyRegexFilter); ok {
		return x.RowKeyRegexFilter
	}
	return nil
}

func (m *RowFilter) GetRowSampleFilter() float64 {
	if x, ok := m.GetFilter().(*RowFilter_RowSampleFilter); ok {
		return x.RowSampleFilter
	}
	return 0
}

func (m *RowFilter) GetFamilyNameRegexFilter() string {
	if x, ok := m.GetFilter().(*RowFilter_FamilyNameRegexFilter); ok {
		return x.FamilyNameRegexFilter
	}
	return ""
}

func (m *RowFilter) GetColumnQualifierRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ColumnQualifierRegexFilter); ok {
		return x.ColumnQualifierRegexFilter
	}
	return nil
}

func (m *RowFilter) GetColumnRangeFilter() *ColumnRange {
	if x, ok := m.GetFilter().(*RowFilter_ColumnRangeFilter); ok {
		return x.ColumnRangeFilter
	}
	return nil
}

func (m *RowFilter) GetTimestampRangeFilter() *TimestampRange {
	if x, ok := m.GetFilter().(*RowFilter_TimestampRangeFilter); ok {
		return x.TimestampRangeFilter
	}
	return nil
}

func (m *RowFilter) GetValueRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ValueRegexFilter); ok {
		return x.ValueRegexFilter
	}
	return nil
}

func (m *RowFilter) GetValueRangeFilter() *ValueRange {
	if x, ok := m.GetFilter().(*RowFilter_ValueRangeFilter); ok {
		return x.ValueRangeFilter
	}
	return nil
}

func (m *RowFilter) GetCellsPerRowOffsetFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowOffsetFilter); ok {
		return x.CellsPerRowOffsetFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerRowLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowLimitFilter); ok {
		return x.CellsPerRowLimitFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerColumnLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerColumnLimitFilter); ok {
		return x.CellsPerColumnLimitFilter
	}
	return 0
}

func (m *RowFilter) GetStripValueTransformer() bool {
	if x, ok := m.GetFilter().(*RowFilter_StripValueTransformer); ok {
		return x.StripValueTransformer
	}
	return false
}

func (m *RowFilter) GetApplyLabelTransformer() string {
	if x, ok := m.GetFilter().(*RowFilter_ApplyLabelTransformer); ok {
		return x.ApplyLabelTransformer
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RowFilter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RowFilter_Chain_)(nil),
		(*RowFilter_Interleave_)(nil),
		(*RowFilter_Condition_)(nil),
		(*RowFilter_Sink)(nil),
		(*RowFilter_PassAllFilter)(nil),
		(*RowFilter_BlockAllFilter)(nil),
		(*RowFilter_RowKeyRegexFilter)(nil),
		(*RowFilter_RowSampleFilter)(nil),
		(*RowFilter_FamilyNameRegexFilter)(nil),
		(*RowFilter_ColumnQualifierRegexFilter)(nil),
		(*RowFilter_ColumnRangeFilter)(nil),
		(*RowFilter_TimestampRangeFilter)(nil),
		(*RowFilter_ValueRegexFilter)(nil),
		(*RowFilter_ValueRangeFilter)(nil),
		(*RowFilter_CellsPerRowOffsetFilter)(nil),
		(*RowFilter_CellsPerRowLimitFilter)(nil),
		(*RowFilter_CellsPerColumnLimitFilter)(nil),
		(*RowFilter_StripValueTransformer)(nil),
		(*RowFilter_ApplyLabelTransformer)(nil),
	}
}

// A RowFilter which sends rows through several RowFilters in sequence.
type RowFilter_Chain struct {
	// The elements of "filters" are chained together to process the input row:
	// in row -> f(0) -> intermediate row -> f(1) -> ... -> f(N) -> out row
	// The full chain is executed atomically.
	Filters              []*RowFilter `protobuf:"bytes,1,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *RowFilter_Chain) Reset()         { *m = RowFilter_Chain{} }
func (m *RowFilter_Chain) String() string { return proto.CompactTextString(m) }
func (*RowFilter_Chain) ProtoMessage()    {}
func (*RowFilter_Chain) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{9, 0}
}

func (m *RowFilter_Chain) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowFilter_Chain.Unmarshal(m, b)
}
func (m *RowFilter_Chain) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowFilter_Chain.Marshal(b, m, deterministic)
}
func (m *RowFilter_Chain) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowFilter_Chain.Merge(m, src)
}
func (m *RowFilter_Chain) XXX_Size() int {
	return xxx_messageInfo_RowFilter_Chain.Size(m)
}
func (m *RowFilter_Chain) XXX_DiscardUnknown() {
	xxx_messageInfo_RowFilter_Chain.DiscardUnknown(m)
}

var xxx_messageInfo_RowFilter_Chain proto.InternalMessageInfo

func (m *RowFilter_Chain) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which sends each row to each of several component
// RowFilters and interleaves the results.
type RowFilter_Interleave struct {
	// The elements of "filters" all process a copy of the input row, and the
	// results are pooled, sorted, and combined into a single output row.
	// If multiple cells are produced with the same column and timestamp,
	// they will all appear in the output row in an unspecified mutual order.
	// Consider the following example, with three filters:
	//
	//                                  input row
	//                                      |
	//            -----------------------------------------------------
	//            |                         |                         |
	//           f(0)                      f(1)                      f(2)
	//            |                         |                         |
	//     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
	//     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
	//            |                         |                         |
	//            -----------------------------------------------------
	//                                      |
	//     1:                      foo,bar,10,z   // could have switched with #2
	//     2:                      foo,bar,10,x   // could have switched with #1
	//     3:                      foo,blah,11,z
	//     4:                      far,bar,7,a
	//     5:                      far,blah,5,x   // identical to #6
	//     6:                      far,blah,5,x   // identical to #5
	//
	// All interleaved filters are executed atomically.
	Filters              []*RowFilter `protobuf:"bytes,1,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *RowFilter_Interleave) Reset()         { *m = RowFilter_Interleave{} }
func (m *RowFilter_Interleave) String() string { return proto.CompactTextString(m) }
func (*RowFilter_Interleave) ProtoMessage()    {}
func (*RowFilter_Interleave) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{9, 1}
}

func (m *RowFilter_Interleave) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowFilter_Interleave.Unmarshal(m, b)
}
func (m *RowFilter_Interleave) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowFilter_Interleave.Marshal(b, m, deterministic)
}
func (m *RowFilter_Interleave) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowFilter_Interleave.Merge(m, src)
}
func (m *RowFilter_Interleave) XXX_Size() int {
	return xxx_messageInfo_RowFilter_Interleave.Size(m)
}
func (m *RowFilter_Interleave) XXX_DiscardUnknown() {
	xxx_messageInfo_RowFilter_Interleave.DiscardUnknown(m)
}

var xxx_messageInfo_RowFilter_Interleave proto.InternalMessageInfo

func (m *RowFilter_Interleave) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which evaluates one of two possible RowFilters, depending on
// whether or not a predicate RowFilter outputs any cells from the input row.
//
// IMPORTANT NOTE: The predicate filter does not execute atomically with the
// true and false filters, which may lead to inconsistent or unexpected
// results. Additionally, Condition filters have poor performance, especially
// when filters are set for the false condition.
type RowFilter_Condition struct {
	// If `predicate_filter` outputs any cells, then `true_filter` will be
	// evaluated on the input row. Otherwise, `false_filter` will be evaluated.
	PredicateFilter *RowFilter `protobuf:"bytes,1,opt,name=predicate_filter,json=predicateFilter,proto3" json:"predicate_filter,omitempty"`
	// The filter to apply to the input row if `predicate_filter` returns any
	// results. If not provided, no results will be returned in the true case.
	TrueFilter *RowFilter `protobuf:"bytes,2,opt,name=true_filter,json=trueFilter,proto3" json:"true_filter,omitempty"`
	// The filter to apply to the input row if `predicate_filter` does not
	// return any results. If not provided, no results will be returned in the
	// false case.
	FalseFilter          *RowFilter `protobuf:"bytes,3,opt,name=false_filter,json=falseFilter,proto3" json:"false_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RowFilter_Condition) Reset()         { *m = RowFilter_Condition{} }
func (m *RowFilter_Condition) String() string { return proto.CompactTextString(m) }
func (*RowFilter_Condition) ProtoMessage()    {}
func (*RowFilter_Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{9, 2}
}

func (m *RowFilter_Condition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowFilter_Condition.Unmarshal(m, b)
}
func (m *RowFilter_Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowFilter_Condition.Marshal(b, m, deterministic)
}
func (m *RowFilter_Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowFilter_Condition.Merge(m, src)
}
func (m *RowFilter_Condition) XXX_Size() int {
	return xxx_messageInfo_RowFilter_Condition.Size(m)
}
func (m *RowFilter_Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_RowFilter_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_RowFilter_Condition proto.InternalMessageInfo

func (m *RowFilter_Condition) GetPredicateFilter() *RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetTrueFilter() *RowFilter {
	if m != nil {
		return m.TrueFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetFalseFilter() *RowFilter {
	if m != nil {
		return m.FalseFilter
	}
	return nil
}

// Specifies a particular change to be made to the contents of a row.
type Mutation struct {
	// Which of the possible Mutation types to apply.
	//
	// Types that are valid to be assigned to Mutation:
	//	*Mutation_SetCell_
	//	*Mutation_DeleteFromColumn_
	//	*Mutation_DeleteFromFamily_
	//	*Mutation_DeleteFromRow_
	Mutation             isMutation_Mutation `protobuf_oneof:"mutation"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Mutation) Reset()         { *m = Mutation{} }
func (m *Mutation) String() string { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()    {}
func (*Mutation) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{10}
}

func (m *Mutation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation.Unmarshal(m, b)
}
func (m *Mutation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation.Marshal(b, m, deterministic)
}
func (m *Mutation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation.Merge(m, src)
}
func (m *Mutation) XXX_Size() int {
	return xxx_messageInfo_Mutation.Size(m)
}
func (m *Mutation) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation proto.InternalMessageInfo

type isMutation_Mutation interface {
	isMutation_Mutation()
}

type Mutation_SetCell_ struct {
	SetCell *Mutation_SetCell `protobuf:"bytes,1,opt,name=set_cell,json=setCell,proto3,oneof"`
}

type Mutation_DeleteFromColumn_ struct {
	DeleteFromColumn *Mutation_DeleteFromColumn `protobuf:"bytes,2,opt,name=delete_from_column,json=deleteFromColumn,proto3,oneof"`
}

type Mutation_DeleteFromFamily_ struct {
	DeleteFromFamily *Mutation_DeleteFromFamily `protobuf:"bytes,3,opt,name=delete_from_family,json=deleteFromFamily,proto3,oneof"`
}

type Mutation_DeleteFromRow_ struct {
	DeleteFromRow *Mutation_DeleteFromRow `protobuf:"bytes,4,opt,name=delete_from_row,json=deleteFromRow,proto3,oneof"`
}

func (*Mutation_SetCell_) isMutation_Mutation() {}

func (*Mutation_DeleteFromColumn_) isMutation_Mutation() {}

func (*Mutation_DeleteFromFamily_) isMutation_Mutation() {}

func (*Mutation_DeleteFromRow_) isMutation_Mutation() {}

func (m *Mutation) GetMutation() isMutation_Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

func (m *Mutation) GetSetCell() *Mutation_SetCell {
	if x, ok := m.GetMutation().(*Mutation_SetCell_); ok {
		return x.SetCell
	}
	return nil
}

func (m *Mutation) GetDeleteFromColumn() *Mutation_DeleteFromColumn {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromColumn_); ok {
		return x.DeleteFromColumn
	}
	return nil
}

func (m *Mutation) GetDeleteFromFamily() *Mutation_DeleteFromFamily {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromFamily_); ok {
		return x.DeleteFromFamily
	}
	return nil
}

func (m *Mutation) GetDeleteFromRow() *Mutation_DeleteFromRow {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromRow_); ok {
		return x.DeleteFromRow
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Mutation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Mutation_SetCell_)(nil),
		(*Mutation_DeleteFromColumn_)(nil),
		(*Mutation_DeleteFromFamily_)(nil),
		(*Mutation_DeleteFromRow_)(nil),
	}
}

// A Mutation which sets the value of the specified cell.
type Mutation_SetCell struct {
	// The name of the family into which new data should be written.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The qualifier of the column into which new data should be written.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The timestamp of the cell into which new data should be written.
	// Use -1 for current Bigtable server time.
	// Otherwise, the client should set this value itself, noting that the
	// default value is a timestamp of zero if the field is left unspecified.
	// Values must match the granularity of the table (e.g. micros, millis).
	TimestampMicros int64 `protobuf:"varint,3,opt,name=timestamp_micros,json=timestampMicros,proto3" json:"timestamp_micros,omitempty"`
	// The value to be written into the specified cell.
	Value                []byte   `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mutation_SetCell) Reset()         { *m = Mutation_SetCell{} }
func (m *Mutation_SetCell) String() string { return proto.CompactTextString(m) }
func (*Mutation_SetCell) ProtoMessage()    {}
func (*Mutation_SetCell) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{10, 0}
}

func (m *Mutation_SetCell) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation_SetCell.Unmarshal(m, b)
}
func (m *Mutation_SetCell) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation_SetCell.Marshal(b, m, deterministic)
}
func (m *Mutation_SetCell) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation_SetCell.Merge(m, src)
}
func (m *Mutation_SetCell) XXX_Size() int {
	return xxx_messageInfo_Mutation_SetCell.Size(m)
}
func (m *Mutation_SetCell) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation_SetCell.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation_SetCell proto.InternalMessageInfo

func (m *Mutation_SetCell) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *Mutation_SetCell) GetColumnQualifier() []byte {
	if m != nil {
		return m.ColumnQualifier
	}
	return nil
}

func (m *Mutation_SetCell) GetTimestampMicros() int64 {
	if m != nil {
		return m.TimestampMicros
	}
	return 0
}

func (m *Mutation_SetCell) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// A Mutation which deletes cells from the specified column, optionally
// restricting the deletions to a given timestamp range.
type Mutation_DeleteFromColumn struct {
	// The name of the family from which cells should be deleted.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The qualifier of the column from which cells should be deleted.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The range of timestamps within which cells should be deleted.
	TimeRange            *TimestampRange `protobuf:"bytes,3,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Mutation_DeleteFromColumn) Reset()         { *m = Mutation_DeleteFromColumn{} }
func (m *Mutation_DeleteFromColumn) String() string { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromColumn) ProtoMessage()    {}
func (*Mutation_DeleteFromColumn) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{10, 1}
}

func (m *Mutation_DeleteFromColumn) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation_DeleteFromColumn.Unmarshal(m, b)
}
func (m *Mutation_DeleteFromColumn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation_DeleteFromColumn.Marshal(b, m, deterministic)
}
func (m *Mutation_DeleteFromColumn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation_DeleteFromColumn.Merge(m, src)
}
func (m *Mutation_DeleteFromColumn) XXX_Size() int {
	return xxx_messageInfo_Mutation_DeleteFromColumn.Size(m)
}
func (m *Mutation_DeleteFromColumn) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation_DeleteFromColumn.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation_DeleteFromColumn proto.InternalMessageInfo

func (m *Mutation_DeleteFromColumn) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *Mutation_DeleteFromColumn) GetColumnQualifier() []byte {
	if m != nil {
		return m.ColumnQualifier
	}
	return nil
}

func (m *Mutation_DeleteFromColumn) GetTimeRange() *TimestampRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

// A Mutation which deletes all cells from the specified column family.
type Mutation_DeleteFromFamily struct {
	// The name of the family from which cells should be deleted.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName           string   `protobuf:"bytes,1,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mutation_DeleteFromFamily) Reset()         { *m = Mutation_DeleteFromFamily{} }
func (m *Mutation_DeleteFromFamily) String() string { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromFamily) ProtoMessage()    {}
func (*Mutation_DeleteFromFamily) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{10, 2}
}

func (m *Mutation_DeleteFromFamily) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation_DeleteFromFamily.Unmarshal(m, b)
}
func (m *Mutation_DeleteFromFamily) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation_DeleteFromFamily.Marshal(b, m, deterministic)
}
func (m *Mutation_DeleteFromFamily) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation_DeleteFromFamily.Merge(m, src)
}
func (m *Mutation_DeleteFromFamily) XXX_Size() int {
	return xxx_messageInfo_Mutation_DeleteFromFamily.Size(m)
}
func (m *Mutation_DeleteFromFamily) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation_DeleteFromFamily.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation_DeleteFromFamily proto.InternalMessageInfo

func (m *Mutation_DeleteFromFamily) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

// A Mutation which deletes all cells from the containing row.
type Mutation_DeleteFromRow struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mutation_DeleteFromRow) Reset()         { *m = Mutation_DeleteFromRow{} }
func (m *Mutation_DeleteFromRow) String() string { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromRow) ProtoMessage()    {}
func (*Mutation_DeleteFromRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{10, 3}
}

func (m *Mutation_DeleteFromRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation_DeleteFromRow.Unmarshal(m, b)
}
func (m *Mutation_DeleteFromRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation_DeleteFromRow.Marshal(b, m, deterministic)
}
func (m *Mutation_DeleteFromRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation_DeleteFromRow.Merge(m, src)
}
func (m *Mutation_DeleteFromRow) XXX_Size() int {
	return xxx_messageInfo_Mutation_DeleteFromRow.Size(m)
}
func (m *Mutation_DeleteFromRow) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation_DeleteFromRow.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation_DeleteFromRow proto.InternalMessageInfo

// Specifies an atomic read/modify/write operation on the latest value of the
// specified column.
type ReadModifyWriteRule struct {
	// The name of the family to which the read/modify/write should be applied.
	// Must match `[-_.a-zA-Z0-9]+`
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The qualifier of the column to which the read/modify/write should be
	// applied.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The rule used to determine the column's new latest value from its current
	// latest value.
	//
	// Types that are valid to be assigned to Rule:
	//	*ReadModifyWriteRule_AppendValue
	//	*ReadModifyWriteRule_IncrementAmount
	Rule                 isReadModifyWriteRule_Rule `protobuf_oneof:"rule"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ReadModifyWriteRule) Reset()         { *m = ReadModifyWriteRule{} }
func (m *ReadModifyWriteRule) String() string { return proto.CompactTextString(m) }
func (*ReadModifyWriteRule) ProtoMessage()    {}
func (*ReadModifyWriteRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_343df51a8f7aa933, []int{11}
}

func (m *ReadModifyWriteRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadModifyWriteRule.Unmarshal(m, b)
}
func (m *ReadModifyWriteRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadModifyWriteRule.Marshal(b, m, deterministic)
}
func (m *ReadModifyWriteRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadModifyWriteRule.Merge(m, src)
}
func (m *ReadModifyWriteRule) XXX_Size() int {
	return xxx_messageInfo_ReadModifyWriteRule.Size(m)
}
func (m *ReadModifyWriteRule) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadModifyWriteRule.DiscardUnknown(m)
}

var xxx_messageInfo_ReadModifyWriteRule proto.InternalMessageInfo

func (m *ReadModifyWriteRule) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *ReadModifyWriteRule) GetColumnQualifier() []byte {
	if m != nil {
		return m.ColumnQualifier
	}
	return nil
}

type isReadModifyWriteRule_Rule interface {
	isReadModifyWriteRule_Rule()
}

type ReadModifyWriteRule_AppendValue struct {
	AppendValue []byte `protobuf:"bytes,3,opt,name=append_value,json=appendValue,proto3,oneof"`
}

type ReadModifyWriteRule_IncrementAmount struct {
	IncrementAmount int64 `protobuf:"varint,4,opt,name=increment_amount,json=incrementAmount,proto3,oneof"`
}

func (*ReadModifyWriteRule_AppendValue) isReadModifyWriteRule_Rule() {}

func (*ReadModifyWriteRule_IncrementAmount) isReadModifyWriteRule_Rule() {}

func (m *ReadModifyWriteRule) GetRule() isReadModifyWriteRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *ReadModifyWriteRule) GetAppendValue() []byte {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_AppendValue); ok {
		return x.AppendValue
	}
	return nil
}

func (m *ReadModifyWriteRule) GetIncrementAmount() int64 {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_IncrementAmount); ok {
		return x.IncrementAmount
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReadModifyWriteRule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReadModifyWriteRule_AppendValue)(nil),
		(*ReadModifyWriteRule_IncrementAmount)(nil),
	}
}

func init() {
	proto.RegisterType((*Row)(nil), "google.bigtable.v2.Row")
	proto.RegisterType((*Family)(nil), "google.bigtable.v2.Family")
	proto.RegisterType((*Column)(nil), "google.bigtable.v2.Column")
	proto.RegisterType((*Cell)(nil), "google.bigtable.v2.Cell")
	proto.RegisterType((*RowRange)(nil), "google.bigtable.v2.RowRange")
	proto.RegisterType((*RowSet)(nil), "google.bigtable.v2.RowSet")
	proto.RegisterType((*ColumnRange)(nil), "google.bigtable.v2.ColumnRange")
	proto.RegisterType((*TimestampRange)(nil), "google.bigtable.v2.TimestampRange")
	proto.RegisterType((*ValueRange)(nil), "google.bigtable.v2.ValueRange")
	proto.RegisterType((*RowFilter)(nil), "google.bigtable.v2.RowFilter")
	proto.RegisterType((*RowFilter_Chain)(nil), "google.bigtable.v2.RowFilter.Chain")
	proto.RegisterType((*RowFilter_Interleave)(nil), "google.bigtable.v2.RowFilter.Interleave")
	proto.RegisterType((*RowFilter_Condition)(nil), "google.bigtable.v2.RowFilter.Condition")
	proto.RegisterType((*Mutation)(nil), "google.bigtable.v2.Mutation")
	proto.RegisterType((*Mutation_SetCell)(nil), "google.bigtable.v2.Mutation.SetCell")
	proto.RegisterType((*Mutation_DeleteFromColumn)(nil), "google.bigtable.v2.Mutation.DeleteFromColumn")
	proto.RegisterType((*Mutation_DeleteFromFamily)(nil), "google.bigtable.v2.Mutation.DeleteFromFamily")
	proto.RegisterType((*Mutation_DeleteFromRow)(nil), "google.bigtable.v2.Mutation.DeleteFromRow")
	proto.RegisterType((*ReadModifyWriteRule)(nil), "google.bigtable.v2.ReadModifyWriteRule")
}

func init() {
	proto.RegisterFile("google/bigtable/v2/data.proto", fileDescriptor_343df51a8f7aa933)
}

var fileDescriptor_343df51a8f7aa933 = []byte{
	// 1444 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdb, 0x72, 0x1b, 0x45,
	0x13, 0xd6, 0x5a, 0xb6, 0x2c, 0xf5, 0xca, 0x96, 0x32, 0x71, 0x1c, 0x45, 0x7f, 0xfc, 0xc7, 0xa5,
	0x50, 0x41, 0x31, 0x20, 0x83, 0x92, 0x0a, 0x87, 0x50, 0x54, 0x2c, 0x87, 0x44, 0x90, 0xf3, 0xc4,
	0x65, 0xaa, 0x52, 0xa1, 0x96, 0xb1, 0x34, 0x12, 0x5b, 0x9e, 0xdd, 0x59, 0x76, 0x57, 0x56, 0xf4,
	0x22, 0x70, 0x0d, 0x97, 0xbc, 0x02, 0x77, 0x5c, 0xf2, 0x02, 0xf0, 0x18, 0x3c, 0x00, 0x17, 0xd4,
	0x9c, 0xf6, 0xa0, 0x38, 0xb6, 0x8b, 0xca, 0xdd, 0x6e, 0xf7, 0xf7, 0x7d, 0xdd, 0xd3, 0xd3, 0xd3,
	0x3b, 0x0b, 0x1b, 0x63, 0xce, 0xc7, 0x8c, 0x6e, 0x1f, 0xb8, 0xe3, 0x98, 0x1c, 0x30, 0xba, 0x7d,
	0xd4, 0xdd, 0x1e, 0x92, 0x98, 0x74, 0x82, 0x90, 0xc7, 0x1c, 0x21, 0xe5, 0xee, 0x18, 0x77, 0xe7,
	0xa8, 0xdb, 0x7a, 0x02, 0x45, 0xcc, 0xa7, 0xa8, 0x0e, 0xc5, 0x43, 0x3a, 0x6b, 0x58, 0x9b, 0x56,
	0xbb, 0x8a, 0xc5, 0x23, 0xba, 0x05, 0xe5, 0x11, 0xf1, 0x5c, 0xe6, 0xd2, 0xa8, 0xb1, 0xb0, 0x59,
	0x6c, 0xdb, 0xdd, 0x66, 0xe7, 0x75, 0x7e, 0xe7, 0x9e, 0xc0, 0xcc, 0x70, 0x82, 0x6d, 0x61, 0x28,
	0x29, 0x1b, 0x42, 0xb0, 0xe8, 0x13, 0x8f, 0x4a, 0xd1, 0x0a, 0x96, 0xcf, 0xe8, 0x26, 0x2c, 0x0f,
	0x38, 0x9b, 0x78, 0xfe, 0x89, 0xa2, 0xbb, 0x12, 0x82, 0x0d, 0xb4, 0xb5, 0x0f, 0x25, 0x65, 0x42,
	0x97, 0xa1, 0xf2, 0xc3, 0x84, 0x30, 0x77, 0xe4, 0xd2, 0x50, 0x67, 0x9b, 0x1a, 0x50, 0x07, 0x96,
	0x06, 0x94, 0x31, 0xa3, 0xdd, 0x38, 0x56, 0x9b, 0x32, 0x86, 0x15, 0xac, 0xe5, 0xc0, 0xa2, 0x78,
	0x45, 0xd7, 0xa1, 0x1e, 0xbb, 0x1e, 0x8d, 0x62, 0xe2, 0x05, 0x8e, 0xe7, 0x0e, 0x42, 0x1e, 0x49,
	0xf1, 0x22, 0xae, 0x25, 0xf6, 0x47, 0xd2, 0x8c, 0xd6, 0x60, 0xe9, 0x88, 0xb0, 0x09, 0x6d, 0x2c,
	0xc8, 0xe0, 0xea, 0x05, 0xad, 0x43, 0x89, 0x91, 0x03, 0xca, 0xa2, 0x46, 0x71, 0xb3, 0xd8, 0xae,
	0x60, 0xfd, 0xd6, 0xfa, 0xdd, 0x82, 0x32, 0xe6, 0x53, 0x4c, 0xfc, 0x31, 0x45, 0x5b, 0x50, 0x8f,
	0x62, 0x12, 0xc6, 0xce, 0x21, 0x9d, 0x39, 0x03, 0xc6, 0x23, 0x3a, 0x54, 0x4b, 0xe8, 0x17, 0xf0,
	0xaa, 0xf4, 0x3c, 0xa0, 0xb3, 0x5d, 0x69, 0x47, 0xd7, 0x60, 0x35, 0xc5, 0xf2, 0x80, 0xfa, 0x2a,
	0x5e, 0xbf, 0x80, 0xab, 0x06, 0xf9, 0x24, 0xa0, 0x3e, 0x6a, 0x41, 0x95, 0xfa, 0xc3, 0x14, 0x55,
	0x94, 0x28, 0x0b, 0x03, 0xf5, 0x87, 0x06, 0x73, 0x0d, 0x56, 0x0d, 0x46, 0x47, 0x5d, 0xd4, 0xa8,
	0xaa, 0x42, 0xa9, 0x98, 0x3d, 0x1b, 0x2a, 0x49, 0xcc, 0x5e, 0x05, 0x96, 0x35, 0xa9, 0xf5, 0x1d,
	0x94, 0x30, 0x9f, 0x3e, 0xa7, 0x31, 0xba, 0x04, 0xe5, 0x90, 0x4f, 0x85, 0x51, 0xd4, 0xa7, 0xd8,
	0xae, 0xe2, 0xe5, 0x90, 0x4f, 0x1f, 0xd0, 0x59, 0x84, 0x6e, 0x03, 0x08, 0x57, 0x28, 0x56, 0x6a,
	0xea, 0x7f, 0xf9, 0xb8, 0xfa, 0x9b, 0x72, 0xe0, 0x4a, 0xa8, 0x9f, 0xa2, 0xd6, 0x2f, 0x0b, 0x60,
	0xeb, 0x3d, 0x97, 0x95, 0xba, 0x02, 0xb6, 0xec, 0xa7, 0x99, 0x93, 0x69, 0x20, 0x50, 0xa6, 0xc7,
	0xa2, 0x8d, 0x6e, 0xc1, 0xba, 0x4a, 0x35, 0xd9, 0x7b, 0xb3, 0x34, 0x53, 0xa6, 0x35, 0xe9, 0x7f,
	0x66, 0xdc, 0xba, 0xac, 0x5d, 0x58, 0x9b, 0xe7, 0x65, 0xca, 0x56, 0xc0, 0x28, 0xcf, 0x92, 0xe5,
	0xeb, 0xc2, 0x9a, 0xa8, 0xc4, 0x6b, 0x91, 0x4c, 0x11, 0x11, 0xf5, 0x87, 0xf3, 0x71, 0x3a, 0x80,
	0xf2, 0x1c, 0x19, 0x65, 0x49, 0x33, 0xea, 0x59, 0x86, 0x88, 0xd1, 0x3b, 0x07, 0xb5, 0xb9, 0xbc,
	0x7a, 0x35, 0x58, 0xc9, 0x49, 0xb4, 0x5e, 0xc1, 0xea, 0x9e, 0x69, 0x46, 0x55, 0xa6, 0x9b, 0xa6,
	0x0a, 0x6f, 0x68, 0x5e, 0xb5, 0xd6, 0xbd, 0xb9, 0x0e, 0xfe, 0x50, 0xad, 0xe7, 0x35, 0xce, 0x82,
	0xe4, 0x88, 0xbc, 0xe7, 0x18, 0xad, 0xbf, 0x2c, 0x80, 0x7d, 0xd1, 0xe7, 0x2a, 0x6c, 0x07, 0x54,
	0x99, 0x1c, 0xd9, 0xfb, 0xf3, 0x9d, 0xac, 0x7a, 0x5c, 0xc2, 0x75, 0x31, 0x92, 0xbe, 0x57, 0xf8,
	0x5c, 0x37, 0xaf, 0xa6, 0x68, 0x59, 0xec, 0x2d, 0x10, 0xc5, 0xc9, 0x2b, 0x9b, 0x9e, 0x16, 0x5d,
	0x9c, 0xd5, 0xd5, 0x7d, 0x9d, 0x51, 0xcd, 0xf6, 0x75, 0xa2, 0xd9, 0x5b, 0x01, 0x3b, 0x13, 0x5f,
	0xb4, 0x79, 0x42, 0x6b, 0xfd, 0x63, 0x43, 0x05, 0xf3, 0xe9, 0x3d, 0x97, 0xc5, 0x34, 0x44, 0xb7,
	0x61, 0x69, 0xf0, 0x3d, 0x71, 0x7d, 0xb9, 0x18, 0xbb, 0x7b, 0xf5, 0x0d, 0xfd, 0xab, 0xd0, 0x9d,
	0x5d, 0x01, 0xed, 0x17, 0xb0, 0xe2, 0xa0, 0xaf, 0x01, 0x5c, 0x3f, 0xa6, 0x21, 0xa3, 0xe4, 0x48,
	0x8d, 0x07, 0xbb, 0xdb, 0x3e, 0x59, 0xe1, 0xab, 0x04, 0xdf, 0x2f, 0xe0, 0x0c, 0x1b, 0xdd, 0x87,
	0xca, 0x80, 0xfb, 0x43, 0x37, 0x76, 0xb9, 0x6a, 0x4e, 0xbb, 0xfb, 0xee, 0x29, 0xc9, 0x18, 0x78,
	0xbf, 0x80, 0x53, 0x2e, 0x5a, 0x83, 0xc5, 0xc8, 0xf5, 0x0f, 0x1b, 0xf5, 0x4d, 0xab, 0x5d, 0xee,
	0x17, 0xb0, 0x7c, 0x43, 0x6d, 0xa8, 0x05, 0x24, 0x8a, 0x1c, 0xc2, 0x98, 0x33, 0x92, 0xfc, 0xc6,
	0x39, 0x0d, 0x58, 0x11, 0x8e, 0x1d, 0xc6, 0x74, 0x45, 0xb6, 0xa0, 0x7e, 0xc0, 0xf8, 0xe0, 0x30,
	0x0b, 0x45, 0x1a, 0xba, 0x2a, 0x3d, 0x29, 0xf6, 0x23, 0x58, 0xd3, 0xd3, 0xc1, 0x09, 0xe9, 0x98,
	0xbe, 0x32, 0xf8, 0x45, 0xbd, 0xd7, 0xe7, 0xd4, 0xac, 0xc0, 0xc2, 0xa7, 0x29, 0xef, 0x83, 0x30,
	0x3a, 0x11, 0xf1, 0x02, 0x46, 0x0d, 0x7e, 0x75, 0xd3, 0x6a, 0x5b, 0xfd, 0x02, 0xae, 0x85, 0x7c,
	0xfa, 0x5c, 0x7a, 0x34, 0xfa, 0x53, 0x68, 0x64, 0xc6, 0x42, 0x3e, 0x88, 0x38, 0x5b, 0x95, 0x7e,
	0x01, 0x5f, 0x48, 0xa7, 0x44, 0x36, 0xd0, 0x2e, 0x6c, 0xa8, 0x8f, 0x49, 0xe6, 0x4c, 0xe6, 0xf8,
	0x25, 0x9d, 0x64, 0x53, 0xc1, 0x92, 0xe3, 0x99, 0x15, 0x79, 0x06, 0xe7, 0xb5, 0x88, 0x1c, 0x73,
	0x86, 0xba, 0x2c, 0xf7, 0xe7, 0xca, 0x09, 0x1f, 0x32, 0x81, 0x16, 0x05, 0x18, 0xa4, 0xaf, 0x5a,
	0xf2, 0x05, 0xac, 0xa7, 0x07, 0x31, 0xa7, 0x5a, 0x96, 0xaa, 0xad, 0xe3, 0x54, 0xf3, 0x63, 0x40,
	0x0c, 0xbb, 0x38, 0x67, 0xd1, 0xda, 0x1d, 0x40, 0xea, 0x6c, 0xe4, 0x16, 0x5a, 0x31, 0xe7, 0x54,
	0xfa, 0xb2, 0xcb, 0x7b, 0x9c, 0xe0, 0xb3, 0x79, 0xd4, 0x64, 0x1e, 0xff, 0x3f, 0x2e, 0x8f, 0x74,
	0x26, 0xa4, 0x7a, 0x99, 0xf8, 0x5f, 0xc0, 0xff, 0xe4, 0x67, 0xd6, 0x09, 0x44, 0xb1, 0xf9, 0xd4,
	0xe1, 0xa3, 0x51, 0x44, 0x63, 0x23, 0x0c, 0x9b, 0x56, 0x7b, 0xa9, 0x5f, 0xc0, 0x17, 0x25, 0xe8,
	0x29, 0x0d, 0x31, 0x9f, 0x3e, 0x91, 0x08, 0xcd, 0xff, 0x1c, 0x9a, 0x79, 0x3e, 0x73, 0x3d, 0x37,
	0xa1, 0xdb, 0x9a, 0xbe, 0x9e, 0xa1, 0x3f, 0x14, 0x00, 0xcd, 0xee, 0xc1, 0x46, 0xca, 0xd6, 0xdb,
	0x96, 0x13, 0xa8, 0x6a, 0x81, 0x4b, 0x46, 0x40, 0x6d, 0x56, 0x56, 0xe3, 0x13, 0xb8, 0x18, 0xc5,
	0xa1, 0x1b, 0xe8, 0x19, 0x13, 0x87, 0xc4, 0x8f, 0x46, 0x3c, 0xf4, 0x68, 0xd8, 0x58, 0xd1, 0x87,
	0xe0, 0x82, 0x04, 0xc8, 0x4a, 0xec, 0xa5, 0x6e, 0xc1, 0x24, 0x41, 0xc0, 0x66, 0x8e, 0xbc, 0x08,
	0xe4, 0x98, 0xe7, 0x4d, 0xa7, 0x4a, 0xc0, 0x43, 0xe1, 0xcf, 0x30, 0x9b, 0x77, 0x60, 0x49, 0x0e,
	0x16, 0xf4, 0x31, 0x2c, 0xab, 0x4c, 0xd5, 0xb7, 0xd6, 0xee, 0x6e, 0x9c, 0x38, 0x01, 0xb0, 0x41,
	0x37, 0xbf, 0x04, 0x48, 0x07, 0xcb, 0x7f, 0x97, 0xf9, 0xd3, 0x82, 0x4a, 0x32, 0x55, 0x50, 0x1f,
	0xea, 0x41, 0x48, 0x87, 0xee, 0x80, 0xc4, 0x49, 0x6b, 0xa8, 0x29, 0x79, 0x8a, 0x5e, 0x2d, 0xa1,
	0x25, 0x6d, 0x61, 0xc7, 0xe1, 0x24, 0x11, 0x59, 0x38, 0x8b, 0x08, 0x08, 0x86, 0xe6, 0xdf, 0x81,
	0xea, 0x88, 0xb0, 0x28, 0x11, 0x28, 0x9e, 0x45, 0xc0, 0x96, 0x14, 0xf5, 0xd2, 0x2b, 0x43, 0x49,
	0x71, 0x5b, 0x7f, 0x2f, 0x41, 0xf9, 0xd1, 0x24, 0x26, 0x72, 0x89, 0x3b, 0x50, 0x16, 0xed, 0x29,
	0xda, 0x41, 0x2f, 0xed, 0x9d, 0xe3, 0x44, 0x0d, 0xbe, 0xf3, 0x9c, 0xc6, 0xe2, 0xf6, 0xd8, 0x2f,
	0xe0, 0xe5, 0x48, 0x3d, 0xa2, 0x6f, 0x01, 0x0d, 0x29, 0xa3, 0xa2, 0x44, 0x21, 0xf7, 0x74, 0xdb,
	0xe9, 0x25, 0x7e, 0x70, 0xa2, 0xd8, 0x5d, 0x49, 0xbb, 0x17, 0x72, 0x4f, 0xb5, 0xa1, 0x38, 0x51,
	0xc3, 0x39, 0xdb, 0xbc, 0xbc, 0x1a, 0x75, 0xba, 0x00, 0x67, 0x95, 0x57, 0x97, 0xf3, 0xbc, 0xbc,
	0xbe, 0xb0, 0xef, 0x41, 0x2d, 0x2b, 0x1f, 0xf2, 0xa9, 0x9c, 0xdd, 0x76, 0x77, 0xeb, 0x8c, 0xda,
	0x98, 0x4f, 0xc5, 0x27, 0x64, 0x98, 0x35, 0x34, 0x7f, 0xb4, 0x60, 0x59, 0x97, 0xea, 0xf4, 0x8b,
	0xdd, 0x75, 0xa8, 0xcf, 0xcf, 0x69, 0x7d, 0xd3, 0xae, 0xcd, 0x0d, 0xe6, 0x63, 0x2f, 0xed, 0xc5,
	0x53, 0x2e, 0xed, 0x8b, 0x99, 0x4b, 0x7b, 0xf3, 0x67, 0x0b, 0xea, 0xf3, 0x65, 0x7f, 0xab, 0x19,
	0xee, 0x00, 0x88, 0x4c, 0xd4, 0x3c, 0xd5, 0xdb, 0x74, 0x86, 0x81, 0x8e, 0x2b, 0x82, 0x25, 0x1f,
	0x9b, 0x37, 0xb2, 0x29, 0xea, 0x6d, 0x3a, 0x2d, 0xc5, 0x66, 0x0d, 0x56, 0x72, 0x7b, 0xd2, 0x03,
	0x28, 0x7b, 0x7a, 0xb7, 0x5a, 0xbf, 0x59, 0x70, 0x1e, 0x53, 0x32, 0x7c, 0xc4, 0x87, 0xee, 0x68,
	0xf6, 0x4d, 0xe8, 0xc6, 0x14, 0x4f, 0x18, 0x7d, 0xab, 0x0b, 0xbf, 0x0a, 0x55, 0x12, 0x04, 0xc9,
	0x2d, 0x2b, 0xb9, 0x5e, 0xdb, 0xca, 0x2a, 0xa7, 0x25, 0x7a, 0x0f, 0xea, 0xae, 0x3f, 0x08, 0xa9,
	0x47, 0xfd, 0xd8, 0x21, 0x1e, 0x9f, 0xf8, 0xb1, 0xdc, 0x9f, 0xa2, 0xf8, 0xf4, 0x27, 0x9e, 0x1d,
	0xe9, 0xe8, 0x95, 0x60, 0x31, 0x9c, 0x30, 0xda, 0xfb, 0xc9, 0x82, 0xf5, 0x01, 0xf7, 0x8e, 0x29,
	0x62, 0xaf, 0x72, 0x97, 0xc4, 0xe4, 0xa9, 0xf8, 0xd1, 0x7d, 0x6a, 0xbd, 0xf8, 0x4c, 0x03, 0xc6,
	0x9c, 0x11, 0x7f, 0xdc, 0xe1, 0xe1, 0x78, 0x7b, 0x4c, 0x7d, 0xf9, 0x1b, 0xbc, 0xad, 0x5c, 0x24,
	0x70, 0xa3, 0xec, 0x8f, 0xf2, 0x6d, 0xf3, 0xfc, 0xeb, 0x42, 0xe3, 0xbe, 0x22, 0xef, 0x32, 0x3e,
	0x19, 0x76, 0x7a, 0x26, 0xc6, 0x7e, 0xf7, 0x0f, 0xe3, 0x7a, 0x29, 0x5d, 0x2f, 0x8d, 0xeb, 0xe5,
	0x7e, 0xf7, 0xa0, 0x24, 0xc5, 0x6f, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x05, 0xf7, 0x92, 0x43,
	0x84, 0x0f, 0x00, 0x00,
}
