// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package cloudbuild

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Possible status of a build or build step.
type Build_Status int32

const (
	// Status of the build is unknown.
	Build_STATUS_UNKNOWN Build_Status = 0
	// Build or step is queued; work has not yet begun.
	Build_QUEUED Build_Status = 1
	// Build or step is being executed.
	Build_WORKING Build_Status = 2
	// Build or step finished successfully.
	Build_SUCCESS Build_Status = 3
	// Build or step failed to complete successfully.
	Build_FAILURE Build_Status = 4
	// Build or step failed due to an internal cause.
	Build_INTERNAL_ERROR Build_Status = 5
	// Build or step took longer than was allowed.
	Build_TIMEOUT Build_Status = 6
	// Build or step was canceled by a user.
	Build_CANCELLED Build_Status = 7
	// Build was enqueued for longer than the value of `queue_ttl`.
	Build_EXPIRED Build_Status = 9
)

var Build_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "QUEUED",
	2: "WORKING",
	3: "SUCCESS",
	4: "FAILURE",
	5: "INTERNAL_ERROR",
	6: "TIMEOUT",
	7: "CANCELLED",
	9: "EXPIRED",
}

var Build_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"QUEUED":         1,
	"WORKING":        2,
	"SUCCESS":        3,
	"FAILURE":        4,
	"INTERNAL_ERROR": 5,
	"TIMEOUT":        6,
	"CANCELLED":      7,
	"EXPIRED":        9,
}

func (x Build_Status) String() string {
	return proto.EnumName(Build_Status_name, int32(x))
}

func (Build_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{10, 0}
}

// Specifies the hash algorithm, if any.
type Hash_HashType int32

const (
	// No hash requested.
	Hash_NONE Hash_HashType = 0
	// Use a sha256 hash.
	Hash_SHA256 Hash_HashType = 1
	// Use a md5 hash.
	Hash_MD5 Hash_HashType = 2
)

var Hash_HashType_name = map[int32]string{
	0: "NONE",
	1: "SHA256",
	2: "MD5",
}

var Hash_HashType_value = map[string]int32{
	"NONE":   0,
	"SHA256": 1,
	"MD5":    2,
}

func (x Hash_HashType) String() string {
	return proto.EnumName(Hash_HashType_name, int32(x))
}

func (Hash_HashType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{16, 0}
}

// Controls behavior of Pull Request comments.
type PullRequestFilter_CommentControl int32

const (
	// Do not require comments on Pull Requests before builds are triggered.
	PullRequestFilter_COMMENTS_DISABLED PullRequestFilter_CommentControl = 0
	// Enforce that repository owners or collaborators must comment on Pull
	// Requests before builds are triggered.
	PullRequestFilter_COMMENTS_ENABLED PullRequestFilter_CommentControl = 1
)

var PullRequestFilter_CommentControl_name = map[int32]string{
	0: "COMMENTS_DISABLED",
	1: "COMMENTS_ENABLED",
}

var PullRequestFilter_CommentControl_value = map[string]int32{
	"COMMENTS_DISABLED": 0,
	"COMMENTS_ENABLED":  1,
}

func (x PullRequestFilter_CommentControl) String() string {
	return proto.EnumName(PullRequestFilter_CommentControl_name, int32(x))
}

func (PullRequestFilter_CommentControl) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{25, 0}
}

// Specifies the manner in which the build should be verified, if at all.
type BuildOptions_VerifyOption int32

const (
	// Not a verifiable build. (default)
	BuildOptions_NOT_VERIFIED BuildOptions_VerifyOption = 0
	// Verified build.
	BuildOptions_VERIFIED BuildOptions_VerifyOption = 1
)

var BuildOptions_VerifyOption_name = map[int32]string{
	0: "NOT_VERIFIED",
	1: "VERIFIED",
}

var BuildOptions_VerifyOption_value = map[string]int32{
	"NOT_VERIFIED": 0,
	"VERIFIED":     1,
}

func (x BuildOptions_VerifyOption) String() string {
	return proto.EnumName(BuildOptions_VerifyOption_name, int32(x))
}

func (BuildOptions_VerifyOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{33, 0}
}

// Supported VM sizes.
type BuildOptions_MachineType int32

const (
	// Standard machine type.
	BuildOptions_UNSPECIFIED BuildOptions_MachineType = 0
	// Highcpu machine with 8 CPUs.
	BuildOptions_N1_HIGHCPU_8 BuildOptions_MachineType = 1
	// Highcpu machine with 32 CPUs.
	BuildOptions_N1_HIGHCPU_32 BuildOptions_MachineType = 2
)

var BuildOptions_MachineType_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "N1_HIGHCPU_8",
	2: "N1_HIGHCPU_32",
}

var BuildOptions_MachineType_value = map[string]int32{
	"UNSPECIFIED":   0,
	"N1_HIGHCPU_8":  1,
	"N1_HIGHCPU_32": 2,
}

func (x BuildOptions_MachineType) String() string {
	return proto.EnumName(BuildOptions_MachineType_name, int32(x))
}

func (BuildOptions_MachineType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{33, 1}
}

// Specifies the behavior when there is an error in the substitution checks.
type BuildOptions_SubstitutionOption int32

const (
	// Fails the build if error in substitutions checks, like missing
	// a substitution in the template or in the map.
	BuildOptions_MUST_MATCH BuildOptions_SubstitutionOption = 0
	// Do not fail the build if error in substitutions checks.
	BuildOptions_ALLOW_LOOSE BuildOptions_SubstitutionOption = 1
)

var BuildOptions_SubstitutionOption_name = map[int32]string{
	0: "MUST_MATCH",
	1: "ALLOW_LOOSE",
}

var BuildOptions_SubstitutionOption_value = map[string]int32{
	"MUST_MATCH":  0,
	"ALLOW_LOOSE": 1,
}

func (x BuildOptions_SubstitutionOption) String() string {
	return proto.EnumName(BuildOptions_SubstitutionOption_name, int32(x))
}

func (BuildOptions_SubstitutionOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{33, 2}
}

// Specifies the behavior when writing build logs to Google Cloud Storage.
type BuildOptions_LogStreamingOption int32

const (
	// Service may automatically determine build log streaming behavior.
	BuildOptions_STREAM_DEFAULT BuildOptions_LogStreamingOption = 0
	// Build logs should be streamed to Google Cloud Storage.
	BuildOptions_STREAM_ON BuildOptions_LogStreamingOption = 1
	// Build logs should not be streamed to Google Cloud Storage; they will be
	// written when the build is completed.
	BuildOptions_STREAM_OFF BuildOptions_LogStreamingOption = 2
)

var BuildOptions_LogStreamingOption_name = map[int32]string{
	0: "STREAM_DEFAULT",
	1: "STREAM_ON",
	2: "STREAM_OFF",
}

var BuildOptions_LogStreamingOption_value = map[string]int32{
	"STREAM_DEFAULT": 0,
	"STREAM_ON":      1,
	"STREAM_OFF":     2,
}

func (x BuildOptions_LogStreamingOption) String() string {
	return proto.EnumName(BuildOptions_LogStreamingOption_name, int32(x))
}

func (BuildOptions_LogStreamingOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{33, 3}
}

// Specifies the logging mode.
type BuildOptions_LoggingMode int32

const (
	// The service determines the logging mode. The default is `LEGACY`. Do not
	// rely on the default logging behavior as it may change in the future.
	BuildOptions_LOGGING_UNSPECIFIED BuildOptions_LoggingMode = 0
	// Stackdriver logging and Cloud Storage logging are enabled.
	BuildOptions_LEGACY BuildOptions_LoggingMode = 1
	// Only Cloud Storage logging is enabled.
	BuildOptions_GCS_ONLY BuildOptions_LoggingMode = 2
)

var BuildOptions_LoggingMode_name = map[int32]string{
	0: "LOGGING_UNSPECIFIED",
	1: "LEGACY",
	2: "GCS_ONLY",
}

var BuildOptions_LoggingMode_value = map[string]int32{
	"LOGGING_UNSPECIFIED": 0,
	"LEGACY":              1,
	"GCS_ONLY":            2,
}

func (x BuildOptions_LoggingMode) String() string {
	return proto.EnumName(BuildOptions_LoggingMode_name, int32(x))
}

func (BuildOptions_LoggingMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{33, 4}
}

// Supported GCP regions to create the `WorkerPool`.
type WorkerPool_Region int32

const (
	// no region
	WorkerPool_REGION_UNSPECIFIED WorkerPool_Region = 0
	// us-central1 region
	WorkerPool_US_CENTRAL1 WorkerPool_Region = 1
	// us-west1 region
	WorkerPool_US_WEST1 WorkerPool_Region = 2
	// us-east1 region
	WorkerPool_US_EAST1 WorkerPool_Region = 3
	// us-east4 region
	WorkerPool_US_EAST4 WorkerPool_Region = 4
)

var WorkerPool_Region_name = map[int32]string{
	0: "REGION_UNSPECIFIED",
	1: "US_CENTRAL1",
	2: "US_WEST1",
	3: "US_EAST1",
	4: "US_EAST4",
}

var WorkerPool_Region_value = map[string]int32{
	"REGION_UNSPECIFIED": 0,
	"US_CENTRAL1":        1,
	"US_WEST1":           2,
	"US_EAST1":           3,
	"US_EAST4":           4,
}

func (x WorkerPool_Region) String() string {
	return proto.EnumName(WorkerPool_Region_name, int32(x))
}

func (WorkerPool_Region) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{34, 0}
}

// `WorkerPool` status
type WorkerPool_Status int32

const (
	// Status of the `WorkerPool` is unknown.
	WorkerPool_STATUS_UNSPECIFIED WorkerPool_Status = 0
	// `WorkerPool` is being created.
	WorkerPool_CREATING WorkerPool_Status = 1
	// `WorkerPool` is running.
	WorkerPool_RUNNING WorkerPool_Status = 2
	// `WorkerPool` is being deleted: cancelling builds and draining workers.
	WorkerPool_DELETING WorkerPool_Status = 3
	// `WorkerPool` is deleted.
	WorkerPool_DELETED WorkerPool_Status = 4
)

var WorkerPool_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "CREATING",
	2: "RUNNING",
	3: "DELETING",
	4: "DELETED",
}

var WorkerPool_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"CREATING":           1,
	"RUNNING":            2,
	"DELETING":           3,
	"DELETED":            4,
}

func (x WorkerPool_Status) String() string {
	return proto.EnumName(WorkerPool_Status_name, int32(x))
}

func (WorkerPool_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{34, 1}
}

// Specifies a build to retry.
type RetryBuildRequest struct {
	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Build ID of the original build.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RetryBuildRequest) Reset()         { *m = RetryBuildRequest{} }
func (m *RetryBuildRequest) String() string { return proto.CompactTextString(m) }
func (*RetryBuildRequest) ProtoMessage()    {}
func (*RetryBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{0}
}

func (m *RetryBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RetryBuildRequest.Unmarshal(m, b)
}
func (m *RetryBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RetryBuildRequest.Marshal(b, m, deterministic)
}
func (m *RetryBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryBuildRequest.Merge(m, src)
}
func (m *RetryBuildRequest) XXX_Size() int {
	return xxx_messageInfo_RetryBuildRequest.Size(m)
}
func (m *RetryBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RetryBuildRequest proto.InternalMessageInfo

func (m *RetryBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RetryBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Specifies a build trigger to run and the source to use.
type RunBuildTriggerRequest struct {
	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the trigger.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Required. Source to build against this trigger.
	Source               *RepoSource `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RunBuildTriggerRequest) Reset()         { *m = RunBuildTriggerRequest{} }
func (m *RunBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*RunBuildTriggerRequest) ProtoMessage()    {}
func (*RunBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{1}
}

func (m *RunBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunBuildTriggerRequest.Unmarshal(m, b)
}
func (m *RunBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *RunBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunBuildTriggerRequest.Merge(m, src)
}
func (m *RunBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_RunBuildTriggerRequest.Size(m)
}
func (m *RunBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunBuildTriggerRequest proto.InternalMessageInfo

func (m *RunBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RunBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *RunBuildTriggerRequest) GetSource() *RepoSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// Location of the source in an archive file in Google Cloud Storage.
type StorageSource struct {
	// Google Cloud Storage bucket containing the source (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Google Cloud Storage object containing the source.
	//
	// This object must be a gzipped archive file (`.tar.gz`) containing source to
	// build.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Google Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation           int64    `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StorageSource) Reset()         { *m = StorageSource{} }
func (m *StorageSource) String() string { return proto.CompactTextString(m) }
func (*StorageSource) ProtoMessage()    {}
func (*StorageSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{2}
}

func (m *StorageSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageSource.Unmarshal(m, b)
}
func (m *StorageSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageSource.Marshal(b, m, deterministic)
}
func (m *StorageSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageSource.Merge(m, src)
}
func (m *StorageSource) XXX_Size() int {
	return xxx_messageInfo_StorageSource.Size(m)
}
func (m *StorageSource) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageSource.DiscardUnknown(m)
}

var xxx_messageInfo_StorageSource proto.InternalMessageInfo

func (m *StorageSource) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *StorageSource) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *StorageSource) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

// Location of the source in a Google Cloud Source Repository.
type RepoSource struct {
	// ID of the project that owns the Cloud Source Repository. If omitted, the
	// project ID requesting the build is assumed.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Name of the Cloud Source Repository.
	RepoName string `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	// A revision within the Cloud Source Repository must be specified in
	// one of these ways.
	//
	// Types that are valid to be assigned to Revision:
	//	*RepoSource_BranchName
	//	*RepoSource_TagName
	//	*RepoSource_CommitSha
	Revision isRepoSource_Revision `protobuf_oneof:"revision"`
	// Directory, relative to the source root, in which to run the build.
	//
	// This must be a relative path. If a step's `dir` is specified and is an
	// absolute path, this value is ignored for that step's execution.
	Dir string `protobuf:"bytes,7,opt,name=dir,proto3" json:"dir,omitempty"`
	// Only trigger a build if the revision regex does NOT match the revision
	// regex.
	InvertRegex bool `protobuf:"varint,8,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
	// Substitutions to use in a triggered build.
	// Should only be used with RunBuildTrigger
	Substitutions        map[string]string `protobuf:"bytes,9,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RepoSource) Reset()         { *m = RepoSource{} }
func (m *RepoSource) String() string { return proto.CompactTextString(m) }
func (*RepoSource) ProtoMessage()    {}
func (*RepoSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{3}
}

func (m *RepoSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RepoSource.Unmarshal(m, b)
}
func (m *RepoSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RepoSource.Marshal(b, m, deterministic)
}
func (m *RepoSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RepoSource.Merge(m, src)
}
func (m *RepoSource) XXX_Size() int {
	return xxx_messageInfo_RepoSource.Size(m)
}
func (m *RepoSource) XXX_DiscardUnknown() {
	xxx_messageInfo_RepoSource.DiscardUnknown(m)
}

var xxx_messageInfo_RepoSource proto.InternalMessageInfo

func (m *RepoSource) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RepoSource) GetRepoName() string {
	if m != nil {
		return m.RepoName
	}
	return ""
}

type isRepoSource_Revision interface {
	isRepoSource_Revision()
}

type RepoSource_BranchName struct {
	BranchName string `protobuf:"bytes,3,opt,name=branch_name,json=branchName,proto3,oneof"`
}

type RepoSource_TagName struct {
	TagName string `protobuf:"bytes,4,opt,name=tag_name,json=tagName,proto3,oneof"`
}

type RepoSource_CommitSha struct {
	CommitSha string `protobuf:"bytes,5,opt,name=commit_sha,json=commitSha,proto3,oneof"`
}

func (*RepoSource_BranchName) isRepoSource_Revision() {}

func (*RepoSource_TagName) isRepoSource_Revision() {}

func (*RepoSource_CommitSha) isRepoSource_Revision() {}

func (m *RepoSource) GetRevision() isRepoSource_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *RepoSource) GetBranchName() string {
	if x, ok := m.GetRevision().(*RepoSource_BranchName); ok {
		return x.BranchName
	}
	return ""
}

func (m *RepoSource) GetTagName() string {
	if x, ok := m.GetRevision().(*RepoSource_TagName); ok {
		return x.TagName
	}
	return ""
}

func (m *RepoSource) GetCommitSha() string {
	if x, ok := m.GetRevision().(*RepoSource_CommitSha); ok {
		return x.CommitSha
	}
	return ""
}

func (m *RepoSource) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *RepoSource) GetInvertRegex() bool {
	if m != nil {
		return m.InvertRegex
	}
	return false
}

func (m *RepoSource) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RepoSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RepoSource_BranchName)(nil),
		(*RepoSource_TagName)(nil),
		(*RepoSource_CommitSha)(nil),
	}
}

// Location of the source in a supported storage service.
type Source struct {
	// Location of source.
	//
	// Types that are valid to be assigned to Source:
	//	*Source_StorageSource
	//	*Source_RepoSource
	Source               isSource_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Source) Reset()         { *m = Source{} }
func (m *Source) String() string { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()    {}
func (*Source) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{4}
}

func (m *Source) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Source.Unmarshal(m, b)
}
func (m *Source) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Source.Marshal(b, m, deterministic)
}
func (m *Source) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Source.Merge(m, src)
}
func (m *Source) XXX_Size() int {
	return xxx_messageInfo_Source.Size(m)
}
func (m *Source) XXX_DiscardUnknown() {
	xxx_messageInfo_Source.DiscardUnknown(m)
}

var xxx_messageInfo_Source proto.InternalMessageInfo

type isSource_Source interface {
	isSource_Source()
}

type Source_StorageSource struct {
	StorageSource *StorageSource `protobuf:"bytes,2,opt,name=storage_source,json=storageSource,proto3,oneof"`
}

type Source_RepoSource struct {
	RepoSource *RepoSource `protobuf:"bytes,3,opt,name=repo_source,json=repoSource,proto3,oneof"`
}

func (*Source_StorageSource) isSource_Source() {}

func (*Source_RepoSource) isSource_Source() {}

func (m *Source) GetSource() isSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Source) GetStorageSource() *StorageSource {
	if x, ok := m.GetSource().(*Source_StorageSource); ok {
		return x.StorageSource
	}
	return nil
}

func (m *Source) GetRepoSource() *RepoSource {
	if x, ok := m.GetSource().(*Source_RepoSource); ok {
		return x.RepoSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Source) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Source_StorageSource)(nil),
		(*Source_RepoSource)(nil),
	}
}

// An image built by the pipeline.
type BuiltImage struct {
	// Name used to push the container image to Google Container Registry, as
	// presented to `docker push`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Docker Registry 2.0 digest.
	Digest string `protobuf:"bytes,3,opt,name=digest,proto3" json:"digest,omitempty"`
	// Output only. Stores timing information for pushing the specified image.
	PushTiming           *TimeSpan `protobuf:"bytes,4,opt,name=push_timing,json=pushTiming,proto3" json:"push_timing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BuiltImage) Reset()         { *m = BuiltImage{} }
func (m *BuiltImage) String() string { return proto.CompactTextString(m) }
func (*BuiltImage) ProtoMessage()    {}
func (*BuiltImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{5}
}

func (m *BuiltImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuiltImage.Unmarshal(m, b)
}
func (m *BuiltImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuiltImage.Marshal(b, m, deterministic)
}
func (m *BuiltImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuiltImage.Merge(m, src)
}
func (m *BuiltImage) XXX_Size() int {
	return xxx_messageInfo_BuiltImage.Size(m)
}
func (m *BuiltImage) XXX_DiscardUnknown() {
	xxx_messageInfo_BuiltImage.DiscardUnknown(m)
}

var xxx_messageInfo_BuiltImage proto.InternalMessageInfo

func (m *BuiltImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuiltImage) GetDigest() string {
	if m != nil {
		return m.Digest
	}
	return ""
}

func (m *BuiltImage) GetPushTiming() *TimeSpan {
	if m != nil {
		return m.PushTiming
	}
	return nil
}

// A step in the build pipeline.
type BuildStep struct {
	// Required. The name of the container image that will run this particular
	// build step.
	//
	// If the image is available in the host's Docker daemon's cache, it
	// will be run directly. If not, the host will attempt to pull the image
	// first, using the builder service account's credentials if necessary.
	//
	// The Docker daemon's cache will already have the latest versions of all of
	// the officially supported build steps
	// ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
	// The Docker daemon will also have cached many of the layers for some popular
	// images, like "ubuntu", "debian", but they will be refreshed at the time you
	// attempt to use them.
	//
	// If you built an image in a previous build step, it will be stored in the
	// host's Docker daemon's cache and is available to use as the name for a
	// later build step.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of environment variable definitions to be used when running a step.
	//
	// The elements are of the form "KEY=VALUE" for the environment variable "KEY"
	// being given the value "VALUE".
	Env []string `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// A list of arguments that will be presented to the step when it is started.
	//
	// If the image used to run the step's container has an entrypoint, the `args`
	// are used as arguments to that entrypoint. If the image does not define
	// an entrypoint, the first element in args is used as the entrypoint,
	// and the remainder will be used as arguments.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Working directory to use when running this step's container.
	//
	// If this value is a relative path, it is relative to the build's working
	// directory. If this value is absolute, it may be outside the build's working
	// directory, in which case the contents of the path may not be persisted
	// across build step executions, unless a `volume` for that path is specified.
	//
	// If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
	// which specifies an absolute path, the `RepoSource` `dir` is ignored for
	// the step's execution.
	Dir string `protobuf:"bytes,4,opt,name=dir,proto3" json:"dir,omitempty"`
	// Unique identifier for this build step, used in `wait_for` to
	// reference this build step as a dependency.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The ID(s) of the step(s) that this build step depends on.
	// This build step will not start until all the build steps in `wait_for`
	// have completed successfully. If `wait_for` is empty, this build step will
	// start when all previous build steps in the `Build.Steps` list have
	// completed successfully.
	WaitFor []string `protobuf:"bytes,6,rep,name=wait_for,json=waitFor,proto3" json:"wait_for,omitempty"`
	// Entrypoint to be used instead of the build step image's default entrypoint.
	// If unset, the image's default entrypoint is used.
	Entrypoint string `protobuf:"bytes,7,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// A list of environment variables which are encrypted using a Cloud Key
	// Management Service crypto key. These values must be specified in the
	// build's `Secret`.
	SecretEnv []string `protobuf:"bytes,8,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
	// List of volumes to mount into the build step.
	//
	// Each volume is created as an empty volume prior to execution of the
	// build step. Upon completion of the build, volumes and their contents are
	// discarded.
	//
	// Using a named volume in only one step is not valid as it is indicative
	// of a build request with an incorrect configuration.
	Volumes []*Volume `protobuf:"bytes,9,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// Output only. Stores timing information for executing this build step.
	Timing *TimeSpan `protobuf:"bytes,10,opt,name=timing,proto3" json:"timing,omitempty"`
	// Output only. Stores timing information for pulling this build step's
	// builder image only.
	PullTiming *TimeSpan `protobuf:"bytes,13,opt,name=pull_timing,json=pullTiming,proto3" json:"pull_timing,omitempty"`
	// Time limit for executing this build step. If not defined, the step has no
	// time limit and will be allowed to continue to run until either it completes
	// or the build itself times out.
	Timeout *duration.Duration `protobuf:"bytes,11,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Output only. Status of the build step. At this time, build step status is
	// only updated on build completion; step status is not updated in real-time
	// as the build progresses.
	Status               Build_Status `protobuf:"varint,12,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BuildStep) Reset()         { *m = BuildStep{} }
func (m *BuildStep) String() string { return proto.CompactTextString(m) }
func (*BuildStep) ProtoMessage()    {}
func (*BuildStep) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{6}
}

func (m *BuildStep) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildStep.Unmarshal(m, b)
}
func (m *BuildStep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildStep.Marshal(b, m, deterministic)
}
func (m *BuildStep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildStep.Merge(m, src)
}
func (m *BuildStep) XXX_Size() int {
	return xxx_messageInfo_BuildStep.Size(m)
}
func (m *BuildStep) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildStep.DiscardUnknown(m)
}

var xxx_messageInfo_BuildStep proto.InternalMessageInfo

func (m *BuildStep) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuildStep) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *BuildStep) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *BuildStep) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *BuildStep) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildStep) GetWaitFor() []string {
	if m != nil {
		return m.WaitFor
	}
	return nil
}

func (m *BuildStep) GetEntrypoint() string {
	if m != nil {
		return m.Entrypoint
	}
	return ""
}

func (m *BuildStep) GetSecretEnv() []string {
	if m != nil {
		return m.SecretEnv
	}
	return nil
}

func (m *BuildStep) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *BuildStep) GetTiming() *TimeSpan {
	if m != nil {
		return m.Timing
	}
	return nil
}

func (m *BuildStep) GetPullTiming() *TimeSpan {
	if m != nil {
		return m.PullTiming
	}
	return nil
}

func (m *BuildStep) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *BuildStep) GetStatus() Build_Status {
	if m != nil {
		return m.Status
	}
	return Build_STATUS_UNKNOWN
}

// Volume describes a Docker container volume which is mounted into build steps
// in order to persist files across build step execution.
type Volume struct {
	// Name of the volume to mount.
	//
	// Volume names must be unique per build step and must be valid names for
	// Docker volumes. Each named volume must be used by at least two build steps.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path at which to mount the volume.
	//
	// Paths must be absolute and cannot conflict with other volume paths on the
	// same build step or with certain reserved volume paths.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Volume) Reset()         { *m = Volume{} }
func (m *Volume) String() string { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()    {}
func (*Volume) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{7}
}

func (m *Volume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Volume.Unmarshal(m, b)
}
func (m *Volume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Volume.Marshal(b, m, deterministic)
}
func (m *Volume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Volume.Merge(m, src)
}
func (m *Volume) XXX_Size() int {
	return xxx_messageInfo_Volume.Size(m)
}
func (m *Volume) XXX_DiscardUnknown() {
	xxx_messageInfo_Volume.DiscardUnknown(m)
}

var xxx_messageInfo_Volume proto.InternalMessageInfo

func (m *Volume) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Volume) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Artifacts created by the build pipeline.
type Results struct {
	// Container images that were built as a part of the build.
	Images []*BuiltImage `protobuf:"bytes,2,rep,name=images,proto3" json:"images,omitempty"`
	// List of build step digests, in the order corresponding to build step
	// indices.
	BuildStepImages []string `protobuf:"bytes,3,rep,name=build_step_images,json=buildStepImages,proto3" json:"build_step_images,omitempty"`
	// Path to the artifact manifest. Only populated when artifacts are uploaded.
	ArtifactManifest string `protobuf:"bytes,4,opt,name=artifact_manifest,json=artifactManifest,proto3" json:"artifact_manifest,omitempty"`
	// Number of artifacts uploaded. Only populated when artifacts are uploaded.
	NumArtifacts int64 `protobuf:"varint,5,opt,name=num_artifacts,json=numArtifacts,proto3" json:"num_artifacts,omitempty"`
	// List of build step outputs, produced by builder images, in the order
	// corresponding to build step indices.
	//
	// [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
	// can produce this output by writing to `$BUILDER_OUTPUT/output`.
	// Only the first 4KB of data is stored.
	BuildStepOutputs [][]byte `protobuf:"bytes,6,rep,name=build_step_outputs,json=buildStepOutputs,proto3" json:"build_step_outputs,omitempty"`
	// Time to push all non-container artifacts.
	ArtifactTiming       *TimeSpan `protobuf:"bytes,7,opt,name=artifact_timing,json=artifactTiming,proto3" json:"artifact_timing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Results) Reset()         { *m = Results{} }
func (m *Results) String() string { return proto.CompactTextString(m) }
func (*Results) ProtoMessage()    {}
func (*Results) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{8}
}

func (m *Results) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Results.Unmarshal(m, b)
}
func (m *Results) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Results.Marshal(b, m, deterministic)
}
func (m *Results) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Results.Merge(m, src)
}
func (m *Results) XXX_Size() int {
	return xxx_messageInfo_Results.Size(m)
}
func (m *Results) XXX_DiscardUnknown() {
	xxx_messageInfo_Results.DiscardUnknown(m)
}

var xxx_messageInfo_Results proto.InternalMessageInfo

func (m *Results) GetImages() []*BuiltImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Results) GetBuildStepImages() []string {
	if m != nil {
		return m.BuildStepImages
	}
	return nil
}

func (m *Results) GetArtifactManifest() string {
	if m != nil {
		return m.ArtifactManifest
	}
	return ""
}

func (m *Results) GetNumArtifacts() int64 {
	if m != nil {
		return m.NumArtifacts
	}
	return 0
}

func (m *Results) GetBuildStepOutputs() [][]byte {
	if m != nil {
		return m.BuildStepOutputs
	}
	return nil
}

func (m *Results) GetArtifactTiming() *TimeSpan {
	if m != nil {
		return m.ArtifactTiming
	}
	return nil
}

// An artifact that was uploaded during a build. This
// is a single record in the artifact manifest JSON file.
type ArtifactResult struct {
	// The path of an artifact in a Google Cloud Storage bucket, with the
	// generation number. For example,
	// `gs://mybucket/path/to/output.jar#generation`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The file hash of the artifact.
	FileHash             []*FileHashes `protobuf:"bytes,2,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ArtifactResult) Reset()         { *m = ArtifactResult{} }
func (m *ArtifactResult) String() string { return proto.CompactTextString(m) }
func (*ArtifactResult) ProtoMessage()    {}
func (*ArtifactResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{9}
}

func (m *ArtifactResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactResult.Unmarshal(m, b)
}
func (m *ArtifactResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactResult.Marshal(b, m, deterministic)
}
func (m *ArtifactResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactResult.Merge(m, src)
}
func (m *ArtifactResult) XXX_Size() int {
	return xxx_messageInfo_ArtifactResult.Size(m)
}
func (m *ArtifactResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactResult.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactResult proto.InternalMessageInfo

func (m *ArtifactResult) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *ArtifactResult) GetFileHash() []*FileHashes {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// A build resource in the Cloud Build API.
//
// At a high level, a `Build` describes where to find source code, how to build
// it (for example, the builder image to run on the source), and where to store
// the built artifacts.
//
// Fields can include the following variables, which will be expanded when the
// build is created:
//
// - $PROJECT_ID: the project ID of the build.
// - $BUILD_ID: the autogenerated ID of the build.
// - $REPO_NAME: the source repository name specified by RepoSource.
// - $BRANCH_NAME: the branch name specified by RepoSource.
// - $TAG_NAME: the tag name specified by RepoSource.
// - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
//   resolved from the specified branch or tag.
// - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
type Build struct {
	// Output only. Unique identifier of the build.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. ID of the project.
	ProjectId string `protobuf:"bytes,16,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. Status of the build.
	Status Build_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
	// Output only. Customer-readable message about the current status.
	StatusDetail string `protobuf:"bytes,24,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// The location of the source files to build.
	Source *Source `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The operations to be performed on the workspace.
	Steps []*BuildStep `protobuf:"bytes,11,rep,name=steps,proto3" json:"steps,omitempty"`
	// Output only. Results of the build.
	Results *Results `protobuf:"bytes,10,opt,name=results,proto3" json:"results,omitempty"`
	// Output only. Time at which the request to create the build was received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which execution of the build was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time at which execution of the build was finished.
	//
	// The difference between finish_time and start_time is the duration of the
	// build's execution.
	FinishTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	// Amount of time that this build should be allowed to run, to second
	// granularity. If this amount of time elapses, work on the build will cease
	// and the build status will be `TIMEOUT`.
	//
	// Default time is ten minutes.
	Timeout *duration.Duration `protobuf:"bytes,12,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images are pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the `Build` resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build status is marked
	// `FAILURE`.
	Images []string `protobuf:"bytes,13,rep,name=images,proto3" json:"images,omitempty"`
	// Artifacts produced by the build that should be uploaded upon
	// successful completion of all build steps.
	Artifacts *Artifacts `protobuf:"bytes,37,opt,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Google Cloud Storage bucket where logs should be written (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	// Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
	LogsBucket string `protobuf:"bytes,19,opt,name=logs_bucket,json=logsBucket,proto3" json:"logs_bucket,omitempty"`
	// Output only. A permanent fixed identifier for source.
	SourceProvenance *SourceProvenance `protobuf:"bytes,21,opt,name=source_provenance,json=sourceProvenance,proto3" json:"source_provenance,omitempty"`
	// Output only. The ID of the `BuildTrigger` that triggered this build, if it
	// was triggered automatically.
	BuildTriggerId string `protobuf:"bytes,22,opt,name=build_trigger_id,json=buildTriggerId,proto3" json:"build_trigger_id,omitempty"`
	// Special options for this build.
	Options *BuildOptions `protobuf:"bytes,23,opt,name=options,proto3" json:"options,omitempty"`
	// Output only. URL to logs for this build in Google Cloud Console.
	LogUrl string `protobuf:"bytes,25,opt,name=log_url,json=logUrl,proto3" json:"log_url,omitempty"`
	// Substitutions data for `Build` resource.
	Substitutions map[string]string `protobuf:"bytes,29,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tags for annotation of a `Build`. These are not docker tags.
	Tags []string `protobuf:"bytes,31,rep,name=tags,proto3" json:"tags,omitempty"`
	// Secrets to decrypt using Cloud Key Management Service.
	Secrets []*Secret `protobuf:"bytes,32,rep,name=secrets,proto3" json:"secrets,omitempty"`
	// Output only. Stores timing information for phases of the build. Valid keys
	// are:
	//
	// * BUILD: time to execute all build steps
	// * PUSH: time to push all specified images.
	// * FETCHSOURCE: time to fetch source.
	//
	// If the build does not specify source or images,
	// these keys will not be included.
	Timing               map[string]*TimeSpan `protobuf:"bytes,33,rep,name=timing,proto3" json:"timing,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Build) Reset()         { *m = Build{} }
func (m *Build) String() string { return proto.CompactTextString(m) }
func (*Build) ProtoMessage()    {}
func (*Build) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{10}
}

func (m *Build) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Build.Unmarshal(m, b)
}
func (m *Build) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Build.Marshal(b, m, deterministic)
}
func (m *Build) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Build.Merge(m, src)
}
func (m *Build) XXX_Size() int {
	return xxx_messageInfo_Build.Size(m)
}
func (m *Build) XXX_DiscardUnknown() {
	xxx_messageInfo_Build.DiscardUnknown(m)
}

var xxx_messageInfo_Build proto.InternalMessageInfo

func (m *Build) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Build) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Build) GetStatus() Build_Status {
	if m != nil {
		return m.Status
	}
	return Build_STATUS_UNKNOWN
}

func (m *Build) GetStatusDetail() string {
	if m != nil {
		return m.StatusDetail
	}
	return ""
}

func (m *Build) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Build) GetSteps() []*BuildStep {
	if m != nil {
		return m.Steps
	}
	return nil
}

func (m *Build) GetResults() *Results {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *Build) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Build) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Build) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func (m *Build) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *Build) GetImages() []string {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Build) GetArtifacts() *Artifacts {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *Build) GetLogsBucket() string {
	if m != nil {
		return m.LogsBucket
	}
	return ""
}

func (m *Build) GetSourceProvenance() *SourceProvenance {
	if m != nil {
		return m.SourceProvenance
	}
	return nil
}

func (m *Build) GetBuildTriggerId() string {
	if m != nil {
		return m.BuildTriggerId
	}
	return ""
}

func (m *Build) GetOptions() *BuildOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Build) GetLogUrl() string {
	if m != nil {
		return m.LogUrl
	}
	return ""
}

func (m *Build) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

func (m *Build) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Build) GetSecrets() []*Secret {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *Build) GetTiming() map[string]*TimeSpan {
	if m != nil {
		return m.Timing
	}
	return nil
}

// Artifacts produced by a build that should be uploaded upon
// successful completion of all build steps.
type Artifacts struct {
	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images will be pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the Build resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build is marked FAILURE.
	Images []string `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	// A list of objects to be uploaded to Cloud Storage upon successful
	// completion of all build steps.
	//
	// Files in the workspace matching specified paths globs will be uploaded to
	// the specified Cloud Storage location using the builder service account's
	// credentials.
	//
	// The location and generation of the uploaded objects will be stored in the
	// Build resource's results field.
	//
	// If any objects fail to be pushed, the build is marked FAILURE.
	Objects              *Artifacts_ArtifactObjects `protobuf:"bytes,2,opt,name=objects,proto3" json:"objects,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Artifacts) Reset()         { *m = Artifacts{} }
func (m *Artifacts) String() string { return proto.CompactTextString(m) }
func (*Artifacts) ProtoMessage()    {}
func (*Artifacts) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{11}
}

func (m *Artifacts) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifacts.Unmarshal(m, b)
}
func (m *Artifacts) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifacts.Marshal(b, m, deterministic)
}
func (m *Artifacts) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifacts.Merge(m, src)
}
func (m *Artifacts) XXX_Size() int {
	return xxx_messageInfo_Artifacts.Size(m)
}
func (m *Artifacts) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifacts.DiscardUnknown(m)
}

var xxx_messageInfo_Artifacts proto.InternalMessageInfo

func (m *Artifacts) GetImages() []string {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Artifacts) GetObjects() *Artifacts_ArtifactObjects {
	if m != nil {
		return m.Objects
	}
	return nil
}

// Files in the workspace to upload to Cloud Storage upon successful
// completion of all build steps.
type Artifacts_ArtifactObjects struct {
	// Cloud Storage bucket and optional object path, in the form
	// "gs://bucket/path/to/somewhere/". (see [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	//
	// Files in the workspace matching any path pattern will be uploaded to
	// Cloud Storage with this location as a prefix.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Path globs used to match files in the build's workspace.
	Paths []string `protobuf:"bytes,2,rep,name=paths,proto3" json:"paths,omitempty"`
	// Output only. Stores timing information for pushing all artifact objects.
	Timing               *TimeSpan `protobuf:"bytes,3,opt,name=timing,proto3" json:"timing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Artifacts_ArtifactObjects) Reset()         { *m = Artifacts_ArtifactObjects{} }
func (m *Artifacts_ArtifactObjects) String() string { return proto.CompactTextString(m) }
func (*Artifacts_ArtifactObjects) ProtoMessage()    {}
func (*Artifacts_ArtifactObjects) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{11, 0}
}

func (m *Artifacts_ArtifactObjects) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifacts_ArtifactObjects.Unmarshal(m, b)
}
func (m *Artifacts_ArtifactObjects) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifacts_ArtifactObjects.Marshal(b, m, deterministic)
}
func (m *Artifacts_ArtifactObjects) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifacts_ArtifactObjects.Merge(m, src)
}
func (m *Artifacts_ArtifactObjects) XXX_Size() int {
	return xxx_messageInfo_Artifacts_ArtifactObjects.Size(m)
}
func (m *Artifacts_ArtifactObjects) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifacts_ArtifactObjects.DiscardUnknown(m)
}

var xxx_messageInfo_Artifacts_ArtifactObjects proto.InternalMessageInfo

func (m *Artifacts_ArtifactObjects) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Artifacts_ArtifactObjects) GetPaths() []string {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *Artifacts_ArtifactObjects) GetTiming() *TimeSpan {
	if m != nil {
		return m.Timing
	}
	return nil
}

// Start and end times for a build execution phase.
type TimeSpan struct {
	// Start of time span.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of time span.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimeSpan) Reset()         { *m = TimeSpan{} }
func (m *TimeSpan) String() string { return proto.CompactTextString(m) }
func (*TimeSpan) ProtoMessage()    {}
func (*TimeSpan) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{12}
}

func (m *TimeSpan) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeSpan.Unmarshal(m, b)
}
func (m *TimeSpan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeSpan.Marshal(b, m, deterministic)
}
func (m *TimeSpan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSpan.Merge(m, src)
}
func (m *TimeSpan) XXX_Size() int {
	return xxx_messageInfo_TimeSpan.Size(m)
}
func (m *TimeSpan) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSpan.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSpan proto.InternalMessageInfo

func (m *TimeSpan) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimeSpan) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Metadata for build operations.
type BuildOperationMetadata struct {
	// The build that the operation is tracking.
	Build                *Build   `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildOperationMetadata) Reset()         { *m = BuildOperationMetadata{} }
func (m *BuildOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*BuildOperationMetadata) ProtoMessage()    {}
func (*BuildOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{13}
}

func (m *BuildOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildOperationMetadata.Unmarshal(m, b)
}
func (m *BuildOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildOperationMetadata.Marshal(b, m, deterministic)
}
func (m *BuildOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildOperationMetadata.Merge(m, src)
}
func (m *BuildOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_BuildOperationMetadata.Size(m)
}
func (m *BuildOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BuildOperationMetadata proto.InternalMessageInfo

func (m *BuildOperationMetadata) GetBuild() *Build {
	if m != nil {
		return m.Build
	}
	return nil
}

// Provenance of the source. Ways to find the original source, or verify that
// some source was used for this build.
type SourceProvenance struct {
	// A copy of the build's `source.storage_source`, if exists, with any
	// generations resolved.
	ResolvedStorageSource *StorageSource `protobuf:"bytes,3,opt,name=resolved_storage_source,json=resolvedStorageSource,proto3" json:"resolved_storage_source,omitempty"`
	// A copy of the build's `source.repo_source`, if exists, with any
	// revisions resolved.
	ResolvedRepoSource *RepoSource `protobuf:"bytes,6,opt,name=resolved_repo_source,json=resolvedRepoSource,proto3" json:"resolved_repo_source,omitempty"`
	// Output only. Hash(es) of the build source, which can be used to verify that
	// the original source integrity was maintained in the build. Note that
	// `FileHashes` will only be populated if `BuildOptions` has requested a
	// `SourceProvenanceHash`.
	//
	// The keys to this map are file paths used as build source and the values
	// contain the hash values for those files.
	//
	// If the build source came in a single package such as a gzipped tarfile
	// (`.tar.gz`), the `FileHash` will be for the single path to that file.
	FileHashes           map[string]*FileHashes `protobuf:"bytes,4,rep,name=file_hashes,json=fileHashes,proto3" json:"file_hashes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *SourceProvenance) Reset()         { *m = SourceProvenance{} }
func (m *SourceProvenance) String() string { return proto.CompactTextString(m) }
func (*SourceProvenance) ProtoMessage()    {}
func (*SourceProvenance) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{14}
}

func (m *SourceProvenance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceProvenance.Unmarshal(m, b)
}
func (m *SourceProvenance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceProvenance.Marshal(b, m, deterministic)
}
func (m *SourceProvenance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceProvenance.Merge(m, src)
}
func (m *SourceProvenance) XXX_Size() int {
	return xxx_messageInfo_SourceProvenance.Size(m)
}
func (m *SourceProvenance) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceProvenance.DiscardUnknown(m)
}

var xxx_messageInfo_SourceProvenance proto.InternalMessageInfo

func (m *SourceProvenance) GetResolvedStorageSource() *StorageSource {
	if m != nil {
		return m.ResolvedStorageSource
	}
	return nil
}

func (m *SourceProvenance) GetResolvedRepoSource() *RepoSource {
	if m != nil {
		return m.ResolvedRepoSource
	}
	return nil
}

func (m *SourceProvenance) GetFileHashes() map[string]*FileHashes {
	if m != nil {
		return m.FileHashes
	}
	return nil
}

// Container message for hashes of byte content of files, used in
// SourceProvenance messages to verify integrity of source input to the build.
type FileHashes struct {
	// Collection of file hashes.
	FileHash             []*Hash  `protobuf:"bytes,1,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileHashes) Reset()         { *m = FileHashes{} }
func (m *FileHashes) String() string { return proto.CompactTextString(m) }
func (*FileHashes) ProtoMessage()    {}
func (*FileHashes) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{15}
}

func (m *FileHashes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileHashes.Unmarshal(m, b)
}
func (m *FileHashes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileHashes.Marshal(b, m, deterministic)
}
func (m *FileHashes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileHashes.Merge(m, src)
}
func (m *FileHashes) XXX_Size() int {
	return xxx_messageInfo_FileHashes.Size(m)
}
func (m *FileHashes) XXX_DiscardUnknown() {
	xxx_messageInfo_FileHashes.DiscardUnknown(m)
}

var xxx_messageInfo_FileHashes proto.InternalMessageInfo

func (m *FileHashes) GetFileHash() []*Hash {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// Container message for hash values.
type Hash struct {
	// The type of hash that was performed.
	Type Hash_HashType `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"type,omitempty"`
	// The hash value.
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Hash) Reset()         { *m = Hash{} }
func (m *Hash) String() string { return proto.CompactTextString(m) }
func (*Hash) ProtoMessage()    {}
func (*Hash) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{16}
}

func (m *Hash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Hash.Unmarshal(m, b)
}
func (m *Hash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Hash.Marshal(b, m, deterministic)
}
func (m *Hash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hash.Merge(m, src)
}
func (m *Hash) XXX_Size() int {
	return xxx_messageInfo_Hash.Size(m)
}
func (m *Hash) XXX_DiscardUnknown() {
	xxx_messageInfo_Hash.DiscardUnknown(m)
}

var xxx_messageInfo_Hash proto.InternalMessageInfo

func (m *Hash) GetType() Hash_HashType {
	if m != nil {
		return m.Type
	}
	return Hash_NONE
}

func (m *Hash) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// Pairs a set of secret environment variables containing encrypted
// values with the Cloud KMS key to use to decrypt the value.
type Secret struct {
	// Cloud KMS key name to use to decrypt these envs.
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Map of environment variable name to its encrypted value.
	//
	// Secret environment variables must be unique across all of a build's
	// secrets, and must be used by at least one build step. Values can be at most
	// 64 KB in size. There can be at most 100 secret values across all of a
	// build's secrets.
	SecretEnv            map[string][]byte `protobuf:"bytes,3,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{17}
}

func (m *Secret) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Secret.Unmarshal(m, b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return xxx_messageInfo_Secret.Size(m)
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

func (m *Secret) GetKmsKeyName() string {
	if m != nil {
		return m.KmsKeyName
	}
	return ""
}

func (m *Secret) GetSecretEnv() map[string][]byte {
	if m != nil {
		return m.SecretEnv
	}
	return nil
}

// Request to create a new build.
type CreateBuildRequest struct {
	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Build resource to create.
	Build                *Build   `protobuf:"bytes,2,opt,name=build,proto3" json:"build,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateBuildRequest) Reset()         { *m = CreateBuildRequest{} }
func (m *CreateBuildRequest) String() string { return proto.CompactTextString(m) }
func (*CreateBuildRequest) ProtoMessage()    {}
func (*CreateBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{18}
}

func (m *CreateBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBuildRequest.Unmarshal(m, b)
}
func (m *CreateBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBuildRequest.Marshal(b, m, deterministic)
}
func (m *CreateBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBuildRequest.Merge(m, src)
}
func (m *CreateBuildRequest) XXX_Size() int {
	return xxx_messageInfo_CreateBuildRequest.Size(m)
}
func (m *CreateBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBuildRequest proto.InternalMessageInfo

func (m *CreateBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateBuildRequest) GetBuild() *Build {
	if m != nil {
		return m.Build
	}
	return nil
}

// Request to get a build.
type GetBuildRequest struct {
	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the build.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBuildRequest) Reset()         { *m = GetBuildRequest{} }
func (m *GetBuildRequest) String() string { return proto.CompactTextString(m) }
func (*GetBuildRequest) ProtoMessage()    {}
func (*GetBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{19}
}

func (m *GetBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBuildRequest.Unmarshal(m, b)
}
func (m *GetBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBuildRequest.Marshal(b, m, deterministic)
}
func (m *GetBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBuildRequest.Merge(m, src)
}
func (m *GetBuildRequest) XXX_Size() int {
	return xxx_messageInfo_GetBuildRequest.Size(m)
}
func (m *GetBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBuildRequest proto.InternalMessageInfo

func (m *GetBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Request to list builds.
type ListBuildsRequest struct {
	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The raw filter text to constrain the results.
	Filter               string   `protobuf:"bytes,8,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildsRequest) Reset()         { *m = ListBuildsRequest{} }
func (m *ListBuildsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBuildsRequest) ProtoMessage()    {}
func (*ListBuildsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{20}
}

func (m *ListBuildsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsRequest.Unmarshal(m, b)
}
func (m *ListBuildsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsRequest.Marshal(b, m, deterministic)
}
func (m *ListBuildsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsRequest.Merge(m, src)
}
func (m *ListBuildsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBuildsRequest.Size(m)
}
func (m *ListBuildsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsRequest proto.InternalMessageInfo

func (m *ListBuildsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListBuildsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBuildsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBuildsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response including listed builds.
type ListBuildsResponse struct {
	// Builds will be sorted by `create_time`, descending.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds,proto3" json:"builds,omitempty"`
	// Token to receive the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildsResponse) Reset()         { *m = ListBuildsResponse{} }
func (m *ListBuildsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBuildsResponse) ProtoMessage()    {}
func (*ListBuildsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{21}
}

func (m *ListBuildsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsResponse.Unmarshal(m, b)
}
func (m *ListBuildsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsResponse.Marshal(b, m, deterministic)
}
func (m *ListBuildsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsResponse.Merge(m, src)
}
func (m *ListBuildsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBuildsResponse.Size(m)
}
func (m *ListBuildsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsResponse proto.InternalMessageInfo

func (m *ListBuildsResponse) GetBuilds() []*Build {
	if m != nil {
		return m.Builds
	}
	return nil
}

func (m *ListBuildsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to cancel an ongoing build.
type CancelBuildRequest struct {
	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the build.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelBuildRequest) Reset()         { *m = CancelBuildRequest{} }
func (m *CancelBuildRequest) String() string { return proto.CompactTextString(m) }
func (*CancelBuildRequest) ProtoMessage()    {}
func (*CancelBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{22}
}

func (m *CancelBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelBuildRequest.Unmarshal(m, b)
}
func (m *CancelBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelBuildRequest.Marshal(b, m, deterministic)
}
func (m *CancelBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelBuildRequest.Merge(m, src)
}
func (m *CancelBuildRequest) XXX_Size() int {
	return xxx_messageInfo_CancelBuildRequest.Size(m)
}
func (m *CancelBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelBuildRequest proto.InternalMessageInfo

func (m *CancelBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Configuration for an automated build in response to source repository
// changes.
type BuildTrigger struct {
	// Output only. Unique identifier of the trigger.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human-readable description of this trigger.
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// User-assigned name of the trigger. Must be unique within the project.
	// Trigger names must meet the following requirements:
	//
	// + They must contain only alphanumeric characters and dashes.
	// + They can be 1-64 characters long.
	// + They must begin and end with an alphanumeric character.
	Name string `protobuf:"bytes,21,opt,name=name,proto3" json:"name,omitempty"`
	// Tags for annotation of a `BuildTrigger`
	Tags []string `protobuf:"bytes,19,rep,name=tags,proto3" json:"tags,omitempty"`
	// Template describing the types of source changes to trigger a build.
	//
	// Branch and tag names in trigger templates are interpreted as regular
	// expressions. Any branch or tag change that matches that regular expression
	// will trigger a build.
	//
	// Mutually exclusive with `github`.
	TriggerTemplate *RepoSource `protobuf:"bytes,7,opt,name=trigger_template,json=triggerTemplate,proto3" json:"trigger_template,omitempty"`
	// GitHubEventsConfig describes the configuration of a trigger that creates
	// a build whenever a GitHub event is received.
	//
	// Mutually exclusive with `trigger_template`.
	Github *GitHubEventsConfig `protobuf:"bytes,13,opt,name=github,proto3" json:"github,omitempty"`
	// Template describing the Build request to make when the trigger is matched.
	//
	// Types that are valid to be assigned to BuildTemplate:
	//	*BuildTrigger_Build
	//	*BuildTrigger_Filename
	BuildTemplate isBuildTrigger_BuildTemplate `protobuf_oneof:"build_template"`
	// Output only. Time when the trigger was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// If true, the trigger will never result in a build.
	Disabled bool `protobuf:"varint,9,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Substitutions data for Build resource.
	Substitutions map[string]string `protobuf:"bytes,11,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ignored_files and included_files are file glob matches using
	// https://golang.org/pkg/path/filepath/#Match extended with support for "**".
	//
	// If ignored_files and changed files are both empty, then they are
	// not used to determine whether or not to trigger a build.
	//
	// If ignored_files is not empty, then we ignore any files that match
	// any of the ignored_file globs. If the change has no files that are
	// outside of the ignored_files globs, then we do not trigger a build.
	IgnoredFiles []string `protobuf:"bytes,15,rep,name=ignored_files,json=ignoredFiles,proto3" json:"ignored_files,omitempty"`
	// If any of the files altered in the commit pass the ignored_files
	// filter and included_files is empty, then as far as this filter is
	// concerned, we should trigger the build.
	//
	// If any of the files altered in the commit pass the ignored_files
	// filter and included_files is not empty, then we make sure that at
	// least one of those files matches a included_files glob. If not,
	// then we do not trigger a build.
	IncludedFiles        []string `protobuf:"bytes,16,rep,name=included_files,json=includedFiles,proto3" json:"included_files,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildTrigger) Reset()         { *m = BuildTrigger{} }
func (m *BuildTrigger) String() string { return proto.CompactTextString(m) }
func (*BuildTrigger) ProtoMessage()    {}
func (*BuildTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{23}
}

func (m *BuildTrigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildTrigger.Unmarshal(m, b)
}
func (m *BuildTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildTrigger.Marshal(b, m, deterministic)
}
func (m *BuildTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildTrigger.Merge(m, src)
}
func (m *BuildTrigger) XXX_Size() int {
	return xxx_messageInfo_BuildTrigger.Size(m)
}
func (m *BuildTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_BuildTrigger proto.InternalMessageInfo

func (m *BuildTrigger) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildTrigger) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *BuildTrigger) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuildTrigger) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *BuildTrigger) GetTriggerTemplate() *RepoSource {
	if m != nil {
		return m.TriggerTemplate
	}
	return nil
}

func (m *BuildTrigger) GetGithub() *GitHubEventsConfig {
	if m != nil {
		return m.Github
	}
	return nil
}

type isBuildTrigger_BuildTemplate interface {
	isBuildTrigger_BuildTemplate()
}

type BuildTrigger_Build struct {
	Build *Build `protobuf:"bytes,4,opt,name=build,proto3,oneof"`
}

type BuildTrigger_Filename struct {
	Filename string `protobuf:"bytes,8,opt,name=filename,proto3,oneof"`
}

func (*BuildTrigger_Build) isBuildTrigger_BuildTemplate() {}

func (*BuildTrigger_Filename) isBuildTrigger_BuildTemplate() {}

func (m *BuildTrigger) GetBuildTemplate() isBuildTrigger_BuildTemplate {
	if m != nil {
		return m.BuildTemplate
	}
	return nil
}

func (m *BuildTrigger) GetBuild() *Build {
	if x, ok := m.GetBuildTemplate().(*BuildTrigger_Build); ok {
		return x.Build
	}
	return nil
}

func (m *BuildTrigger) GetFilename() string {
	if x, ok := m.GetBuildTemplate().(*BuildTrigger_Filename); ok {
		return x.Filename
	}
	return ""
}

func (m *BuildTrigger) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *BuildTrigger) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *BuildTrigger) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

func (m *BuildTrigger) GetIgnoredFiles() []string {
	if m != nil {
		return m.IgnoredFiles
	}
	return nil
}

func (m *BuildTrigger) GetIncludedFiles() []string {
	if m != nil {
		return m.IncludedFiles
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BuildTrigger) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BuildTrigger_Build)(nil),
		(*BuildTrigger_Filename)(nil),
	}
}

// GitHubEventsConfig describes the configuration of a trigger that creates a
// build whenever a GitHub event is received.
//
// This message is experimental.
type GitHubEventsConfig struct {
	// The installationID that emits the GitHub event.
	InstallationId int64 `protobuf:"varint,1,opt,name=installation_id,json=installationId,proto3" json:"installation_id,omitempty"` // Deprecated: Do not use.
	// Owner of the repository. For example: The owner for
	// https://github.com/googlecloudplatform/cloud-builders is
	// "googlecloudplatform".
	Owner string `protobuf:"bytes,6,opt,name=owner,proto3" json:"owner,omitempty"`
	// Name of the repository. For example: The name for
	// https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// Filter describing the types of events to trigger a build.
	// Currently supported event types: push, pull_request.
	//
	// Types that are valid to be assigned to Event:
	//	*GitHubEventsConfig_PullRequest
	//	*GitHubEventsConfig_Push
	Event                isGitHubEventsConfig_Event `protobuf_oneof:"event"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *GitHubEventsConfig) Reset()         { *m = GitHubEventsConfig{} }
func (m *GitHubEventsConfig) String() string { return proto.CompactTextString(m) }
func (*GitHubEventsConfig) ProtoMessage()    {}
func (*GitHubEventsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{24}
}

func (m *GitHubEventsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GitHubEventsConfig.Unmarshal(m, b)
}
func (m *GitHubEventsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GitHubEventsConfig.Marshal(b, m, deterministic)
}
func (m *GitHubEventsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitHubEventsConfig.Merge(m, src)
}
func (m *GitHubEventsConfig) XXX_Size() int {
	return xxx_messageInfo_GitHubEventsConfig.Size(m)
}
func (m *GitHubEventsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GitHubEventsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GitHubEventsConfig proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GitHubEventsConfig) GetInstallationId() int64 {
	if m != nil {
		return m.InstallationId
	}
	return 0
}

func (m *GitHubEventsConfig) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GitHubEventsConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isGitHubEventsConfig_Event interface {
	isGitHubEventsConfig_Event()
}

type GitHubEventsConfig_PullRequest struct {
	PullRequest *PullRequestFilter `protobuf:"bytes,4,opt,name=pull_request,json=pullRequest,proto3,oneof"`
}

type GitHubEventsConfig_Push struct {
	Push *PushFilter `protobuf:"bytes,5,opt,name=push,proto3,oneof"`
}

func (*GitHubEventsConfig_PullRequest) isGitHubEventsConfig_Event() {}

func (*GitHubEventsConfig_Push) isGitHubEventsConfig_Event() {}

func (m *GitHubEventsConfig) GetEvent() isGitHubEventsConfig_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *GitHubEventsConfig) GetPullRequest() *PullRequestFilter {
	if x, ok := m.GetEvent().(*GitHubEventsConfig_PullRequest); ok {
		return x.PullRequest
	}
	return nil
}

func (m *GitHubEventsConfig) GetPush() *PushFilter {
	if x, ok := m.GetEvent().(*GitHubEventsConfig_Push); ok {
		return x.Push
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GitHubEventsConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GitHubEventsConfig_PullRequest)(nil),
		(*GitHubEventsConfig_Push)(nil),
	}
}

// PullRequestFilter contains filter properties for matching GitHub Pull
// Requests.
type PullRequestFilter struct {
	// Target refs to match.
	// A target ref is the git reference where the pull request will be applied.
	//
	// Types that are valid to be assigned to GitRef:
	//	*PullRequestFilter_Branch
	GitRef isPullRequestFilter_GitRef `protobuf_oneof:"git_ref"`
	// Whether to block builds on a "/gcbrun" comment from a repository admin or
	// collaborator.
	CommentControl PullRequestFilter_CommentControl `protobuf:"varint,5,opt,name=comment_control,json=commentControl,proto3,enum=google.devtools.cloudbuild.v1.PullRequestFilter_CommentControl" json:"comment_control,omitempty"`
	// If true, branches that do NOT match the git_ref will trigger a build.
	InvertRegex          bool     `protobuf:"varint,6,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PullRequestFilter) Reset()         { *m = PullRequestFilter{} }
func (m *PullRequestFilter) String() string { return proto.CompactTextString(m) }
func (*PullRequestFilter) ProtoMessage()    {}
func (*PullRequestFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{25}
}

func (m *PullRequestFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullRequestFilter.Unmarshal(m, b)
}
func (m *PullRequestFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullRequestFilter.Marshal(b, m, deterministic)
}
func (m *PullRequestFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullRequestFilter.Merge(m, src)
}
func (m *PullRequestFilter) XXX_Size() int {
	return xxx_messageInfo_PullRequestFilter.Size(m)
}
func (m *PullRequestFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PullRequestFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PullRequestFilter proto.InternalMessageInfo

type isPullRequestFilter_GitRef interface {
	isPullRequestFilter_GitRef()
}

type PullRequestFilter_Branch struct {
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3,oneof"`
}

func (*PullRequestFilter_Branch) isPullRequestFilter_GitRef() {}

func (m *PullRequestFilter) GetGitRef() isPullRequestFilter_GitRef {
	if m != nil {
		return m.GitRef
	}
	return nil
}

func (m *PullRequestFilter) GetBranch() string {
	if x, ok := m.GetGitRef().(*PullRequestFilter_Branch); ok {
		return x.Branch
	}
	return ""
}

func (m *PullRequestFilter) GetCommentControl() PullRequestFilter_CommentControl {
	if m != nil {
		return m.CommentControl
	}
	return PullRequestFilter_COMMENTS_DISABLED
}

func (m *PullRequestFilter) GetInvertRegex() bool {
	if m != nil {
		return m.InvertRegex
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PullRequestFilter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PullRequestFilter_Branch)(nil),
	}
}

// Push contains filter properties for matching GitHub git pushes.
type PushFilter struct {
	// Modified refs to match.
	// A modified refs are the refs modified by a git push operation.
	//
	// Types that are valid to be assigned to GitRef:
	//	*PushFilter_Branch
	//	*PushFilter_Tag
	GitRef isPushFilter_GitRef `protobuf_oneof:"git_ref"`
	// When true, only trigger a build if the revision regex does NOT match the
	// git_ref regex.
	InvertRegex          bool     `protobuf:"varint,4,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushFilter) Reset()         { *m = PushFilter{} }
func (m *PushFilter) String() string { return proto.CompactTextString(m) }
func (*PushFilter) ProtoMessage()    {}
func (*PushFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{26}
}

func (m *PushFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PushFilter.Unmarshal(m, b)
}
func (m *PushFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PushFilter.Marshal(b, m, deterministic)
}
func (m *PushFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushFilter.Merge(m, src)
}
func (m *PushFilter) XXX_Size() int {
	return xxx_messageInfo_PushFilter.Size(m)
}
func (m *PushFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PushFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PushFilter proto.InternalMessageInfo

type isPushFilter_GitRef interface {
	isPushFilter_GitRef()
}

type PushFilter_Branch struct {
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3,oneof"`
}

type PushFilter_Tag struct {
	Tag string `protobuf:"bytes,3,opt,name=tag,proto3,oneof"`
}

func (*PushFilter_Branch) isPushFilter_GitRef() {}

func (*PushFilter_Tag) isPushFilter_GitRef() {}

func (m *PushFilter) GetGitRef() isPushFilter_GitRef {
	if m != nil {
		return m.GitRef
	}
	return nil
}

func (m *PushFilter) GetBranch() string {
	if x, ok := m.GetGitRef().(*PushFilter_Branch); ok {
		return x.Branch
	}
	return ""
}

func (m *PushFilter) GetTag() string {
	if x, ok := m.GetGitRef().(*PushFilter_Tag); ok {
		return x.Tag
	}
	return ""
}

func (m *PushFilter) GetInvertRegex() bool {
	if m != nil {
		return m.InvertRegex
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PushFilter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PushFilter_Branch)(nil),
		(*PushFilter_Tag)(nil),
	}
}

// Request to create a new `BuildTrigger`.
type CreateBuildTriggerRequest struct {
	// Required. ID of the project for which to configure automatic builds.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. `BuildTrigger` to create.
	Trigger              *BuildTrigger `protobuf:"bytes,2,opt,name=trigger,proto3" json:"trigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateBuildTriggerRequest) Reset()         { *m = CreateBuildTriggerRequest{} }
func (m *CreateBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*CreateBuildTriggerRequest) ProtoMessage()    {}
func (*CreateBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{27}
}

func (m *CreateBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBuildTriggerRequest.Unmarshal(m, b)
}
func (m *CreateBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *CreateBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBuildTriggerRequest.Merge(m, src)
}
func (m *CreateBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_CreateBuildTriggerRequest.Size(m)
}
func (m *CreateBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBuildTriggerRequest proto.InternalMessageInfo

func (m *CreateBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// Returns the `BuildTrigger` with the specified ID.
type GetBuildTriggerRequest struct {
	// Required. ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Identifier (`id` or `name`) of the `BuildTrigger` to get.
	TriggerId            string   `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBuildTriggerRequest) Reset()         { *m = GetBuildTriggerRequest{} }
func (m *GetBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*GetBuildTriggerRequest) ProtoMessage()    {}
func (*GetBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{28}
}

func (m *GetBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBuildTriggerRequest.Unmarshal(m, b)
}
func (m *GetBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *GetBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBuildTriggerRequest.Merge(m, src)
}
func (m *GetBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_GetBuildTriggerRequest.Size(m)
}
func (m *GetBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBuildTriggerRequest proto.InternalMessageInfo

func (m *GetBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request to list existing `BuildTriggers`.
type ListBuildTriggersRequest struct {
	// Required. ID of the project for which to list BuildTriggers.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildTriggersRequest) Reset()         { *m = ListBuildTriggersRequest{} }
func (m *ListBuildTriggersRequest) String() string { return proto.CompactTextString(m) }
func (*ListBuildTriggersRequest) ProtoMessage()    {}
func (*ListBuildTriggersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{29}
}

func (m *ListBuildTriggersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildTriggersRequest.Unmarshal(m, b)
}
func (m *ListBuildTriggersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildTriggersRequest.Marshal(b, m, deterministic)
}
func (m *ListBuildTriggersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildTriggersRequest.Merge(m, src)
}
func (m *ListBuildTriggersRequest) XXX_Size() int {
	return xxx_messageInfo_ListBuildTriggersRequest.Size(m)
}
func (m *ListBuildTriggersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildTriggersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildTriggersRequest proto.InternalMessageInfo

func (m *ListBuildTriggersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListBuildTriggersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBuildTriggersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response containing existing `BuildTriggers`.
type ListBuildTriggersResponse struct {
	// `BuildTriggers` for the project, sorted by `create_time` descending.
	Triggers []*BuildTrigger `protobuf:"bytes,1,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Token to receive the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildTriggersResponse) Reset()         { *m = ListBuildTriggersResponse{} }
func (m *ListBuildTriggersResponse) String() string { return proto.CompactTextString(m) }
func (*ListBuildTriggersResponse) ProtoMessage()    {}
func (*ListBuildTriggersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{30}
}

func (m *ListBuildTriggersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildTriggersResponse.Unmarshal(m, b)
}
func (m *ListBuildTriggersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildTriggersResponse.Marshal(b, m, deterministic)
}
func (m *ListBuildTriggersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildTriggersResponse.Merge(m, src)
}
func (m *ListBuildTriggersResponse) XXX_Size() int {
	return xxx_messageInfo_ListBuildTriggersResponse.Size(m)
}
func (m *ListBuildTriggersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildTriggersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildTriggersResponse proto.InternalMessageInfo

func (m *ListBuildTriggersResponse) GetTriggers() []*BuildTrigger {
	if m != nil {
		return m.Triggers
	}
	return nil
}

func (m *ListBuildTriggersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a `BuildTrigger`.
type DeleteBuildTriggerRequest struct {
	// Required. ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the `BuildTrigger` to delete.
	TriggerId            string   `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteBuildTriggerRequest) Reset()         { *m = DeleteBuildTriggerRequest{} }
func (m *DeleteBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteBuildTriggerRequest) ProtoMessage()    {}
func (*DeleteBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{31}
}

func (m *DeleteBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteBuildTriggerRequest.Unmarshal(m, b)
}
func (m *DeleteBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *DeleteBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteBuildTriggerRequest.Merge(m, src)
}
func (m *DeleteBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteBuildTriggerRequest.Size(m)
}
func (m *DeleteBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteBuildTriggerRequest proto.InternalMessageInfo

func (m *DeleteBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request to update an existing `BuildTrigger`.
type UpdateBuildTriggerRequest struct {
	// Required. ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the `BuildTrigger` to update.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Required. `BuildTrigger` to update.
	Trigger              *BuildTrigger `protobuf:"bytes,3,opt,name=trigger,proto3" json:"trigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpdateBuildTriggerRequest) Reset()         { *m = UpdateBuildTriggerRequest{} }
func (m *UpdateBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBuildTriggerRequest) ProtoMessage()    {}
func (*UpdateBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{32}
}

func (m *UpdateBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBuildTriggerRequest.Unmarshal(m, b)
}
func (m *UpdateBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBuildTriggerRequest.Merge(m, src)
}
func (m *UpdateBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBuildTriggerRequest.Size(m)
}
func (m *UpdateBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBuildTriggerRequest proto.InternalMessageInfo

func (m *UpdateBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *UpdateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// Optional arguments to enable specific features of builds.
type BuildOptions struct {
	// Requested hash for SourceProvenance.
	SourceProvenanceHash []Hash_HashType `protobuf:"varint,1,rep,packed,name=source_provenance_hash,json=sourceProvenanceHash,proto3,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"source_provenance_hash,omitempty"`
	// Requested verifiability options.
	RequestedVerifyOption BuildOptions_VerifyOption `protobuf:"varint,2,opt,name=requested_verify_option,json=requestedVerifyOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_VerifyOption" json:"requested_verify_option,omitempty"`
	// Compute Engine machine type on which to run the build.
	MachineType BuildOptions_MachineType `protobuf:"varint,3,opt,name=machine_type,json=machineType,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_MachineType" json:"machine_type,omitempty"`
	// Requested disk size for the VM that runs the build. Note that this is *NOT*
	// "disk free"; some of the space will be used by the operating system and
	// build utilities. Also note that this is the minimum disk size that will be
	// allocated for the build -- the build may run with a larger disk than
	// requested. At present, the maximum disk size is 1000GB; builds that request
	// more than the maximum are rejected with an error.
	DiskSizeGb int64 `protobuf:"varint,6,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Option to specify behavior when there is an error in the substitution
	// checks.
	SubstitutionOption BuildOptions_SubstitutionOption `protobuf:"varint,4,opt,name=substitution_option,json=substitutionOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption" json:"substitution_option,omitempty"`
	// Option to define build log streaming behavior to Google Cloud
	// Storage.
	LogStreamingOption BuildOptions_LogStreamingOption `protobuf:"varint,5,opt,name=log_streaming_option,json=logStreamingOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_LogStreamingOption" json:"log_streaming_option,omitempty"`
	// Option to specify a `WorkerPool` for the build.
	// Format: projects/{project}/workerPools/{workerPool}
	//
	// This field is experimental.
	WorkerPool string `protobuf:"bytes,7,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Option to specify the logging mode, which determines where the logs are
	// stored.
	Logging BuildOptions_LoggingMode `protobuf:"varint,11,opt,name=logging,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_LoggingMode" json:"logging,omitempty"`
	// A list of global environment variable definitions that will exist for all
	// build steps in this build. If a variable is defined in both globally and in
	// a build step, the variable will use the build step value.
	//
	// The elements are of the form "KEY=VALUE" for the environment variable "KEY"
	// being given the value "VALUE".
	Env []string `protobuf:"bytes,12,rep,name=env,proto3" json:"env,omitempty"`
	// A list of global environment variables, which are encrypted using a Cloud
	// Key Management Service crypto key. These values must be specified in the
	// build's `Secret`. These variables will be available to all build steps
	// in this build.
	SecretEnv []string `protobuf:"bytes,13,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
	// Global list of volumes to mount for ALL build steps
	//
	// Each volume is created as an empty volume prior to starting the build
	// process. Upon completion of the build, volumes and their contents are
	// discarded. Global volume names and paths cannot conflict with the volumes
	// defined a build step.
	//
	// Using a global volume in a build with only one step is not valid as
	// it is indicative of a build request with an incorrect configuration.
	Volumes              []*Volume `protobuf:"bytes,14,rep,name=volumes,proto3" json:"volumes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BuildOptions) Reset()         { *m = BuildOptions{} }
func (m *BuildOptions) String() string { return proto.CompactTextString(m) }
func (*BuildOptions) ProtoMessage()    {}
func (*BuildOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{33}
}

func (m *BuildOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildOptions.Unmarshal(m, b)
}
func (m *BuildOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildOptions.Marshal(b, m, deterministic)
}
func (m *BuildOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildOptions.Merge(m, src)
}
func (m *BuildOptions) XXX_Size() int {
	return xxx_messageInfo_BuildOptions.Size(m)
}
func (m *BuildOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildOptions.DiscardUnknown(m)
}

var xxx_messageInfo_BuildOptions proto.InternalMessageInfo

func (m *BuildOptions) GetSourceProvenanceHash() []Hash_HashType {
	if m != nil {
		return m.SourceProvenanceHash
	}
	return nil
}

func (m *BuildOptions) GetRequestedVerifyOption() BuildOptions_VerifyOption {
	if m != nil {
		return m.RequestedVerifyOption
	}
	return BuildOptions_NOT_VERIFIED
}

func (m *BuildOptions) GetMachineType() BuildOptions_MachineType {
	if m != nil {
		return m.MachineType
	}
	return BuildOptions_UNSPECIFIED
}

func (m *BuildOptions) GetDiskSizeGb() int64 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *BuildOptions) GetSubstitutionOption() BuildOptions_SubstitutionOption {
	if m != nil {
		return m.SubstitutionOption
	}
	return BuildOptions_MUST_MATCH
}

func (m *BuildOptions) GetLogStreamingOption() BuildOptions_LogStreamingOption {
	if m != nil {
		return m.LogStreamingOption
	}
	return BuildOptions_STREAM_DEFAULT
}

func (m *BuildOptions) GetWorkerPool() string {
	if m != nil {
		return m.WorkerPool
	}
	return ""
}

func (m *BuildOptions) GetLogging() BuildOptions_LoggingMode {
	if m != nil {
		return m.Logging
	}
	return BuildOptions_LOGGING_UNSPECIFIED
}

func (m *BuildOptions) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *BuildOptions) GetSecretEnv() []string {
	if m != nil {
		return m.SecretEnv
	}
	return nil
}

func (m *BuildOptions) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

// Configuration for a WorkerPool to run the builds.
//
// Workers are machines that Cloud Build uses to run your builds. By default,
// all workers run in a project owned by Cloud Build. To have full control over
// the workers that execute your builds -- such as enabling them to access
// private resources on your private network -- you can request Cloud Build to
// run the workers in your own project by creating a custom workers pool.
type WorkerPool struct {
	// User-defined name of the `WorkerPool`.
	Name string `protobuf:"bytes,14,opt,name=name,proto3" json:"name,omitempty"`
	// The project ID of the GCP project for which the `WorkerPool` is created.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. The service account used to manage the `WorkerPool`. The
	// service account must have the Compute Instance Admin (Beta) permission at
	// the project level.
	ServiceAccountEmail string `protobuf:"bytes,3,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Total number of workers to be created across all requested regions.
	WorkerCount int64 `protobuf:"varint,4,opt,name=worker_count,json=workerCount,proto3" json:"worker_count,omitempty"`
	// Configuration to be used for a creating workers in the `WorkerPool`.
	WorkerConfig *WorkerConfig `protobuf:"bytes,16,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// List of regions to create the `WorkerPool`. Regions can't be empty.
	// If Cloud Build adds a new GCP region in the future, the existing
	// `WorkerPool` will not be enabled in the new region automatically;
	// you must add the new region to the `regions` field to enable the
	// `WorkerPool` in that region.
	Regions []WorkerPool_Region `protobuf:"varint,9,rep,packed,name=regions,proto3,enum=google.devtools.cloudbuild.v1.WorkerPool_Region" json:"regions,omitempty"`
	// Output only. Time at which the request to create the `WorkerPool` was
	// received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the request to update the `WorkerPool` was
	// received.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,17,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time at which the request to delete the `WorkerPool` was
	// received.
	DeleteTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. WorkerPool Status.
	Status               WorkerPool_Status `protobuf:"varint,13,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.WorkerPool_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *WorkerPool) Reset()         { *m = WorkerPool{} }
func (m *WorkerPool) String() string { return proto.CompactTextString(m) }
func (*WorkerPool) ProtoMessage()    {}
func (*WorkerPool) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{34}
}

func (m *WorkerPool) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkerPool.Unmarshal(m, b)
}
func (m *WorkerPool) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkerPool.Marshal(b, m, deterministic)
}
func (m *WorkerPool) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerPool.Merge(m, src)
}
func (m *WorkerPool) XXX_Size() int {
	return xxx_messageInfo_WorkerPool.Size(m)
}
func (m *WorkerPool) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerPool.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerPool proto.InternalMessageInfo

func (m *WorkerPool) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WorkerPool) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *WorkerPool) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *WorkerPool) GetWorkerCount() int64 {
	if m != nil {
		return m.WorkerCount
	}
	return 0
}

func (m *WorkerPool) GetWorkerConfig() *WorkerConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *WorkerPool) GetRegions() []WorkerPool_Region {
	if m != nil {
		return m.Regions
	}
	return nil
}

func (m *WorkerPool) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *WorkerPool) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *WorkerPool) GetDeleteTime() *timestamp.Timestamp {
	if m != nil {
		return m.DeleteTime
	}
	return nil
}

func (m *WorkerPool) GetStatus() WorkerPool_Status {
	if m != nil {
		return m.Status
	}
	return WorkerPool_STATUS_UNSPECIFIED
}

// WorkerConfig defines the configuration to be used for a creating workers in
// the pool.
type WorkerConfig struct {
	// Machine Type of the worker, such as n1-standard-1.
	// See https://cloud.google.com/compute/docs/machine-types.
	// If left blank, Cloud Build will use a standard unspecified machine to
	// create the worker pool.
	// `machine_type` is overridden if you specify a different machine type in
	// `build_options`. In this case, the VM specified in the `build_options`
	// will be created on demand at build time. For more information see
	// https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Size of the disk attached to the worker, in GB.
	// See https://cloud.google.com/compute/docs/disks/
	// If `0` is specified, Cloud Build will use a standard disk size.
	// `disk_size` is overridden if you specify a different disk size in
	// `build_options`. In this case, a VM with a disk size specified in the
	// `build_options` will be created on demand at build time. For more
	// information see
	// https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
	DiskSizeGb int64 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The network definition used to create the worker.
	// If this section is left empty, the workers will be created in
	// WorkerPool.project_id on the default network.
	Network *Network `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// The tag applied to the worker, and the same tag used by the firewall rule.
	// It is used to identify the Cloud Build workers among other VMs.
	// The default value for tag is `worker`.
	Tag                  string   `protobuf:"bytes,4,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkerConfig) Reset()         { *m = WorkerConfig{} }
func (m *WorkerConfig) String() string { return proto.CompactTextString(m) }
func (*WorkerConfig) ProtoMessage()    {}
func (*WorkerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{35}
}

func (m *WorkerConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkerConfig.Unmarshal(m, b)
}
func (m *WorkerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkerConfig.Marshal(b, m, deterministic)
}
func (m *WorkerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerConfig.Merge(m, src)
}
func (m *WorkerConfig) XXX_Size() int {
	return xxx_messageInfo_WorkerConfig.Size(m)
}
func (m *WorkerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerConfig proto.InternalMessageInfo

func (m *WorkerConfig) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *WorkerConfig) GetDiskSizeGb() int64 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *WorkerConfig) GetNetwork() *Network {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *WorkerConfig) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// Network describes the GCP network used to create workers in.
type Network struct {
	// Project id containing the defined network and subnetwork. For a peered VPC,
	// this will be the same as the project_id in which the workers are created.
	// For a shared VPC, this will be the project sharing the network with the
	// project_id project in which workers will be created. For custom workers
	// with no VPC, this will be the same as project_id.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Network on which the workers are created.
	// "default" network is used if empty.
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// Subnetwork on which the workers are created.
	// "default" subnetwork is used if empty.
	Subnetwork           string   `protobuf:"bytes,3,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Network) Reset()         { *m = Network{} }
func (m *Network) String() string { return proto.CompactTextString(m) }
func (*Network) ProtoMessage()    {}
func (*Network) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{36}
}

func (m *Network) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Network.Unmarshal(m, b)
}
func (m *Network) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Network.Marshal(b, m, deterministic)
}
func (m *Network) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Network.Merge(m, src)
}
func (m *Network) XXX_Size() int {
	return xxx_messageInfo_Network.Size(m)
}
func (m *Network) XXX_DiscardUnknown() {
	xxx_messageInfo_Network.DiscardUnknown(m)
}

var xxx_messageInfo_Network proto.InternalMessageInfo

func (m *Network) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Network) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *Network) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

// Request to create a new `WorkerPool`.
type CreateWorkerPoolRequest struct {
	// ID of the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// `WorkerPool` resource to create.
	WorkerPool           *WorkerPool `protobuf:"bytes,2,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateWorkerPoolRequest) Reset()         { *m = CreateWorkerPoolRequest{} }
func (m *CreateWorkerPoolRequest) String() string { return proto.CompactTextString(m) }
func (*CreateWorkerPoolRequest) ProtoMessage()    {}
func (*CreateWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{37}
}

func (m *CreateWorkerPoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateWorkerPoolRequest.Unmarshal(m, b)
}
func (m *CreateWorkerPoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateWorkerPoolRequest.Marshal(b, m, deterministic)
}
func (m *CreateWorkerPoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateWorkerPoolRequest.Merge(m, src)
}
func (m *CreateWorkerPoolRequest) XXX_Size() int {
	return xxx_messageInfo_CreateWorkerPoolRequest.Size(m)
}
func (m *CreateWorkerPoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateWorkerPoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateWorkerPoolRequest proto.InternalMessageInfo

func (m *CreateWorkerPoolRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateWorkerPoolRequest) GetWorkerPool() *WorkerPool {
	if m != nil {
		return m.WorkerPool
	}
	return nil
}

// Request to get a `WorkerPool` with the specified name.
type GetWorkerPoolRequest struct {
	// The field will contain name of the resource requested, for example:
	// "projects/project-1/workerPools/workerpool-name"
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetWorkerPoolRequest) Reset()         { *m = GetWorkerPoolRequest{} }
func (m *GetWorkerPoolRequest) String() string { return proto.CompactTextString(m) }
func (*GetWorkerPoolRequest) ProtoMessage()    {}
func (*GetWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{38}
}

func (m *GetWorkerPoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetWorkerPoolRequest.Unmarshal(m, b)
}
func (m *GetWorkerPoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetWorkerPoolRequest.Marshal(b, m, deterministic)
}
func (m *GetWorkerPoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkerPoolRequest.Merge(m, src)
}
func (m *GetWorkerPoolRequest) XXX_Size() int {
	return xxx_messageInfo_GetWorkerPoolRequest.Size(m)
}
func (m *GetWorkerPoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkerPoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkerPoolRequest proto.InternalMessageInfo

func (m *GetWorkerPoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to delete a `WorkerPool`.
type DeleteWorkerPoolRequest struct {
	// The field will contain name of the resource requested, for example:
	// "projects/project-1/workerPools/workerpool-name"
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteWorkerPoolRequest) Reset()         { *m = DeleteWorkerPoolRequest{} }
func (m *DeleteWorkerPoolRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteWorkerPoolRequest) ProtoMessage()    {}
func (*DeleteWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{39}
}

func (m *DeleteWorkerPoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteWorkerPoolRequest.Unmarshal(m, b)
}
func (m *DeleteWorkerPoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteWorkerPoolRequest.Marshal(b, m, deterministic)
}
func (m *DeleteWorkerPoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteWorkerPoolRequest.Merge(m, src)
}
func (m *DeleteWorkerPoolRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteWorkerPoolRequest.Size(m)
}
func (m *DeleteWorkerPoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteWorkerPoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteWorkerPoolRequest proto.InternalMessageInfo

func (m *DeleteWorkerPoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to update a `WorkerPool`.
type UpdateWorkerPoolRequest struct {
	// The field will contain name of the resource requested, for example:
	// "projects/project-1/workerPools/workerpool-name"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// `WorkerPool` resource to update.
	WorkerPool           *WorkerPool `protobuf:"bytes,3,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *UpdateWorkerPoolRequest) Reset()         { *m = UpdateWorkerPoolRequest{} }
func (m *UpdateWorkerPoolRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateWorkerPoolRequest) ProtoMessage()    {}
func (*UpdateWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{40}
}

func (m *UpdateWorkerPoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateWorkerPoolRequest.Unmarshal(m, b)
}
func (m *UpdateWorkerPoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateWorkerPoolRequest.Marshal(b, m, deterministic)
}
func (m *UpdateWorkerPoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateWorkerPoolRequest.Merge(m, src)
}
func (m *UpdateWorkerPoolRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateWorkerPoolRequest.Size(m)
}
func (m *UpdateWorkerPoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateWorkerPoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateWorkerPoolRequest proto.InternalMessageInfo

func (m *UpdateWorkerPoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateWorkerPoolRequest) GetWorkerPool() *WorkerPool {
	if m != nil {
		return m.WorkerPool
	}
	return nil
}

// Request to list `WorkerPool`s.
type ListWorkerPoolsRequest struct {
	// ID of the parent project.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWorkerPoolsRequest) Reset()         { *m = ListWorkerPoolsRequest{} }
func (m *ListWorkerPoolsRequest) String() string { return proto.CompactTextString(m) }
func (*ListWorkerPoolsRequest) ProtoMessage()    {}
func (*ListWorkerPoolsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{41}
}

func (m *ListWorkerPoolsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWorkerPoolsRequest.Unmarshal(m, b)
}
func (m *ListWorkerPoolsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWorkerPoolsRequest.Marshal(b, m, deterministic)
}
func (m *ListWorkerPoolsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkerPoolsRequest.Merge(m, src)
}
func (m *ListWorkerPoolsRequest) XXX_Size() int {
	return xxx_messageInfo_ListWorkerPoolsRequest.Size(m)
}
func (m *ListWorkerPoolsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkerPoolsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkerPoolsRequest proto.InternalMessageInfo

func (m *ListWorkerPoolsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// Response containing existing `WorkerPools`.
type ListWorkerPoolsResponse struct {
	// `WorkerPools` for the project.
	WorkerPools          []*WorkerPool `protobuf:"bytes,1,rep,name=worker_pools,json=workerPools,proto3" json:"worker_pools,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ListWorkerPoolsResponse) Reset()         { *m = ListWorkerPoolsResponse{} }
func (m *ListWorkerPoolsResponse) String() string { return proto.CompactTextString(m) }
func (*ListWorkerPoolsResponse) ProtoMessage()    {}
func (*ListWorkerPoolsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{42}
}

func (m *ListWorkerPoolsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWorkerPoolsResponse.Unmarshal(m, b)
}
func (m *ListWorkerPoolsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWorkerPoolsResponse.Marshal(b, m, deterministic)
}
func (m *ListWorkerPoolsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkerPoolsResponse.Merge(m, src)
}
func (m *ListWorkerPoolsResponse) XXX_Size() int {
	return xxx_messageInfo_ListWorkerPoolsResponse.Size(m)
}
func (m *ListWorkerPoolsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkerPoolsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkerPoolsResponse proto.InternalMessageInfo

func (m *ListWorkerPoolsResponse) GetWorkerPools() []*WorkerPool {
	if m != nil {
		return m.WorkerPools
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.devtools.cloudbuild.v1.Build_Status", Build_Status_name, Build_Status_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.Hash_HashType", Hash_HashType_name, Hash_HashType_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.PullRequestFilter_CommentControl", PullRequestFilter_CommentControl_name, PullRequestFilter_CommentControl_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_VerifyOption", BuildOptions_VerifyOption_name, BuildOptions_VerifyOption_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_MachineType", BuildOptions_MachineType_name, BuildOptions_MachineType_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption", BuildOptions_SubstitutionOption_name, BuildOptions_SubstitutionOption_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_LogStreamingOption", BuildOptions_LogStreamingOption_name, BuildOptions_LogStreamingOption_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_LoggingMode", BuildOptions_LoggingMode_name, BuildOptions_LoggingMode_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.WorkerPool_Region", WorkerPool_Region_name, WorkerPool_Region_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.WorkerPool_Status", WorkerPool_Status_name, WorkerPool_Status_value)
	proto.RegisterType((*RetryBuildRequest)(nil), "google.devtools.cloudbuild.v1.RetryBuildRequest")
	proto.RegisterType((*RunBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.RunBuildTriggerRequest")
	proto.RegisterType((*StorageSource)(nil), "google.devtools.cloudbuild.v1.StorageSource")
	proto.RegisterType((*RepoSource)(nil), "google.devtools.cloudbuild.v1.RepoSource")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.cloudbuild.v1.RepoSource.SubstitutionsEntry")
	proto.RegisterType((*Source)(nil), "google.devtools.cloudbuild.v1.Source")
	proto.RegisterType((*BuiltImage)(nil), "google.devtools.cloudbuild.v1.BuiltImage")
	proto.RegisterType((*BuildStep)(nil), "google.devtools.cloudbuild.v1.BuildStep")
	proto.RegisterType((*Volume)(nil), "google.devtools.cloudbuild.v1.Volume")
	proto.RegisterType((*Results)(nil), "google.devtools.cloudbuild.v1.Results")
	proto.RegisterType((*ArtifactResult)(nil), "google.devtools.cloudbuild.v1.ArtifactResult")
	proto.RegisterType((*Build)(nil), "google.devtools.cloudbuild.v1.Build")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.cloudbuild.v1.Build.SubstitutionsEntry")
	proto.RegisterMapType((map[string]*TimeSpan)(nil), "google.devtools.cloudbuild.v1.Build.TimingEntry")
	proto.RegisterType((*Artifacts)(nil), "google.devtools.cloudbuild.v1.Artifacts")
	proto.RegisterType((*Artifacts_ArtifactObjects)(nil), "google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects")
	proto.RegisterType((*TimeSpan)(nil), "google.devtools.cloudbuild.v1.TimeSpan")
	proto.RegisterType((*BuildOperationMetadata)(nil), "google.devtools.cloudbuild.v1.BuildOperationMetadata")
	proto.RegisterType((*SourceProvenance)(nil), "google.devtools.cloudbuild.v1.SourceProvenance")
	proto.RegisterMapType((map[string]*FileHashes)(nil), "google.devtools.cloudbuild.v1.SourceProvenance.FileHashesEntry")
	proto.RegisterType((*FileHashes)(nil), "google.devtools.cloudbuild.v1.FileHashes")
	proto.RegisterType((*Hash)(nil), "google.devtools.cloudbuild.v1.Hash")
	proto.RegisterType((*Secret)(nil), "google.devtools.cloudbuild.v1.Secret")
	proto.RegisterMapType((map[string][]byte)(nil), "google.devtools.cloudbuild.v1.Secret.SecretEnvEntry")
	proto.RegisterType((*CreateBuildRequest)(nil), "google.devtools.cloudbuild.v1.CreateBuildRequest")
	proto.RegisterType((*GetBuildRequest)(nil), "google.devtools.cloudbuild.v1.GetBuildRequest")
	proto.RegisterType((*ListBuildsRequest)(nil), "google.devtools.cloudbuild.v1.ListBuildsRequest")
	proto.RegisterType((*ListBuildsResponse)(nil), "google.devtools.cloudbuild.v1.ListBuildsResponse")
	proto.RegisterType((*CancelBuildRequest)(nil), "google.devtools.cloudbuild.v1.CancelBuildRequest")
	proto.RegisterType((*BuildTrigger)(nil), "google.devtools.cloudbuild.v1.BuildTrigger")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.cloudbuild.v1.BuildTrigger.SubstitutionsEntry")
	proto.RegisterType((*GitHubEventsConfig)(nil), "google.devtools.cloudbuild.v1.GitHubEventsConfig")
	proto.RegisterType((*PullRequestFilter)(nil), "google.devtools.cloudbuild.v1.PullRequestFilter")
	proto.RegisterType((*PushFilter)(nil), "google.devtools.cloudbuild.v1.PushFilter")
	proto.RegisterType((*CreateBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.CreateBuildTriggerRequest")
	proto.RegisterType((*GetBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.GetBuildTriggerRequest")
	proto.RegisterType((*ListBuildTriggersRequest)(nil), "google.devtools.cloudbuild.v1.ListBuildTriggersRequest")
	proto.RegisterType((*ListBuildTriggersResponse)(nil), "google.devtools.cloudbuild.v1.ListBuildTriggersResponse")
	proto.RegisterType((*DeleteBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.DeleteBuildTriggerRequest")
	proto.RegisterType((*UpdateBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.UpdateBuildTriggerRequest")
	proto.RegisterType((*BuildOptions)(nil), "google.devtools.cloudbuild.v1.BuildOptions")
	proto.RegisterType((*WorkerPool)(nil), "google.devtools.cloudbuild.v1.WorkerPool")
	proto.RegisterType((*WorkerConfig)(nil), "google.devtools.cloudbuild.v1.WorkerConfig")
	proto.RegisterType((*Network)(nil), "google.devtools.cloudbuild.v1.Network")
	proto.RegisterType((*CreateWorkerPoolRequest)(nil), "google.devtools.cloudbuild.v1.CreateWorkerPoolRequest")
	proto.RegisterType((*GetWorkerPoolRequest)(nil), "google.devtools.cloudbuild.v1.GetWorkerPoolRequest")
	proto.RegisterType((*DeleteWorkerPoolRequest)(nil), "google.devtools.cloudbuild.v1.DeleteWorkerPoolRequest")
	proto.RegisterType((*UpdateWorkerPoolRequest)(nil), "google.devtools.cloudbuild.v1.UpdateWorkerPoolRequest")
	proto.RegisterType((*ListWorkerPoolsRequest)(nil), "google.devtools.cloudbuild.v1.ListWorkerPoolsRequest")
	proto.RegisterType((*ListWorkerPoolsResponse)(nil), "google.devtools.cloudbuild.v1.ListWorkerPoolsResponse")
}

func init() {
	proto.RegisterFile("google/devtools/cloudbuild/v1/cloudbuild.proto", fileDescriptor_8a9099620ac1526a)
}

var fileDescriptor_8a9099620ac1526a = []byte{
	// 3938 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x3b, 0x4d, 0x73, 0x1b, 0x47,
	0x76, 0x1c, 0x80, 0xc4, 0xc7, 0x03, 0x08, 0x0e, 0x5b, 0x12, 0x05, 0xc1, 0x96, 0x45, 0x8f, 0xd7,
	0xbb, 0xb2, 0x65, 0x03, 0x16, 0xb5, 0xb2, 0x15, 0x5a, 0xb2, 0x04, 0x82, 0x20, 0x08, 0x1b, 0x04,
	0xb8, 0x03, 0xd0, 0xca, 0xee, 0x26, 0x35, 0x3b, 0x00, 0x9a, 0x83, 0x09, 0x07, 0x33, 0xd8, 0x99,
	0x06, 0xb4, 0xb4, 0xe3, 0xcb, 0x96, 0xab, 0x52, 0xa9, 0x75, 0x55, 0x52, 0x95, 0x1f, 0x90, 0x4a,
	0x0e, 0x49, 0x6e, 0x7b, 0xdc, 0x53, 0x2a, 0xa7, 0x4d, 0xaa, 0x7c, 0xc8, 0x21, 0xb9, 0xa9, 0x2a,
	0x55, 0xa9, 0x54, 0x4e, 0x39, 0xe4, 0x27, 0xa4, 0x52, 0xfd, 0x31, 0xc0, 0x00, 0x20, 0x35, 0x80,
	0xe4, 0xdd, 0x8b, 0x84, 0x7e, 0xdd, 0xef, 0xf5, 0x7b, 0xdd, 0xef, 0xbb, 0x87, 0x90, 0x37, 0x1c,
	0xc7, 0xb0, 0x70, 0xa1, 0x8b, 0x47, 0xc4, 0x71, 0x2c, 0xaf, 0xd0, 0xb1, 0x9c, 0x61, 0xb7, 0x3d,
	0x34, 0xad, 0x6e, 0x61, 0x74, 0x37, 0x30, 0xca, 0x0f, 0x5c, 0x87, 0x38, 0xe8, 0x26, 0x5f, 0x9f,
	0xf7, 0xd7, 0xe7, 0x03, 0x2b, 0x46, 0x77, 0x73, 0xaf, 0x0b, 0x72, 0xfa, 0xc0, 0x2c, 0xe8, 0xb6,
	0xed, 0x10, 0x9d, 0x98, 0x8e, 0xed, 0x71, 0xe4, 0xdc, 0xf5, 0xc0, 0x6c, 0xc7, 0x32, 0xb1, 0x4d,
	0xc4, 0xc4, 0xad, 0xc0, 0xc4, 0xa9, 0x89, 0xad, 0xae, 0xd6, 0xc6, 0x3d, 0x7d, 0x64, 0x3a, 0xae,
	0x58, 0xf0, 0x96, 0x58, 0x60, 0x39, 0xb6, 0xe1, 0x0e, 0x6d, 0xdb, 0xb4, 0x8d, 0x82, 0x33, 0xc0,
	0xee, 0x14, 0xf9, 0x37, 0xc4, 0x22, 0x36, 0x6a, 0x0f, 0x4f, 0x0b, 0xdd, 0x21, 0x5f, 0x20, 0xe6,
	0x5f, 0x9b, 0x9d, 0xc7, 0xfd, 0x01, 0x39, 0x9f, 0x61, 0x61, 0x3c, 0x49, 0xcc, 0x3e, 0xf6, 0x88,
	0xde, 0x1f, 0xf0, 0x05, 0x4a, 0x0d, 0x36, 0x55, 0x4c, 0xdc, 0xf3, 0x3d, 0x2a, 0xab, 0x8a, 0x7f,
	0x3e, 0xc4, 0x1e, 0x41, 0x0a, 0xc0, 0xc0, 0x75, 0xfe, 0x04, 0x77, 0x88, 0x66, 0x76, 0xb3, 0xd2,
	0xb6, 0x74, 0x3b, 0xb9, 0x17, 0xfd, 0xcf, 0x62, 0x44, 0x4d, 0x0a, 0x70, 0xb5, 0x8b, 0xae, 0x40,
	0xc4, 0xec, 0x66, 0x23, 0x93, 0xb9, 0x88, 0xd9, 0x55, 0xfe, 0x41, 0x82, 0x2d, 0x75, 0x68, 0x33,
	0x62, 0x2d, 0xd7, 0x34, 0x0c, 0xec, 0x2e, 0x43, 0x53, 0x01, 0x20, 0x1c, 0x4b, 0x9b, 0xa6, 0x9d,
	0x14, 0xe0, 0x6a, 0x17, 0x1d, 0x40, 0xcc, 0x73, 0x86, 0x6e, 0x07, 0x67, 0xa3, 0xdb, 0xd2, 0xed,
	0xd4, 0xce, 0x3b, 0xf9, 0x17, 0xde, 0x5d, 0x5e, 0xc5, 0x03, 0xa7, 0xc9, 0x10, 0x38, 0x29, 0x81,
	0xad, 0x68, 0xb0, 0xde, 0x24, 0x8e, 0xab, 0x1b, 0x98, 0xcf, 0xa2, 0x2d, 0x88, 0xb5, 0x87, 0x9d,
	0x33, 0x4c, 0x38, 0x73, 0xaa, 0x18, 0x51, 0xb8, 0xd3, 0xa6, 0x0c, 0x72, 0x86, 0x54, 0x31, 0x42,
	0x6f, 0x00, 0x18, 0xd8, 0x16, 0x97, 0xc5, 0x98, 0x89, 0xaa, 0x01, 0x88, 0xf2, 0x97, 0x51, 0x80,
	0xc9, 0xe6, 0xe8, 0xe6, 0xbc, 0xfc, 0x41, 0xd1, 0x5f, 0x83, 0xa4, 0x8b, 0x07, 0x8e, 0x66, 0xeb,
	0x7d, 0x2c, 0x36, 0x4a, 0x50, 0x40, 0x5d, 0xef, 0x63, 0xf4, 0x26, 0xa4, 0xda, 0xae, 0x6e, 0x77,
	0x7a, 0x7c, 0x9a, 0xee, 0x95, 0x3c, 0x5c, 0x51, 0x81, 0x03, 0xd9, 0x92, 0xd7, 0x20, 0x41, 0x74,
	0x83, 0xcf, 0xaf, 0x8a, 0xf9, 0x38, 0xd1, 0x0d, 0x36, 0x79, 0x0b, 0xa0, 0xe3, 0xf4, 0xfb, 0x26,
	0xd1, 0xbc, 0x9e, 0x9e, 0x5d, 0x13, 0xd3, 0x49, 0x0e, 0x6b, 0xf6, 0x74, 0x24, 0x43, 0xb4, 0x6b,
	0xba, 0xd9, 0x38, 0xdb, 0x97, 0xfe, 0x44, 0x6f, 0x42, 0xda, 0xb4, 0x47, 0xd8, 0x25, 0x9a, 0x8b,
	0x0d, 0xfc, 0x8b, 0x6c, 0x62, 0x5b, 0xba, 0x9d, 0x50, 0x53, 0x1c, 0xa6, 0x52, 0x10, 0x6a, 0xc3,
	0xba, 0x37, 0x6c, 0x7b, 0xc4, 0x24, 0x43, 0xa6, 0xaf, 0xd9, 0xe4, 0x76, 0xf4, 0x76, 0x6a, 0xe7,
	0xe1, 0xc2, 0x17, 0x92, 0x6f, 0x06, 0xd1, 0xcb, 0x36, 0x71, 0xcf, 0xd5, 0x69, 0x92, 0xb9, 0x27,
	0x80, 0xe6, 0x17, 0x51, 0x76, 0xcf, 0xf0, 0xb9, 0x38, 0x44, 0xfa, 0x13, 0x5d, 0x85, 0xb5, 0x91,
	0x6e, 0x0d, 0xfd, 0xa3, 0xe3, 0x83, 0xdd, 0xc8, 0x03, 0x69, 0x0f, 0x20, 0xe1, 0xe2, 0x91, 0xe9,
	0xd1, 0x2b, 0xf9, 0x8d, 0x04, 0x31, 0x71, 0x1d, 0x27, 0x90, 0xf1, 0xf8, 0xf5, 0x6b, 0x42, 0x9d,
	0x22, 0x4c, 0x9d, 0xde, 0x0b, 0xe1, 0x7e, 0x4a, 0x67, 0x0e, 0x57, 0xd4, 0x75, 0x6f, 0x4a, 0x89,
	0x6a, 0x90, 0x62, 0xd7, 0xf8, 0x92, 0x2a, 0x4a, 0x2f, 0xd5, 0x9d, 0x28, 0x6c, 0xc2, 0xd7, 0x75,
	0xe5, 0xcf, 0x24, 0x00, 0x6a, 0x55, 0xa4, 0xda, 0xd7, 0x0d, 0x8c, 0x10, 0xac, 0xb2, 0x9b, 0xe6,
	0x27, 0xc0, 0x7e, 0x53, 0x3d, 0xed, 0x9a, 0x06, 0xf6, 0x08, 0xd7, 0x0f, 0x55, 0x8c, 0xd0, 0x11,
	0xa4, 0x06, 0x43, 0xaf, 0xa7, 0x11, 0xb3, 0x6f, 0xda, 0x06, 0x53, 0x8e, 0xd4, 0xce, 0x0f, 0x42,
	0x58, 0x6a, 0x99, 0x7d, 0xdc, 0x1c, 0xe8, 0x36, 0xb5, 0x99, 0xa8, 0x0a, 0x94, 0x40, 0x8b, 0xe1,
	0x2b, 0xdf, 0xac, 0x42, 0x92, 0xd9, 0x77, 0x93, 0xe0, 0xc1, 0x85, 0x8c, 0xc8, 0x10, 0xc5, 0xf6,
	0x28, 0x1b, 0xd9, 0x8e, 0xd2, 0xdb, 0xc1, 0xf6, 0x88, 0xae, 0xd2, 0x5d, 0xc3, 0xcb, 0x46, 0x19,
	0x88, 0xfd, 0xf6, 0x55, 0x6e, 0x75, 0xa2, 0x72, 0x19, 0xe6, 0x51, 0x98, 0x76, 0x52, 0x67, 0x82,
	0x6e, 0x40, 0xe2, 0x99, 0x6e, 0x12, 0xed, 0xd4, 0x71, 0xb3, 0x31, 0x86, 0x19, 0xa7, 0xe3, 0x03,
	0xc7, 0xa5, 0xb6, 0x87, 0xa9, 0x26, 0x0c, 0x1c, 0xd3, 0x26, 0x42, 0x6d, 0x03, 0x10, 0x6a, 0x6c,
	0x1e, 0xee, 0xb8, 0x98, 0x68, 0x94, 0x93, 0x04, 0x43, 0x4e, 0x72, 0x48, 0xd9, 0x1e, 0xa1, 0xc7,
	0x10, 0x1f, 0x39, 0xd6, 0xb0, 0x8f, 0x7d, 0x9d, 0x7d, 0x3b, 0xe4, 0x38, 0x3e, 0x67, 0xab, 0x55,
	0x1f, 0x0b, 0xed, 0x43, 0x4c, 0x1c, 0x27, 0xbc, 0xc4, 0x71, 0x0a, 0x5c, 0x74, 0x48, 0x6f, 0xc6,
	0xb2, 0xfc, 0x9b, 0x59, 0x5f, 0x8a, 0x14, 0xbd, 0x14, 0xcb, 0xe2, 0x97, 0x82, 0xee, 0x41, 0x9c,
	0x3a, 0x76, 0x67, 0x48, 0xb2, 0x29, 0x46, 0xe5, 0x86, 0x4f, 0xc5, 0x77, 0xfc, 0xf9, 0x7d, 0x11,
	0x35, 0x54, 0x7f, 0x25, 0x2a, 0x41, 0xcc, 0x23, 0x3a, 0x19, 0x7a, 0xd9, 0xf4, 0xb6, 0x74, 0x3b,
	0xb3, 0x73, 0x27, 0x64, 0x67, 0x76, 0xeb, 0xf9, 0x26, 0x43, 0x51, 0x05, 0xaa, 0xf2, 0x01, 0xc4,
	0xf8, 0xe1, 0x5c, 0xa8, 0x0a, 0x08, 0x56, 0x07, 0x3a, 0xe9, 0x09, 0xab, 0x64, 0xbf, 0x95, 0x6f,
	0x23, 0x10, 0x57, 0xb1, 0x37, 0xb4, 0x88, 0x87, 0x8a, 0x10, 0x33, 0xa9, 0x42, 0x7b, 0x4c, 0x5b,
	0xc2, 0x2d, 0x65, 0x62, 0x02, 0xaa, 0x40, 0x44, 0xef, 0xc2, 0x26, 0x9b, 0xd6, 0x3c, 0x82, 0x07,
	0x9a, 0xa0, 0xc6, 0x15, 0x6d, 0xa3, 0xed, 0xeb, 0x69, 0x95, 0xaf, 0xbd, 0x03, 0x9b, 0xba, 0x4b,
	0xcc, 0x53, 0xbd, 0x43, 0xb4, 0xbe, 0x6e, 0x9b, 0xa7, 0xd4, 0x5a, 0xb8, 0x06, 0xca, 0xfe, 0xc4,
	0x91, 0x80, 0xa3, 0xb7, 0x60, 0xdd, 0x1e, 0xf6, 0x35, 0x1f, 0xee, 0x31, 0xcd, 0x8c, 0xaa, 0x69,
	0x7b, 0xd8, 0x2f, 0xfa, 0x30, 0xf4, 0x1e, 0xa0, 0xc0, 0xee, 0xce, 0x90, 0x0c, 0x86, 0xc4, 0x63,
	0xda, 0x9a, 0x56, 0xe5, 0xf1, 0xf6, 0x0d, 0x0e, 0x47, 0xc7, 0xb0, 0x31, 0xde, 0x5f, 0x5c, 0x7a,
	0x7c, 0xb9, 0x4b, 0xcf, 0xf8, 0xf8, 0xc2, 0x1a, 0x09, 0x64, 0x7c, 0x66, 0xf8, 0x99, 0xa2, 0x1c,
	0x24, 0x2c, 0xa7, 0xc3, 0x83, 0x12, 0xbf, 0x8a, 0xf1, 0x18, 0x1d, 0x40, 0xf2, 0xd4, 0xb4, 0xb0,
	0xd6, 0xd3, 0xbd, 0xde, 0x82, 0x27, 0x7e, 0x60, 0x5a, 0xf8, 0x50, 0xf7, 0x7a, 0xd8, 0x53, 0x13,
	0xa7, 0xe2, 0xb7, 0xf2, 0x17, 0x69, 0x58, 0x63, 0xda, 0x20, 0xb2, 0x80, 0x71, 0x34, 0x8f, 0x32,
	0xc3, 0x9d, 0x0e, 0xf5, 0xf2, 0x64, 0x32, 0x10, 0xef, 0x26, 0xca, 0x17, 0x79, 0x69, 0xe5, 0xa3,
	0x57, 0xc4, 0x7f, 0x69, 0x5d, 0x4c, 0x74, 0xd3, 0xca, 0x66, 0x99, 0xc0, 0x69, 0x0e, 0xdc, 0x67,
	0x30, 0xf4, 0x68, 0x26, 0x61, 0x08, 0xb3, 0x75, 0xee, 0x7b, 0xfd, 0x3c, 0x01, 0x7d, 0x02, 0x6b,
	0xf4, 0x6e, 0xbd, 0x6c, 0x8a, 0x9d, 0xd7, 0xed, 0x45, 0xf8, 0xa4, 0x77, 0xae, 0x72, 0x34, 0x54,
	0x86, 0xb8, 0xcb, 0xb5, 0x5d, 0xf8, 0x8a, 0xef, 0x87, 0x46, 0x03, 0xb6, 0x9a, 0x9f, 0x98, 0x8f,
	0x8b, 0x9e, 0x40, 0xaa, 0xe3, 0x62, 0x9d, 0x60, 0xaa, 0x38, 0x38, 0x1b, 0x63, 0xa4, 0x72, 0x73,
	0x56, 0xde, 0xf2, 0xd3, 0x3b, 0xe1, 0xb8, 0x39, 0x0e, 0x85, 0xa2, 0x4f, 0x00, 0x3c, 0xa2, 0xbb,
	0x84, 0x13, 0x88, 0x2f, 0x46, 0x20, 0xc9, 0x50, 0x18, 0xfe, 0x13, 0x48, 0x9d, 0x9a, 0xb6, 0xc9,
	0x23, 0x09, 0x66, 0x09, 0xc1, 0x22, 0x1c, 0x70, 0x1c, 0x46, 0x21, 0xe0, 0xa5, 0xd2, 0x0b, 0x7b,
	0xa9, 0xad, 0xb1, 0x8b, 0x58, 0x67, 0x46, 0xed, 0xdb, 0xfd, 0x01, 0x24, 0x27, 0xa6, 0xf9, 0x36,
	0x23, 0x17, 0x76, 0x37, 0x63, 0xb3, 0x55, 0x27, 0xa8, 0xe8, 0x16, 0xa4, 0x2c, 0xc7, 0xf0, 0x34,
	0x91, 0xfb, 0x5d, 0xe1, 0xb1, 0x84, 0x82, 0xf6, 0x78, 0xfe, 0xf7, 0x47, 0xb0, 0xc9, 0x55, 0x41,
	0x1b, 0xb8, 0xce, 0x08, 0xdb, 0xba, 0xdd, 0xc1, 0xd9, 0x6b, 0x6c, 0xc3, 0xc2, 0x42, 0xaa, 0x74,
	0x3c, 0x46, 0x53, 0x65, 0x6f, 0x06, 0x82, 0x6e, 0x03, 0x77, 0x13, 0x5a, 0x20, 0xf1, 0xdd, 0x62,
	0x3c, 0x64, 0xda, 0x81, 0x2c, 0xba, 0xda, 0xa5, 0x8a, 0xe4, 0x0c, 0x78, 0xa2, 0x75, 0x9d, 0xed,
	0xbe, 0x90, 0xc9, 0x34, 0x38, 0x8a, 0xea, 0xe3, 0xa2, 0xd7, 0x21, 0x6e, 0x39, 0x86, 0x36, 0x74,
	0xad, 0xec, 0x8d, 0x89, 0x65, 0xc6, 0x2c, 0xc7, 0x38, 0x71, 0x2d, 0xf4, 0xc7, 0xb3, 0x39, 0xdd,
	0x4d, 0xa6, 0xf5, 0x1f, 0x2d, 0x66, 0x9d, 0x61, 0xe9, 0x1c, 0x8d, 0x07, 0x44, 0x37, 0xbc, 0xec,
	0x2d, 0x9e, 0x08, 0xd0, 0xdf, 0x34, 0x18, 0xf3, 0xc8, 0xec, 0x65, 0xb7, 0x17, 0x0a, 0xc6, 0x4d,
	0xb6, 0x5a, 0xf5, 0xb1, 0xd0, 0xd1, 0x38, 0x18, 0xbf, 0xc9, 0xf0, 0x3f, 0x58, 0x88, 0x59, 0xee,
	0x40, 0x19, 0x97, 0x53, 0x51, 0xf9, 0xd5, 0x53, 0xce, 0x5c, 0x1b, 0x52, 0x01, 0xea, 0x17, 0xa0,
	0x3e, 0x0a, 0xa2, 0x2e, 0xe1, 0xfd, 0x27, 0x7b, 0x28, 0xdf, 0xd0, 0x54, 0x96, 0x7b, 0x41, 0x04,
	0x99, 0x66, 0xab, 0xd8, 0x3a, 0x69, 0x6a, 0x27, 0xf5, 0xcf, 0xea, 0x8d, 0xa7, 0x75, 0x79, 0x05,
	0x01, 0xc4, 0x7e, 0x74, 0x52, 0x3e, 0x29, 0xef, 0xcb, 0x12, 0x4a, 0x41, 0xfc, 0x69, 0x43, 0xfd,
	0xac, 0x5a, 0xaf, 0xc8, 0x11, 0x3a, 0x68, 0x9e, 0x94, 0x4a, 0xe5, 0x66, 0x53, 0x8e, 0xd2, 0xc1,
	0x41, 0xb1, 0x5a, 0x3b, 0x51, 0xcb, 0xf2, 0x2a, 0x25, 0x53, 0xad, 0xb7, 0xca, 0x6a, 0xbd, 0x58,
	0xd3, 0xca, 0xaa, 0xda, 0x50, 0xe5, 0x35, 0xba, 0xa0, 0x55, 0x3d, 0x2a, 0x37, 0x4e, 0x5a, 0x72,
	0x0c, 0xad, 0x43, 0xb2, 0x54, 0xac, 0x97, 0xca, 0xb5, 0x5a, 0x79, 0x5f, 0x8e, 0xd3, 0xb9, 0xf2,
	0x1f, 0x1e, 0x57, 0xd5, 0xf2, 0xbe, 0x9c, 0x54, 0xfe, 0x4f, 0x82, 0xe4, 0x24, 0x2a, 0x4e, 0x6c,
	0x56, 0x9a, 0xb2, 0x59, 0x15, 0xe2, 0xbc, 0x78, 0xf2, 0x84, 0xe4, 0x0f, 0x16, 0xb5, 0xd8, 0xf1,
	0xaf, 0x06, 0xc7, 0x57, 0x7d, 0x42, 0xb9, 0xaf, 0x25, 0xd8, 0x98, 0x99, 0x7c, 0x61, 0x0c, 0xbc,
	0x0a, 0x6b, 0x34, 0x0d, 0xf1, 0x44, 0x7e, 0xca, 0x07, 0xe8, 0xf1, 0x58, 0x87, 0xa2, 0xcb, 0x5d,
	0x89, 0x40, 0x53, 0xfe, 0x14, 0x12, 0x3e, 0x0c, 0xfd, 0xc1, 0x94, 0xa7, 0x95, 0xc2, 0x1c, 0x65,
	0xd0, 0xc9, 0xde, 0x87, 0x04, 0xb6, 0xbb, 0x1c, 0x31, 0x12, 0x8a, 0x18, 0xc7, 0x76, 0x97, 0x8e,
	0x94, 0x16, 0x6c, 0x09, 0x6b, 0x17, 0xd5, 0xe7, 0x11, 0x26, 0x7a, 0x57, 0x27, 0x3a, 0xda, 0x85,
	0x35, 0xc6, 0xb4, 0x60, 0xe3, 0x7b, 0x8b, 0xd8, 0x86, 0xca, 0x51, 0x94, 0xbf, 0x8b, 0x82, 0x3c,
	0xeb, 0xc2, 0x50, 0x17, 0xae, 0xbb, 0xd8, 0x73, 0xac, 0x11, 0xa6, 0x49, 0xcf, 0x54, 0x05, 0x15,
	0x5d, 0xbe, 0x82, 0x52, 0xaf, 0xf9, 0xc4, 0xa6, 0x8b, 0xf1, 0x9f, 0xc2, 0xd5, 0xf1, 0x2e, 0xc1,
	0x82, 0x2a, 0xb6, 0x64, 0x41, 0xa5, 0x22, 0x9f, 0x4c, 0xa0, 0x14, 0xc7, 0x34, 0x92, 0x89, 0x34,
	0x08, 0x7b, 0xd9, 0x55, 0xe6, 0x35, 0x1e, 0x2f, 0xe9, 0xcb, 0x03, 0x99, 0x51, 0xc0, 0x89, 0xc0,
	0xe9, 0x18, 0x9a, 0xeb, 0xc1, 0xc6, 0xcc, 0x9a, 0x0b, 0x5c, 0xc1, 0xe3, 0x69, 0x57, 0xb0, 0x44,
	0x3a, 0x16, 0x70, 0x06, 0x75, 0x80, 0xc9, 0x04, 0x7a, 0x12, 0xcc, 0xf2, 0x24, 0x26, 0xdc, 0x5b,
	0x21, 0x64, 0x29, 0x66, 0x20, 0xbf, 0xfb, 0x73, 0x09, 0x56, 0xe9, 0x0f, 0xf4, 0x04, 0x56, 0xc9,
	0xf9, 0x80, 0xeb, 0x70, 0x26, 0xf4, 0x66, 0x29, 0x0a, 0xfb, 0xa7, 0x75, 0x3e, 0xc0, 0x2a, 0xc3,
	0x9c, 0xf6, 0x92, 0x69, 0xc1, 0xb4, 0xf2, 0x0e, 0x24, 0xfc, 0x75, 0x28, 0x01, 0xab, 0xf5, 0x46,
	0xbd, 0xcc, 0x9d, 0x56, 0xf3, 0xb0, 0xb8, 0x73, 0xff, 0x43, 0x59, 0x42, 0x71, 0x88, 0x1e, 0xed,
	0xdf, 0x97, 0x23, 0xca, 0x3f, 0x52, 0x47, 0xc7, 0x3c, 0x3d, 0xda, 0x86, 0xf4, 0x59, 0xdf, 0xd3,
	0xce, 0xf0, 0xb9, 0x16, 0xa8, 0x34, 0xe0, 0xac, 0xef, 0x7d, 0x86, 0xcf, 0x59, 0xa3, 0xa3, 0x39,
	0x55, 0xf7, 0x45, 0x99, 0xec, 0x3f, 0x5c, 0x28, 0x9c, 0x88, 0xff, 0xca, 0xf6, 0x88, 0x07, 0xae,
	0x49, 0xb5, 0x98, 0x7b, 0x08, 0x99, 0xe9, 0xc9, 0xb0, 0x60, 0x90, 0x0e, 0xde, 0xcd, 0x39, 0xa0,
	0x12, 0x4b, 0xc2, 0x96, 0xee, 0xb0, 0x3d, 0xf6, 0x4d, 0x37, 0xb2, 0xb8, 0xe9, 0x72, 0x22, 0xc2,
	0x7e, 0x3f, 0x85, 0x8d, 0x0a, 0x26, 0xdf, 0x4d, 0x67, 0xef, 0x57, 0x12, 0x6c, 0xd6, 0x4c, 0x8f,
	0x53, 0xf3, 0x96, 0x21, 0xf7, 0x1a, 0x24, 0x07, 0xcc, 0x49, 0x98, 0x5f, 0xf0, 0xe3, 0x59, 0x53,
	0x13, 0x14, 0xd0, 0x34, 0xbf, 0xe0, 0x5d, 0x31, 0x3a, 0x49, 0x9c, 0x33, 0x6c, 0x8b, 0xc6, 0x05,
	0x5b, 0xde, 0xa2, 0x00, 0x1a, 0x48, 0x4e, 0x4d, 0x8b, 0x60, 0x97, 0xa5, 0x9b, 0x49, 0x55, 0x8c,
	0x94, 0x2f, 0x00, 0x05, 0x99, 0xf1, 0x06, 0x8e, 0xed, 0x61, 0xf4, 0x10, 0x62, 0x4c, 0x70, 0x4f,
	0x68, 0xfd, 0x62, 0xce, 0x4e, 0xe0, 0xa0, 0xef, 0xc3, 0x86, 0x8d, 0x7f, 0x41, 0xb4, 0x00, 0x3f,
	0x3c, 0xb2, 0xaf, 0x53, 0xf0, 0xb1, 0xcf, 0x93, 0x72, 0x04, 0xa8, 0x44, 0x1d, 0x80, 0xf5, 0xdd,
	0x1c, 0xec, 0xbf, 0xae, 0x41, 0x3a, 0xd8, 0x2f, 0xbd, 0xb8, 0xa4, 0xda, 0x86, 0x54, 0x17, 0x7b,
	0x1d, 0xd7, 0x64, 0x59, 0x1c, 0xab, 0x24, 0x92, 0x6a, 0x10, 0x34, 0x2e, 0xbf, 0xaf, 0x4d, 0x97,
	0xdf, 0x2c, 0xdd, 0xba, 0x12, 0x48, 0xb7, 0x5a, 0x20, 0xfb, 0xa9, 0x26, 0xc1, 0xfd, 0x81, 0xa5,
	0x13, 0xbf, 0x18, 0x58, 0xc2, 0xab, 0x6e, 0x08, 0x12, 0x2d, 0x41, 0x01, 0x55, 0x21, 0x66, 0x98,
	0xa4, 0x37, 0x6c, 0x8b, 0x2e, 0xc6, 0xdd, 0x10, 0x5a, 0x15, 0x93, 0x1c, 0x0e, 0xdb, 0xe5, 0x11,
	0xb6, 0x89, 0x57, 0x72, 0xec, 0x53, 0xd3, 0x50, 0x05, 0x01, 0xf4, 0xd0, 0x57, 0xfb, 0xd5, 0xc5,
	0xd5, 0xfe, 0x70, 0x45, 0xe8, 0x3c, 0x7a, 0x1d, 0x98, 0x1b, 0x63, 0x47, 0x91, 0x10, 0x8d, 0xce,
	0x31, 0x64, 0xb6, 0x8a, 0x5a, 0x5b, 0xbe, 0x8a, 0xca, 0x41, 0xa2, 0x6b, 0x7a, 0x7a, 0xdb, 0xc2,
	0xdd, 0x6c, 0x92, 0xf5, 0x44, 0xc7, 0x63, 0xd4, 0x9d, 0x4d, 0x9e, 0x79, 0xc9, 0xf8, 0xc9, 0x22,
	0x12, 0x88, 0xdb, 0x5f, 0x20, 0x87, 0x7e, 0x0b, 0xd6, 0x4d, 0xc3, 0x76, 0x5c, 0xdc, 0xd5, 0xa8,
	0x5c, 0x5e, 0x76, 0x83, 0xdd, 0x6e, 0x5a, 0x00, 0x69, 0x20, 0xf0, 0xd0, 0xdb, 0x90, 0x31, 0xed,
	0x8e, 0x35, 0xec, 0x8e, 0x57, 0xc9, 0x6c, 0xd5, 0xba, 0x0f, 0x65, 0xcb, 0xbe, 0x83, 0xf6, 0xaa,
	0x0c, 0x19, 0x51, 0xbf, 0x08, 0x55, 0x50, 0xbe, 0x89, 0x00, 0x9a, 0xbf, 0x5e, 0x74, 0x07, 0x36,
	0x4c, 0xdb, 0x23, 0xba, 0x65, 0xb1, 0x04, 0xc5, 0xb7, 0x92, 0xe8, 0x5e, 0x24, 0x2b, 0xa9, 0x99,
	0xe0, 0x54, 0xb5, 0x4b, 0xf7, 0x73, 0x9e, 0xd9, 0xd8, 0x65, 0xf1, 0x3e, 0xa9, 0xf2, 0xc1, 0x58,
	0xc5, 0xe3, 0x01, 0x15, 0x3f, 0x81, 0x34, 0xeb, 0xa1, 0xb9, 0xdc, 0x0e, 0x85, 0xd2, 0x84, 0x95,
	0x00, 0xc7, 0x43, 0xcb, 0x12, 0x96, 0x7b, 0xc0, 0x3c, 0xca, 0xe1, 0x8a, 0xca, 0x7a, 0x71, 0xbe,
	0x39, 0x3f, 0x86, 0xd5, 0xc1, 0xd0, 0xeb, 0x09, 0x0d, 0x79, 0x27, 0x94, 0x9c, 0xd7, 0x1b, 0xd3,
	0x61, 0x88, 0x7b, 0x71, 0x58, 0xc3, 0x54, 0x7c, 0xe5, 0xeb, 0x08, 0x6c, 0xce, 0x6d, 0x87, 0xb2,
	0x10, 0xe3, 0xcd, 0x7b, 0x7e, 0xa2, 0x87, 0x2b, 0xaa, 0x18, 0xa3, 0x1e, 0x6c, 0x74, 0x9c, 0x7e,
	0x1f, 0xdb, 0x44, 0xeb, 0x38, 0x36, 0x71, 0x1d, 0x8b, 0x31, 0x91, 0x09, 0x4d, 0x50, 0xe6, 0x36,
	0xc9, 0x97, 0x38, 0x9d, 0x12, 0x27, 0xa3, 0x66, 0x3a, 0x53, 0xe3, 0xb9, 0x16, 0x7f, 0x6c, 0xae,
	0xc5, 0xaf, 0x3c, 0x82, 0xcc, 0x34, 0x11, 0x74, 0x0d, 0x36, 0x4b, 0x8d, 0xa3, 0xa3, 0x72, 0xbd,
	0xd5, 0xd4, 0xf6, 0xab, 0xcd, 0xe2, 0x1e, 0x2d, 0x06, 0x56, 0xd0, 0x55, 0x90, 0xc7, 0xe0, 0x72,
	0x9d, 0x43, 0xa5, 0xbd, 0x24, 0xc4, 0x0d, 0x93, 0x92, 0x3f, 0x55, 0x7a, 0x00, 0x93, 0x53, 0x7a,
	0x81, 0xf8, 0x08, 0xa2, 0x44, 0x37, 0xc6, 0x4f, 0x1c, 0x74, 0x30, 0xc7, 0xe8, 0xea, 0x1c, 0xa3,
	0xc1, 0x9d, 0x7e, 0x25, 0xc1, 0x8d, 0x40, 0xc4, 0x7d, 0x89, 0x67, 0xa8, 0x4f, 0x21, 0x2e, 0xfc,
	0x9b, 0x08, 0xbd, 0x77, 0x96, 0xb0, 0x60, 0x4e, 0xcd, 0x27, 0xa0, 0xfc, 0x0c, 0xb6, 0xfc, 0x18,
	0xfc, 0xbb, 0x79, 0x10, 0x53, 0xbe, 0x80, 0xec, 0x38, 0x16, 0x8a, 0x2d, 0x7e, 0x5f, 0xf1, 0x99,
	0x56, 0xa1, 0x37, 0x2e, 0xd8, 0x5c, 0xc4, 0xe3, 0x0a, 0x24, 0x04, 0x9b, 0x7e, 0x44, 0x5e, 0xe6,
	0x20, 0xd5, 0x31, 0xf2, 0xc2, 0xa1, 0xb9, 0x03, 0x37, 0xf6, 0xb1, 0x85, 0x5f, 0xfe, 0xe6, 0x17,
	0x39, 0xef, 0x5f, 0x4b, 0x70, 0xe3, 0x64, 0xd0, 0xd5, 0x7f, 0xa7, 0xbb, 0x04, 0x75, 0x30, 0xfa,
	0xaa, 0x3a, 0xf8, 0x5f, 0x09, 0x91, 0x62, 0x88, 0x66, 0x10, 0x6a, 0xc3, 0xd6, 0x5c, 0x4b, 0x6b,
	0x52, 0x2e, 0x2c, 0x9b, 0xe8, 0x5f, 0x9d, 0x6d, 0x6a, 0xb1, 0xd2, 0x61, 0x40, 0xeb, 0x44, 0x76,
	0x26, 0xb8, 0xab, 0x8d, 0xb0, 0x6b, 0x9e, 0x9e, 0x6b, 0xbc, 0x07, 0x25, 0x3a, 0xbe, 0x0f, 0x96,
	0x68, 0x5f, 0xe5, 0x3f, 0x67, 0x04, 0xf8, 0x88, 0xd6, 0x8c, 0x82, 0x70, 0x10, 0x8c, 0x7e, 0x02,
	0xe9, 0xbe, 0xde, 0xe9, 0x99, 0x36, 0xd6, 0x58, 0xd1, 0x12, 0x65, 0xdb, 0x7c, 0xb4, 0xcc, 0x36,
	0x47, 0x1c, 0x9f, 0x89, 0x95, 0xea, 0x4f, 0x06, 0xb4, 0xf4, 0xe8, 0x9a, 0xde, 0x19, 0x33, 0x12,
	0xcd, 0x68, 0x33, 0x5f, 0x19, 0x55, 0x81, 0xc2, 0xa8, 0x9d, 0x54, 0xda, 0xc8, 0x81, 0x2b, 0xc1,
	0x38, 0xed, 0xcb, 0xba, 0xca, 0x98, 0xf8, 0x64, 0x19, 0x26, 0x82, 0x11, 0x59, 0x48, 0x8c, 0xbc,
	0x39, 0x18, 0x1a, 0xc0, 0x55, 0xcb, 0x31, 0x34, 0x8f, 0xb8, 0x58, 0xef, 0x9b, 0xb6, 0xe1, 0xef,
	0xb8, 0xb6, 0xfc, 0x8e, 0x35, 0xc7, 0x68, 0xfa, 0x64, 0xfc, 0x1d, 0xad, 0x39, 0x18, 0xba, 0x05,
	0xa9, 0x67, 0x8e, 0x7b, 0x86, 0x5d, 0x6d, 0xe0, 0x38, 0x96, 0xff, 0xec, 0xc6, 0x41, 0xc7, 0x8e,
	0x63, 0xa1, 0x1f, 0xb1, 0xde, 0xa2, 0x61, 0xda, 0x06, 0x7b, 0x86, 0x5a, 0xf2, 0xf0, 0x6b, 0x1c,
	0xf5, 0xc8, 0xe9, 0x62, 0xd5, 0xa7, 0xe3, 0x3f, 0x26, 0xa6, 0x27, 0x8f, 0x89, 0xd3, 0x6f, 0x7b,
	0xeb, 0x2f, 0x78, 0xdb, 0xcb, 0xbc, 0xcc, 0xdb, 0x9e, 0x92, 0x87, 0xf4, 0x94, 0x5a, 0xc9, 0x90,
	0xae, 0x37, 0x5a, 0xda, 0xe7, 0x65, 0xb5, 0x7a, 0x50, 0x65, 0xc1, 0x2e, 0x0d, 0x89, 0xf1, 0x48,
	0x52, 0x4a, 0x90, 0x0a, 0xa8, 0x0d, 0xda, 0x80, 0xd4, 0x49, 0xbd, 0x79, 0x5c, 0x2e, 0xf9, 0xab,
	0x29, 0xfe, 0x5d, 0xed, 0xb0, 0x5a, 0x39, 0x2c, 0x1d, 0x9f, 0x68, 0x0f, 0x64, 0x09, 0x6d, 0xc2,
	0x7a, 0x00, 0x72, 0x6f, 0x47, 0x8e, 0x28, 0xf7, 0xa7, 0x13, 0x31, 0xb1, 0x75, 0x06, 0xe0, 0xe8,
	0xa4, 0xd9, 0xd2, 0x8e, 0x8a, 0xad, 0xd2, 0xa1, 0xbc, 0x42, 0x69, 0x17, 0x6b, 0xb5, 0xc6, 0x53,
	0xad, 0xd6, 0x68, 0x34, 0xcb, 0xb2, 0xa4, 0x54, 0x00, 0xcd, 0xdf, 0x1d, 0x6f, 0x08, 0xaa, 0xe5,
	0xe2, 0x91, 0xb6, 0x5f, 0x3e, 0x28, 0x9e, 0xd4, 0x5a, 0xf2, 0x0a, 0x5a, 0x87, 0xa4, 0x80, 0x35,
	0xea, 0xb2, 0x44, 0x29, 0xfb, 0xc3, 0x83, 0x03, 0x39, 0xa2, 0x3c, 0x81, 0x54, 0xe0, 0xf8, 0xd1,
	0x75, 0xb8, 0x52, 0x6b, 0x54, 0x2a, 0xd5, 0x7a, 0x45, 0x9b, 0x16, 0x06, 0x20, 0x56, 0x2b, 0x57,
	0x8a, 0xa5, 0x1f, 0xcb, 0x12, 0x3d, 0x86, 0x4a, 0xa9, 0xa9, 0x35, 0xea, 0xb5, 0x1f, 0xcb, 0x11,
	0xe5, 0x7f, 0xd6, 0x00, 0x9e, 0x4e, 0x54, 0xc1, 0xcf, 0xd5, 0x32, 0x81, 0x5c, 0x6d, 0xfa, 0x13,
	0x88, 0xc8, 0xec, 0x27, 0x10, 0x3b, 0x70, 0xcd, 0xc3, 0xee, 0xc8, 0xec, 0x60, 0x4d, 0xef, 0x74,
	0x9c, 0xa1, 0x4d, 0x34, 0xdc, 0xd7, 0x4d, 0x4b, 0x84, 0x9d, 0x2b, 0x62, 0xb2, 0xc8, 0xe7, 0xca,
	0x74, 0x8a, 0xa6, 0x06, 0x42, 0x25, 0x19, 0x90, 0x99, 0x5b, 0x54, 0x15, 0x6a, 0x5a, 0xa2, 0x20,
	0x74, 0x0c, 0xeb, 0xe3, 0x25, 0x34, 0x13, 0x65, 0x0f, 0x52, 0xe1, 0xfe, 0xf4, 0xa9, 0x20, 0xc1,
	0x6a, 0x93, 0xf4, 0xb3, 0xc0, 0x88, 0xfa, 0x66, 0x17, 0x1b, 0xe3, 0x4f, 0x1e, 0x32, 0xa1, 0xe9,
	0xe6, 0xe4, 0x5c, 0xf2, 0x2a, 0x43, 0x54, 0x7d, 0x02, 0xe8, 0xe3, 0xe9, 0x8a, 0x24, 0x15, 0xda,
	0xf3, 0x0b, 0x16, 0x23, 0x1f, 0x43, 0x6a, 0xc8, 0x22, 0x11, 0x47, 0xde, 0x0c, 0x47, 0xe6, 0xcb,
	0x7d, 0xe4, 0x2e, 0x0b, 0x96, 0x1c, 0x39, 0x1d, 0x8e, 0xcc, 0x97, 0x33, 0xe4, 0xc3, 0xf1, 0xf3,
	0xdd, 0x3a, 0x33, 0xf4, 0x25, 0x4e, 0x60, 0xe6, 0x01, 0xf9, 0xa7, 0x10, 0xe3, 0x67, 0x82, 0xb6,
	0x00, 0xa9, 0xe5, 0x4a, 0xb5, 0x51, 0x9f, 0xd1, 0x39, 0x6a, 0x51, 0x4d, 0xad, 0x54, 0xae, 0xb7,
	0xd4, 0x62, 0xed, 0x2e, 0x57, 0xbc, 0x93, 0xa6, 0xf6, 0xb4, 0xdc, 0x6c, 0xdd, 0x95, 0x23, 0x62,
	0x54, 0x2e, 0xd2, 0x51, 0x34, 0x30, 0xfa, 0xa1, 0xbc, 0xaa, 0x7c, 0x3e, 0x6e, 0x92, 0x6f, 0x01,
	0x1a, 0x37, 0xc9, 0x83, 0xc4, 0xd3, 0x90, 0x28, 0xa9, 0xe5, 0x62, 0xab, 0x5a, 0xaf, 0xf0, 0x56,
	0xb9, 0x7a, 0x52, 0xaf, 0xf3, 0x56, 0x79, 0x1a, 0x12, 0xfb, 0xe5, 0x5a, 0x99, 0x4d, 0xb1, 0x5e,
	0x39, 0x1b, 0x95, 0xf7, 0xe5, 0x55, 0xe5, 0xef, 0x25, 0x48, 0x07, 0x15, 0x84, 0xea, 0xe1, 0x54,
	0xec, 0xe1, 0xb5, 0xd3, 0x0b, 0x43, 0x48, 0x64, 0x2e, 0x84, 0x3c, 0x81, 0xb8, 0x8d, 0x09, 0x55,
	0x35, 0x11, 0xf3, 0xc3, 0x9e, 0x0a, 0xeb, 0x7c, 0xb5, 0xea, 0xa3, 0x51, 0x6f, 0x49, 0xb3, 0x67,
	0xf1, 0x51, 0x05, 0xd1, 0x0d, 0xa5, 0x0d, 0x71, 0xb1, 0x2a, 0xec, 0x0b, 0xa4, 0xec, 0x64, 0x77,
	0x6e, 0x9a, 0x63, 0xaa, 0x6f, 0x00, 0x78, 0xc3, 0x76, 0x90, 0xb5, 0xa4, 0x1a, 0x80, 0x28, 0x5f,
	0xc1, 0x75, 0x9e, 0x70, 0x4f, 0x6e, 0xd9, 0x4f, 0x87, 0xb6, 0x20, 0x36, 0xd0, 0x5d, 0x6c, 0x8f,
	0x3f, 0xaa, 0xe2, 0x23, 0xf4, 0xe9, 0x74, 0x28, 0x59, 0xac, 0xf9, 0x19, 0x20, 0x1f, 0x88, 0x3a,
	0xca, 0xbb, 0x70, 0xb5, 0x82, 0xc9, 0xfc, 0xde, 0x17, 0x7c, 0x90, 0xa0, 0xbc, 0x0f, 0xd7, 0x79,
	0x86, 0xb8, 0xd8, 0xf2, 0x73, 0xb8, 0xce, 0x53, 0xbd, 0xcb, 0x97, 0x47, 0x02, 0x0e, 0x6e, 0x46,
	0xaa, 0xe8, 0xab, 0x48, 0xf5, 0x01, 0x6c, 0xd1, 0xcc, 0x7a, 0x32, 0xeb, 0x85, 0x9c, 0xa9, 0x62,
	0xc0, 0xf5, 0x39, 0x0c, 0x91, 0x89, 0xd7, 0xc6, 0x6e, 0x92, 0x32, 0xe6, 0x67, 0xe3, 0x4b, 0x70,
	0x96, 0x9a, 0x70, 0xe6, 0xed, 0xfc, 0xcd, 0x16, 0x40, 0x89, 0xae, 0xe4, 0xdf, 0x00, 0xfc, 0x56,
	0x82, 0x54, 0xa0, 0xe0, 0x42, 0x61, 0xbd, 0x9f, 0xf9, 0x76, 0x68, 0xee, 0xa6, 0x8f, 0x12, 0xf8,
	0x12, 0x32, 0x3f, 0x7e, 0xcc, 0x50, 0xba, 0xdf, 0x16, 0x6f, 0xf9, 0x5f, 0x1c, 0x5c, 0xf2, 0xd0,
	0xf1, 0xbc, 0x28, 0x4f, 0x94, 0xfb, 0x3d, 0xb6, 0xd7, 0x2f, 0xff, 0xfd, 0xbf, 0xff, 0x2a, 0xf2,
	0x8e, 0xb2, 0x5d, 0x18, 0xdd, 0x2d, 0x88, 0x39, 0xaf, 0xf0, 0xe5, 0x64, 0xd5, 0x57, 0x05, 0xde,
	0xf9, 0xdb, 0x15, 0xad, 0xa3, 0xbf, 0x96, 0x20, 0xe1, 0xd7, 0x6a, 0x28, 0x1f, 0xd6, 0xc0, 0x9a,
	0x6e, 0xac, 0xe6, 0x16, 0x6a, 0x53, 0x29, 0x8f, 0x9e, 0x17, 0xd7, 0x03, 0x6c, 0x9a, 0x9c, 0xc7,
	0x1f, 0xa0, 0xb7, 0xc3, 0x78, 0x2c, 0x7c, 0x69, 0x76, 0xbf, 0x42, 0xbf, 0x96, 0x00, 0x26, 0x7d,
	0x4f, 0x14, 0xe6, 0x74, 0xe7, 0xfa, 0xb5, 0xb9, 0xbb, 0x4b, 0x60, 0x70, 0xd5, 0x51, 0x1e, 0x3e,
	0x2f, 0x6e, 0x06, 0x58, 0xe6, 0x0d, 0x58, 0xc6, 0xb6, 0x82, 0x42, 0x8f, 0x96, 0x72, 0x9c, 0x0a,
	0x74, 0x4b, 0xc3, 0x75, 0x63, 0xae, 0xb3, 0xba, 0xe0, 0xc9, 0x56, 0x2e, 0x3c, 0xd9, 0xbb, 0xca,
	0x7b, 0x0b, 0x9d, 0xec, 0x6e, 0x87, 0xed, 0xbb, 0x2b, 0xbd, 0x8b, 0xfe, 0x45, 0x02, 0x98, 0x7c,
	0x11, 0x1b, 0x7a, 0xc6, 0x73, 0x1f, 0xcf, 0x86, 0xe9, 0x72, 0x6f, 0x11, 0x5d, 0xbe, 0x40, 0x94,
	0x0f, 0x94, 0x3b, 0x8b, 0x89, 0xe2, 0x52, 0x8e, 0xa8, 0x24, 0xbf, 0x95, 0xa6, 0x9e, 0x1e, 0xfc,
	0xfe, 0xf2, 0x83, 0xc5, 0xcd, 0x73, 0xba, 0xb6, 0xcd, 0x2d, 0x53, 0x82, 0x2a, 0x87, 0xcf, 0x8b,
	0x28, 0x20, 0x85, 0xa8, 0x45, 0x99, 0x28, 0xef, 0x2b, 0xca, 0xe5, 0xa2, 0xf8, 0x45, 0xff, 0xae,
	0x5f, 0xbe, 0xa2, 0x7f, 0x96, 0x26, 0xef, 0x18, 0xbe, 0x10, 0xf7, 0x17, 0x34, 0xcf, 0x57, 0x91,
	0xa0, 0xf1, 0xbc, 0x78, 0x6d, 0x5e, 0x02, 0xcd, 0x57, 0x2d, 0x54, 0x08, 0x17, 0xa2, 0xf0, 0xe5,
	0x04, 0xeb, 0x2b, 0xf4, 0x4f, 0xc1, 0x37, 0x14, 0xbf, 0x5b, 0x82, 0x3e, 0x5a, 0xd4, 0x26, 0x67,
	0x9a, 0x3b, 0xb9, 0x07, 0xcb, 0x23, 0x0a, 0x9b, 0xfe, 0xe8, 0x79, 0x31, 0x90, 0x0a, 0x30, 0x71,
	0xbe, 0x87, 0x16, 0xb8, 0x13, 0xf4, 0x1b, 0x09, 0xd0, 0x7c, 0x87, 0x25, 0x54, 0xa5, 0x2e, 0x6d,
	0xca, 0xe4, 0xb6, 0xe6, 0xf2, 0xcd, 0x72, 0x7f, 0x40, 0xce, 0xc3, 0xce, 0xfe, 0xdd, 0xa5, 0xcf,
	0xfe, 0x3f, 0x24, 0x40, 0xf3, 0x5d, 0x9b, 0x50, 0xce, 0x2f, 0x6d, 0xf4, 0x2c, 0xa7, 0x4a, 0x3f,
	0x7b, 0x5e, 0xbc, 0x79, 0xa1, 0x38, 0x53, 0x76, 0xb1, 0xbb, 0xb3, 0xac, 0x58, 0x13, 0x23, 0xf9,
	0x5f, 0x09, 0x36, 0x66, 0xbe, 0xbc, 0x0f, 0x35, 0x92, 0x8b, 0xbf, 0xd4, 0x0f, 0x73, 0x60, 0x5f,
	0x4b, 0x8b, 0x78, 0xb0, 0xd7, 0x2f, 0x16, 0x97, 0xb7, 0x8a, 0x98, 0xb4, 0x8f, 0x94, 0x7b, 0xcb,
	0x4a, 0xeb, 0x0e, 0xed, 0x5d, 0xff, 0xbb, 0xbc, 0x67, 0x20, 0xcf, 0x26, 0x9d, 0xe8, 0xc3, 0x85,
	0x5c, 0xdb, 0x5c, 0x2e, 0x97, 0x5b, 0x3c, 0x11, 0x52, 0x56, 0xd0, 0xcf, 0x61, 0x7d, 0x2a, 0xdd,
	0x44, 0xf7, 0xc2, 0x7d, 0xd1, 0x2b, 0x6e, 0xd9, 0x05, 0x79, 0x36, 0x6b, 0x0d, 0x95, 0xf5, 0x92,
	0x34, 0xf7, 0x52, 0x8b, 0x5b, 0xa1, 0x27, 0x3a, 0x9b, 0xec, 0x86, 0xee, 0x72, 0x49, 0x76, 0xbc,
	0x9c, 0x78, 0xbf, 0x94, 0x60, 0x63, 0x26, 0x73, 0x0d, 0xd5, 0xdd, 0x8b, 0x73, 0xe3, 0xdc, 0x87,
	0xcb, 0xa2, 0x09, 0x8f, 0xb8, 0x92, 0x3b, 0xfa, 0xb6, 0x78, 0x23, 0xb0, 0x96, 0x93, 0xd1, 0x07,
	0xa6, 0x97, 0xef, 0x38, 0xfd, 0x7f, 0x2b, 0xe6, 0x7b, 0x84, 0x0c, 0xbc, 0xdd, 0x42, 0xe1, 0xd9,
	0xb3, 0x67, 0x33, 0x93, 0x05, 0x7d, 0x48, 0x7a, 0xfc, 0x6f, 0x8a, 0xde, 0x1f, 0x58, 0x3a, 0x39,
	0x75, 0xdc, 0xfe, 0xde, 0x19, 0x64, 0x3b, 0x4e, 0xdf, 0xe7, 0x66, 0x8a, 0x89, 0x63, 0xe9, 0x27,
	0x15, 0x01, 0x37, 0x1c, 0x4b, 0xb7, 0x8d, 0xbc, 0xe3, 0x1a, 0x05, 0x03, 0xdb, 0xec, 0x46, 0x0a,
	0x13, 0xe2, 0x97, 0xfc, 0xf9, 0xd2, 0xc7, 0x93, 0xd1, 0xdf, 0x46, 0xa2, 0x95, 0xd2, 0x5e, 0x3b,
	0xc6, 0x30, 0xef, 0xfd, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x24, 0x09, 0x72, 0x18, 0xf7, 0x34,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudBuildClient is the client API for CloudBuild service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudBuildClient interface {
	// Starts a build with the specified configuration.
	//
	// This method returns a long-running `Operation`, which includes the build
	// ID. Pass the build ID to `GetBuild` to determine the build status (such as
	// `SUCCESS` or `FAILURE`).
	CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The `Build` that is returned includes its status (such as `SUCCESS`,
	// `FAILURE`, or `WORKING`), and timing information.
	GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Cancels a build in progress.
	CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Creates a new build based on the specified build.
	//
	// This method creates a new build using the original build request, which may
	// or may not result in an identical build.
	//
	// For triggered builds:
	//
	// * Triggered builds resolve to a precise revision; therefore a retry of a
	// triggered build will result in a build that uses the same revision.
	//
	// For non-triggered builds that specify `RepoSource`:
	//
	// * If the original build built from the tip of a branch, the retried build
	// will build from the tip of that branch, which may not be the same revision
	// as the original build.
	// * If the original build specified a commit sha or revision ID, the retried
	// build will use the identical source.
	//
	// For builds that specify `StorageSource`:
	//
	// * If the original build pulled source from Google Cloud Storage without
	// specifying the generation of the object, the new build will use the current
	// object, which may be different from the original build source.
	// * If the original build pulled source from Cloud Storage and specified the
	// generation of the object, the new build will attempt to use the same
	// object, which may or may not be available depending on the bucket's
	// lifecycle management settings.
	RetryBuild(ctx context.Context, in *RetryBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new `BuildTrigger`.
	//
	// This API is experimental.
	CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Returns information about a `BuildTrigger`.
	//
	// This API is experimental.
	GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Lists existing `BuildTrigger`s.
	//
	// This API is experimental.
	ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error)
	// Deletes a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Runs a `BuildTrigger` at a particular source revision.
	RunBuildTrigger(ctx context.Context, in *RunBuildTriggerRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a `WorkerPool` to run the builds, and returns the new worker pool.
	//
	// This API is experimental.
	CreateWorkerPool(ctx context.Context, in *CreateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// Returns information about a `WorkerPool`.
	//
	// This API is experimental.
	GetWorkerPool(ctx context.Context, in *GetWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// Deletes a `WorkerPool` by its project ID and WorkerPool name.
	//
	// This API is experimental.
	DeleteWorkerPool(ctx context.Context, in *DeleteWorkerPoolRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Update a `WorkerPool`.
	//
	// This API is experimental.
	UpdateWorkerPool(ctx context.Context, in *UpdateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// List project's `WorkerPool`s.
	//
	// This API is experimental.
	ListWorkerPools(ctx context.Context, in *ListWorkerPoolsRequest, opts ...grpc.CallOption) (*ListWorkerPoolsResponse, error)
}

type cloudBuildClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudBuildClient(cc grpc.ClientConnInterface) CloudBuildClient {
	return &cloudBuildClient{cc}
}

func (c *cloudBuildClient) CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) RetryBuild(ctx context.Context, in *RetryBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/RetryBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error) {
	out := new(ListBuildTriggersResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) RunBuildTrigger(ctx context.Context, in *RunBuildTriggerRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CreateWorkerPool(ctx context.Context, in *CreateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetWorkerPool(ctx context.Context, in *GetWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) DeleteWorkerPool(ctx context.Context, in *DeleteWorkerPoolRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/DeleteWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) UpdateWorkerPool(ctx context.Context, in *UpdateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/UpdateWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListWorkerPools(ctx context.Context, in *ListWorkerPoolsRequest, opts ...grpc.CallOption) (*ListWorkerPoolsResponse, error) {
	out := new(ListWorkerPoolsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListWorkerPools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudBuildServer is the server API for CloudBuild service.
type CloudBuildServer interface {
	// Starts a build with the specified configuration.
	//
	// This method returns a long-running `Operation`, which includes the build
	// ID. Pass the build ID to `GetBuild` to determine the build status (such as
	// `SUCCESS` or `FAILURE`).
	CreateBuild(context.Context, *CreateBuildRequest) (*longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The `Build` that is returned includes its status (such as `SUCCESS`,
	// `FAILURE`, or `WORKING`), and timing information.
	GetBuild(context.Context, *GetBuildRequest) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Cancels a build in progress.
	CancelBuild(context.Context, *CancelBuildRequest) (*Build, error)
	// Creates a new build based on the specified build.
	//
	// This method creates a new build using the original build request, which may
	// or may not result in an identical build.
	//
	// For triggered builds:
	//
	// * Triggered builds resolve to a precise revision; therefore a retry of a
	// triggered build will result in a build that uses the same revision.
	//
	// For non-triggered builds that specify `RepoSource`:
	//
	// * If the original build built from the tip of a branch, the retried build
	// will build from the tip of that branch, which may not be the same revision
	// as the original build.
	// * If the original build specified a commit sha or revision ID, the retried
	// build will use the identical source.
	//
	// For builds that specify `StorageSource`:
	//
	// * If the original build pulled source from Google Cloud Storage without
	// specifying the generation of the object, the new build will use the current
	// object, which may be different from the original build source.
	// * If the original build pulled source from Cloud Storage and specified the
	// generation of the object, the new build will attempt to use the same
	// object, which may or may not be available depending on the bucket's
	// lifecycle management settings.
	RetryBuild(context.Context, *RetryBuildRequest) (*longrunning.Operation, error)
	// Creates a new `BuildTrigger`.
	//
	// This API is experimental.
	CreateBuildTrigger(context.Context, *CreateBuildTriggerRequest) (*BuildTrigger, error)
	// Returns information about a `BuildTrigger`.
	//
	// This API is experimental.
	GetBuildTrigger(context.Context, *GetBuildTriggerRequest) (*BuildTrigger, error)
	// Lists existing `BuildTrigger`s.
	//
	// This API is experimental.
	ListBuildTriggers(context.Context, *ListBuildTriggersRequest) (*ListBuildTriggersResponse, error)
	// Deletes a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(context.Context, *DeleteBuildTriggerRequest) (*empty.Empty, error)
	// Updates a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(context.Context, *UpdateBuildTriggerRequest) (*BuildTrigger, error)
	// Runs a `BuildTrigger` at a particular source revision.
	RunBuildTrigger(context.Context, *RunBuildTriggerRequest) (*longrunning.Operation, error)
	// Creates a `WorkerPool` to run the builds, and returns the new worker pool.
	//
	// This API is experimental.
	CreateWorkerPool(context.Context, *CreateWorkerPoolRequest) (*WorkerPool, error)
	// Returns information about a `WorkerPool`.
	//
	// This API is experimental.
	GetWorkerPool(context.Context, *GetWorkerPoolRequest) (*WorkerPool, error)
	// Deletes a `WorkerPool` by its project ID and WorkerPool name.
	//
	// This API is experimental.
	DeleteWorkerPool(context.Context, *DeleteWorkerPoolRequest) (*empty.Empty, error)
	// Update a `WorkerPool`.
	//
	// This API is experimental.
	UpdateWorkerPool(context.Context, *UpdateWorkerPoolRequest) (*WorkerPool, error)
	// List project's `WorkerPool`s.
	//
	// This API is experimental.
	ListWorkerPools(context.Context, *ListWorkerPoolsRequest) (*ListWorkerPoolsResponse, error)
}

// UnimplementedCloudBuildServer can be embedded to have forward compatible implementations.
type UnimplementedCloudBuildServer struct {
}

func (*UnimplementedCloudBuildServer) CreateBuild(ctx context.Context, req *CreateBuildRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBuild not implemented")
}
func (*UnimplementedCloudBuildServer) GetBuild(ctx context.Context, req *GetBuildRequest) (*Build, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBuild not implemented")
}
func (*UnimplementedCloudBuildServer) ListBuilds(ctx context.Context, req *ListBuildsRequest) (*ListBuildsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuilds not implemented")
}
func (*UnimplementedCloudBuildServer) CancelBuild(ctx context.Context, req *CancelBuildRequest) (*Build, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelBuild not implemented")
}
func (*UnimplementedCloudBuildServer) RetryBuild(ctx context.Context, req *RetryBuildRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetryBuild not implemented")
}
func (*UnimplementedCloudBuildServer) CreateBuildTrigger(ctx context.Context, req *CreateBuildTriggerRequest) (*BuildTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) GetBuildTrigger(ctx context.Context, req *GetBuildTriggerRequest) (*BuildTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) ListBuildTriggers(ctx context.Context, req *ListBuildTriggersRequest) (*ListBuildTriggersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuildTriggers not implemented")
}
func (*UnimplementedCloudBuildServer) DeleteBuildTrigger(ctx context.Context, req *DeleteBuildTriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) UpdateBuildTrigger(ctx context.Context, req *UpdateBuildTriggerRequest) (*BuildTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) RunBuildTrigger(ctx context.Context, req *RunBuildTriggerRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) CreateWorkerPool(ctx context.Context, req *CreateWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) GetWorkerPool(ctx context.Context, req *GetWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) DeleteWorkerPool(ctx context.Context, req *DeleteWorkerPoolRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) UpdateWorkerPool(ctx context.Context, req *UpdateWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) ListWorkerPools(ctx context.Context, req *ListWorkerPoolsRequest) (*ListWorkerPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkerPools not implemented")
}

func RegisterCloudBuildServer(s *grpc.Server, srv CloudBuildServer) {
	s.RegisterService(&_CloudBuild_serviceDesc, srv)
}

func _CloudBuild_CreateBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuild(ctx, req.(*CreateBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuild(ctx, req.(*GetBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CancelBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CancelBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CancelBuild(ctx, req.(*CancelBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_RetryBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).RetryBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/RetryBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).RetryBuild(ctx, req.(*RetryBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CreateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, req.(*CreateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, req.(*GetBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuildTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, req.(*ListBuildTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_DeleteBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, req.(*DeleteBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_UpdateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, req.(*UpdateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_RunBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).RunBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).RunBuildTrigger(ctx, req.(*RunBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CreateWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateWorkerPool(ctx, req.(*CreateWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetWorkerPool(ctx, req.(*GetWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_DeleteWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).DeleteWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/DeleteWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).DeleteWorkerPool(ctx, req.(*DeleteWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_UpdateWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).UpdateWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/UpdateWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).UpdateWorkerPool(ctx, req.(*UpdateWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListWorkerPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkerPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListWorkerPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListWorkerPools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListWorkerPools(ctx, req.(*ListWorkerPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudBuild_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudbuild.v1.CloudBuild",
	HandlerType: (*CloudBuildServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBuild",
			Handler:    _CloudBuild_CreateBuild_Handler,
		},
		{
			MethodName: "GetBuild",
			Handler:    _CloudBuild_GetBuild_Handler,
		},
		{
			MethodName: "ListBuilds",
			Handler:    _CloudBuild_ListBuilds_Handler,
		},
		{
			MethodName: "CancelBuild",
			Handler:    _CloudBuild_CancelBuild_Handler,
		},
		{
			MethodName: "RetryBuild",
			Handler:    _CloudBuild_RetryBuild_Handler,
		},
		{
			MethodName: "CreateBuildTrigger",
			Handler:    _CloudBuild_CreateBuildTrigger_Handler,
		},
		{
			MethodName: "GetBuildTrigger",
			Handler:    _CloudBuild_GetBuildTrigger_Handler,
		},
		{
			MethodName: "ListBuildTriggers",
			Handler:    _CloudBuild_ListBuildTriggers_Handler,
		},
		{
			MethodName: "DeleteBuildTrigger",
			Handler:    _CloudBuild_DeleteBuildTrigger_Handler,
		},
		{
			MethodName: "UpdateBuildTrigger",
			Handler:    _CloudBuild_UpdateBuildTrigger_Handler,
		},
		{
			MethodName: "RunBuildTrigger",
			Handler:    _CloudBuild_RunBuildTrigger_Handler,
		},
		{
			MethodName: "CreateWorkerPool",
			Handler:    _CloudBuild_CreateWorkerPool_Handler,
		},
		{
			MethodName: "GetWorkerPool",
			Handler:    _CloudBuild_GetWorkerPool_Handler,
		},
		{
			MethodName: "DeleteWorkerPool",
			Handler:    _CloudBuild_DeleteWorkerPool_Handler,
		},
		{
			MethodName: "UpdateWorkerPool",
			Handler:    _CloudBuild_UpdateWorkerPool_Handler,
		},
		{
			MethodName: "ListWorkerPools",
			Handler:    _CloudBuild_ListWorkerPools_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudbuild/v1/cloudbuild.proto",
}
