// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchDeleteDocument = "BatchDeleteDocument"

// BatchDeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteDocument for more information on using the BatchDeleteDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteDocumentRequest method.
//    req, resp := client.BatchDeleteDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument
func (c *Kendra) BatchDeleteDocumentRequest(input *BatchDeleteDocumentInput) (req *request.Request, output *BatchDeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteDocumentInput{}
	}

	output = &BatchDeleteDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteDocument API operation for AWSKendraFrontendService.
//
// Removes one or more documents from an index. The documents must have been
// added with the BatchPutDocument operation.
//
// The documents are deleted asynchronously. You can see the progress of the
// deletion by using AWS CloudWatch. Any error messages releated to the processing
// of the batch are sent to you CloudWatch log.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation BatchDeleteDocument for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchDeleteDocument
func (c *Kendra) BatchDeleteDocument(input *BatchDeleteDocumentInput) (*BatchDeleteDocumentOutput, error) {
	req, out := c.BatchDeleteDocumentRequest(input)
	return out, req.Send()
}

// BatchDeleteDocumentWithContext is the same as BatchDeleteDocument with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) BatchDeleteDocumentWithContext(ctx aws.Context, input *BatchDeleteDocumentInput, opts ...request.Option) (*BatchDeleteDocumentOutput, error) {
	req, out := c.BatchDeleteDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutDocument = "BatchPutDocument"

// BatchPutDocumentRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutDocument for more information on using the BatchPutDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutDocumentRequest method.
//    req, resp := client.BatchPutDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument
func (c *Kendra) BatchPutDocumentRequest(input *BatchPutDocumentInput) (req *request.Request, output *BatchPutDocumentOutput) {
	op := &request.Operation{
		Name:       opBatchPutDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchPutDocumentInput{}
	}

	output = &BatchPutDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutDocument API operation for AWSKendraFrontendService.
//
// Adds one or more documents to an index.
//
// The BatchPutDocument operation enables you to ingest inline documents or
// a set of documents stored in an Amazon S3 bucket. Use this operation to ingest
// your text and unstructured text into an index, add custom attributes to the
// documents, and to attach an access control list to the documents added to
// the index.
//
// The documents are indexed asynchronously. You can see the progress of the
// batch using AWS CloudWatch. Any error messages related to processing the
// batch are sent to your AWS CloudWatch log.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation BatchPutDocument for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ServiceQuotaExceededException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/BatchPutDocument
func (c *Kendra) BatchPutDocument(input *BatchPutDocumentInput) (*BatchPutDocumentOutput, error) {
	req, out := c.BatchPutDocumentRequest(input)
	return out, req.Send()
}

// BatchPutDocumentWithContext is the same as BatchPutDocument with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) BatchPutDocumentWithContext(ctx aws.Context, input *BatchPutDocumentInput, opts ...request.Option) (*BatchPutDocumentOutput, error) {
	req, out := c.BatchPutDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceRequest method.
//    req, resp := client.CreateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource
func (c *Kendra) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for AWSKendraFrontendService.
//
// Creates a data source that you use to with an Amazon Kendra index.
//
// You specify a name, connector type and description for your data source.
// You can choose between an S3 connector, a SharePoint Online connector, and
// a database connector.
//
// You also specify configuration information such as document metadata (author,
// source URI, and so on) and user context information.
//
// CreateDataSource is a synchronous operation. The operation returns 200 if
// the data source was successfully created. Otherwise, an exception is raised.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ResourceAlreadyExistException
//
//   * ServiceQuotaExceededException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource
func (c *Kendra) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFaq = "CreateFaq"

// CreateFaqRequest generates a "aws/request.Request" representing the
// client's request for the CreateFaq operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFaq for more information on using the CreateFaq
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFaqRequest method.
//    req, resp := client.CreateFaqRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq
func (c *Kendra) CreateFaqRequest(input *CreateFaqInput) (req *request.Request, output *CreateFaqOutput) {
	op := &request.Operation{
		Name:       opCreateFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFaqInput{}
	}

	output = &CreateFaqOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFaq API operation for AWSKendraFrontendService.
//
// Creates an new set of frequently asked question (FAQ) questions and answers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateFaq for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ServiceQuotaExceededException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateFaq
func (c *Kendra) CreateFaq(input *CreateFaqInput) (*CreateFaqOutput, error) {
	req, out := c.CreateFaqRequest(input)
	return out, req.Send()
}

// CreateFaqWithContext is the same as CreateFaq with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFaq for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateFaqWithContext(ctx aws.Context, input *CreateFaqInput, opts ...request.Option) (*CreateFaqOutput, error) {
	req, out := c.CreateFaqRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIndex = "CreateIndex"

// CreateIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIndex for more information on using the CreateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIndexRequest method.
//    req, resp := client.CreateIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex
func (c *Kendra) CreateIndexRequest(input *CreateIndexInput) (req *request.Request, output *CreateIndexOutput) {
	op := &request.Operation{
		Name:       opCreateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIndexInput{}
	}

	output = &CreateIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIndex API operation for AWSKendraFrontendService.
//
// Creates a new Amazon Kendra index. Index creation is an asynchronous operation.
// To determine if index creation has completed, check the Status field returned
// from a call to . The Status field is set to ACTIVE when the index is ready
// to use.
//
// Once the index is active you can index your documents using the operation
// or using one of the supported data sources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation CreateIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceAlreadyExistException
//
//   * ServiceQuotaExceededException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex
func (c *Kendra) CreateIndex(input *CreateIndexInput) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	return out, req.Send()
}

// CreateIndexWithContext is the same as CreateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) CreateIndexWithContext(ctx aws.Context, input *CreateIndexInput, opts ...request.Option) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFaq = "DeleteFaq"

// DeleteFaqRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFaq operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFaq for more information on using the DeleteFaq
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFaqRequest method.
//    req, resp := client.DeleteFaqRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq
func (c *Kendra) DeleteFaqRequest(input *DeleteFaqInput) (req *request.Request, output *DeleteFaqOutput) {
	op := &request.Operation{
		Name:       opDeleteFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFaqInput{}
	}

	output = &DeleteFaqOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFaq API operation for AWSKendraFrontendService.
//
// Removes an FAQ from an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteFaq for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq
func (c *Kendra) DeleteFaq(input *DeleteFaqInput) (*DeleteFaqOutput, error) {
	req, out := c.DeleteFaqRequest(input)
	return out, req.Send()
}

// DeleteFaqWithContext is the same as DeleteFaq with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFaq for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteFaqWithContext(ctx aws.Context, input *DeleteFaqInput, opts ...request.Option) (*DeleteFaqOutput, error) {
	req, out := c.DeleteFaqRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIndex = "DeleteIndex"

// DeleteIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIndex for more information on using the DeleteIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIndexRequest method.
//    req, resp := client.DeleteIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex
func (c *Kendra) DeleteIndexRequest(input *DeleteIndexInput) (req *request.Request, output *DeleteIndexOutput) {
	op := &request.Operation{
		Name:       opDeleteIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIndexInput{}
	}

	output = &DeleteIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIndex API operation for AWSKendraFrontendService.
//
// Deletes an existing Amazon Kendra index. An exception is not thrown if the
// index is already being deleted. While the index is being deleted, the Status
// field returned by a call to the DescribeIndex operation is set to DELETING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DeleteIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteIndex
func (c *Kendra) DeleteIndex(input *DeleteIndexInput) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	return out, req.Send()
}

// DeleteIndexWithContext is the same as DeleteIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DeleteIndexWithContext(ctx aws.Context, input *DeleteIndexInput, opts ...request.Option) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSource for more information on using the DescribeDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourceRequest method.
//    req, resp := client.DescribeDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource
func (c *Kendra) DescribeDataSourceRequest(input *DescribeDataSourceInput) (req *request.Request, output *DescribeDataSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	output = &DescribeDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSource API operation for AWSKendraFrontendService.
//
// Gets information about a Amazon Kendra data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeDataSource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource
func (c *Kendra) DescribeDataSource(input *DescribeDataSourceInput) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	return out, req.Send()
}

// DescribeDataSourceWithContext is the same as DescribeDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeDataSourceWithContext(ctx aws.Context, input *DescribeDataSourceInput, opts ...request.Option) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFaq = "DescribeFaq"

// DescribeFaqRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFaq operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFaq for more information on using the DescribeFaq
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFaqRequest method.
//    req, resp := client.DescribeFaqRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq
func (c *Kendra) DescribeFaqRequest(input *DescribeFaqInput) (req *request.Request, output *DescribeFaqOutput) {
	op := &request.Operation{
		Name:       opDescribeFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFaqInput{}
	}

	output = &DescribeFaqOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFaq API operation for AWSKendraFrontendService.
//
// Gets information about an FAQ list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeFaq for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeFaq
func (c *Kendra) DescribeFaq(input *DescribeFaqInput) (*DescribeFaqOutput, error) {
	req, out := c.DescribeFaqRequest(input)
	return out, req.Send()
}

// DescribeFaqWithContext is the same as DescribeFaq with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFaq for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeFaqWithContext(ctx aws.Context, input *DescribeFaqInput, opts ...request.Option) (*DescribeFaqOutput, error) {
	req, out := c.DescribeFaqRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIndex = "DescribeIndex"

// DescribeIndexRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIndex for more information on using the DescribeIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIndexRequest method.
//    req, resp := client.DescribeIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex
func (c *Kendra) DescribeIndexRequest(input *DescribeIndexInput) (req *request.Request, output *DescribeIndexOutput) {
	op := &request.Operation{
		Name:       opDescribeIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIndexInput{}
	}

	output = &DescribeIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIndex API operation for AWSKendraFrontendService.
//
// Describes an existing Amazon Kendra index
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation DescribeIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeIndex
func (c *Kendra) DescribeIndex(input *DescribeIndexInput) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	return out, req.Send()
}

// DescribeIndexWithContext is the same as DescribeIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) DescribeIndexWithContext(ctx aws.Context, input *DescribeIndexInput, opts ...request.Option) (*DescribeIndexOutput, error) {
	req, out := c.DescribeIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataSourceSyncJobs = "ListDataSourceSyncJobs"

// ListDataSourceSyncJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSourceSyncJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSourceSyncJobs for more information on using the ListDataSourceSyncJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourceSyncJobsRequest method.
//    req, resp := client.ListDataSourceSyncJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs
func (c *Kendra) ListDataSourceSyncJobsRequest(input *ListDataSourceSyncJobsInput) (req *request.Request, output *ListDataSourceSyncJobsOutput) {
	op := &request.Operation{
		Name:       opListDataSourceSyncJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourceSyncJobsInput{}
	}

	output = &ListDataSourceSyncJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSourceSyncJobs API operation for AWSKendraFrontendService.
//
// Gets statistics about synchronizing Amazon Kendra with a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListDataSourceSyncJobs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSourceSyncJobs
func (c *Kendra) ListDataSourceSyncJobs(input *ListDataSourceSyncJobsInput) (*ListDataSourceSyncJobsOutput, error) {
	req, out := c.ListDataSourceSyncJobsRequest(input)
	return out, req.Send()
}

// ListDataSourceSyncJobsWithContext is the same as ListDataSourceSyncJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSourceSyncJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourceSyncJobsWithContext(ctx aws.Context, input *ListDataSourceSyncJobsInput, opts ...request.Option) (*ListDataSourceSyncJobsOutput, error) {
	req, out := c.ListDataSourceSyncJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourceSyncJobsPages iterates over the pages of a ListDataSourceSyncJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSourceSyncJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSourceSyncJobs operation.
//    pageNum := 0
//    err := client.ListDataSourceSyncJobsPages(params,
//        func(page *kendra.ListDataSourceSyncJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kendra) ListDataSourceSyncJobsPages(input *ListDataSourceSyncJobsInput, fn func(*ListDataSourceSyncJobsOutput, bool) bool) error {
	return c.ListDataSourceSyncJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourceSyncJobsPagesWithContext same as ListDataSourceSyncJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourceSyncJobsPagesWithContext(ctx aws.Context, input *ListDataSourceSyncJobsInput, fn func(*ListDataSourceSyncJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourceSyncJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourceSyncJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourceSyncJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourcesRequest method.
//    req, resp := client.ListDataSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources
func (c *Kendra) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for AWSKendraFrontendService.
//
// Lists the data sources that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * AccessDeniedException
//
//   * ThrottlingException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListDataSources
func (c *Kendra) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSources operation.
//    pageNum := 0
//    err := client.ListDataSourcesPages(params,
//        func(page *kendra.ListDataSourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kendra) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFaqs = "ListFaqs"

// ListFaqsRequest generates a "aws/request.Request" representing the
// client's request for the ListFaqs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFaqs for more information on using the ListFaqs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFaqsRequest method.
//    req, resp := client.ListFaqsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs
func (c *Kendra) ListFaqsRequest(input *ListFaqsInput) (req *request.Request, output *ListFaqsOutput) {
	op := &request.Operation{
		Name:       opListFaqs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFaqsInput{}
	}

	output = &ListFaqsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFaqs API operation for AWSKendraFrontendService.
//
// Gets a list of FAQ lists associated with an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListFaqs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListFaqs
func (c *Kendra) ListFaqs(input *ListFaqsInput) (*ListFaqsOutput, error) {
	req, out := c.ListFaqsRequest(input)
	return out, req.Send()
}

// ListFaqsWithContext is the same as ListFaqs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFaqs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListFaqsWithContext(ctx aws.Context, input *ListFaqsInput, opts ...request.Option) (*ListFaqsOutput, error) {
	req, out := c.ListFaqsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIndices = "ListIndices"

// ListIndicesRequest generates a "aws/request.Request" representing the
// client's request for the ListIndices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndices for more information on using the ListIndices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIndicesRequest method.
//    req, resp := client.ListIndicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices
func (c *Kendra) ListIndicesRequest(input *ListIndicesInput) (req *request.Request, output *ListIndicesOutput) {
	op := &request.Operation{
		Name:       opListIndices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndicesInput{}
	}

	output = &ListIndicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndices API operation for AWSKendraFrontendService.
//
// Lists the Amazon Kendra indexes that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation ListIndices for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices
func (c *Kendra) ListIndices(input *ListIndicesInput) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	return out, req.Send()
}

// ListIndicesWithContext is the same as ListIndices with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListIndicesWithContext(ctx aws.Context, input *ListIndicesInput, opts ...request.Option) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIndicesPages iterates over the pages of a ListIndices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIndices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIndices operation.
//    pageNum := 0
//    err := client.ListIndicesPages(params,
//        func(page *kendra.ListIndicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Kendra) ListIndicesPages(input *ListIndicesInput, fn func(*ListIndicesOutput, bool) bool) error {
	return c.ListIndicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIndicesPagesWithContext same as ListIndicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) ListIndicesPagesWithContext(ctx aws.Context, input *ListIndicesInput, fn func(*ListIndicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIndicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIndicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIndicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opQuery = "Query"

// QueryRequest generates a "aws/request.Request" representing the
// client's request for the Query operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Query for more information on using the Query
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryRequest method.
//    req, resp := client.QueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query
func (c *Kendra) QueryRequest(input *QueryInput) (req *request.Request, output *QueryOutput) {
	op := &request.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryInput{}
	}

	output = &QueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Query API operation for AWSKendraFrontendService.
//
// Searches an active index. Use this API to search your documents using query.
// The Query operation enables to do faceted search and to filter results based
// on document attributes.
//
// It also enables you to provide user context that Amazon Kendra uses to enforce
// document access control in the search results.
//
// Amazon Kendra searches your index for text content and question and answer
// (FAQ) content. By default the response contains three types of results.
//
//    * Relevant passages
//
//    * Matching FAQs
//
//    * Relevant documents
//
// You can specify that the query return only one type of result using the QueryResultTypeConfig
// parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation Query for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query
func (c *Kendra) Query(input *QueryInput) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	return out, req.Send()
}

// QueryWithContext is the same as Query with the addition of
// the ability to pass a context and additional request options.
//
// See Query for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) QueryWithContext(ctx aws.Context, input *QueryInput, opts ...request.Option) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDataSourceSyncJob = "StartDataSourceSyncJob"

// StartDataSourceSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDataSourceSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataSourceSyncJob for more information on using the StartDataSourceSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDataSourceSyncJobRequest method.
//    req, resp := client.StartDataSourceSyncJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob
func (c *Kendra) StartDataSourceSyncJobRequest(input *StartDataSourceSyncJobInput) (req *request.Request, output *StartDataSourceSyncJobOutput) {
	op := &request.Operation{
		Name:       opStartDataSourceSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataSourceSyncJobInput{}
	}

	output = &StartDataSourceSyncJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataSourceSyncJob API operation for AWSKendraFrontendService.
//
// Starts a synchronization job for a data source. If a synchronization job
// is already in progress, Amazon Kendra returns a ResourceInUseException exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation StartDataSourceSyncJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ResourceInUseException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * ConflictException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StartDataSourceSyncJob
func (c *Kendra) StartDataSourceSyncJob(input *StartDataSourceSyncJobInput) (*StartDataSourceSyncJobOutput, error) {
	req, out := c.StartDataSourceSyncJobRequest(input)
	return out, req.Send()
}

// StartDataSourceSyncJobWithContext is the same as StartDataSourceSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataSourceSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) StartDataSourceSyncJobWithContext(ctx aws.Context, input *StartDataSourceSyncJobInput, opts ...request.Option) (*StartDataSourceSyncJobOutput, error) {
	req, out := c.StartDataSourceSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDataSourceSyncJob = "StopDataSourceSyncJob"

// StopDataSourceSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDataSourceSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDataSourceSyncJob for more information on using the StopDataSourceSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDataSourceSyncJobRequest method.
//    req, resp := client.StopDataSourceSyncJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob
func (c *Kendra) StopDataSourceSyncJobRequest(input *StopDataSourceSyncJobInput) (req *request.Request, output *StopDataSourceSyncJobOutput) {
	op := &request.Operation{
		Name:       opStopDataSourceSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDataSourceSyncJobInput{}
	}

	output = &StopDataSourceSyncJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopDataSourceSyncJob API operation for AWSKendraFrontendService.
//
// Stops a running synchronization job. You can't stop a scheduled synchronization
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation StopDataSourceSyncJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/StopDataSourceSyncJob
func (c *Kendra) StopDataSourceSyncJob(input *StopDataSourceSyncJobInput) (*StopDataSourceSyncJobOutput, error) {
	req, out := c.StopDataSourceSyncJobRequest(input)
	return out, req.Send()
}

// StopDataSourceSyncJobWithContext is the same as StopDataSourceSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDataSourceSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) StopDataSourceSyncJobWithContext(ctx aws.Context, input *StopDataSourceSyncJobInput, opts ...request.Option) (*StopDataSourceSyncJobOutput, error) {
	req, out := c.StopDataSourceSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitFeedback = "SubmitFeedback"

// SubmitFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the SubmitFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitFeedback for more information on using the SubmitFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SubmitFeedbackRequest method.
//    req, resp := client.SubmitFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback
func (c *Kendra) SubmitFeedbackRequest(input *SubmitFeedbackInput) (req *request.Request, output *SubmitFeedbackOutput) {
	op := &request.Operation{
		Name:       opSubmitFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitFeedbackInput{}
	}

	output = &SubmitFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SubmitFeedback API operation for AWSKendraFrontendService.
//
// Enables you to provide feedback to Amazon Kendra to improve the performance
// of the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation SubmitFeedback for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ResourceUnavailableException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback
func (c *Kendra) SubmitFeedback(input *SubmitFeedbackInput) (*SubmitFeedbackOutput, error) {
	req, out := c.SubmitFeedbackRequest(input)
	return out, req.Send()
}

// SubmitFeedbackWithContext is the same as SubmitFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) SubmitFeedbackWithContext(ctx aws.Context, input *SubmitFeedbackInput, opts ...request.Option) (*SubmitFeedbackOutput, error) {
	req, out := c.SubmitFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourceRequest method.
//    req, resp := client.UpdateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource
func (c *Kendra) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataSource API operation for AWSKendraFrontendService.
//
// Updates an existing Amazon Kendra data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource
func (c *Kendra) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIndex = "UpdateIndex"

// UpdateIndexRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIndex for more information on using the UpdateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIndexRequest method.
//    req, resp := client.UpdateIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex
func (c *Kendra) UpdateIndexRequest(input *UpdateIndexInput) (req *request.Request, output *UpdateIndexOutput) {
	op := &request.Operation{
		Name:       opUpdateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIndexInput{}
	}

	output = &UpdateIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIndex API operation for AWSKendraFrontendService.
//
// Updates an existing Amazon Kendra index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSKendraFrontendService's
// API operation UpdateIndex for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * ConflictException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * AccessDeniedException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex
func (c *Kendra) UpdateIndex(input *UpdateIndexInput) (*UpdateIndexOutput, error) {
	req, out := c.UpdateIndexRequest(input)
	return out, req.Send()
}

// UpdateIndexWithContext is the same as UpdateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kendra) UpdateIndexWithContext(ctx aws.Context, input *UpdateIndexInput, opts ...request.Option) (*UpdateIndexOutput, error) {
	req, out := c.UpdateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access Control List files for the documents in a data source.
type AccessControlListConfiguration struct {
	_ struct{} `type:"structure"`

	// Path to the AWS S3 bucket that contains the ACL files.
	KeyPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessControlListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlListConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlListConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlListConfiguration"}
	if s.KeyPath != nil && len(*s.KeyPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPath sets the KeyPath field's value.
func (s *AccessControlListConfiguration) SetKeyPath(v string) *AccessControlListConfiguration {
	s.KeyPath = &v
	return s
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the column that should be used for filtering the
// query response by groups.
type AclConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of groups, separated by semi-colons, that filters a query response
	// based on user context. The document is only returned to users that are in
	// one of the groups specified in the UserContext field of the Query operation.
	//
	// AllowedGroupsColumnName is a required field
	AllowedGroupsColumnName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AclConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AclConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AclConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AclConfiguration"}
	if s.AllowedGroupsColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedGroupsColumnName"))
	}
	if s.AllowedGroupsColumnName != nil && len(*s.AllowedGroupsColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedGroupsColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedGroupsColumnName sets the AllowedGroupsColumnName field's value.
func (s *AclConfiguration) SetAllowedGroupsColumnName(v string) *AclConfiguration {
	s.AllowedGroupsColumnName = &v
	return s
}

type AdditionalResultAttribute struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An attribute returned with a document from a search.
	//
	// Value is a required field
	Value *AdditionalResultAttributeValue `type:"structure" required:"true"`

	// ValueType is a required field
	ValueType *string `type:"string" required:"true" enum:"AdditionalResultAttributeValueType"`
}

// String returns the string representation
func (s AdditionalResultAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdditionalResultAttribute) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *AdditionalResultAttribute) SetKey(v string) *AdditionalResultAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AdditionalResultAttribute) SetValue(v *AdditionalResultAttributeValue) *AdditionalResultAttribute {
	s.Value = v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *AdditionalResultAttribute) SetValueType(v string) *AdditionalResultAttribute {
	s.ValueType = &v
	return s
}

// An attribute returned with a document from a search.
type AdditionalResultAttributeValue struct {
	_ struct{} `type:"structure"`

	// The text associated with the attribute and information about the highlight
	// to apply to the text.
	TextWithHighlightsValue *TextWithHighlights `type:"structure"`
}

// String returns the string representation
func (s AdditionalResultAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdditionalResultAttributeValue) GoString() string {
	return s.String()
}

// SetTextWithHighlightsValue sets the TextWithHighlightsValue field's value.
func (s *AdditionalResultAttributeValue) SetTextWithHighlightsValue(v *TextWithHighlights) *AdditionalResultAttributeValue {
	s.TextWithHighlightsValue = v
	return s
}

// Provides filtering the query results based on document attributes.
//
// When you use the AndAllFilters or OrAllFilters, filters you can use a total
// of 3 layers. For example, you can use:
//
// <AndAllFilters>
//
// <OrAllFilters>
//
// <EqualTo>
type AttributeFilter struct {
	_ struct{} `type:"structure"`

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []*AttributeFilter `min:"1" type:"list"`

	// Returns true when a document contains all of the specified document attributes.
	ContainsAll *DocumentAttribute `type:"structure"`

	// Returns true when a document contains any of the specified document attributes.
	ContainsAny *DocumentAttribute `type:"structure"`

	// Performs an equals operation on two document attributes.
	EqualsTo *DocumentAttribute `type:"structure"`

	// Performs a greater than operation on two document attributes. Use with a
	// document attribute of type Integer or Long.
	GreaterThan *DocumentAttribute `type:"structure"`

	// Performs a greater or equals than operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	GreaterThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a less than operation on two document attributes. Use with a document
	// attribute of type Integer or Long.
	LessThan *DocumentAttribute `type:"structure"`

	// Performs a less than or equals operation on two document attributes. Use
	// with a document attribute of type Integer or Long.
	LessThanOrEquals *DocumentAttribute `type:"structure"`

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter `type:"structure"`

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []*AttributeFilter `min:"1" type:"list"`
}

// String returns the string representation
func (s AttributeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeFilter"}
	if s.AndAllFilters != nil && len(s.AndAllFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AndAllFilters", 1))
	}
	if s.OrAllFilters != nil && len(s.OrAllFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrAllFilters", 1))
	}
	if s.AndAllFilters != nil {
		for i, v := range s.AndAllFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AndAllFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ContainsAll != nil {
		if err := s.ContainsAll.Validate(); err != nil {
			invalidParams.AddNested("ContainsAll", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainsAny != nil {
		if err := s.ContainsAny.Validate(); err != nil {
			invalidParams.AddNested("ContainsAny", err.(request.ErrInvalidParams))
		}
	}
	if s.EqualsTo != nil {
		if err := s.EqualsTo.Validate(); err != nil {
			invalidParams.AddNested("EqualsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEquals != nil {
		if err := s.GreaterThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThanOrEquals != nil {
		if err := s.LessThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.NotFilter != nil {
		if err := s.NotFilter.Validate(); err != nil {
			invalidParams.AddNested("NotFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.OrAllFilters != nil {
		for i, v := range s.OrAllFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAllFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndAllFilters sets the AndAllFilters field's value.
func (s *AttributeFilter) SetAndAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.AndAllFilters = v
	return s
}

// SetContainsAll sets the ContainsAll field's value.
func (s *AttributeFilter) SetContainsAll(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAll = v
	return s
}

// SetContainsAny sets the ContainsAny field's value.
func (s *AttributeFilter) SetContainsAny(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAny = v
	return s
}

// SetEqualsTo sets the EqualsTo field's value.
func (s *AttributeFilter) SetEqualsTo(v *DocumentAttribute) *AttributeFilter {
	s.EqualsTo = v
	return s
}

// SetGreaterThan sets the GreaterThan field's value.
func (s *AttributeFilter) SetGreaterThan(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThan = v
	return s
}

// SetGreaterThanOrEquals sets the GreaterThanOrEquals field's value.
func (s *AttributeFilter) SetGreaterThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThanOrEquals = v
	return s
}

// SetLessThan sets the LessThan field's value.
func (s *AttributeFilter) SetLessThan(v *DocumentAttribute) *AttributeFilter {
	s.LessThan = v
	return s
}

// SetLessThanOrEquals sets the LessThanOrEquals field's value.
func (s *AttributeFilter) SetLessThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.LessThanOrEquals = v
	return s
}

// SetNotFilter sets the NotFilter field's value.
func (s *AttributeFilter) SetNotFilter(v *AttributeFilter) *AttributeFilter {
	s.NotFilter = v
	return s
}

// SetOrAllFilters sets the OrAllFilters field's value.
func (s *AttributeFilter) SetOrAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.OrAllFilters = v
	return s
}

type BatchDeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// One or more identifiers for documents to delete from the index.
	//
	// DocumentIdList is a required field
	DocumentIdList []*string `min:"1" type:"list" required:"true"`

	// The identifier of the index that contains the documents to delete.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteDocumentInput"}
	if s.DocumentIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentIdList"))
	}
	if s.DocumentIdList != nil && len(s.DocumentIdList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentIdList", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentIdList sets the DocumentIdList field's value.
func (s *BatchDeleteDocumentInput) SetDocumentIdList(v []*string) *BatchDeleteDocumentInput {
	s.DocumentIdList = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchDeleteDocumentInput) SetIndexId(v string) *BatchDeleteDocumentInput {
	s.IndexId = &v
	return s
}

type BatchDeleteDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A list of documents that could not be removed from the index. Each entry
	// contains an error message that indicates why the document couldn't be removed
	// from the index.
	FailedDocuments []*BatchDeleteDocumentResponseFailedDocument `type:"list"`
}

// String returns the string representation
func (s BatchDeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteDocumentOutput) GoString() string {
	return s.String()
}

// SetFailedDocuments sets the FailedDocuments field's value.
func (s *BatchDeleteDocumentOutput) SetFailedDocuments(v []*BatchDeleteDocumentResponseFailedDocument) *BatchDeleteDocumentOutput {
	s.FailedDocuments = v
	return s
}

// Provides information about documents that could not be removed from an index
// by the BatchDeleteDocument operation.
type BatchDeleteDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The error code for why the document couldn't be removed from the index.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// An explanation for why the document couldn't be removed from the index.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the document that couldn't be removed from the index.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchDeleteDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteDocumentResponseFailedDocument) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchDeleteDocumentResponseFailedDocument) SetErrorCode(v string) *BatchDeleteDocumentResponseFailedDocument {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchDeleteDocumentResponseFailedDocument) SetErrorMessage(v string) *BatchDeleteDocumentResponseFailedDocument {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchDeleteDocumentResponseFailedDocument) SetId(v string) *BatchDeleteDocumentResponseFailedDocument {
	s.Id = &v
	return s
}

type BatchPutDocumentInput struct {
	_ struct{} `type:"structure"`

	// One or more documents to add to the index.
	//
	// Each document is limited to 5 Mb, the total size of the list is limited to
	// 50 Mb.
	//
	// Documents is a required field
	Documents []*Document `min:"1" type:"list" required:"true"`

	// The identifier of the index to add the documents to. You need to create the
	// index first using the CreateIndex operation.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role that is allowed to run the BatchPutDocument
	// operation. For more information, see IAM Roles for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutDocumentInput"}
	if s.Documents == nil {
		invalidParams.Add(request.NewErrParamRequired("Documents"))
	}
	if s.Documents != nil && len(s.Documents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Documents", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Documents != nil {
		for i, v := range s.Documents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Documents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocuments sets the Documents field's value.
func (s *BatchPutDocumentInput) SetDocuments(v []*Document) *BatchPutDocumentInput {
	s.Documents = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchPutDocumentInput) SetIndexId(v string) *BatchPutDocumentInput {
	s.IndexId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BatchPutDocumentInput) SetRoleArn(v string) *BatchPutDocumentInput {
	s.RoleArn = &v
	return s
}

type BatchPutDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A list of documents that were not added to the index because the document
	// failed a validation check. Each document contains an error message that indicates
	// why the document couldn't be added to the index.
	//
	// If there was an error adding a document to an index the error is reported
	// in your AWS CloudWatch log.
	FailedDocuments []*BatchPutDocumentResponseFailedDocument `type:"list"`
}

// String returns the string representation
func (s BatchPutDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutDocumentOutput) GoString() string {
	return s.String()
}

// SetFailedDocuments sets the FailedDocuments field's value.
func (s *BatchPutDocumentOutput) SetFailedDocuments(v []*BatchPutDocumentResponseFailedDocument) *BatchPutDocumentOutput {
	s.FailedDocuments = v
	return s
}

// Provides information about a document that could not be indexed.
type BatchPutDocumentResponseFailedDocument struct {
	_ struct{} `type:"structure"`

	// The type of error that caused the document to fail to be indexed.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// A description of the reason why the document could not be indexed.
	ErrorMessage *string `min:"1" type:"string"`

	// The unique identifier of the document.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutDocumentResponseFailedDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutDocumentResponseFailedDocument) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutDocumentResponseFailedDocument) SetErrorCode(v string) *BatchPutDocumentResponseFailedDocument {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutDocumentResponseFailedDocument) SetErrorMessage(v string) *BatchPutDocumentResponseFailedDocument {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchPutDocumentResponseFailedDocument) SetId(v string) *BatchPutDocumentResponseFailedDocument {
	s.Id = &v
	return s
}

// Gathers information about when a particular result was clicked by a user.
// Your application uses the SubmitFeedback operation to provide click information.
type ClickFeedback struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp of the data and time that the result was clicked.
	//
	// ClickTime is a required field
	ClickTime *time.Time `type:"timestamp" required:"true"`

	// The unique identifier of the search result that was clicked.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ClickFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClickFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClickFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClickFeedback"}
	if s.ClickTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ClickTime"))
	}
	if s.ResultId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClickTime sets the ClickTime field's value.
func (s *ClickFeedback) SetClickTime(v time.Time) *ClickFeedback {
	s.ClickTime = &v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *ClickFeedback) SetResultId(v string) *ClickFeedback {
	s.ResultId = &v
	return s
}

// Provides information about how Amazon Kendra should use the columns of a
// database in an index.
type ColumnConfiguration struct {
	_ struct{} `type:"structure"`

	// One to five columns that indicate when a document in the database has changed.
	//
	// ChangeDetectingColumns is a required field
	ChangeDetectingColumns []*string `min:"1" type:"list" required:"true"`

	// The column that contains the contents of the document.
	//
	// DocumentDataColumnName is a required field
	DocumentDataColumnName *string `min:"1" type:"string" required:"true"`

	// The column that provides the document's unique identifier.
	//
	// DocumentIdColumnName is a required field
	DocumentIdColumnName *string `min:"1" type:"string" required:"true"`

	// The column that contains the title of the document.
	DocumentTitleColumnName *string `min:"1" type:"string"`

	// An array of objects that map database column names to the corresponding fields
	// in an index. You must first create the fields in the index using the UpdateIndex
	// operation.
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`
}

// String returns the string representation
func (s ColumnConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnConfiguration"}
	if s.ChangeDetectingColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeDetectingColumns"))
	}
	if s.ChangeDetectingColumns != nil && len(s.ChangeDetectingColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeDetectingColumns", 1))
	}
	if s.DocumentDataColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentDataColumnName"))
	}
	if s.DocumentDataColumnName != nil && len(*s.DocumentDataColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentDataColumnName", 1))
	}
	if s.DocumentIdColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentIdColumnName"))
	}
	if s.DocumentIdColumnName != nil && len(*s.DocumentIdColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentIdColumnName", 1))
	}
	if s.DocumentTitleColumnName != nil && len(*s.DocumentTitleColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleColumnName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeDetectingColumns sets the ChangeDetectingColumns field's value.
func (s *ColumnConfiguration) SetChangeDetectingColumns(v []*string) *ColumnConfiguration {
	s.ChangeDetectingColumns = v
	return s
}

// SetDocumentDataColumnName sets the DocumentDataColumnName field's value.
func (s *ColumnConfiguration) SetDocumentDataColumnName(v string) *ColumnConfiguration {
	s.DocumentDataColumnName = &v
	return s
}

// SetDocumentIdColumnName sets the DocumentIdColumnName field's value.
func (s *ColumnConfiguration) SetDocumentIdColumnName(v string) *ColumnConfiguration {
	s.DocumentIdColumnName = &v
	return s
}

// SetDocumentTitleColumnName sets the DocumentTitleColumnName field's value.
func (s *ColumnConfiguration) SetDocumentTitleColumnName(v string) *ColumnConfiguration {
	s.DocumentTitleColumnName = &v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *ColumnConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *ColumnConfiguration {
	s.FieldMappings = v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides the information necessary to connect to a database.
type ConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the host for the database. Can be either a string (host.subdomain.domain.tld)
	// or an IPv4 or IPv6 address.
	//
	// DatabaseHost is a required field
	DatabaseHost *string `min:"1" type:"string" required:"true"`

	// The name of the database containing the document data.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The port that the database uses for connections.
	//
	// DatabasePort is a required field
	DatabasePort *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Database Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html).
	// For more information about AWS Secrets Manager, see What Is AWS Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the AWS Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The name of the table that contains the document data.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionConfiguration"}
	if s.DatabaseHost == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseHost"))
	}
	if s.DatabaseHost != nil && len(*s.DatabaseHost) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseHost", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.DatabasePort == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabasePort"))
	}
	if s.DatabasePort != nil && *s.DatabasePort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatabasePort", 1))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseHost sets the DatabaseHost field's value.
func (s *ConnectionConfiguration) SetDatabaseHost(v string) *ConnectionConfiguration {
	s.DatabaseHost = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ConnectionConfiguration) SetDatabaseName(v string) *ConnectionConfiguration {
	s.DatabaseName = &v
	return s
}

// SetDatabasePort sets the DatabasePort field's value.
func (s *ConnectionConfiguration) SetDatabasePort(v int64) *ConnectionConfiguration {
	s.DatabasePort = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ConnectionConfiguration) SetSecretArn(v string) *ConnectionConfiguration {
	s.SecretArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ConnectionConfiguration) SetTableName(v string) *ConnectionConfiguration {
	s.TableName = &v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The connector configuration information that is required to access the repository.
	//
	// Configuration is a required field
	Configuration *DataSourceConfiguration `type:"structure" required:"true"`

	// A description for the data source.
	Description *string `min:"1" type:"string"`

	// The identifier of the index that should be associated with this data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// A unique name for the data source. A data source name can't be changed without
	// deleting and recreating the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source. For more information, see IAM Roles for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// Sets the frequency that Amazon Kendra will check the documents in your repository
	// and update the index. If you don't set a schedule Amazon Kendra will not
	// periodically update the index. You can call the StartDataSourceSyncJob operation
	// to update the index.
	Schedule *string `type:"string"`

	// The type of repository that contains the data source.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataSourceType"`
}

// String returns the string representation
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateDataSourceInput) SetConfiguration(v *DataSourceConfiguration) *CreateDataSourceInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceInput) SetDescription(v string) *CreateDataSourceInput {
	s.Description = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateDataSourceInput) SetIndexId(v string) *CreateDataSourceInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDataSourceInput) SetRoleArn(v string) *CreateDataSourceInput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateDataSourceInput) SetSchedule(v string) *CreateDataSourceInput {
	s.Schedule = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the data source.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateDataSourceOutput) SetId(v string) *CreateDataSourceOutput {
	s.Id = &v
	return s
}

type CreateFaqInput struct {
	_ struct{} `type:"structure"`

	// A description of the FAQ.
	Description *string `min:"1" type:"string"`

	// The identifier of the index that contains the FAQ.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name that should be associated with the FAQ.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the S3
	// bucket that contains the FAQs. For more information, see IAM Roles for Amazon
	// Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The S3 location of the FAQ input data.
	//
	// S3Path is a required field
	S3Path *S3Path `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateFaqInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFaqInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFaqInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFaqInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.S3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Path"))
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateFaqInput) SetDescription(v string) *CreateFaqInput {
	s.Description = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateFaqInput) SetIndexId(v string) *CreateFaqInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFaqInput) SetName(v string) *CreateFaqInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateFaqInput) SetRoleArn(v string) *CreateFaqInput {
	s.RoleArn = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *CreateFaqInput) SetS3Path(v *S3Path) *CreateFaqInput {
	s.S3Path = v
	return s
}

type CreateFaqOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateFaqOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFaqOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateFaqOutput) SetId(v string) *CreateFaqOutput {
	s.Id = &v
	return s
}

type CreateIndexInput struct {
	_ struct{} `type:"structure"`

	// A token that you provide to identify the request to create an index. Multiple
	// calls to the CreateIndex operation with the same client token will create
	// only one index.”
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description for the index.
	Description *string `min:"1" type:"string"`

	// The name for the new index.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch
	// logs and metrics. This is also the role used when you use the BatchPutDocument
	// operation to index documents from an Amazon S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The identifier of the AWS KMS customer managed key (CMK) to use to encrypt
	// data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIndexInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIndexInput) SetClientToken(v string) *CreateIndexInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIndexInput) SetDescription(v string) *CreateIndexInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIndexInput) SetName(v string) *CreateIndexInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIndexInput) SetRoleArn(v string) *CreateIndexInput {
	s.RoleArn = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateIndexInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateIndexInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

type CreateIndexOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the index. Use this identifier when you query an
	// index, set up a data source, or index a document.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation
func (s CreateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIndexOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateIndexOutput) SetId(v string) *CreateIndexOutput {
	s.Id = &v
	return s
}

// Configuration information for a Amazon Kendra data source.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information necessary to create a connector for a database.
	DatabaseConfiguration *DatabaseConfiguration `type:"structure"`

	// Provides information to create a connector for a document repository in an
	// Amazon S3 bucket.
	S3Configuration *S3DataSourceConfiguration `type:"structure"`

	// Provides information necessary to create a connector for a Microsoft SharePoint
	// site.
	SharePointConfiguration *SharePointConfiguration `type:"structure"`
}

// String returns the string representation
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.DatabaseConfiguration != nil {
		if err := s.DatabaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DatabaseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.SharePointConfiguration != nil {
		if err := s.SharePointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SharePointConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseConfiguration sets the DatabaseConfiguration field's value.
func (s *DataSourceConfiguration) SetDatabaseConfiguration(v *DatabaseConfiguration) *DataSourceConfiguration {
	s.DatabaseConfiguration = v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *DataSourceConfiguration) SetS3Configuration(v *S3DataSourceConfiguration) *DataSourceConfiguration {
	s.S3Configuration = v
	return s
}

// SetSharePointConfiguration sets the SharePointConfiguration field's value.
func (s *DataSourceConfiguration) SetSharePointConfiguration(v *SharePointConfiguration) *DataSourceConfiguration {
	s.SharePointConfiguration = v
	return s
}

// Summary information for a Amazon Kendra data source. Returned in a call to .
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier for the data source.
	Id *string `min:"1" type:"string"`

	// The name of the data source.
	Name *string `min:"1" type:"string"`

	// The status of the data source. When the status is ATIVE the data source is
	// ready to use.
	Status *string `type:"string" enum:"DataSourceStatus"`

	// The type of the data source.
	Type *string `type:"string" enum:"DataSourceType"`

	// The UNIX datetime that the data source was lasted updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSourceSummary) SetCreatedAt(v time.Time) *DataSourceSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *DataSourceSummary) SetId(v string) *DataSourceSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSourceSummary) SetName(v string) *DataSourceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSummary) SetStatus(v string) *DataSourceSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceSummary) SetType(v string) *DataSourceSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceSummary) SetUpdatedAt(v time.Time) *DataSourceSummary {
	s.UpdatedAt = &v
	return s
}

// Provides information about a synchronization job.
type DataSourceSyncJob struct {
	_ struct{} `type:"structure"`

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string `min:"1" type:"string"`

	// The UNIX datetime that the synchronization job was completed.
	EndTime *time.Time `type:"timestamp"`

	// If the Status field is set to FAILED, the ErrorCode field contains a the
	// reason that the synchronization failed.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// If the Status field is set to ERROR, the ErrorMessage field contains a description
	// of the error that caused the synchronization to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// A unique identifier for the synchronization job.
	ExecutionId *string `min:"1" type:"string"`

	// The UNIX datetime that the synchronization job was started.
	StartTime *time.Time `type:"timestamp"`

	// The execution status of the synchronization job. When the Status field is
	// set to SUCCEEDED, the synchronization job is done. If the status code is
	// set to FAILED, the ErrorCode and ErrorMessage fields give you the reason
	// for the failure.
	Status *string `type:"string" enum:"DataSourceSyncJobStatus"`
}

// String returns the string representation
func (s DataSourceSyncJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceSyncJob) GoString() string {
	return s.String()
}

// SetDataSourceErrorCode sets the DataSourceErrorCode field's value.
func (s *DataSourceSyncJob) SetDataSourceErrorCode(v string) *DataSourceSyncJob {
	s.DataSourceErrorCode = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DataSourceSyncJob) SetEndTime(v time.Time) *DataSourceSyncJob {
	s.EndTime = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *DataSourceSyncJob) SetErrorCode(v string) *DataSourceSyncJob {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DataSourceSyncJob) SetErrorMessage(v string) *DataSourceSyncJob {
	s.ErrorMessage = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DataSourceSyncJob) SetExecutionId(v string) *DataSourceSyncJob {
	s.ExecutionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DataSourceSyncJob) SetStartTime(v time.Time) *DataSourceSyncJob {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSyncJob) SetStatus(v string) *DataSourceSyncJob {
	s.Status = &v
	return s
}

// Maps a column or attribute in the data source to an index field. You must
// first create the fields in the index using the UpdateIndex operation.
type DataSourceToIndexFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the column or attribute in the data source.
	//
	// DataSourceFieldName is a required field
	DataSourceFieldName *string `min:"1" type:"string" required:"true"`

	// The type of data stored in the column or attribute.
	DateFieldFormat *string `min:"4" type:"string"`

	// The name of the field in the index.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DataSourceToIndexFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceToIndexFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceToIndexFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceToIndexFieldMapping"}
	if s.DataSourceFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceFieldName"))
	}
	if s.DataSourceFieldName != nil && len(*s.DataSourceFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceFieldName", 1))
	}
	if s.DateFieldFormat != nil && len(*s.DateFieldFormat) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DateFieldFormat", 4))
	}
	if s.IndexFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceFieldName sets the DataSourceFieldName field's value.
func (s *DataSourceToIndexFieldMapping) SetDataSourceFieldName(v string) *DataSourceToIndexFieldMapping {
	s.DataSourceFieldName = &v
	return s
}

// SetDateFieldFormat sets the DateFieldFormat field's value.
func (s *DataSourceToIndexFieldMapping) SetDateFieldFormat(v string) *DataSourceToIndexFieldMapping {
	s.DateFieldFormat = &v
	return s
}

// SetIndexFieldName sets the IndexFieldName field's value.
func (s *DataSourceToIndexFieldMapping) SetIndexFieldName(v string) *DataSourceToIndexFieldMapping {
	s.IndexFieldName = &v
	return s
}

// Provides information for connecting to an Amazon VPC.
type DataSourceVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Kendra to connect to the data source.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// A list of identifiers for subnets within your Amazon VPC. The subnets should
	// be able to connect to each other in the VPC, and they should have outgoing
	// access to the Internet through a NAT device.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DataSourceVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceVpcConfiguration"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *DataSourceVpcConfiguration) SetSecurityGroupIds(v []*string) *DataSourceVpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DataSourceVpcConfiguration) SetSubnetIds(v []*string) *DataSourceVpcConfiguration {
	s.SubnetIds = v
	return s
}

// Provides the information necessary to connect a database to an index.
type DatabaseConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the database column that provides information for user
	// context filtering.
	AclConfiguration *AclConfiguration `type:"structure"`

	// Information about where the index should get the document information from
	// the database.
	//
	// ColumnConfiguration is a required field
	ColumnConfiguration *ColumnConfiguration `type:"structure" required:"true"`

	// The information necessary to connect to a database.
	//
	// ConnectionConfiguration is a required field
	ConnectionConfiguration *ConnectionConfiguration `type:"structure" required:"true"`

	// The type of database engine that runs the database.
	//
	// DatabaseEngineType is a required field
	DatabaseEngineType *string `type:"string" required:"true" enum:"DatabaseEngineType"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s DatabaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatabaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseConfiguration"}
	if s.ColumnConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnConfiguration"))
	}
	if s.ConnectionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionConfiguration"))
	}
	if s.DatabaseEngineType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseEngineType"))
	}
	if s.AclConfiguration != nil {
		if err := s.AclConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AclConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ColumnConfiguration != nil {
		if err := s.ColumnConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ColumnConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ConnectionConfiguration != nil {
		if err := s.ConnectionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ConnectionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAclConfiguration sets the AclConfiguration field's value.
func (s *DatabaseConfiguration) SetAclConfiguration(v *AclConfiguration) *DatabaseConfiguration {
	s.AclConfiguration = v
	return s
}

// SetColumnConfiguration sets the ColumnConfiguration field's value.
func (s *DatabaseConfiguration) SetColumnConfiguration(v *ColumnConfiguration) *DatabaseConfiguration {
	s.ColumnConfiguration = v
	return s
}

// SetConnectionConfiguration sets the ConnectionConfiguration field's value.
func (s *DatabaseConfiguration) SetConnectionConfiguration(v *ConnectionConfiguration) *DatabaseConfiguration {
	s.ConnectionConfiguration = v
	return s
}

// SetDatabaseEngineType sets the DatabaseEngineType field's value.
func (s *DatabaseConfiguration) SetDatabaseEngineType(v string) *DatabaseConfiguration {
	s.DatabaseEngineType = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *DatabaseConfiguration) SetVpcConfiguration(v *DataSourceVpcConfiguration) *DatabaseConfiguration {
	s.VpcConfiguration = v
	return s
}

type DeleteFaqInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the FAQ to remove.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The index to remove the FAQ from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFaqInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFaqInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFaqInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFaqInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFaqInput) SetId(v string) *DeleteFaqInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteFaqInput) SetIndexId(v string) *DeleteFaqInput {
	s.IndexId = &v
	return s
}

type DeleteFaqOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFaqOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFaqOutput) GoString() string {
	return s.String()
}

type DeleteIndexInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index to delete.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIndexInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteIndexInput) SetId(v string) *DeleteIndexInput {
	s.Id = &v
	return s
}

type DeleteIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIndexOutput) GoString() string {
	return s.String()
}

type DescribeDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeDataSourceInput) SetId(v string) *DescribeDataSourceInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeDataSourceInput) SetIndexId(v string) *DescribeDataSourceInput {
	s.IndexId = &v
	return s
}

type DescribeDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Information that describes where the data source is located and how the data
	// source is configured. The specific information in the description depends
	// on the data source provider.
	Configuration *DataSourceConfiguration `type:"structure"`

	// The Unix timestamp of when the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the data source.
	Description *string `min:"1" type:"string"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// description of the error that caused the data source to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the data source.
	Id *string `min:"1" type:"string"`

	// The identifier of the index that contains the data source.
	IndexId *string `min:"36" type:"string"`

	// The name that you gave the data source when it was created.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that enables the data source to
	// access its resources.
	RoleArn *string `min:"1" type:"string"`

	// The schedule that Amazon Kendra will update the data source.
	Schedule *string `type:"string"`

	// The current status of the data source. When the status is ACTIVE the data
	// source is ready to use. When the status is FAILED, the ErrorMessage field
	// contains the reason that the data source failed.
	Status *string `type:"string" enum:"DataSourceStatus"`

	// The type of the data source.
	Type *string `type:"string" enum:"DataSourceType"`

	// The Unix timestamp of when the data source was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourceOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeDataSourceOutput) SetConfiguration(v *DataSourceConfiguration) *DescribeDataSourceOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeDataSourceOutput) SetCreatedAt(v time.Time) *DescribeDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeDataSourceOutput) SetDescription(v string) *DescribeDataSourceOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeDataSourceOutput) SetErrorMessage(v string) *DescribeDataSourceOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeDataSourceOutput) SetId(v string) *DescribeDataSourceOutput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeDataSourceOutput) SetIndexId(v string) *DescribeDataSourceOutput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeDataSourceOutput) SetName(v string) *DescribeDataSourceOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeDataSourceOutput) SetRoleArn(v string) *DescribeDataSourceOutput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DescribeDataSourceOutput) SetSchedule(v string) *DescribeDataSourceOutput {
	s.Schedule = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSourceOutput) SetStatus(v string) *DescribeDataSourceOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeDataSourceOutput) SetType(v string) *DescribeDataSourceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeDataSourceOutput) SetUpdatedAt(v time.Time) *DescribeDataSourceOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeFaqInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the FAQ.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the FAQ.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFaqInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFaqInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFaqInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFaqInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeFaqInput) SetId(v string) *DescribeFaqInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeFaqInput) SetIndexId(v string) *DescribeFaqInput {
	s.IndexId = &v
	return s
}

type DescribeFaqOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the FAQ was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the FAQ that you provided when it was created.
	Description *string `min:"1" type:"string"`

	// If the Status field is FAILED, the ErrorMessage field contains the reason
	// why the FAQ failed.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The identifier of the index that contains the FAQ.
	IndexId *string `min:"36" type:"string"`

	// The name that you gave the FAQ when it was created.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that provides access to the S3
	// bucket containing the input files for the FAQ.
	RoleArn *string `min:"1" type:"string"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The status of the FAQ. It is ready to use when the status is ACTIVE.
	Status *string `type:"string" enum:"FaqStatus"`

	// The date and time that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeFaqOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFaqOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeFaqOutput) SetCreatedAt(v time.Time) *DescribeFaqOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeFaqOutput) SetDescription(v string) *DescribeFaqOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeFaqOutput) SetErrorMessage(v string) *DescribeFaqOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeFaqOutput) SetId(v string) *DescribeFaqOutput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DescribeFaqOutput) SetIndexId(v string) *DescribeFaqOutput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeFaqOutput) SetName(v string) *DescribeFaqOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeFaqOutput) SetRoleArn(v string) *DescribeFaqOutput {
	s.RoleArn = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *DescribeFaqOutput) SetS3Path(v *S3Path) *DescribeFaqOutput {
	s.S3Path = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeFaqOutput) SetStatus(v string) *DescribeFaqOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeFaqOutput) SetUpdatedAt(v time.Time) *DescribeFaqOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeIndexInput struct {
	_ struct{} `type:"structure"`

	// The name of the index to describe.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIndexInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeIndexInput) SetId(v string) *DescribeIndexInput {
	s.Id = &v
	return s
}

type DescribeIndexOutput struct {
	_ struct{} `type:"structure"`

	// The Unix datetime that the index was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the index.
	Description *string `min:"1" type:"string"`

	// Configuration settings for any metadata applied to the documents in the index.
	DocumentMetadataConfigurations []*DocumentMetadataConfiguration `type:"list"`

	// When th eStatus field value is FAILED, the ErrorMessage field contains a
	// message that explains why.
	ErrorMessage *string `min:"1" type:"string"`

	// the name of the index.
	Id *string `min:"36" type:"string"`

	// Provides information about the number of FAQ questions and answers and the
	// number of text documents indexed.
	IndexStatistics *IndexStatistics `type:"structure"`

	// The name of the index.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission
	// to write to your Amazon Cloudwatch logs.
	RoleArn *string `min:"1" type:"string"`

	// The identifier of the AWS KMS customer master key (CMK) used to encrypt your
	// data. Amazon Kendra doesn't support asymmetric CMKs.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`

	// The current status of the index. When the value is ACTIVE, the index is ready
	// for use. If the Status field value is FAILED, the ErrorMessage field contains
	// a message that explains why.
	Status *string `type:"string" enum:"IndexStatus"`

	// The Unix datetime that the index was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeIndexOutput) SetCreatedAt(v time.Time) *DescribeIndexOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeIndexOutput) SetDescription(v string) *DescribeIndexOutput {
	s.Description = &v
	return s
}

// SetDocumentMetadataConfigurations sets the DocumentMetadataConfigurations field's value.
func (s *DescribeIndexOutput) SetDocumentMetadataConfigurations(v []*DocumentMetadataConfiguration) *DescribeIndexOutput {
	s.DocumentMetadataConfigurations = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeIndexOutput) SetErrorMessage(v string) *DescribeIndexOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeIndexOutput) SetId(v string) *DescribeIndexOutput {
	s.Id = &v
	return s
}

// SetIndexStatistics sets the IndexStatistics field's value.
func (s *DescribeIndexOutput) SetIndexStatistics(v *IndexStatistics) *DescribeIndexOutput {
	s.IndexStatistics = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeIndexOutput) SetName(v string) *DescribeIndexOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeIndexOutput) SetRoleArn(v string) *DescribeIndexOutput {
	s.RoleArn = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *DescribeIndexOutput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *DescribeIndexOutput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIndexOutput) SetStatus(v string) *DescribeIndexOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeIndexOutput) SetUpdatedAt(v time.Time) *DescribeIndexOutput {
	s.UpdatedAt = &v
	return s
}

// A document in an index.
type Document struct {
	_ struct{} `type:"structure"`

	// Information to use for user context filtering.
	AccessControlList []*Principal `min:"1" type:"list"`

	// Custom attributes to apply to the document. Use the custom attributes to
	// provide additional information for searching, to provide facets for refining
	// searches, and to provide additional information in the query response.
	Attributes []*DocumentAttribute `min:"1" type:"list"`

	// The contents of the document.
	//
	// Documents passed to the Blob parameter must be base64 encoded. Your code
	// might not need to encode the document file bytes if you're using an AWS SDK
	// to call Amazon Kendra operations. If you are calling the Amazon Kendra endpoint
	// directly using REST, you must base64 encode the contents before sending.
	//
	// Blob is automatically base64 encoded/decoded by the SDK.
	Blob []byte `min:"1" type:"blob"`

	// The file type of the document in the Blob field.
	ContentType *string `type:"string" enum:"ContentType"`

	// A unique identifier of the document in the index.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path `type:"structure"`

	// The title of the document.
	Title *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Document) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Document"}
	if s.AccessControlList != nil && len(s.AccessControlList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessControlList", 1))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Blob != nil && len(s.Blob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Blob", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3Path != nil {
		if err := s.S3Path.Validate(); err != nil {
			invalidParams.AddNested("S3Path", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *Document) SetAccessControlList(v []*Principal) *Document {
	s.AccessControlList = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Document) SetAttributes(v []*DocumentAttribute) *Document {
	s.Attributes = v
	return s
}

// SetBlob sets the Blob field's value.
func (s *Document) SetBlob(v []byte) *Document {
	s.Blob = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Document) SetContentType(v string) *Document {
	s.ContentType = &v
	return s
}

// SetId sets the Id field's value.
func (s *Document) SetId(v string) *Document {
	s.Id = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *Document) SetS3Path(v *S3Path) *Document {
	s.S3Path = v
	return s
}

// SetTitle sets the Title field's value.
func (s *Document) SetTitle(v string) *Document {
	s.Title = &v
	return s
}

// A custom attribute value assigned to a document.
type DocumentAttribute struct {
	_ struct{} `type:"structure"`

	// The identifier for the attribute.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *DocumentAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s DocumentAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *DocumentAttribute) SetKey(v string) *DocumentAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentAttribute) SetValue(v *DocumentAttributeValue) *DocumentAttribute {
	s.Value = v
	return s
}

// The value of a custom document attribute. You can only provide one value
// for a custom attribute.
type DocumentAttributeValue struct {
	_ struct{} `type:"structure"`

	// A date value expressed as seconds from the Unix epoch.
	DateValue *time.Time `type:"timestamp"`

	// A long integer value.
	LongValue *int64 `type:"long"`

	// A list of strings.
	StringListValue []*string `min:"1" type:"list"`

	// A string, such as "department".
	StringValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DocumentAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentAttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttributeValue"}
	if s.StringListValue != nil && len(s.StringListValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringListValue", 1))
	}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateValue sets the DateValue field's value.
func (s *DocumentAttributeValue) SetDateValue(v time.Time) *DocumentAttributeValue {
	s.DateValue = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *DocumentAttributeValue) SetLongValue(v int64) *DocumentAttributeValue {
	s.LongValue = &v
	return s
}

// SetStringListValue sets the StringListValue field's value.
func (s *DocumentAttributeValue) SetStringListValue(v []*string) *DocumentAttributeValue {
	s.StringListValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *DocumentAttributeValue) SetStringValue(v string) *DocumentAttributeValue {
	s.StringValue = &v
	return s
}

// Provides the count of documents that match a particular attribute when doing
// a faceted search.
type DocumentAttributeValueCountPair struct {
	_ struct{} `type:"structure"`

	// The number of documents in the response that have the attribute value for
	// the key.
	Count *int64 `type:"integer"`

	// The value of the attribute. For example, "HR."
	DocumentAttributeValue *DocumentAttributeValue `type:"structure"`
}

// String returns the string representation
func (s DocumentAttributeValueCountPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentAttributeValueCountPair) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DocumentAttributeValueCountPair) SetCount(v int64) *DocumentAttributeValueCountPair {
	s.Count = &v
	return s
}

// SetDocumentAttributeValue sets the DocumentAttributeValue field's value.
func (s *DocumentAttributeValueCountPair) SetDocumentAttributeValue(v *DocumentAttributeValue) *DocumentAttributeValueCountPair {
	s.DocumentAttributeValue = v
	return s
}

// Specifies the properties of a custom index field.
type DocumentMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the index field.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Provides manual tuning parameters to determine how the field affects the
	// search results.
	Relevance *Relevance `type:"structure"`

	// Provides information about how the field is used during a search.
	Search *Search `type:"structure"`

	// The data type of the index field.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DocumentAttributeValueType"`
}

// String returns the string representation
func (s DocumentMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentMetadataConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentMetadataConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentMetadataConfiguration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Relevance != nil {
		if err := s.Relevance.Validate(); err != nil {
			invalidParams.AddNested("Relevance", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DocumentMetadataConfiguration) SetName(v string) *DocumentMetadataConfiguration {
	s.Name = &v
	return s
}

// SetRelevance sets the Relevance field's value.
func (s *DocumentMetadataConfiguration) SetRelevance(v *Relevance) *DocumentMetadataConfiguration {
	s.Relevance = v
	return s
}

// SetSearch sets the Search field's value.
func (s *DocumentMetadataConfiguration) SetSearch(v *Search) *DocumentMetadataConfiguration {
	s.Search = v
	return s
}

// SetType sets the Type field's value.
func (s *DocumentMetadataConfiguration) SetType(v string) *DocumentMetadataConfiguration {
	s.Type = &v
	return s
}

// Document metadata files that contain information such as the document access
// control information, source URI, document author, and custom attributes.
// Each metadata file contains metadata about a single document.
type DocumentsMetadataConfiguration struct {
	_ struct{} `type:"structure"`

	// A prefix used to filter metadata configuration files in the AWS S3 bucket.
	// The S3 bucket might contain multiple metadata files. Use S3Prefix to include
	// only the desired metadata files.
	S3Prefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DocumentsMetadataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentsMetadataConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentsMetadataConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentsMetadataConfiguration"}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *DocumentsMetadataConfiguration) SetS3Prefix(v string) *DocumentsMetadataConfiguration {
	s.S3Prefix = &v
	return s
}

// Information a document attribute
type Facet struct {
	_ struct{} `type:"structure"`

	// The unique key for the document attribute.
	DocumentAttributeKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Facet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Facet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Facet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Facet"}
	if s.DocumentAttributeKey != nil && len(*s.DocumentAttributeKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentAttributeKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentAttributeKey sets the DocumentAttributeKey field's value.
func (s *Facet) SetDocumentAttributeKey(v string) *Facet {
	s.DocumentAttributeKey = &v
	return s
}

// The facet values for the documents in the response.
type FacetResult struct {
	_ struct{} `type:"structure"`

	// The key for the facet values. This is the same as the DocumentAttributeKey
	// provided in the query.
	DocumentAttributeKey *string `min:"1" type:"string"`

	// An array of key/value pairs, where the key is the value of the attribute
	// and the count is the number of documents that share the key value.
	DocumentAttributeValueCountPairs []*DocumentAttributeValueCountPair `type:"list"`
}

// String returns the string representation
func (s FacetResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FacetResult) GoString() string {
	return s.String()
}

// SetDocumentAttributeKey sets the DocumentAttributeKey field's value.
func (s *FacetResult) SetDocumentAttributeKey(v string) *FacetResult {
	s.DocumentAttributeKey = &v
	return s
}

// SetDocumentAttributeValueCountPairs sets the DocumentAttributeValueCountPairs field's value.
func (s *FacetResult) SetDocumentAttributeValueCountPairs(v []*DocumentAttributeValueCountPair) *FacetResult {
	s.DocumentAttributeValueCountPairs = v
	return s
}

// Provides statistical information about the FAQ questions and answers contained
// in an index.
type FaqStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of FAQ questions and answers contained in the index.
	//
	// IndexedQuestionAnswersCount is a required field
	IndexedQuestionAnswersCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FaqStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaqStatistics) GoString() string {
	return s.String()
}

// SetIndexedQuestionAnswersCount sets the IndexedQuestionAnswersCount field's value.
func (s *FaqStatistics) SetIndexedQuestionAnswersCount(v int64) *FaqStatistics {
	s.IndexedQuestionAnswersCount = &v
	return s
}

// Provides information about a frequently asked questions and answer contained
// in an index.
type FaqSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime that the FAQ was added to the index.
	CreatedAt *time.Time `type:"timestamp"`

	// The unique identifier of the FAQ.
	Id *string `min:"1" type:"string"`

	// The name that you assigned the FAQ when you created or updated the FAQ.
	Name *string `min:"1" type:"string"`

	// The current status of the FAQ. When the status is ACTIVE the FAQ is ready
	// for use.
	Status *string `type:"string" enum:"FaqStatus"`

	// The UNIX datetime that the FAQ was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s FaqSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaqSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FaqSummary) SetCreatedAt(v time.Time) *FaqSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *FaqSummary) SetId(v string) *FaqSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *FaqSummary) SetName(v string) *FaqSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FaqSummary) SetStatus(v string) *FaqSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FaqSummary) SetUpdatedAt(v time.Time) *FaqSummary {
	s.UpdatedAt = &v
	return s
}

// Provides information that you can use to highlight a search result so that
// your users can quickly identify terms in the response.
type Highlight struct {
	_ struct{} `type:"structure"`

	// The zero-based location in the response string where the highlight starts.
	//
	// BeginOffset is a required field
	BeginOffset *int64 `type:"integer" required:"true"`

	// The zero-based location in the response string where the highlight ends.
	//
	// EndOffset is a required field
	EndOffset *int64 `type:"integer" required:"true"`

	// Indicates whether the response is the best response. True if this is the
	// best response; otherwise, false.
	TopAnswer *bool `type:"boolean"`
}

// String returns the string representation
func (s Highlight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Highlight) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Highlight) SetBeginOffset(v int64) *Highlight {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Highlight) SetEndOffset(v int64) *Highlight {
	s.EndOffset = &v
	return s
}

// SetTopAnswer sets the TopAnswer field's value.
func (s *Highlight) SetTopAnswer(v bool) *Highlight {
	s.TopAnswer = &v
	return s
}

// A summary of information about an index.
type IndexConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the index was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// A unique identifier for the index. Use this to identify the index when you
	// are using operations such as Query, DescribeIndex, UpdateIndex, and DeleteIndex.
	Id *string `min:"36" type:"string"`

	// The name of the index.
	Name *string `min:"1" type:"string"`

	// The current status of the index. When the status is ACTIVE, the index is
	// ready to search.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"IndexStatus"`

	// The Unix timestamp when the index was last updated by the UpdateIndex operation.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s IndexConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexConfigurationSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *IndexConfigurationSummary) SetCreatedAt(v time.Time) *IndexConfigurationSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *IndexConfigurationSummary) SetId(v string) *IndexConfigurationSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *IndexConfigurationSummary) SetName(v string) *IndexConfigurationSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IndexConfigurationSummary) SetStatus(v string) *IndexConfigurationSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IndexConfigurationSummary) SetUpdatedAt(v time.Time) *IndexConfigurationSummary {
	s.UpdatedAt = &v
	return s
}

// Provides information about the number of documents and the number of questions
// and answers in an index.
type IndexStatistics struct {
	_ struct{} `type:"structure"`

	// The number of question and answer topics in the index.
	//
	// FaqStatistics is a required field
	FaqStatistics *FaqStatistics `type:"structure" required:"true"`

	// The number of text documents indexed.
	//
	// TextDocumentStatistics is a required field
	TextDocumentStatistics *TextDocumentStatistics `type:"structure" required:"true"`
}

// String returns the string representation
func (s IndexStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexStatistics) GoString() string {
	return s.String()
}

// SetFaqStatistics sets the FaqStatistics field's value.
func (s *IndexStatistics) SetFaqStatistics(v *FaqStatistics) *IndexStatistics {
	s.FaqStatistics = v
	return s
}

// SetTextDocumentStatistics sets the TextDocumentStatistics field's value.
func (s *IndexStatistics) SetTextDocumentStatistics(v *TextDocumentStatistics) *IndexStatistics {
	s.TextDocumentStatistics = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDataSourceSyncJobsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of synchronization jobs to return in the response. If
	// there are fewer results in the list, this response contains only the actual
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to GetDataSourceSyncJobHistory was
	// truncated, include the NextToken to fetch the next set of jobs.
	NextToken *string `min:"1" type:"string"`

	// When specified, the synchronization jobs returned in the list are limited
	// to jobs between the specified dates.
	StartTimeFilter *TimeRange `type:"structure"`

	// When specified, only returns synchronization jobs with the Status field equal
	// to the specified status.
	StatusFilter *string `type:"string" enum:"DataSourceSyncJobStatus"`
}

// String returns the string representation
func (s ListDataSourceSyncJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourceSyncJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourceSyncJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourceSyncJobsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ListDataSourceSyncJobsInput) SetId(v string) *ListDataSourceSyncJobsInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListDataSourceSyncJobsInput) SetIndexId(v string) *ListDataSourceSyncJobsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourceSyncJobsInput) SetMaxResults(v int64) *ListDataSourceSyncJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourceSyncJobsInput) SetNextToken(v string) *ListDataSourceSyncJobsInput {
	s.NextToken = &v
	return s
}

// SetStartTimeFilter sets the StartTimeFilter field's value.
func (s *ListDataSourceSyncJobsInput) SetStartTimeFilter(v *TimeRange) *ListDataSourceSyncJobsInput {
	s.StartTimeFilter = v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListDataSourceSyncJobsInput) SetStatusFilter(v string) *ListDataSourceSyncJobsInput {
	s.StatusFilter = &v
	return s
}

type ListDataSourceSyncJobsOutput struct {
	_ struct{} `type:"structure"`

	// A history of synchronization jobs for the data source.
	History []*DataSourceSyncJob `type:"list"`

	// The GetDataSourceSyncJobHistory operation returns a page of vocabularies
	// at a time. The maximum size of the page is set by the MaxResults parameter.
	// If there are more jobs in the list than the page size, Amazon Kendra returns
	// the NextPage token. Include the token in the next request to the GetDataSourceSyncJobHistory
	// operation to return in the next page of jobs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDataSourceSyncJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourceSyncJobsOutput) GoString() string {
	return s.String()
}

// SetHistory sets the History field's value.
func (s *ListDataSourceSyncJobsOutput) SetHistory(v []*DataSourceSyncJob) *ListDataSourceSyncJobsOutput {
	s.History = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourceSyncJobsOutput) SetNextToken(v string) *ListDataSourceSyncJobsOutput {
	s.NextToken = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of data sources to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of data sources (DataSourceSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ListDataSourcesInput) SetIndexId(v string) *ListDataSourcesInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of data sources.
	NextToken *string `min:"1" type:"string"`

	// An array of summary information for one or more data sources.
	SummaryItems []*DataSourceSummary `type:"list"`
}

// String returns the string representation
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

// SetSummaryItems sets the SummaryItems field's value.
func (s *ListDataSourcesOutput) SetSummaryItems(v []*DataSourceSummary) *ListDataSourcesOutput {
	s.SummaryItems = v
	return s
}

type ListFaqsInput struct {
	_ struct{} `type:"structure"`

	// The index that contains the FAQ lists.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The maximum number of FAQs to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListFaqs was truncated, include
	// the NextToken to fetch the next set of FAQs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFaqsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFaqsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFaqsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFaqsInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *ListFaqsInput) SetIndexId(v string) *ListFaqsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFaqsInput) SetMaxResults(v int64) *ListFaqsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFaqsInput) SetNextToken(v string) *ListFaqsInput {
	s.NextToken = &v
	return s
}

type ListFaqsOutput struct {
	_ struct{} `type:"structure"`

	// information about the FAQs associated with the specified index.
	FaqSummaryItems []*FaqSummary `type:"list"`

	// The ListFaqs operation returns a page of FAQs at a time. The maximum size
	// of the page is set by the MaxResults parameter. If there are more jobs in
	// the list than the page size, Amazon Kendra returns the NextPage token. Include
	// the token in the next request to the ListFaqs operation to return the next
	// page of FAQs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFaqsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFaqsOutput) GoString() string {
	return s.String()
}

// SetFaqSummaryItems sets the FaqSummaryItems field's value.
func (s *ListFaqsOutput) SetFaqSummaryItems(v []*FaqSummary) *ListFaqsOutput {
	s.FaqSummaryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFaqsOutput) SetNextToken(v string) *ListFaqsOutput {
	s.NextToken = &v
	return s
}

type ListIndicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of data sources to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of indexes (DataSourceSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIndicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndicesInput) SetMaxResults(v int64) *ListIndicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesInput) SetNextToken(v string) *ListIndicesInput {
	s.NextToken = &v
	return s
}

type ListIndicesOutput struct {
	_ struct{} `type:"structure"`

	// An array of summary information for one or more indexes.
	IndexConfigurationSummaryItems []*IndexConfigurationSummary `type:"list"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of indexes.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIndicesOutput) GoString() string {
	return s.String()
}

// SetIndexConfigurationSummaryItems sets the IndexConfigurationSummaryItems field's value.
func (s *ListIndicesOutput) SetIndexConfigurationSummaryItems(v []*IndexConfigurationSummary) *ListIndicesOutput {
	s.IndexConfigurationSummaryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesOutput) SetNextToken(v string) *ListIndicesOutput {
	s.NextToken = &v
	return s
}

// Provides user and group information for document access filtering.
type Principal struct {
	_ struct{} `type:"structure"`

	// Whether to allow or deny access to the principal.
	//
	// Access is a required field
	Access *string `type:"string" required:"true" enum:"ReadAccessType"`

	// The name of the user or group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of principal.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Principal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Principal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Principal"}
	if s.Access == nil {
		invalidParams.Add(request.NewErrParamRequired("Access"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccess sets the Access field's value.
func (s *Principal) SetAccess(v string) *Principal {
	s.Access = &v
	return s
}

// SetName sets the Name field's value.
func (s *Principal) SetName(v string) *Principal {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Principal) SetType(v string) *Principal {
	s.Type = &v
	return s
}

type QueryInput struct {
	_ struct{} `type:"structure"`

	// Enables filtered searches based on document attributes. You can only provide
	// one attribute filter; however, the AndAllFilters, NotFilter, and OrAllFilters
	// parameters contain a list of other filters.
	//
	// The AttributeFilter parameter enables you to create a set of filtering rules
	// that a document must satisfy to be included in the query results.
	AttributeFilter *AttributeFilter `type:"structure"`

	// An array of documents attributes. Amazon Kendra returns a count for each
	// attribute key specified. You can use this information to help narrow the
	// search for your user.
	Facets []*Facet `type:"list"`

	// The unique identifier of the index to search. The identifier is returned
	// in the response from the operation.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// Query results are returned in pages the size of the PageSize parameter. By
	// default, Amazon Kendra returns the first page of results. Use this parameter
	// to get result pages after the first one.
	PageNumber *int64 `type:"integer"`

	// Sets the number of results that are returned in each page of results. The
	// default page size is 100.
	PageSize *int64 `type:"integer"`

	// Sets the type of query. Only results for the specified query type are returned.
	QueryResultTypeFilter *string `type:"string" enum:"QueryResultType"`

	// The text to search for.
	//
	// QueryText is a required field
	QueryText *string `min:"1" type:"string" required:"true"`

	// An array of document attributes to include in the response. No other document
	// attributes are included in the response. By default all document attributes
	// are included in the response.
	RequestedDocumentAttributes []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.QueryText == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryText"))
	}
	if s.QueryText != nil && len(*s.QueryText) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryText", 1))
	}
	if s.RequestedDocumentAttributes != nil && len(s.RequestedDocumentAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestedDocumentAttributes", 1))
	}
	if s.AttributeFilter != nil {
		if err := s.AttributeFilter.Validate(); err != nil {
			invalidParams.AddNested("AttributeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.Facets != nil {
		for i, v := range s.Facets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Facets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeFilter sets the AttributeFilter field's value.
func (s *QueryInput) SetAttributeFilter(v *AttributeFilter) *QueryInput {
	s.AttributeFilter = v
	return s
}

// SetFacets sets the Facets field's value.
func (s *QueryInput) SetFacets(v []*Facet) *QueryInput {
	s.Facets = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *QueryInput) SetIndexId(v string) *QueryInput {
	s.IndexId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *QueryInput) SetPageNumber(v int64) *QueryInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *QueryInput) SetPageSize(v int64) *QueryInput {
	s.PageSize = &v
	return s
}

// SetQueryResultTypeFilter sets the QueryResultTypeFilter field's value.
func (s *QueryInput) SetQueryResultTypeFilter(v string) *QueryInput {
	s.QueryResultTypeFilter = &v
	return s
}

// SetQueryText sets the QueryText field's value.
func (s *QueryInput) SetQueryText(v string) *QueryInput {
	s.QueryText = &v
	return s
}

// SetRequestedDocumentAttributes sets the RequestedDocumentAttributes field's value.
func (s *QueryInput) SetRequestedDocumentAttributes(v []*string) *QueryInput {
	s.RequestedDocumentAttributes = v
	return s
}

type QueryOutput struct {
	_ struct{} `type:"structure"`

	// Contains the facet results. A FacetResult contains the counts for each attribute
	// key that was specified in the Facets input parameter.
	FacetResults []*FacetResult `type:"list"`

	// The unique identifier for the search. You use QueryId to identify the search
	// when using the feedback API.
	QueryId *string `min:"1" type:"string"`

	// The results of the search.
	ResultItems []*QueryResultItem `type:"list"`

	// The number of items returned by the search. Use this to determine when you
	// have requested the last set of results.
	TotalNumberOfResults *int64 `type:"integer"`
}

// String returns the string representation
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryOutput) GoString() string {
	return s.String()
}

// SetFacetResults sets the FacetResults field's value.
func (s *QueryOutput) SetFacetResults(v []*FacetResult) *QueryOutput {
	s.FacetResults = v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *QueryOutput) SetQueryId(v string) *QueryOutput {
	s.QueryId = &v
	return s
}

// SetResultItems sets the ResultItems field's value.
func (s *QueryOutput) SetResultItems(v []*QueryResultItem) *QueryOutput {
	s.ResultItems = v
	return s
}

// SetTotalNumberOfResults sets the TotalNumberOfResults field's value.
func (s *QueryOutput) SetTotalNumberOfResults(v int64) *QueryOutput {
	s.TotalNumberOfResults = &v
	return s
}

// A single query result.
//
// A query result contains information about a document returned by the query.
// This includes the original location of the document, a list of attributes
// assigned to the document, and relevant text from the document that satisfies
// the query.
type QueryResultItem struct {
	_ struct{} `type:"structure"`

	AdditionalAttributes []*AdditionalResultAttribute `type:"list"`

	// An array of document attributes for the document that the query result maps
	// to. For example, the document author (Author) or the source URI (SourceUri)
	// of the document.
	DocumentAttributes []*DocumentAttribute `min:"1" type:"list"`

	// An extract of the text in the document. Contains information about highlighting
	// the relevant terms in the excerpt.
	DocumentExcerpt *TextWithHighlights `type:"structure"`

	// The unique identifier for the document.
	DocumentId *string `min:"1" type:"string"`

	// The title of the document. Contains the text of the title and information
	// for highlighting the relevant terms in the title.
	DocumentTitle *TextWithHighlights `type:"structure"`

	// The URI of the original location of the document.
	DocumentURI *string `min:"1" type:"string"`

	// The unique identifier for the query result.
	Id *string `min:"1" type:"string"`

	// The type of document.
	Type *string `type:"string" enum:"QueryResultType"`
}

// String returns the string representation
func (s QueryResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryResultItem) GoString() string {
	return s.String()
}

// SetAdditionalAttributes sets the AdditionalAttributes field's value.
func (s *QueryResultItem) SetAdditionalAttributes(v []*AdditionalResultAttribute) *QueryResultItem {
	s.AdditionalAttributes = v
	return s
}

// SetDocumentAttributes sets the DocumentAttributes field's value.
func (s *QueryResultItem) SetDocumentAttributes(v []*DocumentAttribute) *QueryResultItem {
	s.DocumentAttributes = v
	return s
}

// SetDocumentExcerpt sets the DocumentExcerpt field's value.
func (s *QueryResultItem) SetDocumentExcerpt(v *TextWithHighlights) *QueryResultItem {
	s.DocumentExcerpt = v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *QueryResultItem) SetDocumentId(v string) *QueryResultItem {
	s.DocumentId = &v
	return s
}

// SetDocumentTitle sets the DocumentTitle field's value.
func (s *QueryResultItem) SetDocumentTitle(v *TextWithHighlights) *QueryResultItem {
	s.DocumentTitle = v
	return s
}

// SetDocumentURI sets the DocumentURI field's value.
func (s *QueryResultItem) SetDocumentURI(v string) *QueryResultItem {
	s.DocumentURI = &v
	return s
}

// SetId sets the Id field's value.
func (s *QueryResultItem) SetId(v string) *QueryResultItem {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *QueryResultItem) SetType(v string) *QueryResultItem {
	s.Type = &v
	return s
}

// Provides information for manually tuning the relevance of a field in a search.
// When a query includes terms that match the field, the results are given a
// boost in the response based on these tuning parameters.
type Relevance struct {
	_ struct{} `type:"structure"`

	// Specifies the time period that the boost applies to. For example, to make
	// the boost apply to documents with the field value within the last month,
	// you would use "2628000s". Once the field value is beyond the specified range,
	// the effect of the boost drops off. The higher the importance, the faster
	// the effect drops off. If you don't specify a value, the default is 3 months.
	// The value of the field is a numeric string followed by the character "s",
	// for example "86400s" for one day, or "604800s" for one week.
	//
	// Only applies to DATE fields.
	Duration *string `min:"1" type:"string"`

	// Indicates that this field determines how "fresh" a document is. For example,
	// if document 1 was created on November 5, and document 2 was created on October
	// 31, document 1 is "fresher" than document 2. You can only set the Freshness
	// field on one DATE type field. Only applies to DATE fields.
	Freshness *bool `type:"boolean"`

	// The relative importance of the field in the search. Larger numbers provide
	// more of a boost than smaller numbers.
	Importance *int64 `min:"1" type:"integer"`

	// Determines how values should be interpreted.
	//
	// When the RankOrder field is ASCENDING, higher numbers are better. For example,
	// a document with a rating score of 10 is higher ranking than a document with
	// a rating score of 1.
	//
	// When the RankOrder field is DESCENDING, lower numbers are better. For example,
	// in a task tracking application, a priority 1 task is more important than
	// a priority 5 task.
	//
	// Only applies to LONG and DOUBLE fields.
	RankOrder *string `type:"string" enum:"Order"`

	// A list of values that should be given a different boost when they appear
	// in the result list. For example, if you are boosting a field called "department,"
	// query terms that match the department field are boosted in the result. However,
	// you can add entries from the department field to boost documents with those
	// values higher.
	//
	// For example, you can add entries to the map with names of departments. If
	// you add "HR",5 and "Legal",3 those departments are given special attention
	// when they appear in the metadata of a document. When those terms appear they
	// are given the specified importance instead of the regular importance for
	// the boost.
	ValueImportanceMap map[string]*int64 `type:"map"`
}

// String returns the string representation
func (s Relevance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Relevance) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Relevance) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Relevance"}
	if s.Duration != nil && len(*s.Duration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Duration", 1))
	}
	if s.Importance != nil && *s.Importance < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Importance", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *Relevance) SetDuration(v string) *Relevance {
	s.Duration = &v
	return s
}

// SetFreshness sets the Freshness field's value.
func (s *Relevance) SetFreshness(v bool) *Relevance {
	s.Freshness = &v
	return s
}

// SetImportance sets the Importance field's value.
func (s *Relevance) SetImportance(v int64) *Relevance {
	s.Importance = &v
	return s
}

// SetRankOrder sets the RankOrder field's value.
func (s *Relevance) SetRankOrder(v string) *Relevance {
	s.RankOrder = &v
	return s
}

// SetValueImportanceMap sets the ValueImportanceMap field's value.
func (s *Relevance) SetValueImportanceMap(v map[string]*int64) *Relevance {
	s.ValueImportanceMap = v
	return s
}

// Provides feedback on how relevant a document is to a search. Your application
// uses the SubmitFeedback operation to provide relevance information.
type RelevanceFeedback struct {
	_ struct{} `type:"structure"`

	// Whether to document was relevant or not relevant to the search.
	//
	// RelevanceValue is a required field
	RelevanceValue *string `type:"string" required:"true" enum:"RelevanceType"`

	// The unique identifier of the search result that the user provided relevance
	// feedback for.
	//
	// ResultId is a required field
	ResultId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RelevanceFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelevanceFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelevanceFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelevanceFeedback"}
	if s.RelevanceValue == nil {
		invalidParams.Add(request.NewErrParamRequired("RelevanceValue"))
	}
	if s.ResultId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultId"))
	}
	if s.ResultId != nil && len(*s.ResultId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelevanceValue sets the RelevanceValue field's value.
func (s *RelevanceFeedback) SetRelevanceValue(v string) *RelevanceFeedback {
	s.RelevanceValue = &v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *RelevanceFeedback) SetResultId(v string) *RelevanceFeedback {
	s.ResultId = &v
	return s
}

type ResourceAlreadyExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistException) Code() string {
	return "ResourceAlreadyExistException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides configuration information for a data source to index documents in
// an Amazon S3 bucket.
type S3DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides the path to the S3 bucket that contains the user context filtering
	// files for the data source.
	AccessControlListConfiguration *AccessControlListConfiguration `type:"structure"`

	// The name of the bucket that contains the documents.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Document metadata files that contain information such as the document access
	// control information, source URI, document author, and custom attributes.
	// Each metadata file contains metadata about a single document.
	DocumentsMetadataConfiguration *DocumentsMetadataConfiguration `type:"structure"`

	// A list of glob patterns for documents that should not be indexed. If a document
	// that matches an inclusion prefix also matches an exclusion pattern, the document
	// is not indexed.
	//
	// For more information about glob patterns, see glob (programming) (http://wikipedia.org/wiki/Glob_%28programming%29)
	// in Wikipedia.
	ExclusionPatterns []*string `type:"list"`

	// A list of S3 prefixes for the documents that should be included in the index.
	InclusionPrefixes []*string `type:"list"`
}

// String returns the string representation
func (s S3DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataSourceConfiguration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.AccessControlListConfiguration != nil {
		if err := s.AccessControlListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccessControlListConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentsMetadataConfiguration != nil {
		if err := s.DocumentsMetadataConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DocumentsMetadataConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlListConfiguration sets the AccessControlListConfiguration field's value.
func (s *S3DataSourceConfiguration) SetAccessControlListConfiguration(v *AccessControlListConfiguration) *S3DataSourceConfiguration {
	s.AccessControlListConfiguration = v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *S3DataSourceConfiguration) SetBucketName(v string) *S3DataSourceConfiguration {
	s.BucketName = &v
	return s
}

// SetDocumentsMetadataConfiguration sets the DocumentsMetadataConfiguration field's value.
func (s *S3DataSourceConfiguration) SetDocumentsMetadataConfiguration(v *DocumentsMetadataConfiguration) *S3DataSourceConfiguration {
	s.DocumentsMetadataConfiguration = v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *S3DataSourceConfiguration) SetExclusionPatterns(v []*string) *S3DataSourceConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetInclusionPrefixes sets the InclusionPrefixes field's value.
func (s *S3DataSourceConfiguration) SetInclusionPrefixes(v []*string) *S3DataSourceConfiguration {
	s.InclusionPrefixes = v
	return s
}

// Information required to find a specific file in an Amazon S3 bucket.
type S3Path struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that contains the file.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of the file.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Path) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Path) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Path) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Path"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Path) SetBucket(v string) *S3Path {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Path) SetKey(v string) *S3Path {
	s.Key = &v
	return s
}

// Provides information about how a custom index field is used during a search.
type Search struct {
	_ struct{} `type:"structure"`

	// Determines whether the field is returned in the query response. The default
	// is true.
	Displayable *bool `type:"boolean"`

	// Indicates that the field can be used to create search facets, a count of
	// results for each value in the field. The default is false .
	Facetable *bool `type:"boolean"`

	// Determines whether the field is used in the search. If the Searchable field
	// is true, you can use relevance tuning to manually tune how Amazon Kendra
	// weights the field in the search. The default is true for string fields and
	// false for number and date fields.
	Searchable *bool `type:"boolean"`
}

// String returns the string representation
func (s Search) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Search) GoString() string {
	return s.String()
}

// SetDisplayable sets the Displayable field's value.
func (s *Search) SetDisplayable(v bool) *Search {
	s.Displayable = &v
	return s
}

// SetFacetable sets the Facetable field's value.
func (s *Search) SetFacetable(v bool) *Search {
	s.Facetable = &v
	return s
}

// SetSearchable sets the Searchable field's value.
func (s *Search) SetSearchable(v bool) *Search {
	s.Searchable = &v
	return s
}

// Provides the identifier of the AWS KMS customer master key (CMK) used to
// encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric
// CMKs.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS KMS customer master key (CMK). Amazon Kendra doesn't
	// support asymmetric CMKs.
	KmsKeyId *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ServerSideEncryptionConfiguration) SetKmsKeyId(v string) *ServerSideEncryptionConfiguration {
	s.KmsKeyId = &v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides configuration information for connecting to a Microsoft SharePoint
// data source.
type SharePointConfiguration struct {
	_ struct{} `type:"structure"`

	// TRUE to include attachments to documents stored in your Microsoft SharePoint
	// site in the index; otherwise, FALSE.
	CrawlAttachments *bool `type:"boolean"`

	// The Microsoft SharePoint attribute field that contains the title of the document.
	DocumentTitleFieldName *string `min:"1" type:"string"`

	// A list of regular expression patterns. Documents that match the patterns
	// are excluded from the index. Documents that don't match the patterns are
	// included in the index. If a document matches both an exclusion pattern and
	// an inclusion pattern, the document is not included in the index.
	//
	// The regex is applied to the display URL of the SharePoint document.
	ExclusionPatterns []*string `type:"list"`

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft SharePoint
	// attributes to custom fields in the Amazon Kendra index. You must first create
	// the index fields using the operation before you map SharePoint attributes.
	// For more information, see Mapping Data Source Fields (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
	FieldMappings []*DataSourceToIndexFieldMapping `min:"1" type:"list"`

	// A list of regular expression patterns. Documents that match the patterns
	// are included in the index. Documents that don't match the patterns are excluded
	// from the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index.
	//
	// The regex is applied to the display URL of the SharePoint document.
	InclusionPatterns []*string `type:"list"`

	// The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager.
	// The credentials should be a user/password pair. For more information, see
	// Using a Microsoft SharePoint Data Source (https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html).
	// For more information about AWS Secrets Manager, see What Is AWS Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// in the AWS Secrets Manager user guide.
	//
	// SecretArn is a required field
	SecretArn *string `min:"1" type:"string" required:"true"`

	// The version of Microsoft SharePoint that you are using as a data source.
	//
	// SharePointVersion is a required field
	SharePointVersion *string `type:"string" required:"true" enum:"SharePointVersion"`

	// The URLs of the Microsoft SharePoint site that contains the documents that
	// should be indexed.
	//
	// Urls is a required field
	Urls []*string `min:"1" type:"list" required:"true"`

	// Set to TRUE to use the Microsoft SharePoint change log to determine the documents
	// that need to be updated in the index. Depending on the size of the SharePoint
	// change log, it may take longer for Amazon Kendra to use the change log than
	// it takes it to determine the changed documents using the Amazon Kendra document
	// crawler.
	UseChangeLog *bool `type:"boolean"`

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s SharePointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SharePointConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SharePointConfiguration"}
	if s.DocumentTitleFieldName != nil && len(*s.DocumentTitleFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentTitleFieldName", 1))
	}
	if s.FieldMappings != nil && len(s.FieldMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldMappings", 1))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 1))
	}
	if s.SharePointVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SharePointVersion"))
	}
	if s.Urls == nil {
		invalidParams.Add(request.NewErrParamRequired("Urls"))
	}
	if s.Urls != nil && len(s.Urls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Urls", 1))
	}
	if s.FieldMappings != nil {
		for i, v := range s.FieldMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlAttachments sets the CrawlAttachments field's value.
func (s *SharePointConfiguration) SetCrawlAttachments(v bool) *SharePointConfiguration {
	s.CrawlAttachments = &v
	return s
}

// SetDocumentTitleFieldName sets the DocumentTitleFieldName field's value.
func (s *SharePointConfiguration) SetDocumentTitleFieldName(v string) *SharePointConfiguration {
	s.DocumentTitleFieldName = &v
	return s
}

// SetExclusionPatterns sets the ExclusionPatterns field's value.
func (s *SharePointConfiguration) SetExclusionPatterns(v []*string) *SharePointConfiguration {
	s.ExclusionPatterns = v
	return s
}

// SetFieldMappings sets the FieldMappings field's value.
func (s *SharePointConfiguration) SetFieldMappings(v []*DataSourceToIndexFieldMapping) *SharePointConfiguration {
	s.FieldMappings = v
	return s
}

// SetInclusionPatterns sets the InclusionPatterns field's value.
func (s *SharePointConfiguration) SetInclusionPatterns(v []*string) *SharePointConfiguration {
	s.InclusionPatterns = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *SharePointConfiguration) SetSecretArn(v string) *SharePointConfiguration {
	s.SecretArn = &v
	return s
}

// SetSharePointVersion sets the SharePointVersion field's value.
func (s *SharePointConfiguration) SetSharePointVersion(v string) *SharePointConfiguration {
	s.SharePointVersion = &v
	return s
}

// SetUrls sets the Urls field's value.
func (s *SharePointConfiguration) SetUrls(v []*string) *SharePointConfiguration {
	s.Urls = v
	return s
}

// SetUseChangeLog sets the UseChangeLog field's value.
func (s *SharePointConfiguration) SetUseChangeLog(v bool) *SharePointConfiguration {
	s.UseChangeLog = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *SharePointConfiguration) SetVpcConfiguration(v *DataSourceVpcConfiguration) *SharePointConfiguration {
	s.VpcConfiguration = v
	return s
}

type StartDataSourceSyncJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source to synchronize.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s StartDataSourceSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataSourceSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataSourceSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataSourceSyncJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StartDataSourceSyncJobInput) SetId(v string) *StartDataSourceSyncJobInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *StartDataSourceSyncJobInput) SetIndexId(v string) *StartDataSourceSyncJobInput {
	s.IndexId = &v
	return s
}

type StartDataSourceSyncJobOutput struct {
	_ struct{} `type:"structure"`

	// Identifies a particular synchronization job.
	ExecutionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartDataSourceSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataSourceSyncJobOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *StartDataSourceSyncJobOutput) SetExecutionId(v string) *StartDataSourceSyncJobOutput {
	s.ExecutionId = &v
	return s
}

type StopDataSourceSyncJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source for which to stop the synchronization jobs.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDataSourceSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataSourceSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDataSourceSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDataSourceSyncJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopDataSourceSyncJobInput) SetId(v string) *StopDataSourceSyncJobInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *StopDataSourceSyncJobInput) SetIndexId(v string) *StopDataSourceSyncJobInput {
	s.IndexId = &v
	return s
}

type StopDataSourceSyncJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopDataSourceSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataSourceSyncJobOutput) GoString() string {
	return s.String()
}

type SubmitFeedbackInput struct {
	_ struct{} `type:"structure"`

	// Tells Amazon Kendra that a particular search result link was chosen by the
	// user.
	ClickFeedbackItems []*ClickFeedback `type:"list"`

	// The identifier of the index that was queried.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The identifier of the specific query for which you are submitting feedback.
	// The query ID is returned in the response to the operation.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`

	// Provides Amazon Kendra with relevant or not relevant feedback for whether
	// a particular item was relevant to the search.
	RelevanceFeedbackItems []*RelevanceFeedback `type:"list"`
}

// String returns the string representation
func (s SubmitFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubmitFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubmitFeedbackInput"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}
	if s.ClickFeedbackItems != nil {
		for i, v := range s.ClickFeedbackItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ClickFeedbackItems", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RelevanceFeedbackItems != nil {
		for i, v := range s.RelevanceFeedbackItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelevanceFeedbackItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClickFeedbackItems sets the ClickFeedbackItems field's value.
func (s *SubmitFeedbackInput) SetClickFeedbackItems(v []*ClickFeedback) *SubmitFeedbackInput {
	s.ClickFeedbackItems = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *SubmitFeedbackInput) SetIndexId(v string) *SubmitFeedbackInput {
	s.IndexId = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *SubmitFeedbackInput) SetQueryId(v string) *SubmitFeedbackInput {
	s.QueryId = &v
	return s
}

// SetRelevanceFeedbackItems sets the RelevanceFeedbackItems field's value.
func (s *SubmitFeedbackInput) SetRelevanceFeedbackItems(v []*RelevanceFeedback) *SubmitFeedbackInput {
	s.RelevanceFeedbackItems = v
	return s
}

type SubmitFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SubmitFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubmitFeedbackOutput) GoString() string {
	return s.String()
}

// Provides information about text documents indexed in an index.
type TextDocumentStatistics struct {
	_ struct{} `type:"structure"`

	// The number of text documents indexed.
	//
	// IndexedTextDocumentsCount is a required field
	IndexedTextDocumentsCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TextDocumentStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextDocumentStatistics) GoString() string {
	return s.String()
}

// SetIndexedTextDocumentsCount sets the IndexedTextDocumentsCount field's value.
func (s *TextDocumentStatistics) SetIndexedTextDocumentsCount(v int64) *TextDocumentStatistics {
	s.IndexedTextDocumentsCount = &v
	return s
}

// Provides text and information about where to highlight the text.
type TextWithHighlights struct {
	_ struct{} `type:"structure"`

	// The beginning and end of the text that should be highlighted.
	Highlights []*Highlight `type:"list"`

	// The text to display to the user.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TextWithHighlights) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextWithHighlights) GoString() string {
	return s.String()
}

// SetHighlights sets the Highlights field's value.
func (s *TextWithHighlights) SetHighlights(v []*Highlight) *TextWithHighlights {
	s.Highlights = v
	return s
}

// SetText sets the Text field's value.
func (s *TextWithHighlights) SetText(v string) *TextWithHighlights {
	s.Text = &v
	return s
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides a range of time.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The UNIX datetime of the end of the time range.
	EndTime *time.Time `type:"timestamp"`

	// The UNIX datetime of the beginning of the time range.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRange) SetEndTime(v time.Time) *TimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRange) SetStartTime(v time.Time) *TimeRange {
	s.StartTime = &v
	return s
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Configuration information for a Amazon Kendra data source.
	Configuration *DataSourceConfiguration `type:"structure"`

	// The new description for the data source.
	Description *string `min:"1" type:"string"`

	// The unique identifier of the data source to update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source to update.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name of the data source to update. The name of the data source can't
	// be updated. To rename a data source you must delete the data source and re-create
	// it.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the new role to use when the data source
	// is accessing resources on your behalf.
	RoleArn *string `min:"1" type:"string"`

	// The new update schedule for the data source.
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateDataSourceInput) SetConfiguration(v *DataSourceConfiguration) *UpdateDataSourceInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDataSourceInput) SetId(v string) *UpdateDataSourceInput {
	s.Id = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateDataSourceInput) SetIndexId(v string) *UpdateDataSourceInput {
	s.IndexId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateDataSourceInput) SetRoleArn(v string) *UpdateDataSourceInput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateDataSourceInput) SetSchedule(v string) *UpdateDataSourceInput {
	s.Schedule = &v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

type UpdateIndexInput struct {
	_ struct{} `type:"structure"`

	// A new description for the index.
	Description *string `min:"1" type:"string"`

	// The document metadata to update.
	DocumentMetadataConfigurationUpdates []*DocumentMetadataConfiguration `type:"list"`

	// The identifier of the index to update.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// The name of the index to update.
	Name *string `min:"1" type:"string"`

	// A new IAM role that gives Amazon Kendra permission to access your Amazon
	// CloudWatch logs.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIndexInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DocumentMetadataConfigurationUpdates != nil {
		for i, v := range s.DocumentMetadataConfigurationUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentMetadataConfigurationUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateIndexInput) SetDescription(v string) *UpdateIndexInput {
	s.Description = &v
	return s
}

// SetDocumentMetadataConfigurationUpdates sets the DocumentMetadataConfigurationUpdates field's value.
func (s *UpdateIndexInput) SetDocumentMetadataConfigurationUpdates(v []*DocumentMetadataConfiguration) *UpdateIndexInput {
	s.DocumentMetadataConfigurationUpdates = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateIndexInput) SetId(v string) *UpdateIndexInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateIndexInput) SetName(v string) *UpdateIndexInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateIndexInput) SetRoleArn(v string) *UpdateIndexInput {
	s.RoleArn = &v
	return s
}

type UpdateIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIndexOutput) GoString() string {
	return s.String()
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AdditionalResultAttributeValueTypeTextWithHighlightsValue is a AdditionalResultAttributeValueType enum value
	AdditionalResultAttributeValueTypeTextWithHighlightsValue = "TEXT_WITH_HIGHLIGHTS_VALUE"
)

const (
	// ContentTypePdf is a ContentType enum value
	ContentTypePdf = "PDF"

	// ContentTypeHtml is a ContentType enum value
	ContentTypeHtml = "HTML"

	// ContentTypeMsWord is a ContentType enum value
	ContentTypeMsWord = "MS_WORD"

	// ContentTypePlainText is a ContentType enum value
	ContentTypePlainText = "PLAIN_TEXT"

	// ContentTypePpt is a ContentType enum value
	ContentTypePpt = "PPT"
)

const (
	// DataSourceStatusCreating is a DataSourceStatus enum value
	DataSourceStatusCreating = "CREATING"

	// DataSourceStatusDeleting is a DataSourceStatus enum value
	DataSourceStatusDeleting = "DELETING"

	// DataSourceStatusFailed is a DataSourceStatus enum value
	DataSourceStatusFailed = "FAILED"

	// DataSourceStatusUpdating is a DataSourceStatus enum value
	DataSourceStatusUpdating = "UPDATING"

	// DataSourceStatusActive is a DataSourceStatus enum value
	DataSourceStatusActive = "ACTIVE"
)

const (
	// DataSourceSyncJobStatusFailed is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusFailed = "FAILED"

	// DataSourceSyncJobStatusSucceeded is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSucceeded = "SUCCEEDED"

	// DataSourceSyncJobStatusSyncing is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSyncing = "SYNCING"

	// DataSourceSyncJobStatusIncomplete is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusIncomplete = "INCOMPLETE"

	// DataSourceSyncJobStatusStopping is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusStopping = "STOPPING"

	// DataSourceSyncJobStatusAborted is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusAborted = "ABORTED"
)

const (
	// DataSourceTypeS3 is a DataSourceType enum value
	DataSourceTypeS3 = "S3"

	// DataSourceTypeSharepoint is a DataSourceType enum value
	DataSourceTypeSharepoint = "SHAREPOINT"

	// DataSourceTypeDatabase is a DataSourceType enum value
	DataSourceTypeDatabase = "DATABASE"
)

const (
	// DatabaseEngineTypeRdsAuroraMysql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsAuroraMysql = "RDS_AURORA_MYSQL"

	// DatabaseEngineTypeRdsAuroraPostgresql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsAuroraPostgresql = "RDS_AURORA_POSTGRESQL"

	// DatabaseEngineTypeRdsMysql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsMysql = "RDS_MYSQL"

	// DatabaseEngineTypeRdsPostgresql is a DatabaseEngineType enum value
	DatabaseEngineTypeRdsPostgresql = "RDS_POSTGRESQL"
)

const (
	// DocumentAttributeValueTypeStringValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeStringValue = "STRING_VALUE"

	// DocumentAttributeValueTypeStringListValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeStringListValue = "STRING_LIST_VALUE"

	// DocumentAttributeValueTypeLongValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeLongValue = "LONG_VALUE"

	// DocumentAttributeValueTypeDateValue is a DocumentAttributeValueType enum value
	DocumentAttributeValueTypeDateValue = "DATE_VALUE"
)

const (
	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"

	// ErrorCodeInvalidRequest is a ErrorCode enum value
	ErrorCodeInvalidRequest = "InvalidRequest"
)

const (
	// FaqStatusCreating is a FaqStatus enum value
	FaqStatusCreating = "CREATING"

	// FaqStatusUpdating is a FaqStatus enum value
	FaqStatusUpdating = "UPDATING"

	// FaqStatusActive is a FaqStatus enum value
	FaqStatusActive = "ACTIVE"

	// FaqStatusDeleting is a FaqStatus enum value
	FaqStatusDeleting = "DELETING"

	// FaqStatusFailed is a FaqStatus enum value
	FaqStatusFailed = "FAILED"
)

const (
	// IndexStatusCreating is a IndexStatus enum value
	IndexStatusCreating = "CREATING"

	// IndexStatusActive is a IndexStatus enum value
	IndexStatusActive = "ACTIVE"

	// IndexStatusDeleting is a IndexStatus enum value
	IndexStatusDeleting = "DELETING"

	// IndexStatusFailed is a IndexStatus enum value
	IndexStatusFailed = "FAILED"

	// IndexStatusSystemUpdating is a IndexStatus enum value
	IndexStatusSystemUpdating = "SYSTEM_UPDATING"
)

const (
	// OrderAscending is a Order enum value
	OrderAscending = "ASCENDING"

	// OrderDescending is a Order enum value
	OrderDescending = "DESCENDING"
)

const (
	// PrincipalTypeUser is a PrincipalType enum value
	PrincipalTypeUser = "USER"

	// PrincipalTypeGroup is a PrincipalType enum value
	PrincipalTypeGroup = "GROUP"
)

const (
	// QueryResultTypeDocument is a QueryResultType enum value
	QueryResultTypeDocument = "DOCUMENT"

	// QueryResultTypeQuestionAnswer is a QueryResultType enum value
	QueryResultTypeQuestionAnswer = "QUESTION_ANSWER"

	// QueryResultTypeAnswer is a QueryResultType enum value
	QueryResultTypeAnswer = "ANSWER"
)

const (
	// ReadAccessTypeAllow is a ReadAccessType enum value
	ReadAccessTypeAllow = "ALLOW"

	// ReadAccessTypeDeny is a ReadAccessType enum value
	ReadAccessTypeDeny = "DENY"
)

const (
	// RelevanceTypeRelevant is a RelevanceType enum value
	RelevanceTypeRelevant = "RELEVANT"

	// RelevanceTypeNotRelevant is a RelevanceType enum value
	RelevanceTypeNotRelevant = "NOT_RELEVANT"
)

const (
	// SharePointVersionSharepointOnline is a SharePointVersion enum value
	SharePointVersionSharepointOnline = "SHAREPOINT_ONLINE"
)
