// DO NOT EDIT: This file is autogenerated via the builtin command.

package universe

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 74,
					Line:   246,
				},
				File:   "universe.flux",
				Source: "package universe\n\nimport \"system\"\n\n// now is a function option whose default behaviour is to return the current system time\noption now = system.time\n\n// Booleans\nbuiltin true\nbuiltin false\n\n// Transformation functions\nbuiltin columns\nbuiltin count\nbuiltin covariance\nbuiltin cumulativeSum\nbuiltin derivative\nbuiltin difference\nbuiltin distinct\nbuiltin drop\nbuiltin duplicate\nbuiltin fill\nbuiltin filter\nbuiltin first\nbuiltin group\nbuiltin histogram\nbuiltin histogramQuantile\nbuiltin integral\nbuiltin join\nbuiltin keep\nbuiltin keyValues\nbuiltin keys\nbuiltin last\nbuiltin limit\nbuiltin map\nbuiltin max\nbuiltin mean\nbuiltin min\nbuiltin quantile\nbuiltin pivot\nbuiltin range\nbuiltin reduce\nbuiltin rename\nbuiltin sample\nbuiltin set\nbuiltin timeShift\nbuiltin skew\nbuiltin spread\nbuiltin sort\nbuiltin stateTracking\nbuiltin stddev\nbuiltin sum\nbuiltin union\nbuiltin unique\nbuiltin window\nbuiltin yield\n\n// stream/table index functions\nbuiltin tableFind\nbuiltin getColumn\nbuiltin getRecord\n\n// type conversion functions\nbuiltin bool\nbuiltin duration\nbuiltin float\nbuiltin int\nbuiltin string\nbuiltin time\nbuiltin uint\n\n// contains function\nbuiltin contains\n\n// other builtins\nbuiltin inf\nbuiltin linearBins\nbuiltin logarithmicBins\n\n// covariance function with automatic join\ncov = (x,y,on,pearsonr=false) =>\n    join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])\n\npearsonr = (x,y,on) => cov(x:x, y:y, on:on, pearsonr:true)\n\n// AggregateWindow applies an aggregate function to fixed windows of time.\n// The procedure is to window the data, perform an aggregate operation,\n// and then undo the windowing to produce an output table for every input table.\naggregateWindow = (every, fn, column=\"_value\", timeSrc=\"_stop\",timeDst=\"_time\", createEmpty=true, tables=<-) =>\n    tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)\n\n// Increase returns the total non-negative difference between values in a table.\n// A main usage case is tracking changes in counter values which may wrap over time when they hit\n// a threshold or are reset. In the case of a wrap/reset,\n// we can assume that the absolute delta between two points will be at least their non-negative difference.\nincrease = (tables=<-, columns=[\"_value\"]) =>\n    tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)\n\n// median returns the 50th percentile.\nmedian = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) =>\n    tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)\n\n// stateCount computes the number of consecutive records in a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state count will be incremented\n// When a point evaluates as false, the state count is reset.\n//\n// The state count will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state count.\nstateCount = (fn, column=\"stateCount\", tables=<-) =>\n    tables\n        |> stateTracking(countColumn:column, fn:fn)\n\n// stateDuration computes the duration of a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state duration will be\n// incremented by the duration between points. When a point evaluates as false,\n// the state duration is reset.\n//\n// The state duration will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state duration.\n//\n// Note that as the first point in the given state has no previous point, its\n// state duration will be 0.\n//\n// The duration is represented as an integer in the units specified.\nstateDuration = (fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) =>\n    tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)\n\n// _sortLimit is a helper function, which sorts and limits a table.\n_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)\n\n// top sorts a table by columns and keeps only the top n records.\ntop = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:true)\n\n// top sorts a table by columns and keeps only the bottom n records.\nbottom = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:false)\n\n// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n// then it selects the highest or lowest records based on the column and the _sortLimit function.\n// The default reducer assumes no reducing needs to be performed.\n_highestOrLowest = (n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])\n\n// highestMax returns the top N records from all groups using the maximum of each group.\nhighestMax = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )\n\n// highestAverage returns the top N records from all groups using the average of each group.\nhighestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )\n\n// highestCurrent returns the top N records from all groups using the last value of each group.\nhighestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )\n\n// lowestMin returns the bottom N records from all groups using the minimum of each group.\nlowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )\n\n// lowestAverage returns the bottom N records from all groups using the average of each group.\nlowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )\n\n// lowestCurrent returns the bottom N records from all groups using the last value of each group.\nlowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )\n\ntoString = (tables=<-) => tables |> map(fn:(r) => string(v:r._value))\ntoInt = (tables=<-) => tables |> map(fn:(r) => int(v:r._value))\ntoUInt = (tables=<-) => tables |> map(fn:(r) => uint(v:r._value))\ntoFloat = (tables=<-) => tables |> map(fn:(r) => float(v:r._value))\ntoBool = (tables=<-) => tables |> map(fn:(r) => bool(v:r._value))\ntoTime = (tables=<-) => tables |> map(fn:(r) => time(v:r._value))\ntoDuration = (tables=<-) => tables |> map(fn:(r) => duration(v:r._value))",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   6,
						},
						File:   "universe.flux",
						Source: "now = system.time",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "universe.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   6,
							},
							File:   "universe.flux",
							Source: "system.time",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   6,
								},
								File:   "universe.flux",
								Source: "system",
								Start: ast.Position{
									Column: 14,
									Line:   6,
								},
							},
						},
						Name: "system",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   6,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 21,
									Line:   6,
								},
							},
						},
						Name: "time",
					},
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   6,
					},
					File:   "universe.flux",
					Source: "option now = system.time",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   9,
					},
					File:   "universe.flux",
					Source: "builtin true",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   9,
						},
						File:   "universe.flux",
						Source: "true",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Name: "true",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   10,
					},
					File:   "universe.flux",
					Source: "builtin false",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   10,
						},
						File:   "universe.flux",
						Source: "false",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Name: "false",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   13,
					},
					File:   "universe.flux",
					Source: "builtin columns",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   13,
						},
						File:   "universe.flux",
						Source: "columns",
						Start: ast.Position{
							Column: 9,
							Line:   13,
						},
					},
				},
				Name: "columns",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   14,
					},
					File:   "universe.flux",
					Source: "builtin count",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   14,
						},
						File:   "universe.flux",
						Source: "count",
						Start: ast.Position{
							Column: 9,
							Line:   14,
						},
					},
				},
				Name: "count",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   15,
					},
					File:   "universe.flux",
					Source: "builtin covariance",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "covariance",
						Start: ast.Position{
							Column: 9,
							Line:   15,
						},
					},
				},
				Name: "covariance",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   16,
					},
					File:   "universe.flux",
					Source: "builtin cumulativeSum",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   16,
						},
						File:   "universe.flux",
						Source: "cumulativeSum",
						Start: ast.Position{
							Column: 9,
							Line:   16,
						},
					},
				},
				Name: "cumulativeSum",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   17,
					},
					File:   "universe.flux",
					Source: "builtin derivative",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   17,
						},
						File:   "universe.flux",
						Source: "derivative",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "derivative",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   18,
					},
					File:   "universe.flux",
					Source: "builtin difference",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "difference",
						Start: ast.Position{
							Column: 9,
							Line:   18,
						},
					},
				},
				Name: "difference",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   19,
					},
					File:   "universe.flux",
					Source: "builtin distinct",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "distinct",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "distinct",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   20,
					},
					File:   "universe.flux",
					Source: "builtin drop",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "drop",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "drop",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   21,
					},
					File:   "universe.flux",
					Source: "builtin duplicate",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   21,
						},
						File:   "universe.flux",
						Source: "duplicate",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Name: "duplicate",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   22,
					},
					File:   "universe.flux",
					Source: "builtin fill",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   22,
						},
						File:   "universe.flux",
						Source: "fill",
						Start: ast.Position{
							Column: 9,
							Line:   22,
						},
					},
				},
				Name: "fill",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   23,
					},
					File:   "universe.flux",
					Source: "builtin filter",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   23,
						},
						File:   "universe.flux",
						Source: "filter",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Name: "filter",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   24,
					},
					File:   "universe.flux",
					Source: "builtin first",
					Start: ast.Position{
						Column: 1,
						Line:   24,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   24,
						},
						File:   "universe.flux",
						Source: "first",
						Start: ast.Position{
							Column: 9,
							Line:   24,
						},
					},
				},
				Name: "first",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   25,
					},
					File:   "universe.flux",
					Source: "builtin group",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   25,
						},
						File:   "universe.flux",
						Source: "group",
						Start: ast.Position{
							Column: 9,
							Line:   25,
						},
					},
				},
				Name: "group",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   26,
					},
					File:   "universe.flux",
					Source: "builtin histogram",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   26,
						},
						File:   "universe.flux",
						Source: "histogram",
						Start: ast.Position{
							Column: 9,
							Line:   26,
						},
					},
				},
				Name: "histogram",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   27,
					},
					File:   "universe.flux",
					Source: "builtin histogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   27,
						},
						File:   "universe.flux",
						Source: "histogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   27,
						},
					},
				},
				Name: "histogramQuantile",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   28,
					},
					File:   "universe.flux",
					Source: "builtin integral",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   28,
						},
						File:   "universe.flux",
						Source: "integral",
						Start: ast.Position{
							Column: 9,
							Line:   28,
						},
					},
				},
				Name: "integral",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   29,
					},
					File:   "universe.flux",
					Source: "builtin join",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   29,
						},
						File:   "universe.flux",
						Source: "join",
						Start: ast.Position{
							Column: 9,
							Line:   29,
						},
					},
				},
				Name: "join",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   30,
					},
					File:   "universe.flux",
					Source: "builtin keep",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   30,
						},
						File:   "universe.flux",
						Source: "keep",
						Start: ast.Position{
							Column: 9,
							Line:   30,
						},
					},
				},
				Name: "keep",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   31,
					},
					File:   "universe.flux",
					Source: "builtin keyValues",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   31,
						},
						File:   "universe.flux",
						Source: "keyValues",
						Start: ast.Position{
							Column: 9,
							Line:   31,
						},
					},
				},
				Name: "keyValues",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   32,
					},
					File:   "universe.flux",
					Source: "builtin keys",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   32,
						},
						File:   "universe.flux",
						Source: "keys",
						Start: ast.Position{
							Column: 9,
							Line:   32,
						},
					},
				},
				Name: "keys",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   33,
					},
					File:   "universe.flux",
					Source: "builtin last",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "last",
						Start: ast.Position{
							Column: 9,
							Line:   33,
						},
					},
				},
				Name: "last",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   34,
					},
					File:   "universe.flux",
					Source: "builtin limit",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "limit",
						Start: ast.Position{
							Column: 9,
							Line:   34,
						},
					},
				},
				Name: "limit",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   35,
					},
					File:   "universe.flux",
					Source: "builtin map",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "map",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Name: "map",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   36,
					},
					File:   "universe.flux",
					Source: "builtin max",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "max",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Name: "max",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   37,
					},
					File:   "universe.flux",
					Source: "builtin mean",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 9,
							Line:   37,
						},
					},
				},
				Name: "mean",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   38,
					},
					File:   "universe.flux",
					Source: "builtin min",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "min",
						Start: ast.Position{
							Column: 9,
							Line:   38,
						},
					},
				},
				Name: "min",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   39,
					},
					File:   "universe.flux",
					Source: "builtin quantile",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Name: "quantile",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   40,
					},
					File:   "universe.flux",
					Source: "builtin pivot",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "pivot",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "pivot",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   41,
					},
					File:   "universe.flux",
					Source: "builtin range",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "range",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "range",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   42,
					},
					File:   "universe.flux",
					Source: "builtin reduce",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   42,
						},
						File:   "universe.flux",
						Source: "reduce",
						Start: ast.Position{
							Column: 9,
							Line:   42,
						},
					},
				},
				Name: "reduce",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   43,
					},
					File:   "universe.flux",
					Source: "builtin rename",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   43,
						},
						File:   "universe.flux",
						Source: "rename",
						Start: ast.Position{
							Column: 9,
							Line:   43,
						},
					},
				},
				Name: "rename",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   44,
					},
					File:   "universe.flux",
					Source: "builtin sample",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   44,
						},
						File:   "universe.flux",
						Source: "sample",
						Start: ast.Position{
							Column: 9,
							Line:   44,
						},
					},
				},
				Name: "sample",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   45,
					},
					File:   "universe.flux",
					Source: "builtin set",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   45,
						},
						File:   "universe.flux",
						Source: "set",
						Start: ast.Position{
							Column: 9,
							Line:   45,
						},
					},
				},
				Name: "set",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   46,
					},
					File:   "universe.flux",
					Source: "builtin timeShift",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   46,
						},
						File:   "universe.flux",
						Source: "timeShift",
						Start: ast.Position{
							Column: 9,
							Line:   46,
						},
					},
				},
				Name: "timeShift",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   47,
					},
					File:   "universe.flux",
					Source: "builtin skew",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   47,
						},
						File:   "universe.flux",
						Source: "skew",
						Start: ast.Position{
							Column: 9,
							Line:   47,
						},
					},
				},
				Name: "skew",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   48,
					},
					File:   "universe.flux",
					Source: "builtin spread",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   48,
						},
						File:   "universe.flux",
						Source: "spread",
						Start: ast.Position{
							Column: 9,
							Line:   48,
						},
					},
				},
				Name: "spread",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   49,
					},
					File:   "universe.flux",
					Source: "builtin sort",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   49,
						},
						File:   "universe.flux",
						Source: "sort",
						Start: ast.Position{
							Column: 9,
							Line:   49,
						},
					},
				},
				Name: "sort",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   50,
					},
					File:   "universe.flux",
					Source: "builtin stateTracking",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   50,
						},
						File:   "universe.flux",
						Source: "stateTracking",
						Start: ast.Position{
							Column: 9,
							Line:   50,
						},
					},
				},
				Name: "stateTracking",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   51,
					},
					File:   "universe.flux",
					Source: "builtin stddev",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   51,
						},
						File:   "universe.flux",
						Source: "stddev",
						Start: ast.Position{
							Column: 9,
							Line:   51,
						},
					},
				},
				Name: "stddev",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   52,
					},
					File:   "universe.flux",
					Source: "builtin sum",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   52,
						},
						File:   "universe.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 9,
							Line:   52,
						},
					},
				},
				Name: "sum",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   53,
					},
					File:   "universe.flux",
					Source: "builtin union",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   53,
						},
						File:   "universe.flux",
						Source: "union",
						Start: ast.Position{
							Column: 9,
							Line:   53,
						},
					},
				},
				Name: "union",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   54,
					},
					File:   "universe.flux",
					Source: "builtin unique",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   54,
						},
						File:   "universe.flux",
						Source: "unique",
						Start: ast.Position{
							Column: 9,
							Line:   54,
						},
					},
				},
				Name: "unique",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   55,
					},
					File:   "universe.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   55,
						},
						File:   "universe.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   55,
						},
					},
				},
				Name: "window",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   56,
					},
					File:   "universe.flux",
					Source: "builtin yield",
					Start: ast.Position{
						Column: 1,
						Line:   56,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   56,
						},
						File:   "universe.flux",
						Source: "yield",
						Start: ast.Position{
							Column: 9,
							Line:   56,
						},
					},
				},
				Name: "yield",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   59,
					},
					File:   "universe.flux",
					Source: "builtin tableFind",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   59,
						},
						File:   "universe.flux",
						Source: "tableFind",
						Start: ast.Position{
							Column: 9,
							Line:   59,
						},
					},
				},
				Name: "tableFind",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   60,
					},
					File:   "universe.flux",
					Source: "builtin getColumn",
					Start: ast.Position{
						Column: 1,
						Line:   60,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   60,
						},
						File:   "universe.flux",
						Source: "getColumn",
						Start: ast.Position{
							Column: 9,
							Line:   60,
						},
					},
				},
				Name: "getColumn",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   61,
					},
					File:   "universe.flux",
					Source: "builtin getRecord",
					Start: ast.Position{
						Column: 1,
						Line:   61,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   61,
						},
						File:   "universe.flux",
						Source: "getRecord",
						Start: ast.Position{
							Column: 9,
							Line:   61,
						},
					},
				},
				Name: "getRecord",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   64,
					},
					File:   "universe.flux",
					Source: "builtin bool",
					Start: ast.Position{
						Column: 1,
						Line:   64,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   64,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 9,
							Line:   64,
						},
					},
				},
				Name: "bool",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   65,
					},
					File:   "universe.flux",
					Source: "builtin duration",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   65,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 9,
							Line:   65,
						},
					},
				},
				Name: "duration",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   66,
					},
					File:   "universe.flux",
					Source: "builtin float",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   66,
						},
						File:   "universe.flux",
						Source: "float",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "float",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   67,
					},
					File:   "universe.flux",
					Source: "builtin int",
					Start: ast.Position{
						Column: 1,
						Line:   67,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   67,
						},
						File:   "universe.flux",
						Source: "int",
						Start: ast.Position{
							Column: 9,
							Line:   67,
						},
					},
				},
				Name: "int",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   68,
					},
					File:   "universe.flux",
					Source: "builtin string",
					Start: ast.Position{
						Column: 1,
						Line:   68,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   68,
						},
						File:   "universe.flux",
						Source: "string",
						Start: ast.Position{
							Column: 9,
							Line:   68,
						},
					},
				},
				Name: "string",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   69,
					},
					File:   "universe.flux",
					Source: "builtin time",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   69,
						},
						File:   "universe.flux",
						Source: "time",
						Start: ast.Position{
							Column: 9,
							Line:   69,
						},
					},
				},
				Name: "time",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   70,
					},
					File:   "universe.flux",
					Source: "builtin uint",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   70,
						},
						File:   "universe.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 9,
							Line:   70,
						},
					},
				},
				Name: "uint",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   73,
					},
					File:   "universe.flux",
					Source: "builtin contains",
					Start: ast.Position{
						Column: 1,
						Line:   73,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   73,
						},
						File:   "universe.flux",
						Source: "contains",
						Start: ast.Position{
							Column: 9,
							Line:   73,
						},
					},
				},
				Name: "contains",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   76,
					},
					File:   "universe.flux",
					Source: "builtin inf",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   76,
						},
						File:   "universe.flux",
						Source: "inf",
						Start: ast.Position{
							Column: 9,
							Line:   76,
						},
					},
				},
				Name: "inf",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   77,
					},
					File:   "universe.flux",
					Source: "builtin linearBins",
					Start: ast.Position{
						Column: 1,
						Line:   77,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   77,
						},
						File:   "universe.flux",
						Source: "linearBins",
						Start: ast.Position{
							Column: 9,
							Line:   77,
						},
					},
				},
				Name: "linearBins",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   78,
					},
					File:   "universe.flux",
					Source: "builtin logarithmicBins",
					Start: ast.Position{
						Column: 1,
						Line:   78,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   78,
						},
						File:   "universe.flux",
						Source: "logarithmicBins",
						Start: ast.Position{
							Column: 9,
							Line:   78,
						},
					},
				},
				Name: "logarithmicBins",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   86,
					},
					File:   "universe.flux",
					Source: "cov = (x,y,on,pearsonr=false) =>\n    join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
					Start: ast.Position{
						Column: 1,
						Line:   81,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   81,
						},
						File:   "universe.flux",
						Source: "cov",
						Start: ast.Position{
							Column: 1,
							Line:   81,
						},
					},
				},
				Name: "cov",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   86,
						},
						File:   "universe.flux",
						Source: "(x,y,on,pearsonr=false) =>\n    join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
						Start: ast.Position{
							Column: 7,
							Line:   81,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   84,
									},
									File:   "universe.flux",
									Source: "tables:{x:x, y:y},\n        on:on",
									Start: ast.Position{
										Column: 9,
										Line:   83,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   83,
										},
										File:   "universe.flux",
										Source: "tables:{x:x, y:y}",
										Start: ast.Position{
											Column: 9,
											Line:   83,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   83,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   83,
											},
										},
									},
									Name: "tables",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   83,
											},
											File:   "universe.flux",
											Source: "{x:x, y:y}",
											Start: ast.Position{
												Column: 16,
												Line:   83,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   83,
												},
												File:   "universe.flux",
												Source: "x:x",
												Start: ast.Position{
													Column: 17,
													Line:   83,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   83,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 17,
														Line:   83,
													},
												},
											},
											Name: "x",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   83,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 19,
														Line:   83,
													},
												},
											},
											Name: "x",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   83,
												},
												File:   "universe.flux",
												Source: "y:y",
												Start: ast.Position{
													Column: 22,
													Line:   83,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   83,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 22,
														Line:   83,
													},
												},
											},
											Name: "y",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   83,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 24,
														Line:   83,
													},
												},
											},
											Name: "y",
										},
									}},
									With: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   84,
										},
										File:   "universe.flux",
										Source: "on:on",
										Start: ast.Position{
											Column: 9,
											Line:   84,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   84,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 9,
												Line:   84,
											},
										},
									},
									Name: "on",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   84,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 12,
												Line:   84,
											},
										},
									},
									Name: "on",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   85,
								},
								File:   "universe.flux",
								Source: "join(\n        tables:{x:x, y:y},\n        on:on,\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   82,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   82,
									},
									File:   "universe.flux",
									Source: "join",
									Start: ast.Position{
										Column: 5,
										Line:   82,
									},
								},
							},
							Name: "join",
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
							Start: ast.Position{
								Column: 5,
								Line:   82,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"]",
									Start: ast.Position{
										Column: 19,
										Line:   86,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "pearsonr:pearsonr",
										Start: ast.Position{
											Column: 19,
											Line:   86,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 19,
												Line:   86,
											},
										},
									},
									Name: "pearsonr",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 28,
												Line:   86,
											},
										},
									},
									Name: "pearsonr",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "columns:[\"_value_x\",\"_value_y\"]",
										Start: ast.Position{
											Column: 38,
											Line:   86,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 38,
												Line:   86,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "[\"_value_x\",\"_value_y\"]",
											Start: ast.Position{
												Column: 46,
												Line:   86,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   86,
												},
												File:   "universe.flux",
												Source: "\"_value_x\"",
												Start: ast.Position{
													Column: 47,
													Line:   86,
												},
											},
										},
										Value: "_value_x",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   86,
												},
												File:   "universe.flux",
												Source: "\"_value_y\"",
												Start: ast.Position{
													Column: 58,
													Line:   86,
												},
											},
										},
										Value: "_value_y",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
								Start: ast.Position{
									Column: 8,
									Line:   86,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "covariance",
									Start: ast.Position{
										Column: 8,
										Line:   86,
									},
								},
							},
							Name: "covariance",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   81,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 8,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 8,
									Line:   81,
								},
							},
						},
						Name: "x",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   81,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 10,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 10,
									Line:   81,
								},
							},
						},
						Name: "y",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   81,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 12,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 12,
									Line:   81,
								},
							},
						},
						Name: "on",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   81,
							},
							File:   "universe.flux",
							Source: "pearsonr=false",
							Start: ast.Position{
								Column: 15,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "pearsonr",
								Start: ast.Position{
									Column: 15,
									Line:   81,
								},
							},
						},
						Name: "pearsonr",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "false",
								Start: ast.Position{
									Column: 24,
									Line:   81,
								},
							},
						},
						Name: "false",
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   88,
					},
					File:   "universe.flux",
					Source: "pearsonr = (x,y,on) => cov(x:x, y:y, on:on, pearsonr:true)",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   88,
						},
						File:   "universe.flux",
						Source: "pearsonr",
						Start: ast.Position{
							Column: 1,
							Line:   88,
						},
					},
				},
				Name: "pearsonr",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   88,
						},
						File:   "universe.flux",
						Source: "(x,y,on) => cov(x:x, y:y, on:on, pearsonr:true)",
						Start: ast.Position{
							Column: 12,
							Line:   88,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "x:x, y:y, on:on, pearsonr:true",
								Start: ast.Position{
									Column: 28,
									Line:   88,
								},
							},
						},
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "x:x",
									Start: ast.Position{
										Column: 28,
										Line:   88,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 28,
											Line:   88,
										},
									},
								},
								Name: "x",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 30,
											Line:   88,
										},
									},
								},
								Name: "x",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "y:y",
									Start: ast.Position{
										Column: 33,
										Line:   88,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 33,
											Line:   88,
										},
									},
								},
								Name: "y",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 35,
											Line:   88,
										},
									},
								},
								Name: "y",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "on:on",
									Start: ast.Position{
										Column: 38,
										Line:   88,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 38,
											Line:   88,
										},
									},
								},
								Name: "on",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 41,
											Line:   88,
										},
									},
								},
								Name: "on",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "pearsonr:true",
									Start: ast.Position{
										Column: 45,
										Line:   88,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "pearsonr",
										Start: ast.Position{
											Column: 45,
											Line:   88,
										},
									},
								},
								Name: "pearsonr",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "true",
										Start: ast.Position{
											Column: 54,
											Line:   88,
										},
									},
								},
								Name: "true",
							},
						}},
						With: nil,
					}},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "cov(x:x, y:y, on:on, pearsonr:true)",
							Start: ast.Position{
								Column: 24,
								Line:   88,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "cov",
								Start: ast.Position{
									Column: 24,
									Line:   88,
								},
							},
						},
						Name: "cov",
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 13,
								Line:   88,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 13,
									Line:   88,
								},
							},
						},
						Name: "x",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 15,
								Line:   88,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 15,
									Line:   88,
								},
							},
						},
						Name: "y",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 17,
								Line:   88,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 17,
									Line:   88,
								},
							},
						},
						Name: "on",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 49,
						Line:   98,
					},
					File:   "universe.flux",
					Source: "aggregateWindow = (every, fn, column=\"_value\", timeSrc=\"_stop\",timeDst=\"_time\", createEmpty=true, tables=<-) =>\n    tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "aggregateWindow",
						Start: ast.Position{
							Column: 1,
							Line:   93,
						},
					},
				},
				Name: "aggregateWindow",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   98,
						},
						File:   "universe.flux",
						Source: "(every, fn, column=\"_value\", timeSrc=\"_stop\",timeDst=\"_time\", createEmpty=true, tables=<-) =>\n    tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)",
						Start: ast.Position{
							Column: 19,
							Line:   93,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   94,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   94,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "tables\n        |> window(every:every, createEmpty: createEmpty)",
										Start: ast.Position{
											Column: 5,
											Line:   94,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   95,
												},
												File:   "universe.flux",
												Source: "every:every, createEmpty: createEmpty",
												Start: ast.Position{
													Column: 19,
													Line:   95,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   95,
													},
													File:   "universe.flux",
													Source: "every:every",
													Start: ast.Position{
														Column: 19,
														Line:   95,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   95,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 19,
															Line:   95,
														},
													},
												},
												Name: "every",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   95,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 25,
															Line:   95,
														},
													},
												},
												Name: "every",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   95,
													},
													File:   "universe.flux",
													Source: "createEmpty: createEmpty",
													Start: ast.Position{
														Column: 32,
														Line:   95,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   95,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 32,
															Line:   95,
														},
													},
												},
												Name: "createEmpty",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   95,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 45,
															Line:   95,
														},
													},
												},
												Name: "createEmpty",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   95,
											},
											File:   "universe.flux",
											Source: "window(every:every, createEmpty: createEmpty)",
											Start: ast.Position{
												Column: 12,
												Line:   95,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   95,
												},
												File:   "universe.flux",
												Source: "window",
												Start: ast.Position{
													Column: 12,
													Line:   95,
												},
											},
										},
										Name: "window",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)",
									Start: ast.Position{
										Column: 5,
										Line:   94,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "column:column",
											Start: ast.Position{
												Column: 15,
												Line:   96,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   96,
												},
												File:   "universe.flux",
												Source: "column:column",
												Start: ast.Position{
													Column: 15,
													Line:   96,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   96,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 15,
														Line:   96,
													},
												},
											},
											Name: "column",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   96,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 22,
														Line:   96,
													},
												},
											},
											Name: "column",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "fn(column:column)",
										Start: ast.Position{
											Column: 12,
											Line:   96,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   96,
											},
										},
									},
									Name: "fn",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)",
								Start: ast.Position{
									Column: 5,
									Line:   94,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "column:timeSrc,as:timeDst",
										Start: ast.Position{
											Column: 22,
											Line:   97,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   97,
											},
											File:   "universe.flux",
											Source: "column:timeSrc",
											Start: ast.Position{
												Column: 22,
												Line:   97,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   97,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 22,
													Line:   97,
												},
											},
										},
										Name: "column",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   97,
												},
												File:   "universe.flux",
												Source: "timeSrc",
												Start: ast.Position{
													Column: 29,
													Line:   97,
												},
											},
										},
										Name: "timeSrc",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   97,
											},
											File:   "universe.flux",
											Source: "as:timeDst",
											Start: ast.Position{
												Column: 37,
												Line:   97,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   97,
												},
												File:   "universe.flux",
												Source: "as",
												Start: ast.Position{
													Column: 37,
													Line:   97,
												},
											},
										},
										Name: "as",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   97,
												},
												File:   "universe.flux",
												Source: "timeDst",
												Start: ast.Position{
													Column: 40,
													Line:   97,
												},
											},
										},
										Name: "timeDst",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "duplicate(column:timeSrc,as:timeDst)",
									Start: ast.Position{
										Column: 12,
										Line:   97,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "duplicate",
										Start: ast.Position{
											Column: 12,
											Line:   97,
										},
									},
								},
								Name: "duplicate",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   98,
							},
							File:   "universe.flux",
							Source: "tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)",
							Start: ast.Position{
								Column: 5,
								Line:   94,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "every:inf, timeColumn:timeDst",
									Start: ast.Position{
										Column: 19,
										Line:   98,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "every:inf",
										Start: ast.Position{
											Column: 19,
											Line:   98,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "every",
											Start: ast.Position{
												Column: 19,
												Line:   98,
											},
										},
									},
									Name: "every",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "inf",
											Start: ast.Position{
												Column: 25,
												Line:   98,
											},
										},
									},
									Name: "inf",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "timeColumn:timeDst",
										Start: ast.Position{
											Column: 30,
											Line:   98,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 30,
												Line:   98,
											},
										},
									},
									Name: "timeColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "timeDst",
											Start: ast.Position{
												Column: 41,
												Line:   98,
											},
										},
									},
									Name: "timeDst",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "window(every:inf, timeColumn:timeDst)",
								Start: ast.Position{
									Column: 12,
									Line:   98,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "window",
									Start: ast.Position{
										Column: 12,
										Line:   98,
									},
								},
							},
							Name: "window",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "every",
							Start: ast.Position{
								Column: 20,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "every",
								Start: ast.Position{
									Column: 20,
									Line:   93,
								},
							},
						},
						Name: "every",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 27,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 27,
									Line:   93,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 31,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 31,
									Line:   93,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 38,
									Line:   93,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "timeSrc=\"_stop\"",
							Start: ast.Position{
								Column: 48,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "timeSrc",
								Start: ast.Position{
									Column: 48,
									Line:   93,
								},
							},
						},
						Name: "timeSrc",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "\"_stop\"",
								Start: ast.Position{
									Column: 56,
									Line:   93,
								},
							},
						},
						Value: "_stop",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 79,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "timeDst=\"_time\"",
							Start: ast.Position{
								Column: 64,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "timeDst",
								Start: ast.Position{
									Column: 64,
									Line:   93,
								},
							},
						},
						Name: "timeDst",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 72,
									Line:   93,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "createEmpty=true",
							Start: ast.Position{
								Column: 81,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 81,
									Line:   93,
								},
							},
						},
						Name: "createEmpty",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "true",
								Start: ast.Position{
									Column: 93,
									Line:   93,
								},
							},
						},
						Name: "true",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 99,
								Line:   93,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 99,
									Line:   93,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 106,
								Line:   93,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   107,
					},
					File:   "universe.flux",
					Source: "increase = (tables=<-, columns=[\"_value\"]) =>\n    tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)",
					Start: ast.Position{
						Column: 1,
						Line:   104,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   104,
						},
						File:   "universe.flux",
						Source: "increase",
						Start: ast.Position{
							Column: 1,
							Line:   104,
						},
					},
				},
				Name: "increase",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   107,
						},
						File:   "universe.flux",
						Source: "(tables=<-, columns=[\"_value\"]) =>\n    tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)",
						Start: ast.Position{
							Column: 12,
							Line:   104,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   105,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "tables\n        |> difference(nonNegative: true, columns:columns)",
								Start: ast.Position{
									Column: 5,
									Line:   105,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "nonNegative: true, columns:columns",
										Start: ast.Position{
											Column: 23,
											Line:   106,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   106,
											},
											File:   "universe.flux",
											Source: "nonNegative: true",
											Start: ast.Position{
												Column: 23,
												Line:   106,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   106,
												},
												File:   "universe.flux",
												Source: "nonNegative",
												Start: ast.Position{
													Column: 23,
													Line:   106,
												},
											},
										},
										Name: "nonNegative",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   106,
												},
												File:   "universe.flux",
												Source: "true",
												Start: ast.Position{
													Column: 36,
													Line:   106,
												},
											},
										},
										Name: "true",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   106,
											},
											File:   "universe.flux",
											Source: "columns:columns",
											Start: ast.Position{
												Column: 42,
												Line:   106,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   106,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 42,
													Line:   106,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   106,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 50,
													Line:   106,
												},
											},
										},
										Name: "columns",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "difference(nonNegative: true, columns:columns)",
									Start: ast.Position{
										Column: 12,
										Line:   106,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "difference",
										Start: ast.Position{
											Column: 12,
											Line:   106,
										},
									},
								},
								Name: "difference",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   107,
							},
							File:   "universe.flux",
							Source: "tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)",
							Start: ast.Position{
								Column: 5,
								Line:   105,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   107,
									},
									File:   "universe.flux",
									Source: "columns: columns",
									Start: ast.Position{
										Column: 26,
										Line:   107,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   107,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 26,
											Line:   107,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   107,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 26,
												Line:   107,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   107,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 35,
												Line:   107,
											},
										},
									},
									Name: "columns",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   107,
								},
								File:   "universe.flux",
								Source: "cumulativeSum(columns: columns)",
								Start: ast.Position{
									Column: 12,
									Line:   107,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   107,
									},
									File:   "universe.flux",
									Source: "cumulativeSum",
									Start: ast.Position{
										Column: 12,
										Line:   107,
									},
								},
							},
							Name: "cumulativeSum",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   104,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   104,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   104,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   104,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   104,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   104,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   104,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   104,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   104,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   104,
									},
								},
							},
							Value: "_value",
						}},
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   112,
					},
					File:   "universe.flux",
					Source: "median = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) =>\n    tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)",
					Start: ast.Position{
						Column: 1,
						Line:   110,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   110,
						},
						File:   "universe.flux",
						Source: "median",
						Start: ast.Position{
							Column: 1,
							Line:   110,
						},
					},
				},
				Name: "median",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   112,
						},
						File:   "universe.flux",
						Source: "(method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) =>\n    tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)",
						Start: ast.Position{
							Column: 10,
							Line:   110,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   111,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   112,
							},
							File:   "universe.flux",
							Source: "tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)",
							Start: ast.Position{
								Column: 5,
								Line:   111,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   112,
									},
									File:   "universe.flux",
									Source: "q:0.5, method: method, compression: compression, column: column",
									Start: ast.Position{
										Column: 21,
										Line:   112,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   112,
										},
										File:   "universe.flux",
										Source: "q:0.5",
										Start: ast.Position{
											Column: 21,
											Line:   112,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "q",
											Start: ast.Position{
												Column: 21,
												Line:   112,
											},
										},
									},
									Name: "q",
								},
								Value: &ast.FloatLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "0.5",
											Start: ast.Position{
												Column: 23,
												Line:   112,
											},
										},
									},
									Value: 0.5,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   112,
										},
										File:   "universe.flux",
										Source: "method: method",
										Start: ast.Position{
											Column: 28,
											Line:   112,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 28,
												Line:   112,
											},
										},
									},
									Name: "method",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 36,
												Line:   112,
											},
										},
									},
									Name: "method",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   112,
										},
										File:   "universe.flux",
										Source: "compression: compression",
										Start: ast.Position{
											Column: 44,
											Line:   112,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 44,
												Line:   112,
											},
										},
									},
									Name: "compression",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 57,
												Line:   112,
											},
										},
									},
									Name: "compression",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   112,
										},
										File:   "universe.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 70,
											Line:   112,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 70,
												Line:   112,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 78,
												Line:   112,
											},
										},
									},
									Name: "column",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   112,
								},
								File:   "universe.flux",
								Source: "quantile(q:0.5, method: method, compression: compression, column: column)",
								Start: ast.Position{
									Column: 12,
									Line:   112,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   112,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 12,
										Line:   112,
									},
								},
							},
							Name: "quantile",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   110,
							},
							File:   "universe.flux",
							Source: "method=\"estimate_tdigest\"",
							Start: ast.Position{
								Column: 11,
								Line:   110,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "method",
								Start: ast.Position{
									Column: 11,
									Line:   110,
								},
							},
						},
						Name: "method",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "\"estimate_tdigest\"",
								Start: ast.Position{
									Column: 18,
									Line:   110,
								},
							},
						},
						Value: "estimate_tdigest",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   110,
							},
							File:   "universe.flux",
							Source: "compression=0.0",
							Start: ast.Position{
								Column: 38,
								Line:   110,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "compression",
								Start: ast.Position{
									Column: 38,
									Line:   110,
								},
							},
						},
						Name: "compression",
					},
					Value: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 50,
									Line:   110,
								},
							},
						},
						Value: 0.0,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   110,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 55,
								Line:   110,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 55,
									Line:   110,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 62,
									Line:   110,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   110,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 72,
								Line:   110,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 72,
									Line:   110,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   110,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 79,
								Line:   110,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 52,
						Line:   125,
					},
					File:   "universe.flux",
					Source: "stateCount = (fn, column=\"stateCount\", tables=<-) =>\n    tables\n        |> stateTracking(countColumn:column, fn:fn)",
					Start: ast.Position{
						Column: 1,
						Line:   123,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "stateCount",
						Start: ast.Position{
							Column: 1,
							Line:   123,
						},
					},
				},
				Name: "stateCount",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 52,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateCount\", tables=<-) =>\n    tables\n        |> stateTracking(countColumn:column, fn:fn)",
						Start: ast.Position{
							Column: 14,
							Line:   123,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   124,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 52,
								Line:   125,
							},
							File:   "universe.flux",
							Source: "tables\n        |> stateTracking(countColumn:column, fn:fn)",
							Start: ast.Position{
								Column: 5,
								Line:   124,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "countColumn:column, fn:fn",
									Start: ast.Position{
										Column: 26,
										Line:   125,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "countColumn:column",
										Start: ast.Position{
											Column: 26,
											Line:   125,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "countColumn",
											Start: ast.Position{
												Column: 26,
												Line:   125,
											},
										},
									},
									Name: "countColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   125,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "fn:fn",
										Start: ast.Position{
											Column: 46,
											Line:   125,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 46,
												Line:   125,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 49,
												Line:   125,
											},
										},
									},
									Name: "fn",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "stateTracking(countColumn:column, fn:fn)",
								Start: ast.Position{
									Column: 12,
									Line:   125,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 12,
										Line:   125,
									},
								},
							},
							Name: "stateTracking",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 15,
								Line:   123,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 15,
									Line:   123,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "column=\"stateCount\"",
							Start: ast.Position{
								Column: 19,
								Line:   123,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 19,
									Line:   123,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "\"stateCount\"",
								Start: ast.Position{
									Column: 26,
									Line:   123,
								},
							},
						},
						Value: "stateCount",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 40,
								Line:   123,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 40,
									Line:   123,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 47,
								Line:   123,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 97,
						Line:   144,
					},
					File:   "universe.flux",
					Source: "stateDuration = (fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) =>\n    tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
					Start: ast.Position{
						Column: 1,
						Line:   142,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   142,
						},
						File:   "universe.flux",
						Source: "stateDuration",
						Start: ast.Position{
							Column: 1,
							Line:   142,
						},
					},
				},
				Name: "stateDuration",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   144,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) =>\n    tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
						Start: ast.Position{
							Column: 17,
							Line:   142,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   143,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   144,
							},
							File:   "universe.flux",
							Source: "tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
							Start: ast.Position{
								Column: 5,
								Line:   143,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit",
									Start: ast.Position{
										Column: 26,
										Line:   144,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "durationColumn:column",
										Start: ast.Position{
											Column: 26,
											Line:   144,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "durationColumn",
											Start: ast.Position{
												Column: 26,
												Line:   144,
											},
										},
									},
									Name: "durationColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 41,
												Line:   144,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "timeColumn:timeColumn",
										Start: ast.Position{
											Column: 49,
											Line:   144,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 49,
												Line:   144,
											},
										},
									},
									Name: "timeColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 60,
												Line:   144,
											},
										},
									},
									Name: "timeColumn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "fn:fn",
										Start: ast.Position{
											Column: 72,
											Line:   144,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 72,
												Line:   144,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 75,
												Line:   144,
											},
										},
									},
									Name: "fn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "durationUnit:unit",
										Start: ast.Position{
											Column: 79,
											Line:   144,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "durationUnit",
											Start: ast.Position{
												Column: 79,
												Line:   144,
											},
										},
									},
									Name: "durationUnit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "unit",
											Start: ast.Position{
												Column: 92,
												Line:   144,
											},
										},
									},
									Name: "unit",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
								Start: ast.Position{
									Column: 12,
									Line:   144,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 12,
										Line:   144,
									},
								},
							},
							Name: "stateTracking",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 18,
								Line:   142,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 18,
									Line:   142,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "column=\"stateDuration\"",
							Start: ast.Position{
								Column: 22,
								Line:   142,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   142,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "\"stateDuration\"",
								Start: ast.Position{
									Column: 29,
									Line:   142,
								},
							},
						},
						Value: "stateDuration",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "timeColumn=\"_time\"",
							Start: ast.Position{
								Column: 46,
								Line:   142,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "timeColumn",
								Start: ast.Position{
									Column: 46,
									Line:   142,
								},
							},
						},
						Name: "timeColumn",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 57,
									Line:   142,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "unit=1s",
							Start: ast.Position{
								Column: 66,
								Line:   142,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 66,
									Line:   142,
								},
							},
						},
						Name: "unit",
					},
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "1s",
								Start: ast.Position{
									Column: 71,
									Line:   142,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(1),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 75,
								Line:   142,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 75,
									Line:   142,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 82,
								Line:   142,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   150,
					},
					File:   "universe.flux",
					Source: "_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)",
					Start: ast.Position{
						Column: 1,
						Line:   147,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   147,
						},
						File:   "universe.flux",
						Source: "_sortLimit",
						Start: ast.Position{
							Column: 1,
							Line:   147,
						},
					},
				},
				Name: "_sortLimit",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   150,
						},
						File:   "universe.flux",
						Source: "(n, desc, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)",
						Start: ast.Position{
							Column: 14,
							Line:   147,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   148,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   148,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   149,
								},
								File:   "universe.flux",
								Source: "tables\n        |> sort(columns:columns, desc:desc)",
								Start: ast.Position{
									Column: 5,
									Line:   148,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   149,
										},
										File:   "universe.flux",
										Source: "columns:columns, desc:desc",
										Start: ast.Position{
											Column: 17,
											Line:   149,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   149,
											},
											File:   "universe.flux",
											Source: "columns:columns",
											Start: ast.Position{
												Column: 17,
												Line:   149,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   149,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   149,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   149,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 25,
													Line:   149,
												},
											},
										},
										Name: "columns",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   149,
											},
											File:   "universe.flux",
											Source: "desc:desc",
											Start: ast.Position{
												Column: 34,
												Line:   149,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   149,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 34,
													Line:   149,
												},
											},
										},
										Name: "desc",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   149,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 39,
													Line:   149,
												},
											},
										},
										Name: "desc",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   149,
									},
									File:   "universe.flux",
									Source: "sort(columns:columns, desc:desc)",
									Start: ast.Position{
										Column: 12,
										Line:   149,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   149,
										},
										File:   "universe.flux",
										Source: "sort",
										Start: ast.Position{
											Column: 12,
											Line:   149,
										},
									},
								},
								Name: "sort",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   150,
							},
							File:   "universe.flux",
							Source: "tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)",
							Start: ast.Position{
								Column: 5,
								Line:   148,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   150,
									},
									File:   "universe.flux",
									Source: "n:n",
									Start: ast.Position{
										Column: 18,
										Line:   150,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   150,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 18,
											Line:   150,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   150,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 18,
												Line:   150,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   150,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 20,
												Line:   150,
											},
										},
									},
									Name: "n",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   150,
								},
								File:   "universe.flux",
								Source: "limit(n:n)",
								Start: ast.Position{
									Column: 12,
									Line:   150,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   150,
									},
									File:   "universe.flux",
									Source: "limit",
									Start: ast.Position{
										Column: 12,
										Line:   150,
									},
								},
							},
							Name: "limit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   147,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   147,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "desc",
							Start: ast.Position{
								Column: 18,
								Line:   147,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "desc",
								Start: ast.Position{
									Column: 18,
									Line:   147,
								},
							},
						},
						Name: "desc",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   147,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   147,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   147,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   147,
									},
								},
							},
							Value: "_value",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 44,
								Line:   147,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 44,
									Line:   147,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   147,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 51,
								Line:   147,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 55,
						Line:   155,
					},
					File:   "universe.flux",
					Source: "top = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:true)",
					Start: ast.Position{
						Column: 1,
						Line:   153,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   153,
						},
						File:   "universe.flux",
						Source: "top",
						Start: ast.Position{
							Column: 1,
							Line:   153,
						},
					},
				},
				Name: "top",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   155,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:true)",
						Start: ast.Position{
							Column: 7,
							Line:   153,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   154,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   154,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   155,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _sortLimit(n:n, columns:columns, desc:true)",
							Start: ast.Position{
								Column: 5,
								Line:   154,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "n:n, columns:columns, desc:true",
									Start: ast.Position{
										Column: 23,
										Line:   155,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 23,
											Line:   155,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 23,
												Line:   155,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 25,
												Line:   155,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "columns:columns",
										Start: ast.Position{
											Column: 28,
											Line:   155,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 28,
												Line:   155,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 36,
												Line:   155,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   155,
										},
										File:   "universe.flux",
										Source: "desc:true",
										Start: ast.Position{
											Column: 45,
											Line:   155,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 45,
												Line:   155,
											},
										},
									},
									Name: "desc",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   155,
											},
											File:   "universe.flux",
											Source: "true",
											Start: ast.Position{
												Column: 50,
												Line:   155,
											},
										},
									},
									Name: "true",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n:n, columns:columns, desc:true)",
								Start: ast.Position{
									Column: 12,
									Line:   155,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   155,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 12,
										Line:   155,
									},
								},
							},
							Name: "_sortLimit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   153,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 8,
								Line:   153,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   153,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 8,
									Line:   153,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   153,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 11,
								Line:   153,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   153,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 11,
									Line:   153,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   153,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 19,
									Line:   153,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   153,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 20,
										Line:   153,
									},
								},
							},
							Value: "_value",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   153,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 31,
								Line:   153,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   153,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 31,
									Line:   153,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   153,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   153,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 56,
						Line:   160,
					},
					File:   "universe.flux",
					Source: "bottom = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:false)",
					Start: ast.Position{
						Column: 1,
						Line:   158,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   158,
						},
						File:   "universe.flux",
						Source: "bottom",
						Start: ast.Position{
							Column: 1,
							Line:   158,
						},
					},
				},
				Name: "bottom",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   160,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:false)",
						Start: ast.Position{
							Column: 10,
							Line:   158,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   159,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   159,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _sortLimit(n:n, columns:columns, desc:false)",
							Start: ast.Position{
								Column: 5,
								Line:   159,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   160,
									},
									File:   "universe.flux",
									Source: "n:n, columns:columns, desc:false",
									Start: ast.Position{
										Column: 23,
										Line:   160,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   160,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 23,
											Line:   160,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   160,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 23,
												Line:   160,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   160,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 25,
												Line:   160,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   160,
										},
										File:   "universe.flux",
										Source: "columns:columns",
										Start: ast.Position{
											Column: 28,
											Line:   160,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   160,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 28,
												Line:   160,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   160,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 36,
												Line:   160,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   160,
										},
										File:   "universe.flux",
										Source: "desc:false",
										Start: ast.Position{
											Column: 45,
											Line:   160,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   160,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 45,
												Line:   160,
											},
										},
									},
									Name: "desc",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   160,
											},
											File:   "universe.flux",
											Source: "false",
											Start: ast.Position{
												Column: 50,
												Line:   160,
											},
										},
									},
									Name: "false",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n:n, columns:columns, desc:false)",
								Start: ast.Position{
									Column: 12,
									Line:   160,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   160,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 12,
										Line:   160,
									},
								},
							},
							Name: "_sortLimit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 11,
								Line:   158,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 11,
									Line:   158,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 14,
								Line:   158,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 14,
									Line:   158,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 22,
									Line:   158,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 23,
										Line:   158,
									},
								},
							},
							Value: "_value",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 34,
								Line:   158,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 34,
									Line:   158,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   158,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   170,
					},
					File:   "universe.flux",
					Source: "_highestOrLowest = (n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])",
					Start: ast.Position{
						Column: 1,
						Line:   165,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "_highestOrLowest",
						Start: ast.Position{
							Column: 1,
							Line:   165,
						},
					},
				},
				Name: "_highestOrLowest",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   170,
						},
						File:   "universe.flux",
						Source: "(n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])",
						Start: ast.Position{
							Column: 20,
							Line:   165,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   166,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   166,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "tables\n        |> group(columns:groupColumns)",
										Start: ast.Position{
											Column: 5,
											Line:   166,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "columns:groupColumns",
												Start: ast.Position{
													Column: 18,
													Line:   167,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   167,
													},
													File:   "universe.flux",
													Source: "columns:groupColumns",
													Start: ast.Position{
														Column: 18,
														Line:   167,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   167,
														},
														File:   "universe.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 18,
															Line:   167,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   167,
														},
														File:   "universe.flux",
														Source: "groupColumns",
														Start: ast.Position{
															Column: 26,
															Line:   167,
														},
													},
												},
												Name: "groupColumns",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "group(columns:groupColumns)",
											Start: ast.Position{
												Column: 12,
												Line:   167,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "group",
												Start: ast.Position{
													Column: 12,
													Line:   167,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "tables\n        |> group(columns:groupColumns)\n        |> reducer()",
									Start: ast.Position{
										Column: 5,
										Line:   166,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "reducer()",
										Start: ast.Position{
											Column: 12,
											Line:   168,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 12,
												Line:   168,
											},
										},
									},
									Name: "reducer",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   169,
								},
								File:   "universe.flux",
								Source: "tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])",
								Start: ast.Position{
									Column: 5,
									Line:   166,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   169,
										},
										File:   "universe.flux",
										Source: "columns:[]",
										Start: ast.Position{
											Column: 18,
											Line:   169,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   169,
											},
											File:   "universe.flux",
											Source: "columns:[]",
											Start: ast.Position{
												Column: 18,
												Line:   169,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   169,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 18,
													Line:   169,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   169,
												},
												File:   "universe.flux",
												Source: "[]",
												Start: ast.Position{
													Column: 26,
													Line:   169,
												},
											},
										},
										Elements: nil,
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "group(columns:[])",
									Start: ast.Position{
										Column: 12,
										Line:   169,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   169,
										},
										File:   "universe.flux",
										Source: "group",
										Start: ast.Position{
											Column: 12,
											Line:   169,
										},
									},
								},
								Name: "group",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   170,
							},
							File:   "universe.flux",
							Source: "tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])",
							Start: ast.Position{
								Column: 5,
								Line:   166,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   170,
									},
									File:   "universe.flux",
									Source: "n:n, columns:[column]",
									Start: ast.Position{
										Column: 23,
										Line:   170,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   170,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 23,
											Line:   170,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   170,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 23,
												Line:   170,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   170,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 25,
												Line:   170,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   170,
										},
										File:   "universe.flux",
										Source: "columns:[column]",
										Start: ast.Position{
											Column: 28,
											Line:   170,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   170,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 28,
												Line:   170,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   170,
											},
											File:   "universe.flux",
											Source: "[column]",
											Start: ast.Position{
												Column: 36,
												Line:   170,
											},
										},
									},
									Elements: []ast.Expression{&ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   170,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 37,
													Line:   170,
												},
											},
										},
										Name: "column",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   170,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n:n, columns:[column])",
								Start: ast.Position{
									Column: 12,
									Line:   170,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   170,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 12,
										Line:   170,
									},
								},
							},
							Name: "_sortLimit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 21,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 21,
									Line:   165,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "_sortLimit",
							Start: ast.Position{
								Column: 24,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "_sortLimit",
								Start: ast.Position{
									Column: 24,
									Line:   165,
								},
							},
						},
						Name: "_sortLimit",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "reducer",
							Start: ast.Position{
								Column: 36,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "reducer",
								Start: ast.Position{
									Column: 36,
									Line:   165,
								},
							},
						},
						Name: "reducer",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 45,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 45,
									Line:   165,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 52,
									Line:   165,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 62,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 62,
									Line:   165,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 75,
									Line:   165,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 79,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 79,
									Line:   165,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 86,
								Line:   165,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   182,
					},
					File:   "universe.flux",
					Source: "highestMax = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   173,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   173,
						},
						File:   "universe.flux",
						Source: "highestMax",
						Start: ast.Position{
							Column: 1,
							Line:   173,
						},
					},
				},
				Name: "highestMax",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   182,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
						Start: ast.Position{
							Column: 14,
							Line:   173,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   174,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   174,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   182,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   174,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   181,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top",
									Start: ast.Position{
										Column: 17,
										Line:   176,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   176,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   176,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   176,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   176,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   176,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   176,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   177,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   177,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   177,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   177,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   177,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   177,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   178,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   178,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   178,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   180,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> max(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   180,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   180,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   180,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   180,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> max(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   180,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   180,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   180,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   180,
												},
												File:   "universe.flux",
												Source: "tables |> max(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   180,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   180,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 55,
															Line:   180,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   180,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 55,
																Line:   180,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   180,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 55,
																	Line:   180,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   180,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 62,
																	Line:   180,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   180,
													},
													File:   "universe.flux",
													Source: "max(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   180,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   180,
														},
														File:   "universe.flux",
														Source: "max",
														Start: ast.Position{
															Column: 51,
															Line:   180,
														},
													},
												},
												Name: "max",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   180,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   180,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   180,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   180,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   180,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   180,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   181,
										},
										File:   "universe.flux",
										Source: "_sortLimit: top",
										Start: ast.Position{
											Column: 17,
											Line:   181,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   181,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   181,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   181,
											},
											File:   "universe.flux",
											Source: "top",
											Start: ast.Position{
												Column: 29,
												Line:   181,
											},
										},
									},
									Name: "top",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   182,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   175,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   175,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   173,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   173,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 18,
								Line:   173,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 18,
									Line:   173,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 25,
									Line:   173,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 35,
								Line:   173,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 35,
									Line:   173,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 48,
									Line:   173,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 52,
								Line:   173,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 52,
									Line:   173,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 59,
								Line:   173,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   193,
					},
					File:   "universe.flux",
					Source: "highestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   185,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   185,
						},
						File:   "universe.flux",
						Source: "highestAverage",
						Start: ast.Position{
							Column: 1,
							Line:   185,
						},
					},
				},
				Name: "highestAverage",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   193,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
						Start: ast.Position{
							Column: 18,
							Line:   185,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   186,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   186,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   193,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   186,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   192,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top",
									Start: ast.Position{
										Column: 17,
										Line:   188,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   188,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   188,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   188,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   188,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   189,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   189,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   189,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   189,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   189,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   189,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   190,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   190,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   190,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   190,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   190,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   190,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   191,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> mean(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   191,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   191,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   191,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   191,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> mean(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   191,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   191,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   191,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "tables |> mean(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   191,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   191,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   191,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   191,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   191,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   191,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   191,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   191,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   191,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   191,
													},
													File:   "universe.flux",
													Source: "mean(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   191,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   191,
														},
														File:   "universe.flux",
														Source: "mean",
														Start: ast.Position{
															Column: 51,
															Line:   191,
														},
													},
												},
												Name: "mean",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   191,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   191,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   191,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   191,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   192,
										},
										File:   "universe.flux",
										Source: "_sortLimit: top",
										Start: ast.Position{
											Column: 17,
											Line:   192,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   192,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   192,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   192,
											},
											File:   "universe.flux",
											Source: "top",
											Start: ast.Position{
												Column: 29,
												Line:   192,
											},
										},
									},
									Name: "top",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   193,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   187,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   187,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   185,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 19,
								Line:   185,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 19,
									Line:   185,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   185,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 22,
								Line:   185,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   185,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 29,
									Line:   185,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   185,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 39,
								Line:   185,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 39,
									Line:   185,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 52,
									Line:   185,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   185,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 56,
								Line:   185,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   185,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 56,
									Line:   185,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   185,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 63,
								Line:   185,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   204,
					},
					File:   "universe.flux",
					Source: "highestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   196,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   196,
						},
						File:   "universe.flux",
						Source: "highestCurrent",
						Start: ast.Position{
							Column: 1,
							Line:   196,
						},
					},
				},
				Name: "highestCurrent",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   204,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
						Start: ast.Position{
							Column: 18,
							Line:   196,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   197,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   197,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   204,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   197,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   203,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top",
									Start: ast.Position{
										Column: 17,
										Line:   199,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   199,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   199,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   199,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   199,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   200,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   200,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   200,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   200,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   200,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   201,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   201,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   201,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   201,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   201,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   201,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   202,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> last(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   202,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   202,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   202,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   202,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> last(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   202,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   202,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   202,
												},
												File:   "universe.flux",
												Source: "tables |> last(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   202,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   202,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   202,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   202,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   202,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   202,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   202,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   202,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   202,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "last(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   202,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   202,
														},
														File:   "universe.flux",
														Source: "last",
														Start: ast.Position{
															Column: 51,
															Line:   202,
														},
													},
												},
												Name: "last",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   202,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   202,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   202,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   202,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   202,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   202,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   203,
										},
										File:   "universe.flux",
										Source: "_sortLimit: top",
										Start: ast.Position{
											Column: 17,
											Line:   203,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   203,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   203,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   203,
											},
											File:   "universe.flux",
											Source: "top",
											Start: ast.Position{
												Column: 29,
												Line:   203,
											},
										},
									},
									Name: "top",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   204,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   198,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   198,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   198,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 19,
								Line:   196,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 19,
									Line:   196,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 22,
								Line:   196,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   196,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 29,
									Line:   196,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 39,
								Line:   196,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 39,
									Line:   196,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 52,
									Line:   196,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 56,
								Line:   196,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   196,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 56,
									Line:   196,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   196,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 63,
								Line:   196,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   216,
					},
					File:   "universe.flux",
					Source: "lowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   207,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   207,
						},
						File:   "universe.flux",
						Source: "lowestMin",
						Start: ast.Position{
							Column: 1,
							Line:   207,
						},
					},
				},
				Name: "lowestMin",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   216,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
						Start: ast.Position{
							Column: 13,
							Line:   207,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   208,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   208,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   216,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   208,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   215,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom",
									Start: ast.Position{
										Column: 17,
										Line:   210,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   210,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   210,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   210,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   210,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   210,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   210,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   211,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   211,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   211,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   211,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   211,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   211,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   212,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   212,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   212,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   212,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   212,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   212,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   214,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> min(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   214,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   214,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   214,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   214,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> min(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   214,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   214,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   214,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   214,
												},
												File:   "universe.flux",
												Source: "tables |> min(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   214,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   214,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 55,
															Line:   214,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   214,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 55,
																Line:   214,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   214,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 55,
																	Line:   214,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   214,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 62,
																	Line:   214,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   214,
													},
													File:   "universe.flux",
													Source: "min(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   214,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   214,
														},
														File:   "universe.flux",
														Source: "min",
														Start: ast.Position{
															Column: 51,
															Line:   214,
														},
													},
												},
												Name: "min",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   214,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   214,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   214,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   214,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   214,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   214,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   215,
										},
										File:   "universe.flux",
										Source: "_sortLimit: bottom",
										Start: ast.Position{
											Column: 17,
											Line:   215,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   215,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   215,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   215,
											},
											File:   "universe.flux",
											Source: "bottom",
											Start: ast.Position{
												Column: 29,
												Line:   215,
											},
										},
									},
									Name: "bottom",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   216,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   209,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   209,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   209,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   207,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 14,
								Line:   207,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   207,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 14,
									Line:   207,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   207,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 17,
								Line:   207,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   207,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 17,
									Line:   207,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   207,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 24,
									Line:   207,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   207,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 34,
								Line:   207,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   207,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 34,
									Line:   207,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   207,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 47,
									Line:   207,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   207,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 51,
								Line:   207,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   207,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 51,
									Line:   207,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   207,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 58,
								Line:   207,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   227,
					},
					File:   "universe.flux",
					Source: "lowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   219,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   219,
						},
						File:   "universe.flux",
						Source: "lowestAverage",
						Start: ast.Position{
							Column: 1,
							Line:   219,
						},
					},
				},
				Name: "lowestAverage",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   227,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
						Start: ast.Position{
							Column: 17,
							Line:   219,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   220,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   220,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   227,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   220,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   226,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom",
									Start: ast.Position{
										Column: 17,
										Line:   222,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   222,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   222,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   222,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   222,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   222,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   222,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   223,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   223,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   223,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   223,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   223,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   223,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   224,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   224,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   224,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   224,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   225,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> mean(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   225,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   225,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   225,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   225,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> mean(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   225,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   225,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   225,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   225,
												},
												File:   "universe.flux",
												Source: "tables |> mean(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   225,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   225,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   225,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   225,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   225,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   225,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   225,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   225,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   225,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   225,
													},
													File:   "universe.flux",
													Source: "mean(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   225,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   225,
														},
														File:   "universe.flux",
														Source: "mean",
														Start: ast.Position{
															Column: 51,
															Line:   225,
														},
													},
												},
												Name: "mean",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   225,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   225,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   225,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   225,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   225,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   225,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   226,
										},
										File:   "universe.flux",
										Source: "_sortLimit: bottom",
										Start: ast.Position{
											Column: 17,
											Line:   226,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   226,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   226,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   226,
											},
											File:   "universe.flux",
											Source: "bottom",
											Start: ast.Position{
												Column: 29,
												Line:   226,
											},
										},
									},
									Name: "bottom",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   227,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   221,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   221,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   221,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 18,
								Line:   219,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 18,
									Line:   219,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 21,
								Line:   219,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 21,
									Line:   219,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 28,
									Line:   219,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 38,
								Line:   219,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 38,
									Line:   219,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 51,
									Line:   219,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 55,
								Line:   219,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 55,
									Line:   219,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 62,
								Line:   219,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   238,
					},
					File:   "universe.flux",
					Source: "lowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   230,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   230,
						},
						File:   "universe.flux",
						Source: "lowestCurrent",
						Start: ast.Position{
							Column: 1,
							Line:   230,
						},
					},
				},
				Name: "lowestCurrent",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   238,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
						Start: ast.Position{
							Column: 17,
							Line:   230,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   231,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   231,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   238,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   231,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   237,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom",
									Start: ast.Position{
										Column: 17,
										Line:   233,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   233,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   233,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   233,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   233,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   233,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   233,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   234,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   234,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   234,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   234,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   234,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   234,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   235,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   235,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   235,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   235,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   235,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   235,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   236,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> last(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   236,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   236,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   236,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> last(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   236,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   236,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   236,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   236,
												},
												File:   "universe.flux",
												Source: "tables |> last(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   236,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   236,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   236,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   236,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   236,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   236,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   236,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   236,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   236,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   236,
													},
													File:   "universe.flux",
													Source: "last(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   236,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   236,
														},
														File:   "universe.flux",
														Source: "last",
														Start: ast.Position{
															Column: 51,
															Line:   236,
														},
													},
												},
												Name: "last",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   236,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   236,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   236,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   236,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   236,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   236,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   237,
										},
										File:   "universe.flux",
										Source: "_sortLimit: bottom",
										Start: ast.Position{
											Column: 17,
											Line:   237,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   237,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "bottom",
											Start: ast.Position{
												Column: 29,
												Line:   237,
											},
										},
									},
									Name: "bottom",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   238,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   232,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   232,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   232,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 18,
								Line:   230,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 18,
									Line:   230,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 21,
								Line:   230,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 21,
									Line:   230,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 28,
									Line:   230,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 38,
								Line:   230,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 38,
									Line:   230,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 51,
									Line:   230,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 55,
								Line:   230,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   230,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 55,
									Line:   230,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   230,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 62,
								Line:   230,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   240,
					},
					File:   "universe.flux",
					Source: "toString = (tables=<-) => tables |> map(fn:(r) => string(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   240,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   240,
						},
						File:   "universe.flux",
						Source: "toString",
						Start: ast.Position{
							Column: 1,
							Line:   240,
						},
					},
				},
				Name: "toString",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   240,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => string(v:r._value))",
						Start: ast.Position{
							Column: 12,
							Line:   240,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   240,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 27,
									Line:   240,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   240,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => string(v:r._value))",
							Start: ast.Position{
								Column: 27,
								Line:   240,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   240,
									},
									File:   "universe.flux",
									Source: "fn:(r) => string(v:r._value)",
									Start: ast.Position{
										Column: 41,
										Line:   240,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   240,
										},
										File:   "universe.flux",
										Source: "fn:(r) => string(v:r._value)",
										Start: ast.Position{
											Column: 41,
											Line:   240,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   240,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 41,
												Line:   240,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   240,
											},
											File:   "universe.flux",
											Source: "(r) => string(v:r._value)",
											Start: ast.Position{
												Column: 44,
												Line:   240,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   240,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 58,
														Line:   240,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   240,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 58,
															Line:   240,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   240,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 58,
																Line:   240,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   240,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 60,
																Line:   240,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   240,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 60,
																	Line:   240,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   240,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 62,
																	Line:   240,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   240,
												},
												File:   "universe.flux",
												Source: "string(v:r._value)",
												Start: ast.Position{
													Column: 51,
													Line:   240,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   240,
													},
													File:   "universe.flux",
													Source: "string",
													Start: ast.Position{
														Column: 51,
														Line:   240,
													},
												},
											},
											Name: "string",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   240,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 45,
													Line:   240,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   240,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 45,
														Line:   240,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   240,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => string(v:r._value))",
								Start: ast.Position{
									Column: 37,
									Line:   240,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   240,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 37,
										Line:   240,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   240,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   240,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   240,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   240,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   240,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   240,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 64,
						Line:   241,
					},
					File:   "universe.flux",
					Source: "toInt = (tables=<-) => tables |> map(fn:(r) => int(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   241,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   241,
						},
						File:   "universe.flux",
						Source: "toInt",
						Start: ast.Position{
							Column: 1,
							Line:   241,
						},
					},
				},
				Name: "toInt",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 64,
							Line:   241,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => int(v:r._value))",
						Start: ast.Position{
							Column: 9,
							Line:   241,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   241,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 24,
									Line:   241,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   241,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => int(v:r._value))",
							Start: ast.Position{
								Column: 24,
								Line:   241,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   241,
									},
									File:   "universe.flux",
									Source: "fn:(r) => int(v:r._value)",
									Start: ast.Position{
										Column: 38,
										Line:   241,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   241,
										},
										File:   "universe.flux",
										Source: "fn:(r) => int(v:r._value)",
										Start: ast.Position{
											Column: 38,
											Line:   241,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   241,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 38,
												Line:   241,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   241,
											},
											File:   "universe.flux",
											Source: "(r) => int(v:r._value)",
											Start: ast.Position{
												Column: 41,
												Line:   241,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   241,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 52,
														Line:   241,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   241,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 52,
															Line:   241,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   241,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 52,
																Line:   241,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   241,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 54,
																Line:   241,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   241,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 54,
																	Line:   241,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   241,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 56,
																	Line:   241,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   241,
												},
												File:   "universe.flux",
												Source: "int(v:r._value)",
												Start: ast.Position{
													Column: 48,
													Line:   241,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   241,
													},
													File:   "universe.flux",
													Source: "int",
													Start: ast.Position{
														Column: 48,
														Line:   241,
													},
												},
											},
											Name: "int",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   241,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 42,
													Line:   241,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   241,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 42,
														Line:   241,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   241,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => int(v:r._value))",
								Start: ast.Position{
									Column: 34,
									Line:   241,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   241,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 34,
										Line:   241,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   241,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 10,
								Line:   241,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   241,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 10,
									Line:   241,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   241,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   241,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   242,
					},
					File:   "universe.flux",
					Source: "toUInt = (tables=<-) => tables |> map(fn:(r) => uint(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   242,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   242,
						},
						File:   "universe.flux",
						Source: "toUInt",
						Start: ast.Position{
							Column: 1,
							Line:   242,
						},
					},
				},
				Name: "toUInt",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   242,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => uint(v:r._value))",
						Start: ast.Position{
							Column: 10,
							Line:   242,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   242,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 25,
									Line:   242,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   242,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => uint(v:r._value))",
							Start: ast.Position{
								Column: 25,
								Line:   242,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   242,
									},
									File:   "universe.flux",
									Source: "fn:(r) => uint(v:r._value)",
									Start: ast.Position{
										Column: 39,
										Line:   242,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   242,
										},
										File:   "universe.flux",
										Source: "fn:(r) => uint(v:r._value)",
										Start: ast.Position{
											Column: 39,
											Line:   242,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   242,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 39,
												Line:   242,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   242,
											},
											File:   "universe.flux",
											Source: "(r) => uint(v:r._value)",
											Start: ast.Position{
												Column: 42,
												Line:   242,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   242,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 54,
														Line:   242,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   242,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 54,
															Line:   242,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   242,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 54,
																Line:   242,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   242,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 56,
																Line:   242,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   242,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 56,
																	Line:   242,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   242,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 58,
																	Line:   242,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   242,
												},
												File:   "universe.flux",
												Source: "uint(v:r._value)",
												Start: ast.Position{
													Column: 49,
													Line:   242,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   242,
													},
													File:   "universe.flux",
													Source: "uint",
													Start: ast.Position{
														Column: 49,
														Line:   242,
													},
												},
											},
											Name: "uint",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   242,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 43,
													Line:   242,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   242,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 43,
														Line:   242,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   242,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => uint(v:r._value))",
								Start: ast.Position{
									Column: 35,
									Line:   242,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   242,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 35,
										Line:   242,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   242,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   242,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   242,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   242,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   242,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   242,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   243,
					},
					File:   "universe.flux",
					Source: "toFloat = (tables=<-) => tables |> map(fn:(r) => float(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   243,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   243,
						},
						File:   "universe.flux",
						Source: "toFloat",
						Start: ast.Position{
							Column: 1,
							Line:   243,
						},
					},
				},
				Name: "toFloat",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   243,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => float(v:r._value))",
						Start: ast.Position{
							Column: 11,
							Line:   243,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   243,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 26,
									Line:   243,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   243,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => float(v:r._value))",
							Start: ast.Position{
								Column: 26,
								Line:   243,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   243,
									},
									File:   "universe.flux",
									Source: "fn:(r) => float(v:r._value)",
									Start: ast.Position{
										Column: 40,
										Line:   243,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   243,
										},
										File:   "universe.flux",
										Source: "fn:(r) => float(v:r._value)",
										Start: ast.Position{
											Column: 40,
											Line:   243,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   243,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 40,
												Line:   243,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   243,
											},
											File:   "universe.flux",
											Source: "(r) => float(v:r._value)",
											Start: ast.Position{
												Column: 43,
												Line:   243,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   243,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 56,
														Line:   243,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   243,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 56,
															Line:   243,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   243,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 56,
																Line:   243,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   243,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 58,
																Line:   243,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   243,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 58,
																	Line:   243,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   243,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 60,
																	Line:   243,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   243,
												},
												File:   "universe.flux",
												Source: "float(v:r._value)",
												Start: ast.Position{
													Column: 50,
													Line:   243,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   243,
													},
													File:   "universe.flux",
													Source: "float",
													Start: ast.Position{
														Column: 50,
														Line:   243,
													},
												},
											},
											Name: "float",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   243,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 44,
													Line:   243,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   243,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 44,
														Line:   243,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   243,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => float(v:r._value))",
								Start: ast.Position{
									Column: 36,
									Line:   243,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   243,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 36,
										Line:   243,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   243,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 12,
								Line:   243,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   243,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 12,
									Line:   243,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   243,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 19,
								Line:   243,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   244,
					},
					File:   "universe.flux",
					Source: "toBool = (tables=<-) => tables |> map(fn:(r) => bool(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   244,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   244,
						},
						File:   "universe.flux",
						Source: "toBool",
						Start: ast.Position{
							Column: 1,
							Line:   244,
						},
					},
				},
				Name: "toBool",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   244,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => bool(v:r._value))",
						Start: ast.Position{
							Column: 10,
							Line:   244,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   244,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 25,
									Line:   244,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   244,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => bool(v:r._value))",
							Start: ast.Position{
								Column: 25,
								Line:   244,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   244,
									},
									File:   "universe.flux",
									Source: "fn:(r) => bool(v:r._value)",
									Start: ast.Position{
										Column: 39,
										Line:   244,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   244,
										},
										File:   "universe.flux",
										Source: "fn:(r) => bool(v:r._value)",
										Start: ast.Position{
											Column: 39,
											Line:   244,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   244,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 39,
												Line:   244,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   244,
											},
											File:   "universe.flux",
											Source: "(r) => bool(v:r._value)",
											Start: ast.Position{
												Column: 42,
												Line:   244,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   244,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 54,
														Line:   244,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   244,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 54,
															Line:   244,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   244,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 54,
																Line:   244,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   244,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 56,
																Line:   244,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   244,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 56,
																	Line:   244,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   244,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 58,
																	Line:   244,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   244,
												},
												File:   "universe.flux",
												Source: "bool(v:r._value)",
												Start: ast.Position{
													Column: 49,
													Line:   244,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   244,
													},
													File:   "universe.flux",
													Source: "bool",
													Start: ast.Position{
														Column: 49,
														Line:   244,
													},
												},
											},
											Name: "bool",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   244,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 43,
													Line:   244,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   244,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 43,
														Line:   244,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   244,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => bool(v:r._value))",
								Start: ast.Position{
									Column: 35,
									Line:   244,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   244,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 35,
										Line:   244,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   244,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   244,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   244,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   244,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   244,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   244,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   245,
					},
					File:   "universe.flux",
					Source: "toTime = (tables=<-) => tables |> map(fn:(r) => time(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   245,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   245,
						},
						File:   "universe.flux",
						Source: "toTime",
						Start: ast.Position{
							Column: 1,
							Line:   245,
						},
					},
				},
				Name: "toTime",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   245,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => time(v:r._value))",
						Start: ast.Position{
							Column: 10,
							Line:   245,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   245,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 25,
									Line:   245,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   245,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => time(v:r._value))",
							Start: ast.Position{
								Column: 25,
								Line:   245,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   245,
									},
									File:   "universe.flux",
									Source: "fn:(r) => time(v:r._value)",
									Start: ast.Position{
										Column: 39,
										Line:   245,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   245,
										},
										File:   "universe.flux",
										Source: "fn:(r) => time(v:r._value)",
										Start: ast.Position{
											Column: 39,
											Line:   245,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   245,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 39,
												Line:   245,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   245,
											},
											File:   "universe.flux",
											Source: "(r) => time(v:r._value)",
											Start: ast.Position{
												Column: 42,
												Line:   245,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   245,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 54,
														Line:   245,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   245,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 54,
															Line:   245,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   245,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 54,
																Line:   245,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   245,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 56,
																Line:   245,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   245,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 56,
																	Line:   245,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   245,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 58,
																	Line:   245,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   245,
												},
												File:   "universe.flux",
												Source: "time(v:r._value)",
												Start: ast.Position{
													Column: 49,
													Line:   245,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   245,
													},
													File:   "universe.flux",
													Source: "time",
													Start: ast.Position{
														Column: 49,
														Line:   245,
													},
												},
											},
											Name: "time",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   245,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 43,
													Line:   245,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   245,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 43,
														Line:   245,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   245,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => time(v:r._value))",
								Start: ast.Position{
									Column: 35,
									Line:   245,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   245,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 35,
										Line:   245,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   245,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   245,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   245,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   245,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   245,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   245,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 74,
						Line:   246,
					},
					File:   "universe.flux",
					Source: "toDuration = (tables=<-) => tables |> map(fn:(r) => duration(v:r._value))",
					Start: ast.Position{
						Column: 1,
						Line:   246,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   246,
						},
						File:   "universe.flux",
						Source: "toDuration",
						Start: ast.Position{
							Column: 1,
							Line:   246,
						},
					},
				},
				Name: "toDuration",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 74,
							Line:   246,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => duration(v:r._value))",
						Start: ast.Position{
							Column: 14,
							Line:   246,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   246,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   246,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   246,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => duration(v:r._value))",
							Start: ast.Position{
								Column: 29,
								Line:   246,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   246,
									},
									File:   "universe.flux",
									Source: "fn:(r) => duration(v:r._value)",
									Start: ast.Position{
										Column: 43,
										Line:   246,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   246,
										},
										File:   "universe.flux",
										Source: "fn:(r) => duration(v:r._value)",
										Start: ast.Position{
											Column: 43,
											Line:   246,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   246,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   246,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   246,
											},
											File:   "universe.flux",
											Source: "(r) => duration(v:r._value)",
											Start: ast.Position{
												Column: 46,
												Line:   246,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   246,
													},
													File:   "universe.flux",
													Source: "v:r._value",
													Start: ast.Position{
														Column: 62,
														Line:   246,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   246,
														},
														File:   "universe.flux",
														Source: "v:r._value",
														Start: ast.Position{
															Column: 62,
															Line:   246,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   246,
															},
															File:   "universe.flux",
															Source: "v",
															Start: ast.Position{
																Column: 62,
																Line:   246,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   246,
															},
															File:   "universe.flux",
															Source: "r._value",
															Start: ast.Position{
																Column: 64,
																Line:   246,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   246,
																},
																File:   "universe.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 64,
																	Line:   246,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   246,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 66,
																	Line:   246,
																},
															},
														},
														Name: "_value",
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   246,
												},
												File:   "universe.flux",
												Source: "duration(v:r._value)",
												Start: ast.Position{
													Column: 53,
													Line:   246,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   246,
													},
													File:   "universe.flux",
													Source: "duration",
													Start: ast.Position{
														Column: 53,
														Line:   246,
													},
												},
											},
											Name: "duration",
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   246,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   246,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   246,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   246,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   246,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => duration(v:r._value))",
								Start: ast.Position{
									Column: 39,
									Line:   246,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   246,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   246,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   246,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   246,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   246,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   246,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   246,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   246,
							},
						},
					}},
				}},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   3,
					},
					File:   "universe.flux",
					Source: "import \"system\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   3,
						},
						File:   "universe.flux",
						Source: "\"system\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "system",
			},
		}},
		Name: "universe.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "universe.flux",
					Source: "package universe",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "universe.flux",
						Source: "universe",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe",
			},
		},
	}},
	Package: "universe",
	Path:    "universe",
}
