package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomLines invokes the alidns.DeleteCustomLines API synchronously
// api document: https://help.aliyun.com/api/alidns/deletecustomlines.html
func (client *Client) DeleteCustomLines(request *DeleteCustomLinesRequest) (response *DeleteCustomLinesResponse, err error) {
	response = CreateDeleteCustomLinesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomLinesWithChan invokes the alidns.DeleteCustomLines API asynchronously
// api document: https://help.aliyun.com/api/alidns/deletecustomlines.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCustomLinesWithChan(request *DeleteCustomLinesRequest) (<-chan *DeleteCustomLinesResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomLinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomLines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomLinesWithCallback invokes the alidns.DeleteCustomLines API asynchronously
// api document: https://help.aliyun.com/api/alidns/deletecustomlines.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCustomLinesWithCallback(request *DeleteCustomLinesRequest, callback func(response *DeleteCustomLinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomLinesResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomLines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomLinesRequest is the request struct for api DeleteCustomLines
type DeleteCustomLinesRequest struct {
	*requests.RpcRequest
	LineIds      string `position:"Query" name:"LineIds"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteCustomLinesResponse is the response struct for api DeleteCustomLines
type DeleteCustomLinesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomLinesRequest creates a request to invoke DeleteCustomLines API
func CreateDeleteCustomLinesRequest() (request *DeleteCustomLinesRequest) {
	request = &DeleteCustomLinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DeleteCustomLines", "alidns", "openAPI")
	return
}

// CreateDeleteCustomLinesResponse creates a response to parse from DeleteCustomLines response
func CreateDeleteCustomLinesResponse() (response *DeleteCustomLinesResponse) {
	response = &DeleteCustomLinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
