package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGtmRecoveryPlan invokes the alidns.DeleteGtmRecoveryPlan API synchronously
// api document: https://help.aliyun.com/api/alidns/deletegtmrecoveryplan.html
func (client *Client) DeleteGtmRecoveryPlan(request *DeleteGtmRecoveryPlanRequest) (response *DeleteGtmRecoveryPlanResponse, err error) {
	response = CreateDeleteGtmRecoveryPlanResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGtmRecoveryPlanWithChan invokes the alidns.DeleteGtmRecoveryPlan API asynchronously
// api document: https://help.aliyun.com/api/alidns/deletegtmrecoveryplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGtmRecoveryPlanWithChan(request *DeleteGtmRecoveryPlanRequest) (<-chan *DeleteGtmRecoveryPlanResponse, <-chan error) {
	responseChan := make(chan *DeleteGtmRecoveryPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGtmRecoveryPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGtmRecoveryPlanWithCallback invokes the alidns.DeleteGtmRecoveryPlan API asynchronously
// api document: https://help.aliyun.com/api/alidns/deletegtmrecoveryplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGtmRecoveryPlanWithCallback(request *DeleteGtmRecoveryPlanRequest, callback func(response *DeleteGtmRecoveryPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGtmRecoveryPlanResponse
		var err error
		defer close(result)
		response, err = client.DeleteGtmRecoveryPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGtmRecoveryPlanRequest is the request struct for api DeleteGtmRecoveryPlan
type DeleteGtmRecoveryPlanRequest struct {
	*requests.RpcRequest
	UserClientIp   string           `position:"Query" name:"UserClientIp"`
	RecoveryPlanId requests.Integer `position:"Query" name:"RecoveryPlanId"`
	Lang           string           `position:"Query" name:"Lang"`
}

// DeleteGtmRecoveryPlanResponse is the response struct for api DeleteGtmRecoveryPlan
type DeleteGtmRecoveryPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGtmRecoveryPlanRequest creates a request to invoke DeleteGtmRecoveryPlan API
func CreateDeleteGtmRecoveryPlanRequest() (request *DeleteGtmRecoveryPlanRequest) {
	request = &DeleteGtmRecoveryPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DeleteGtmRecoveryPlan", "alidns", "openAPI")
	return
}

// CreateDeleteGtmRecoveryPlanResponse creates a response to parse from DeleteGtmRecoveryPlan response
func CreateDeleteGtmRecoveryPlanResponse() (response *DeleteGtmRecoveryPlanResponse) {
	response = &DeleteGtmRecoveryPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
