package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIsvStatistics invokes the aliyuncvc.ListIsvStatistics API synchronously
// api document: https://help.aliyun.com/api/aliyuncvc/listisvstatistics.html
func (client *Client) ListIsvStatistics(request *ListIsvStatisticsRequest) (response *ListIsvStatisticsResponse, err error) {
	response = CreateListIsvStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ListIsvStatisticsWithChan invokes the aliyuncvc.ListIsvStatistics API asynchronously
// api document: https://help.aliyun.com/api/aliyuncvc/listisvstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListIsvStatisticsWithChan(request *ListIsvStatisticsRequest) (<-chan *ListIsvStatisticsResponse, <-chan error) {
	responseChan := make(chan *ListIsvStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIsvStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIsvStatisticsWithCallback invokes the aliyuncvc.ListIsvStatistics API asynchronously
// api document: https://help.aliyun.com/api/aliyuncvc/listisvstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListIsvStatisticsWithCallback(request *ListIsvStatisticsRequest, callback func(response *ListIsvStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIsvStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ListIsvStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIsvStatisticsRequest is the request struct for api ListIsvStatistics
type ListIsvStatisticsRequest struct {
	*requests.RpcRequest
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
}

// ListIsvStatisticsResponse is the response struct for api ListIsvStatistics
type ListIsvStatisticsResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListIsvStatisticsRequest creates a request to invoke ListIsvStatistics API
func CreateListIsvStatisticsRequest() (request *ListIsvStatisticsRequest) {
	request = &ListIsvStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "ListIsvStatistics", "aliyuncvc", "openAPI")
	return
}

// CreateListIsvStatisticsResponse creates a response to parse from ListIsvStatistics response
func CreateListIsvStatisticsResponse() (response *ListIsvStatisticsResponse) {
	response = &ListIsvStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
