package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVoiceAppraise invokes the ccc.CreateVoiceAppraise API synchronously
// api document: https://help.aliyun.com/api/ccc/createvoiceappraise.html
func (client *Client) CreateVoiceAppraise(request *CreateVoiceAppraiseRequest) (response *CreateVoiceAppraiseResponse, err error) {
	response = CreateCreateVoiceAppraiseResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVoiceAppraiseWithChan invokes the ccc.CreateVoiceAppraise API asynchronously
// api document: https://help.aliyun.com/api/ccc/createvoiceappraise.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVoiceAppraiseWithChan(request *CreateVoiceAppraiseRequest) (<-chan *CreateVoiceAppraiseResponse, <-chan error) {
	responseChan := make(chan *CreateVoiceAppraiseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVoiceAppraise(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVoiceAppraiseWithCallback invokes the ccc.CreateVoiceAppraise API asynchronously
// api document: https://help.aliyun.com/api/ccc/createvoiceappraise.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVoiceAppraiseWithCallback(request *CreateVoiceAppraiseRequest, callback func(response *CreateVoiceAppraiseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVoiceAppraiseResponse
		var err error
		defer close(result)
		response, err = client.CreateVoiceAppraise(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVoiceAppraiseRequest is the request struct for api CreateVoiceAppraise
type CreateVoiceAppraiseRequest struct {
	*requests.RpcRequest
	IsAppraise           requests.Boolean `position:"Query" name:"IsAppraise"`
	Content              string           `position:"Body" name:"Content"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	ContactFlowVersionId string           `position:"Query" name:"ContactFlowVersionId"`
}

// CreateVoiceAppraiseResponse is the response struct for api CreateVoiceAppraise
type CreateVoiceAppraiseResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateVoiceAppraiseRequest creates a request to invoke CreateVoiceAppraise API
func CreateCreateVoiceAppraiseRequest() (request *CreateVoiceAppraiseRequest) {
	request = &CreateVoiceAppraiseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "CreateVoiceAppraise", "", "")
	return
}

// CreateCreateVoiceAppraiseResponse creates a response to parse from CreateVoiceAppraise response
func CreateCreateVoiceAppraiseResponse() (response *CreateVoiceAppraiseResponse) {
	response = &CreateVoiceAppraiseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
