package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIvrTrackingDetail invokes the ccc.ListIvrTrackingDetail API synchronously
// api document: https://help.aliyun.com/api/ccc/listivrtrackingdetail.html
func (client *Client) ListIvrTrackingDetail(request *ListIvrTrackingDetailRequest) (response *ListIvrTrackingDetailResponse, err error) {
	response = CreateListIvrTrackingDetailResponse()
	err = client.DoAction(request, response)
	return
}

// ListIvrTrackingDetailWithChan invokes the ccc.ListIvrTrackingDetail API asynchronously
// api document: https://help.aliyun.com/api/ccc/listivrtrackingdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListIvrTrackingDetailWithChan(request *ListIvrTrackingDetailRequest) (<-chan *ListIvrTrackingDetailResponse, <-chan error) {
	responseChan := make(chan *ListIvrTrackingDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIvrTrackingDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIvrTrackingDetailWithCallback invokes the ccc.ListIvrTrackingDetail API asynchronously
// api document: https://help.aliyun.com/api/ccc/listivrtrackingdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListIvrTrackingDetailWithCallback(request *ListIvrTrackingDetailRequest, callback func(response *ListIvrTrackingDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIvrTrackingDetailResponse
		var err error
		defer close(result)
		response, err = client.ListIvrTrackingDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIvrTrackingDetailRequest is the request struct for api ListIvrTrackingDetail
type ListIvrTrackingDetailRequest struct {
	*requests.RpcRequest
	ContactId     string           `position:"Query" name:"ContactId"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	StopTime      requests.Integer `position:"Query" name:"StopTime"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	CallingNumber string           `position:"Query" name:"CallingNumber"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	CalledNumber  string           `position:"Query" name:"CalledNumber"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListIvrTrackingDetailResponse is the response struct for api ListIvrTrackingDetail
type ListIvrTrackingDetailResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	Success            bool               `json:"Success" xml:"Success"`
	Code               string             `json:"Code" xml:"Code"`
	Message            string             `json:"Message" xml:"Message"`
	HttpStatusCode     int                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	IvrTrackingDetails IvrTrackingDetails `json:"IvrTrackingDetails" xml:"IvrTrackingDetails"`
}

// CreateListIvrTrackingDetailRequest creates a request to invoke ListIvrTrackingDetail API
func CreateListIvrTrackingDetailRequest() (request *ListIvrTrackingDetailRequest) {
	request = &ListIvrTrackingDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ListIvrTrackingDetail", "", "")
	return
}

// CreateListIvrTrackingDetailResponse creates a response to parse from ListIvrTrackingDetail response
func CreateListIvrTrackingDetailResponse() (response *ListIvrTrackingDetailResponse) {
	response = &ListIvrTrackingDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
