package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPredictiveJobGroups invokes the ccc.ListPredictiveJobGroups API synchronously
// api document: https://help.aliyun.com/api/ccc/listpredictivejobgroups.html
func (client *Client) ListPredictiveJobGroups(request *ListPredictiveJobGroupsRequest) (response *ListPredictiveJobGroupsResponse, err error) {
	response = CreateListPredictiveJobGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPredictiveJobGroupsWithChan invokes the ccc.ListPredictiveJobGroups API asynchronously
// api document: https://help.aliyun.com/api/ccc/listpredictivejobgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobGroupsWithChan(request *ListPredictiveJobGroupsRequest) (<-chan *ListPredictiveJobGroupsResponse, <-chan error) {
	responseChan := make(chan *ListPredictiveJobGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPredictiveJobGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPredictiveJobGroupsWithCallback invokes the ccc.ListPredictiveJobGroups API asynchronously
// api document: https://help.aliyun.com/api/ccc/listpredictivejobgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPredictiveJobGroupsWithCallback(request *ListPredictiveJobGroupsRequest, callback func(response *ListPredictiveJobGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPredictiveJobGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListPredictiveJobGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPredictiveJobGroupsRequest is the request struct for api ListPredictiveJobGroups
type ListPredictiveJobGroupsRequest struct {
	*requests.RpcRequest
	Criteria     string           `position:"Query" name:"Criteria"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	SkillGroupId string           `position:"Query" name:"SkillGroupId"`
	Name         string           `position:"Query" name:"Name"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
}

// ListPredictiveJobGroupsResponse is the response struct for api ListPredictiveJobGroups
type ListPredictiveJobGroupsResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	Success        bool      `json:"Success" xml:"Success"`
	Code           string    `json:"Code" xml:"Code"`
	Message        string    `json:"Message" xml:"Message"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	JobGroups      JobGroups `json:"JobGroups" xml:"JobGroups"`
}

// CreateListPredictiveJobGroupsRequest creates a request to invoke ListPredictiveJobGroups API
func CreateListPredictiveJobGroupsRequest() (request *ListPredictiveJobGroupsRequest) {
	request = &ListPredictiveJobGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ListPredictiveJobGroups", "", "")
	return
}

// CreateListPredictiveJobGroupsResponse creates a response to parse from ListPredictiveJobGroups response
func CreateListPredictiveJobGroupsResponse() (response *ListPredictiveJobGroupsResponse) {
	response = &ListPredictiveJobGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
