package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFCTrigger invokes the cdn.AddFCTrigger API synchronously
// api document: https://help.aliyun.com/api/cdn/addfctrigger.html
func (client *Client) AddFCTrigger(request *AddFCTriggerRequest) (response *AddFCTriggerResponse, err error) {
	response = CreateAddFCTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// AddFCTriggerWithChan invokes the cdn.AddFCTrigger API asynchronously
// api document: https://help.aliyun.com/api/cdn/addfctrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddFCTriggerWithChan(request *AddFCTriggerRequest) (<-chan *AddFCTriggerResponse, <-chan error) {
	responseChan := make(chan *AddFCTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFCTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFCTriggerWithCallback invokes the cdn.AddFCTrigger API asynchronously
// api document: https://help.aliyun.com/api/cdn/addfctrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddFCTriggerWithCallback(request *AddFCTriggerRequest, callback func(response *AddFCTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFCTriggerResponse
		var err error
		defer close(result)
		response, err = client.AddFCTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFCTriggerRequest is the request struct for api AddFCTrigger
type AddFCTriggerRequest struct {
	*requests.RpcRequest
	Notes            string           `position:"Body" name:"Notes"`
	EventMetaVersion string           `position:"Body" name:"EventMetaVersion"`
	TriggerARN       string           `position:"Query" name:"TriggerARN"`
	SourceARN        string           `position:"Body" name:"SourceARN"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	RoleARN          string           `position:"Body" name:"RoleARN"`
	EventMetaName    string           `position:"Body" name:"EventMetaName"`
	FunctionARN      string           `position:"Body" name:"FunctionARN"`
}

// AddFCTriggerResponse is the response struct for api AddFCTrigger
type AddFCTriggerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddFCTriggerRequest creates a request to invoke AddFCTrigger API
func CreateAddFCTriggerRequest() (request *AddFCTriggerRequest) {
	request = &AddFCTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "AddFCTrigger", "", "")
	return
}

// CreateAddFCTriggerResponse creates a response to parse from AddFCTrigger response
func CreateAddFCTriggerResponse() (response *AddFCTriggerResponse) {
	response = &AddFCTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
