package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFileCacheExpiredConfig invokes the cdn.ModifyFileCacheExpiredConfig API synchronously
// api document: https://help.aliyun.com/api/cdn/modifyfilecacheexpiredconfig.html
func (client *Client) ModifyFileCacheExpiredConfig(request *ModifyFileCacheExpiredConfigRequest) (response *ModifyFileCacheExpiredConfigResponse, err error) {
	response = CreateModifyFileCacheExpiredConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFileCacheExpiredConfigWithChan invokes the cdn.ModifyFileCacheExpiredConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/modifyfilecacheexpiredconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFileCacheExpiredConfigWithChan(request *ModifyFileCacheExpiredConfigRequest) (<-chan *ModifyFileCacheExpiredConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyFileCacheExpiredConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFileCacheExpiredConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFileCacheExpiredConfigWithCallback invokes the cdn.ModifyFileCacheExpiredConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/modifyfilecacheexpiredconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFileCacheExpiredConfigWithCallback(request *ModifyFileCacheExpiredConfigRequest, callback func(response *ModifyFileCacheExpiredConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFileCacheExpiredConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyFileCacheExpiredConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFileCacheExpiredConfigRequest is the request struct for api ModifyFileCacheExpiredConfig
type ModifyFileCacheExpiredConfigRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	Weight        string           `position:"Query" name:"Weight"`
	CacheContent  string           `position:"Query" name:"CacheContent"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	TTL           string           `position:"Query" name:"TTL"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ConfigID      string           `position:"Query" name:"ConfigID"`
}

// ModifyFileCacheExpiredConfigResponse is the response struct for api ModifyFileCacheExpiredConfig
type ModifyFileCacheExpiredConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyFileCacheExpiredConfigRequest creates a request to invoke ModifyFileCacheExpiredConfig API
func CreateModifyFileCacheExpiredConfigRequest() (request *ModifyFileCacheExpiredConfigRequest) {
	request = &ModifyFileCacheExpiredConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "ModifyFileCacheExpiredConfig", "", "")
	return
}

// CreateModifyFileCacheExpiredConfigResponse creates a response to parse from ModifyFileCacheExpiredConfig response
func CreateModifyFileCacheExpiredConfigResponse() (response *ModifyFileCacheExpiredConfigResponse) {
	response = &ModifyFileCacheExpiredConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
