package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenCdnService invokes the cdn.OpenCdnService API synchronously
// api document: https://help.aliyun.com/api/cdn/opencdnservice.html
func (client *Client) OpenCdnService(request *OpenCdnServiceRequest) (response *OpenCdnServiceResponse, err error) {
	response = CreateOpenCdnServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenCdnServiceWithChan invokes the cdn.OpenCdnService API asynchronously
// api document: https://help.aliyun.com/api/cdn/opencdnservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OpenCdnServiceWithChan(request *OpenCdnServiceRequest) (<-chan *OpenCdnServiceResponse, <-chan error) {
	responseChan := make(chan *OpenCdnServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenCdnService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenCdnServiceWithCallback invokes the cdn.OpenCdnService API asynchronously
// api document: https://help.aliyun.com/api/cdn/opencdnservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OpenCdnServiceWithCallback(request *OpenCdnServiceRequest, callback func(response *OpenCdnServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenCdnServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenCdnService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenCdnServiceRequest is the request struct for api OpenCdnService
type OpenCdnServiceRequest struct {
	*requests.RpcRequest
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken      string           `position:"Query" name:"SecurityToken"`
	InternetChargeType string           `position:"Query" name:"InternetChargeType"`
}

// OpenCdnServiceResponse is the response struct for api OpenCdnService
type OpenCdnServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenCdnServiceRequest creates a request to invoke OpenCdnService API
func CreateOpenCdnServiceRequest() (request *OpenCdnServiceRequest) {
	request = &OpenCdnServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "OpenCdnService", "", "")
	return
}

// CreateOpenCdnServiceResponse creates a response to parse from OpenCdnService response
func CreateOpenCdnServiceResponse() (response *OpenCdnServiceResponse) {
	response = &OpenCdnServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
