package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetIpControlApis invokes the cloudapi.SetIpControlApis API synchronously
// api document: https://help.aliyun.com/api/cloudapi/setipcontrolapis.html
func (client *Client) SetIpControlApis(request *SetIpControlApisRequest) (response *SetIpControlApisResponse, err error) {
	response = CreateSetIpControlApisResponse()
	err = client.DoAction(request, response)
	return
}

// SetIpControlApisWithChan invokes the cloudapi.SetIpControlApis API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/setipcontrolapis.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetIpControlApisWithChan(request *SetIpControlApisRequest) (<-chan *SetIpControlApisResponse, <-chan error) {
	responseChan := make(chan *SetIpControlApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetIpControlApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetIpControlApisWithCallback invokes the cloudapi.SetIpControlApis API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/setipcontrolapis.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetIpControlApisWithCallback(request *SetIpControlApisRequest, callback func(response *SetIpControlApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetIpControlApisResponse
		var err error
		defer close(result)
		response, err = client.SetIpControlApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetIpControlApisRequest is the request struct for api SetIpControlApis
type SetIpControlApisRequest struct {
	*requests.RpcRequest
	StageName     string `position:"Query" name:"StageName"`
	GroupId       string `position:"Query" name:"GroupId"`
	IpControlId   string `position:"Query" name:"IpControlId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	ApiIds        string `position:"Query" name:"ApiIds"`
}

// SetIpControlApisResponse is the response struct for api SetIpControlApis
type SetIpControlApisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetIpControlApisRequest creates a request to invoke SetIpControlApis API
func CreateSetIpControlApisRequest() (request *SetIpControlApisRequest) {
	request = &SetIpControlApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "SetIpControlApis", "apigateway", "openAPI")
	return
}

// CreateSetIpControlApisResponse creates a response to parse from SetIpControlApis response
func CreateSetIpControlApisResponse() (response *SetIpControlApisResponse) {
	response = &SetIpControlApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
