package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopActionReturning invokes the cloudwf.ShopActionReturning API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopactionreturning.html
func (client *Client) ShopActionReturning(request *ShopActionReturningRequest) (response *ShopActionReturningResponse, err error) {
	response = CreateShopActionReturningResponse()
	err = client.DoAction(request, response)
	return
}

// ShopActionReturningWithChan invokes the cloudwf.ShopActionReturning API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopactionreturning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopActionReturningWithChan(request *ShopActionReturningRequest) (<-chan *ShopActionReturningResponse, <-chan error) {
	responseChan := make(chan *ShopActionReturningResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopActionReturning(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopActionReturningWithCallback invokes the cloudwf.ShopActionReturning API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopactionreturning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopActionReturningWithCallback(request *ShopActionReturningRequest, callback func(response *ShopActionReturningResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopActionReturningResponse
		var err error
		defer close(result)
		response, err = client.ShopActionReturning(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopActionReturningRequest is the request struct for api ShopActionReturning
type ShopActionReturningRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// ShopActionReturningResponse is the response struct for api ShopActionReturning
type ShopActionReturningResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopActionReturningRequest creates a request to invoke ShopActionReturning API
func CreateShopActionReturningRequest() (request *ShopActionReturningRequest) {
	request = &ShopActionReturningRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopActionReturning", "cloudwf", "openAPI")
	return
}

// CreateShopActionReturningResponse creates a response to parse from ShopActionReturning response
func CreateShopActionReturningResponse() (response *ShopActionReturningResponse) {
	response = &ShopActionReturningResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
