package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMetricRuleList invokes the cms.DescribeMetricRuleList API synchronously
// api document: https://help.aliyun.com/api/cms/describemetricrulelist.html
func (client *Client) DescribeMetricRuleList(request *DescribeMetricRuleListRequest) (response *DescribeMetricRuleListResponse, err error) {
	response = CreateDescribeMetricRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMetricRuleListWithChan invokes the cms.DescribeMetricRuleList API asynchronously
// api document: https://help.aliyun.com/api/cms/describemetricrulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMetricRuleListWithChan(request *DescribeMetricRuleListRequest) (<-chan *DescribeMetricRuleListResponse, <-chan error) {
	responseChan := make(chan *DescribeMetricRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMetricRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMetricRuleListWithCallback invokes the cms.DescribeMetricRuleList API asynchronously
// api document: https://help.aliyun.com/api/cms/describemetricrulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMetricRuleListWithCallback(request *DescribeMetricRuleListRequest, callback func(response *DescribeMetricRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMetricRuleListResponse
		var err error
		defer close(result)
		response, err = client.DescribeMetricRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMetricRuleListRequest is the request struct for api DescribeMetricRuleList
type DescribeMetricRuleListRequest struct {
	*requests.RpcRequest
	EnableState requests.Boolean `position:"Query" name:"EnableState"`
	RuleName    string           `position:"Query" name:"RuleName"`
	PageSize    string           `position:"Query" name:"PageSize"`
	MetricName  string           `position:"Query" name:"MetricName"`
	GroupId     string           `position:"Query" name:"GroupId"`
	RuleIds     string           `position:"Query" name:"RuleIds"`
	Namespace   string           `position:"Query" name:"Namespace"`
	AlertState  string           `position:"Query" name:"AlertState"`
	Page        string           `position:"Query" name:"Page"`
	Dimensions  string           `position:"Query" name:"Dimensions"`
}

// DescribeMetricRuleListResponse is the response struct for api DescribeMetricRuleList
type DescribeMetricRuleListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Total     string `json:"Total" xml:"Total"`
	Alarms    Alarms `json:"Alarms" xml:"Alarms"`
}

// CreateDescribeMetricRuleListRequest creates a request to invoke DescribeMetricRuleList API
func CreateDescribeMetricRuleListRequest() (request *DescribeMetricRuleListRequest) {
	request = &DescribeMetricRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMetricRuleList", "cms", "openAPI")
	return
}

// CreateDescribeMetricRuleListResponse creates a response to parse from DescribeMetricRuleList response
func CreateDescribeMetricRuleListResponse() (response *DescribeMetricRuleListResponse) {
	response = &DescribeMetricRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
