package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRepoSyncRule invokes the cr.CreateRepoSyncRule API synchronously
// api document: https://help.aliyun.com/api/cr/createreposyncrule.html
func (client *Client) CreateRepoSyncRule(request *CreateRepoSyncRuleRequest) (response *CreateRepoSyncRuleResponse, err error) {
	response = CreateCreateRepoSyncRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRepoSyncRuleWithChan invokes the cr.CreateRepoSyncRule API asynchronously
// api document: https://help.aliyun.com/api/cr/createreposyncrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRepoSyncRuleWithChan(request *CreateRepoSyncRuleRequest) (<-chan *CreateRepoSyncRuleResponse, <-chan error) {
	responseChan := make(chan *CreateRepoSyncRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRepoSyncRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRepoSyncRuleWithCallback invokes the cr.CreateRepoSyncRule API asynchronously
// api document: https://help.aliyun.com/api/cr/createreposyncrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRepoSyncRuleWithCallback(request *CreateRepoSyncRuleRequest, callback func(response *CreateRepoSyncRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRepoSyncRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateRepoSyncRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRepoSyncRuleRequest is the request struct for api CreateRepoSyncRule
type CreateRepoSyncRuleRequest struct {
	*requests.RpcRequest
	NamespaceName       string `position:"Query" name:"NamespaceName"`
	TargetRepoName      string `position:"Query" name:"TargetRepoName"`
	SyncScope           string `position:"Query" name:"SyncScope"`
	SyncRuleName        string `position:"Query" name:"SyncRuleName"`
	TagFilter           string `position:"Query" name:"TagFilter"`
	TargetNamespaceName string `position:"Query" name:"TargetNamespaceName"`
	InstanceId          string `position:"Query" name:"InstanceId"`
	TargetInstanceId    string `position:"Query" name:"TargetInstanceId"`
	RepoName            string `position:"Query" name:"RepoName"`
	TargetRegionId      string `position:"Query" name:"TargetRegionId"`
	SyncTrigger         string `position:"Query" name:"SyncTrigger"`
}

// CreateRepoSyncRuleResponse is the response struct for api CreateRepoSyncRule
type CreateRepoSyncRuleResponse struct {
	*responses.BaseResponse
	CreateRepoSyncRuleIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                        string `json:"Code" xml:"Code"`
	RequestId                   string `json:"RequestId" xml:"RequestId"`
	SyncRuleId                  string `json:"SyncRuleId" xml:"SyncRuleId"`
}

// CreateCreateRepoSyncRuleRequest creates a request to invoke CreateRepoSyncRule API
func CreateCreateRepoSyncRuleRequest() (request *CreateRepoSyncRuleRequest) {
	request = &CreateRepoSyncRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "CreateRepoSyncRule", "cr", "openAPI")
	return
}

// CreateCreateRepoSyncRuleResponse creates a response to parse from CreateRepoSyncRule response
func CreateCreateRepoSyncRuleResponse() (response *CreateRepoSyncRuleResponse) {
	response = &CreateRepoSyncRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
