package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoBuildRecordStatus invokes the cr.GetRepoBuildRecordStatus API synchronously
// api document: https://help.aliyun.com/api/cr/getrepobuildrecordstatus.html
func (client *Client) GetRepoBuildRecordStatus(request *GetRepoBuildRecordStatusRequest) (response *GetRepoBuildRecordStatusResponse, err error) {
	response = CreateGetRepoBuildRecordStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoBuildRecordStatusWithChan invokes the cr.GetRepoBuildRecordStatus API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepobuildrecordstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoBuildRecordStatusWithChan(request *GetRepoBuildRecordStatusRequest) (<-chan *GetRepoBuildRecordStatusResponse, <-chan error) {
	responseChan := make(chan *GetRepoBuildRecordStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoBuildRecordStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoBuildRecordStatusWithCallback invokes the cr.GetRepoBuildRecordStatus API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepobuildrecordstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoBuildRecordStatusWithCallback(request *GetRepoBuildRecordStatusRequest, callback func(response *GetRepoBuildRecordStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoBuildRecordStatusResponse
		var err error
		defer close(result)
		response, err = client.GetRepoBuildRecordStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoBuildRecordStatusRequest is the request struct for api GetRepoBuildRecordStatus
type GetRepoBuildRecordStatusRequest struct {
	*requests.RpcRequest
	BuildRecordId string `position:"Query" name:"BuildRecordId"`
	RepoId        string `position:"Query" name:"RepoId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// GetRepoBuildRecordStatusResponse is the response struct for api GetRepoBuildRecordStatus
type GetRepoBuildRecordStatusResponse struct {
	*responses.BaseResponse
	GetRepoBuildRecordStatusIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                              string `json:"Code" xml:"Code"`
	RequestId                         string `json:"RequestId" xml:"RequestId"`
	BuildStatus                       string `json:"BuildStatus" xml:"BuildStatus"`
}

// CreateGetRepoBuildRecordStatusRequest creates a request to invoke GetRepoBuildRecordStatus API
func CreateGetRepoBuildRecordStatusRequest() (request *GetRepoBuildRecordStatusRequest) {
	request = &GetRepoBuildRecordStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetRepoBuildRecordStatus", "cr", "openAPI")
	return
}

// CreateGetRepoBuildRecordStatusResponse creates a response to parse from GetRepoBuildRecordStatus response
func CreateGetRepoBuildRecordStatusResponse() (response *GetRepoBuildRecordStatusResponse) {
	response = &GetRepoBuildRecordStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
