package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListChartRepository invokes the cr.ListChartRepository API synchronously
// api document: https://help.aliyun.com/api/cr/listchartrepository.html
func (client *Client) ListChartRepository(request *ListChartRepositoryRequest) (response *ListChartRepositoryResponse, err error) {
	response = CreateListChartRepositoryResponse()
	err = client.DoAction(request, response)
	return
}

// ListChartRepositoryWithChan invokes the cr.ListChartRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/listchartrepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListChartRepositoryWithChan(request *ListChartRepositoryRequest) (<-chan *ListChartRepositoryResponse, <-chan error) {
	responseChan := make(chan *ListChartRepositoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListChartRepository(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListChartRepositoryWithCallback invokes the cr.ListChartRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/listchartrepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListChartRepositoryWithCallback(request *ListChartRepositoryRequest, callback func(response *ListChartRepositoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListChartRepositoryResponse
		var err error
		defer close(result)
		response, err = client.ListChartRepository(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListChartRepositoryRequest is the request struct for api ListChartRepository
type ListChartRepositoryRequest struct {
	*requests.RpcRequest
	InstanceId        string           `position:"Query" name:"InstanceId"`
	RepoName          string           `position:"Query" name:"RepoName"`
	RepoNamespaceName string           `position:"Query" name:"RepoNamespaceName"`
	PageNo            requests.Integer `position:"Query" name:"PageNo"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	RepoStatus        string           `position:"Query" name:"RepoStatus"`
}

// ListChartRepositoryResponse is the response struct for api ListChartRepository
type ListChartRepositoryResponse struct {
	*responses.BaseResponse
	ListChartRepositoryIsSuccess bool               `json:"IsSuccess" xml:"IsSuccess"`
	Code                         string             `json:"Code" xml:"Code"`
	RequestId                    string             `json:"RequestId" xml:"RequestId"`
	PageNo                       int                `json:"PageNo" xml:"PageNo"`
	PageSize                     int                `json:"PageSize" xml:"PageSize"`
	TotalCount                   string             `json:"TotalCount" xml:"TotalCount"`
	Repositories                 []RepositoriesItem `json:"Repositories" xml:"Repositories"`
}

// CreateListChartRepositoryRequest creates a request to invoke ListChartRepository API
func CreateListChartRepositoryRequest() (request *ListChartRepositoryRequest) {
	request = &ListChartRepositoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListChartRepository", "cr", "openAPI")
	return
}

// CreateListChartRepositoryResponse creates a response to parse from ListChartRepository response
func CreateListChartRepositoryResponse() (response *ListChartRepositoryResponse) {
	response = &ListChartRepositoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
