package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepoBuildRecordLog invokes the cr.ListRepoBuildRecordLog API synchronously
// api document: https://help.aliyun.com/api/cr/listrepobuildrecordlog.html
func (client *Client) ListRepoBuildRecordLog(request *ListRepoBuildRecordLogRequest) (response *ListRepoBuildRecordLogResponse, err error) {
	response = CreateListRepoBuildRecordLogResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepoBuildRecordLogWithChan invokes the cr.ListRepoBuildRecordLog API asynchronously
// api document: https://help.aliyun.com/api/cr/listrepobuildrecordlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoBuildRecordLogWithChan(request *ListRepoBuildRecordLogRequest) (<-chan *ListRepoBuildRecordLogResponse, <-chan error) {
	responseChan := make(chan *ListRepoBuildRecordLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepoBuildRecordLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepoBuildRecordLogWithCallback invokes the cr.ListRepoBuildRecordLog API asynchronously
// api document: https://help.aliyun.com/api/cr/listrepobuildrecordlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoBuildRecordLogWithCallback(request *ListRepoBuildRecordLogRequest, callback func(response *ListRepoBuildRecordLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepoBuildRecordLogResponse
		var err error
		defer close(result)
		response, err = client.ListRepoBuildRecordLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepoBuildRecordLogRequest is the request struct for api ListRepoBuildRecordLog
type ListRepoBuildRecordLogRequest struct {
	*requests.RpcRequest
	BuildRecordId string           `position:"Query" name:"BuildRecordId"`
	RepoId        string           `position:"Query" name:"RepoId"`
	Offset        requests.Integer `position:"Query" name:"Offset"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
}

// ListRepoBuildRecordLogResponse is the response struct for api ListRepoBuildRecordLog
type ListRepoBuildRecordLogResponse struct {
	*responses.BaseResponse
	ListRepoBuildRecordLogIsSuccess bool                  `json:"IsSuccess" xml:"IsSuccess"`
	Code                            string                `json:"Code" xml:"Code"`
	RequestId                       string                `json:"RequestId" xml:"RequestId"`
	PageNo                          int                   `json:"PageNo" xml:"PageNo"`
	PageSize                        int                   `json:"PageSize" xml:"PageSize"`
	TotalCount                      string                `json:"TotalCount" xml:"TotalCount"`
	BuildRecordLogs                 []BuildRecordLogsItem `json:"BuildRecordLogs" xml:"BuildRecordLogs"`
}

// CreateListRepoBuildRecordLogRequest creates a request to invoke ListRepoBuildRecordLog API
func CreateListRepoBuildRecordLogRequest() (request *ListRepoBuildRecordLogRequest) {
	request = &ListRepoBuildRecordLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListRepoBuildRecordLog", "cr", "openAPI")
	return
}

// CreateListRepoBuildRecordLogResponse creates a response to parse from ListRepoBuildRecordLog response
func CreateListRepoBuildRecordLogResponse() (response *ListRepoBuildRecordLogResponse) {
	response = &ListRepoBuildRecordLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
