package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepoSyncTask invokes the cr.ListRepoSyncTask API synchronously
// api document: https://help.aliyun.com/api/cr/listreposynctask.html
func (client *Client) ListRepoSyncTask(request *ListRepoSyncTaskRequest) (response *ListRepoSyncTaskResponse, err error) {
	response = CreateListRepoSyncTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepoSyncTaskWithChan invokes the cr.ListRepoSyncTask API asynchronously
// api document: https://help.aliyun.com/api/cr/listreposynctask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoSyncTaskWithChan(request *ListRepoSyncTaskRequest) (<-chan *ListRepoSyncTaskResponse, <-chan error) {
	responseChan := make(chan *ListRepoSyncTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepoSyncTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepoSyncTaskWithCallback invokes the cr.ListRepoSyncTask API asynchronously
// api document: https://help.aliyun.com/api/cr/listreposynctask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoSyncTaskWithCallback(request *ListRepoSyncTaskRequest, callback func(response *ListRepoSyncTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepoSyncTaskResponse
		var err error
		defer close(result)
		response, err = client.ListRepoSyncTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepoSyncTaskRequest is the request struct for api ListRepoSyncTask
type ListRepoSyncTaskRequest struct {
	*requests.RpcRequest
	SyncRecordId string           `position:"Query" name:"SyncRecordId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	PageNo       requests.Integer `position:"Query" name:"PageNo"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
}

// ListRepoSyncTaskResponse is the response struct for api ListRepoSyncTask
type ListRepoSyncTaskResponse struct {
	*responses.BaseResponse
	ListRepoSyncTaskIsSuccess bool            `json:"IsSuccess" xml:"IsSuccess"`
	Code                      string          `json:"Code" xml:"Code"`
	RequestId                 string          `json:"RequestId" xml:"RequestId"`
	PageNo                    int             `json:"PageNo" xml:"PageNo"`
	PageSize                  int             `json:"PageSize" xml:"PageSize"`
	TotalCount                string          `json:"TotalCount" xml:"TotalCount"`
	SyncTasks                 []SyncTasksItem `json:"SyncTasks" xml:"SyncTasks"`
}

// CreateListRepoSyncTaskRequest creates a request to invoke ListRepoSyncTask API
func CreateListRepoSyncTaskRequest() (request *ListRepoSyncTaskRequest) {
	request = &ListRepoSyncTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListRepoSyncTask", "cr", "openAPI")
	return
}

// CreateListRepoSyncTaskResponse creates a response to parse from ListRepoSyncTask response
func CreateListRepoSyncTaskResponse() (response *ListRepoSyncTaskResponse) {
	response = &ListRepoSyncTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
