package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterUserKubeconfig invokes the cs.DescribeClusterUserKubeconfig API synchronously
// api document: https://help.aliyun.com/api/cs/describeclusteruserkubeconfig.html
func (client *Client) DescribeClusterUserKubeconfig(request *DescribeClusterUserKubeconfigRequest) (response *DescribeClusterUserKubeconfigResponse, err error) {
	response = CreateDescribeClusterUserKubeconfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterUserKubeconfigWithChan invokes the cs.DescribeClusterUserKubeconfig API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusteruserkubeconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterUserKubeconfigWithChan(request *DescribeClusterUserKubeconfigRequest) (<-chan *DescribeClusterUserKubeconfigResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterUserKubeconfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterUserKubeconfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterUserKubeconfigWithCallback invokes the cs.DescribeClusterUserKubeconfig API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusteruserkubeconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterUserKubeconfigWithCallback(request *DescribeClusterUserKubeconfigRequest, callback func(response *DescribeClusterUserKubeconfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterUserKubeconfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterUserKubeconfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterUserKubeconfigRequest is the request struct for api DescribeClusterUserKubeconfig
type DescribeClusterUserKubeconfigRequest struct {
	*requests.RoaRequest
	PrivateIpAddress requests.Boolean `position:"Query" name:"PrivateIpAddress"`
	ClusterId        string           `position:"Path" name:"ClusterId"`
}

// DescribeClusterUserKubeconfigResponse is the response struct for api DescribeClusterUserKubeconfig
type DescribeClusterUserKubeconfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeClusterUserKubeconfigRequest creates a request to invoke DescribeClusterUserKubeconfig API
func CreateDescribeClusterUserKubeconfigRequest() (request *DescribeClusterUserKubeconfigRequest) {
	request = &DescribeClusterUserKubeconfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterUserKubeconfig", "/k8s/[ClusterId]/user_config", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterUserKubeconfigResponse creates a response to parse from DescribeClusterUserKubeconfig response
func CreateDescribeClusterUserKubeconfigResponse() (response *DescribeClusterUserKubeconfigResponse) {
	response = &DescribeClusterUserKubeconfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
