package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreCheckForCreateCluster invokes the cs.PreCheckForCreateCluster API synchronously
// api document: https://help.aliyun.com/api/cs/precheckforcreatecluster.html
func (client *Client) PreCheckForCreateCluster(request *PreCheckForCreateClusterRequest) (response *PreCheckForCreateClusterResponse, err error) {
	response = CreatePreCheckForCreateClusterResponse()
	err = client.DoAction(request, response)
	return
}

// PreCheckForCreateClusterWithChan invokes the cs.PreCheckForCreateCluster API asynchronously
// api document: https://help.aliyun.com/api/cs/precheckforcreatecluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreCheckForCreateClusterWithChan(request *PreCheckForCreateClusterRequest) (<-chan *PreCheckForCreateClusterResponse, <-chan error) {
	responseChan := make(chan *PreCheckForCreateClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreCheckForCreateCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreCheckForCreateClusterWithCallback invokes the cs.PreCheckForCreateCluster API asynchronously
// api document: https://help.aliyun.com/api/cs/precheckforcreatecluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreCheckForCreateClusterWithCallback(request *PreCheckForCreateClusterRequest, callback func(response *PreCheckForCreateClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreCheckForCreateClusterResponse
		var err error
		defer close(result)
		response, err = client.PreCheckForCreateCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreCheckForCreateClusterRequest is the request struct for api PreCheckForCreateCluster
type PreCheckForCreateClusterRequest struct {
	*requests.RoaRequest
}

// PreCheckForCreateClusterResponse is the response struct for api PreCheckForCreateCluster
type PreCheckForCreateClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePreCheckForCreateClusterRequest creates a request to invoke PreCheckForCreateCluster API
func CreatePreCheckForCreateClusterRequest() (request *PreCheckForCreateClusterRequest) {
	request = &PreCheckForCreateClusterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "PreCheckForCreateCluster", "/api/v1/ess/precheck", "", "")
	request.Method = requests.POST
	return
}

// CreatePreCheckForCreateClusterResponse creates a response to parse from PreCheckForCreateCluster response
func CreatePreCheckForCreateClusterResponse() (response *PreCheckForCreateClusterResponse) {
	response = &PreCheckForCreateClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
