package dnsknocker

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeResourceRecord invokes the dnsknocker.ChangeResourceRecord API synchronously
// api document: https://help.aliyun.com/api/dnsknocker/changeresourcerecord.html
func (client *Client) ChangeResourceRecord(request *ChangeResourceRecordRequest) (response *ChangeResourceRecordResponse, err error) {
	response = CreateChangeResourceRecordResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeResourceRecordWithChan invokes the dnsknocker.ChangeResourceRecord API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/changeresourcerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeResourceRecordWithChan(request *ChangeResourceRecordRequest) (<-chan *ChangeResourceRecordResponse, <-chan error) {
	responseChan := make(chan *ChangeResourceRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeResourceRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeResourceRecordWithCallback invokes the dnsknocker.ChangeResourceRecord API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/changeresourcerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeResourceRecordWithCallback(request *ChangeResourceRecordRequest, callback func(response *ChangeResourceRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeResourceRecordResponse
		var err error
		defer close(result)
		response, err = client.ChangeResourceRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeResourceRecordRequest is the request struct for api ChangeResourceRecord
type ChangeResourceRecordRequest struct {
	*requests.RpcRequest
	AccessID      string `position:"Body" name:"AccessID"`
	AccessSecret  string `position:"Body" name:"AccessSecret"`
	NewRRInfo     string `position:"Body" name:"NewRRInfo"`
	ZoneName      string `position:"Body" name:"ZoneName"`
	TransactionId string `position:"Body" name:"TransactionId"`
	Group         string `position:"Body" name:"Group"`
	OldRRInfo     string `position:"Body" name:"OldRRInfo"`
}

// ChangeResourceRecordResponse is the response struct for api ChangeResourceRecord
type ChangeResourceRecordResponse struct {
	*responses.BaseResponse
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	Success       string `json:"Success" xml:"Success"`
	TransactionId string `json:"TransactionId" xml:"TransactionId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateChangeResourceRecordRequest creates a request to invoke ChangeResourceRecord API
func CreateChangeResourceRecordRequest() (request *ChangeResourceRecordRequest) {
	request = &ChangeResourceRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DnsKnocker", "2019-09-10", "ChangeResourceRecord", "dns_knocker", "openAPI")
	return
}

// CreateChangeResourceRecordResponse creates a response to parse from ChangeResourceRecord response
func CreateChangeResourceRecordResponse() (response *ChangeResourceRecordResponse) {
	response = &ChangeResourceRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
