package dnsknocker

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourceRecord invokes the dnsknocker.CreateResourceRecord API synchronously
// api document: https://help.aliyun.com/api/dnsknocker/createresourcerecord.html
func (client *Client) CreateResourceRecord(request *CreateResourceRecordRequest) (response *CreateResourceRecordResponse, err error) {
	response = CreateCreateResourceRecordResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourceRecordWithChan invokes the dnsknocker.CreateResourceRecord API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/createresourcerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateResourceRecordWithChan(request *CreateResourceRecordRequest) (<-chan *CreateResourceRecordResponse, <-chan error) {
	responseChan := make(chan *CreateResourceRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourceRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourceRecordWithCallback invokes the dnsknocker.CreateResourceRecord API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/createresourcerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateResourceRecordWithCallback(request *CreateResourceRecordRequest, callback func(response *CreateResourceRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourceRecordResponse
		var err error
		defer close(result)
		response, err = client.CreateResourceRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourceRecordRequest is the request struct for api CreateResourceRecord
type CreateResourceRecordRequest struct {
	*requests.RpcRequest
	AccessID      string `position:"Body" name:"AccessID"`
	RrTTL         string `position:"Body" name:"RrTTL"`
	AccessSecret  string `position:"Body" name:"AccessSecret"`
	RrLine        string `position:"Body" name:"RrLine"`
	DomainName    string `position:"Body" name:"DomainName"`
	RrValue       string `position:"Body" name:"RrValue"`
	ZoneName      string `position:"Body" name:"ZoneName"`
	TransactionId string `position:"Body" name:"TransactionId"`
	Group         string `position:"Body" name:"Group"`
	RrType        string `position:"Body" name:"RrType"`
}

// CreateResourceRecordResponse is the response struct for api CreateResourceRecord
type CreateResourceRecordResponse struct {
	*responses.BaseResponse
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	Success       string `json:"Success" xml:"Success"`
	TransactionId string `json:"TransactionId" xml:"TransactionId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateResourceRecordRequest creates a request to invoke CreateResourceRecord API
func CreateCreateResourceRecordRequest() (request *CreateResourceRecordRequest) {
	request = &CreateResourceRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DnsKnocker", "2019-09-10", "CreateResourceRecord", "dns_knocker", "openAPI")
	return
}

// CreateCreateResourceRecordResponse creates a response to parse from CreateResourceRecord response
func CreateCreateResourceRecordResponse() (response *CreateResourceRecordResponse) {
	response = &CreateResourceRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
