package dnsknocker

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceRecords invokes the dnsknocker.DeleteResourceRecords API synchronously
// api document: https://help.aliyun.com/api/dnsknocker/deleteresourcerecords.html
func (client *Client) DeleteResourceRecords(request *DeleteResourceRecordsRequest) (response *DeleteResourceRecordsResponse, err error) {
	response = CreateDeleteResourceRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceRecordsWithChan invokes the dnsknocker.DeleteResourceRecords API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/deleteresourcerecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourceRecordsWithChan(request *DeleteResourceRecordsRequest) (<-chan *DeleteResourceRecordsResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceRecordsWithCallback invokes the dnsknocker.DeleteResourceRecords API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/deleteresourcerecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourceRecordsWithCallback(request *DeleteResourceRecordsRequest, callback func(response *DeleteResourceRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceRecordsResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceRecordsRequest is the request struct for api DeleteResourceRecords
type DeleteResourceRecordsRequest struct {
	*requests.RpcRequest
	AccessID      string `position:"Body" name:"AccessID"`
	AccessSecret  string `position:"Body" name:"AccessSecret"`
	TypeList      string `position:"Body" name:"TypeList"`
	Line          string `position:"Body" name:"Line"`
	DomainName    string `position:"Body" name:"DomainName"`
	ZoneName      string `position:"Body" name:"ZoneName"`
	TransactionId string `position:"Body" name:"TransactionId"`
	Group         string `position:"Body" name:"Group"`
}

// DeleteResourceRecordsResponse is the response struct for api DeleteResourceRecords
type DeleteResourceRecordsResponse struct {
	*responses.BaseResponse
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	Success       string `json:"Success" xml:"Success"`
	TransactionId string `json:"TransactionId" xml:"TransactionId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResourceRecordsRequest creates a request to invoke DeleteResourceRecords API
func CreateDeleteResourceRecordsRequest() (request *DeleteResourceRecordsRequest) {
	request = &DeleteResourceRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DnsKnocker", "2019-09-10", "DeleteResourceRecords", "dns_knocker", "openAPI")
	return
}

// CreateDeleteResourceRecordsResponse creates a response to parse from DeleteResourceRecords response
func CreateDeleteResourceRecordsResponse() (response *DeleteResourceRecordsResponse) {
	response = &DeleteResourceRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
