package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeAccountPassword invokes the drds.ChangeAccountPassword API synchronously
// api document: https://help.aliyun.com/api/drds/changeaccountpassword.html
func (client *Client) ChangeAccountPassword(request *ChangeAccountPasswordRequest) (response *ChangeAccountPasswordResponse, err error) {
	response = CreateChangeAccountPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeAccountPasswordWithChan invokes the drds.ChangeAccountPassword API asynchronously
// api document: https://help.aliyun.com/api/drds/changeaccountpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeAccountPasswordWithChan(request *ChangeAccountPasswordRequest) (<-chan *ChangeAccountPasswordResponse, <-chan error) {
	responseChan := make(chan *ChangeAccountPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeAccountPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeAccountPasswordWithCallback invokes the drds.ChangeAccountPassword API asynchronously
// api document: https://help.aliyun.com/api/drds/changeaccountpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeAccountPasswordWithCallback(request *ChangeAccountPasswordRequest, callback func(response *ChangeAccountPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeAccountPasswordResponse
		var err error
		defer close(result)
		response, err = client.ChangeAccountPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeAccountPasswordRequest is the request struct for api ChangeAccountPassword
type ChangeAccountPasswordRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	Password       string `position:"Query" name:"Password"`
	AccountName    string `position:"Query" name:"AccountName"`
}

// ChangeAccountPasswordResponse is the response struct for api ChangeAccountPassword
type ChangeAccountPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateChangeAccountPasswordRequest creates a request to invoke ChangeAccountPassword API
func CreateChangeAccountPasswordRequest() (request *ChangeAccountPasswordRequest) {
	request = &ChangeAccountPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "ChangeAccountPassword", "Drds", "openAPI")
	return
}

// CreateChangeAccountPasswordResponse creates a response to parse from ChangeAccountPassword response
func CreateChangeAccountPasswordResponse() (response *ChangeAccountPasswordResponse) {
	response = &ChangeAccountPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
