package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckNewTableNameValid invokes the drds.CheckNewTableNameValid API synchronously
// api document: https://help.aliyun.com/api/drds/checknewtablenamevalid.html
func (client *Client) CheckNewTableNameValid(request *CheckNewTableNameValidRequest) (response *CheckNewTableNameValidResponse, err error) {
	response = CreateCheckNewTableNameValidResponse()
	err = client.DoAction(request, response)
	return
}

// CheckNewTableNameValidWithChan invokes the drds.CheckNewTableNameValid API asynchronously
// api document: https://help.aliyun.com/api/drds/checknewtablenamevalid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckNewTableNameValidWithChan(request *CheckNewTableNameValidRequest) (<-chan *CheckNewTableNameValidResponse, <-chan error) {
	responseChan := make(chan *CheckNewTableNameValidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckNewTableNameValid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckNewTableNameValidWithCallback invokes the drds.CheckNewTableNameValid API asynchronously
// api document: https://help.aliyun.com/api/drds/checknewtablenamevalid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckNewTableNameValidWithCallback(request *CheckNewTableNameValidRequest, callback func(response *CheckNewTableNameValidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckNewTableNameValidResponse
		var err error
		defer close(result)
		response, err = client.CheckNewTableNameValid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckNewTableNameValidRequest is the request struct for api CheckNewTableNameValid
type CheckNewTableNameValidRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
	TableName      string `position:"Query" name:"TableName"`
}

// CheckNewTableNameValidResponse is the response struct for api CheckNewTableNameValid
type CheckNewTableNameValidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCheckNewTableNameValidRequest creates a request to invoke CheckNewTableNameValid API
func CreateCheckNewTableNameValidRequest() (request *CheckNewTableNameValidRequest) {
	request = &CheckNewTableNameValidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "CheckNewTableNameValid", "Drds", "openAPI")
	return
}

// CreateCheckNewTableNameValidResponse creates a response to parse from CheckNewTableNameValid response
func CreateCheckNewTableNameValidResponse() (response *CheckNewTableNameValidResponse) {
	response = &CheckNewTableNameValidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
