package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupLocal invokes the drds.DescribeBackupLocal API synchronously
// api document: https://help.aliyun.com/api/drds/describebackuplocal.html
func (client *Client) DescribeBackupLocal(request *DescribeBackupLocalRequest) (response *DescribeBackupLocalResponse, err error) {
	response = CreateDescribeBackupLocalResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupLocalWithChan invokes the drds.DescribeBackupLocal API asynchronously
// api document: https://help.aliyun.com/api/drds/describebackuplocal.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBackupLocalWithChan(request *DescribeBackupLocalRequest) (<-chan *DescribeBackupLocalResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupLocalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupLocal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupLocalWithCallback invokes the drds.DescribeBackupLocal API asynchronously
// api document: https://help.aliyun.com/api/drds/describebackuplocal.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBackupLocalWithCallback(request *DescribeBackupLocalRequest, callback func(response *DescribeBackupLocalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupLocalResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupLocal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupLocalRequest is the request struct for api DescribeBackupLocal
type DescribeBackupLocalRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeBackupLocalResponse is the response struct for api DescribeBackupLocal
type DescribeBackupLocalResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	BackupPolicyDO BackupPolicyDO `json:"BackupPolicyDO" xml:"BackupPolicyDO"`
}

// CreateDescribeBackupLocalRequest creates a request to invoke DescribeBackupLocal API
func CreateDescribeBackupLocalRequest() (request *DescribeBackupLocalRequest) {
	request = &DescribeBackupLocalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeBackupLocal", "Drds", "openAPI")
	return
}

// CreateDescribeBackupLocalResponse creates a response to parse from DescribeBackupLocal response
func CreateDescribeBackupLocalResponse() (response *DescribeBackupLocalResponse) {
	response = &DescribeBackupLocalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
