package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGlobalBroadcastType invokes the drds.DescribeGlobalBroadcastType API synchronously
// api document: https://help.aliyun.com/api/drds/describeglobalbroadcasttype.html
func (client *Client) DescribeGlobalBroadcastType(request *DescribeGlobalBroadcastTypeRequest) (response *DescribeGlobalBroadcastTypeResponse, err error) {
	response = CreateDescribeGlobalBroadcastTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGlobalBroadcastTypeWithChan invokes the drds.DescribeGlobalBroadcastType API asynchronously
// api document: https://help.aliyun.com/api/drds/describeglobalbroadcasttype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGlobalBroadcastTypeWithChan(request *DescribeGlobalBroadcastTypeRequest) (<-chan *DescribeGlobalBroadcastTypeResponse, <-chan error) {
	responseChan := make(chan *DescribeGlobalBroadcastTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGlobalBroadcastType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGlobalBroadcastTypeWithCallback invokes the drds.DescribeGlobalBroadcastType API asynchronously
// api document: https://help.aliyun.com/api/drds/describeglobalbroadcasttype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGlobalBroadcastTypeWithCallback(request *DescribeGlobalBroadcastTypeRequest, callback func(response *DescribeGlobalBroadcastTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGlobalBroadcastTypeResponse
		var err error
		defer close(result)
		response, err = client.DescribeGlobalBroadcastType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGlobalBroadcastTypeRequest is the request struct for api DescribeGlobalBroadcastType
type DescribeGlobalBroadcastTypeRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// DescribeGlobalBroadcastTypeResponse is the response struct for api DescribeGlobalBroadcastType
type DescribeGlobalBroadcastTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeGlobalBroadcastTypeRequest creates a request to invoke DescribeGlobalBroadcastType API
func CreateDescribeGlobalBroadcastTypeRequest() (request *DescribeGlobalBroadcastTypeRequest) {
	request = &DescribeGlobalBroadcastTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeGlobalBroadcastType", "Drds", "openAPI")
	return
}

// CreateDescribeGlobalBroadcastTypeResponse creates a response to parse from DescribeGlobalBroadcastType response
func CreateDescribeGlobalBroadcastTypeResponse() (response *DescribeGlobalBroadcastTypeResponse) {
	response = &DescribeGlobalBroadcastTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
