package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTableListByType invokes the drds.DescribeTableListByType API synchronously
// api document: https://help.aliyun.com/api/drds/describetablelistbytype.html
func (client *Client) DescribeTableListByType(request *DescribeTableListByTypeRequest) (response *DescribeTableListByTypeResponse, err error) {
	response = CreateDescribeTableListByTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTableListByTypeWithChan invokes the drds.DescribeTableListByType API asynchronously
// api document: https://help.aliyun.com/api/drds/describetablelistbytype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTableListByTypeWithChan(request *DescribeTableListByTypeRequest) (<-chan *DescribeTableListByTypeResponse, <-chan error) {
	responseChan := make(chan *DescribeTableListByTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTableListByType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTableListByTypeWithCallback invokes the drds.DescribeTableListByType API asynchronously
// api document: https://help.aliyun.com/api/drds/describetablelistbytype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTableListByTypeWithCallback(request *DescribeTableListByTypeRequest, callback func(response *DescribeTableListByTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTableListByTypeResponse
		var err error
		defer close(result)
		response, err = client.DescribeTableListByType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTableListByTypeRequest is the request struct for api DescribeTableListByType
type DescribeTableListByTypeRequest struct {
	*requests.RpcRequest
	TableType      string           `position:"Query" name:"TableType"`
	Query          string           `position:"Query" name:"Query"`
	CurrentPage    requests.Integer `position:"Query" name:"CurrentPage"`
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	DbName         string           `position:"Query" name:"DbName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeTableListByTypeResponse is the response struct for api DescribeTableListByType
type DescribeTableListByTypeResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Success    bool       `json:"Success" xml:"Success"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	Total      int        `json:"Total" xml:"Total"`
	List       []ListItem `json:"List" xml:"List"`
}

// CreateDescribeTableListByTypeRequest creates a request to invoke DescribeTableListByType API
func CreateDescribeTableListByTypeRequest() (request *DescribeTableListByTypeRequest) {
	request = &DescribeTableListByTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeTableListByType", "Drds", "openAPI")
	return
}

// CreateDescribeTableListByTypeResponse creates a response to parse from DescribeTableListByType response
func CreateDescribeTableListByTypeResponse() (response *DescribeTableListByTypeResponse) {
	response = &DescribeTableListByTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
