package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTableShardingInfo invokes the drds.DescribeTableShardingInfo API synchronously
// api document: https://help.aliyun.com/api/drds/describetableshardinginfo.html
func (client *Client) DescribeTableShardingInfo(request *DescribeTableShardingInfoRequest) (response *DescribeTableShardingInfoResponse, err error) {
	response = CreateDescribeTableShardingInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTableShardingInfoWithChan invokes the drds.DescribeTableShardingInfo API asynchronously
// api document: https://help.aliyun.com/api/drds/describetableshardinginfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTableShardingInfoWithChan(request *DescribeTableShardingInfoRequest) (<-chan *DescribeTableShardingInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeTableShardingInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTableShardingInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTableShardingInfoWithCallback invokes the drds.DescribeTableShardingInfo API asynchronously
// api document: https://help.aliyun.com/api/drds/describetableshardinginfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTableShardingInfoWithCallback(request *DescribeTableShardingInfoRequest, callback func(response *DescribeTableShardingInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTableShardingInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeTableShardingInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTableShardingInfoRequest is the request struct for api DescribeTableShardingInfo
type DescribeTableShardingInfoRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
	TableName      string `position:"Query" name:"TableName"`
}

// DescribeTableShardingInfoResponse is the response struct for api DescribeTableShardingInfo
type DescribeTableShardingInfoResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   bool                            `json:"Success" xml:"Success"`
	Data      DataInDescribeTableShardingInfo `json:"Data" xml:"Data"`
}

// CreateDescribeTableShardingInfoRequest creates a request to invoke DescribeTableShardingInfo API
func CreateDescribeTableShardingInfoRequest() (request *DescribeTableShardingInfoRequest) {
	request = &DescribeTableShardingInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeTableShardingInfo", "Drds", "openAPI")
	return
}

// CreateDescribeTableShardingInfoResponse creates a response to parse from DescribeTableShardingInfo response
func CreateDescribeTableShardingInfoResponse() (response *DescribeTableShardingInfoResponse) {
	response = &DescribeTableShardingInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
