package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveDataImportTask invokes the drds.RemoveDataImportTask API synchronously
// api document: https://help.aliyun.com/api/drds/removedataimporttask.html
func (client *Client) RemoveDataImportTask(request *RemoveDataImportTaskRequest) (response *RemoveDataImportTaskResponse, err error) {
	response = CreateRemoveDataImportTaskResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveDataImportTaskWithChan invokes the drds.RemoveDataImportTask API asynchronously
// api document: https://help.aliyun.com/api/drds/removedataimporttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveDataImportTaskWithChan(request *RemoveDataImportTaskRequest) (<-chan *RemoveDataImportTaskResponse, <-chan error) {
	responseChan := make(chan *RemoveDataImportTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveDataImportTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveDataImportTaskWithCallback invokes the drds.RemoveDataImportTask API asynchronously
// api document: https://help.aliyun.com/api/drds/removedataimporttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveDataImportTaskWithCallback(request *RemoveDataImportTaskRequest, callback func(response *RemoveDataImportTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveDataImportTaskResponse
		var err error
		defer close(result)
		response, err = client.RemoveDataImportTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveDataImportTaskRequest is the request struct for api RemoveDataImportTask
type RemoveDataImportTaskRequest struct {
	*requests.RpcRequest
	TaskId requests.Integer `position:"Query" name:"TaskId"`
}

// RemoveDataImportTaskResponse is the response struct for api RemoveDataImportTask
type RemoveDataImportTaskResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Success          bool             `json:"Success" xml:"Success"`
	TaskManageResult TaskManageResult `json:"TaskManageResult" xml:"TaskManageResult"`
}

// CreateRemoveDataImportTaskRequest creates a request to invoke RemoveDataImportTask API
func CreateRemoveDataImportTaskRequest() (request *RemoveDataImportTaskRequest) {
	request = &RemoveDataImportTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "RemoveDataImportTask", "Drds", "openAPI")
	return
}

// CreateRemoveDataImportTaskResponse creates a response to parse from RemoveDataImportTask response
func CreateRemoveDataImportTaskResponse() (response *RemoveDataImportTaskResponse) {
	response = &RemoveDataImportTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
