package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetupBroadcastTables invokes the drds.SetupBroadcastTables API synchronously
// api document: https://help.aliyun.com/api/drds/setupbroadcasttables.html
func (client *Client) SetupBroadcastTables(request *SetupBroadcastTablesRequest) (response *SetupBroadcastTablesResponse, err error) {
	response = CreateSetupBroadcastTablesResponse()
	err = client.DoAction(request, response)
	return
}

// SetupBroadcastTablesWithChan invokes the drds.SetupBroadcastTables API asynchronously
// api document: https://help.aliyun.com/api/drds/setupbroadcasttables.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetupBroadcastTablesWithChan(request *SetupBroadcastTablesRequest) (<-chan *SetupBroadcastTablesResponse, <-chan error) {
	responseChan := make(chan *SetupBroadcastTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetupBroadcastTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetupBroadcastTablesWithCallback invokes the drds.SetupBroadcastTables API asynchronously
// api document: https://help.aliyun.com/api/drds/setupbroadcasttables.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetupBroadcastTablesWithCallback(request *SetupBroadcastTablesRequest, callback func(response *SetupBroadcastTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetupBroadcastTablesResponse
		var err error
		defer close(result)
		response, err = client.SetupBroadcastTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetupBroadcastTablesRequest is the request struct for api SetupBroadcastTables
type SetupBroadcastTablesRequest struct {
	*requests.RpcRequest
	Active         requests.Boolean `position:"Query" name:"Active"`
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	DbName         string           `position:"Query" name:"DbName"`
	TableName      *[]string        `position:"Query" name:"TableName"  type:"Repeated"`
}

// SetupBroadcastTablesResponse is the response struct for api SetupBroadcastTables
type SetupBroadcastTablesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSetupBroadcastTablesRequest creates a request to invoke SetupBroadcastTables API
func CreateSetupBroadcastTablesRequest() (request *SetupBroadcastTablesRequest) {
	request = &SetupBroadcastTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SetupBroadcastTables", "Drds", "openAPI")
	return
}

// CreateSetupBroadcastTablesResponse creates a response to parse from SetupBroadcastTables response
func CreateSetupBroadcastTablesResponse() (response *SetupBroadcastTablesResponse) {
	response = &SetupBroadcastTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
