package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SqlCompatibilityCancel invokes the drds.SqlCompatibilityCancel API synchronously
// api document: https://help.aliyun.com/api/drds/sqlcompatibilitycancel.html
func (client *Client) SqlCompatibilityCancel(request *SqlCompatibilityCancelRequest) (response *SqlCompatibilityCancelResponse, err error) {
	response = CreateSqlCompatibilityCancelResponse()
	err = client.DoAction(request, response)
	return
}

// SqlCompatibilityCancelWithChan invokes the drds.SqlCompatibilityCancel API asynchronously
// api document: https://help.aliyun.com/api/drds/sqlcompatibilitycancel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SqlCompatibilityCancelWithChan(request *SqlCompatibilityCancelRequest) (<-chan *SqlCompatibilityCancelResponse, <-chan error) {
	responseChan := make(chan *SqlCompatibilityCancelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SqlCompatibilityCancel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SqlCompatibilityCancelWithCallback invokes the drds.SqlCompatibilityCancel API asynchronously
// api document: https://help.aliyun.com/api/drds/sqlcompatibilitycancel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SqlCompatibilityCancelWithCallback(request *SqlCompatibilityCancelRequest, callback func(response *SqlCompatibilityCancelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SqlCompatibilityCancelResponse
		var err error
		defer close(result)
		response, err = client.SqlCompatibilityCancel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SqlCompatibilityCancelRequest is the request struct for api SqlCompatibilityCancel
type SqlCompatibilityCancelRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	TaskId         requests.Integer `position:"Query" name:"TaskId"`
}

// SqlCompatibilityCancelResponse is the response struct for api SqlCompatibilityCancel
type SqlCompatibilityCancelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSqlCompatibilityCancelRequest creates a request to invoke SqlCompatibilityCancel API
func CreateSqlCompatibilityCancelRequest() (request *SqlCompatibilityCancelRequest) {
	request = &SqlCompatibilityCancelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SqlCompatibilityCancel", "Drds", "openAPI")
	return
}

// CreateSqlCompatibilityCancelResponse creates a response to parse from SqlCompatibilityCancel response
func CreateSqlCompatibilityCancelResponse() (response *SqlCompatibilityCancelResponse) {
	response = &SqlCompatibilityCancelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
