package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAxgGroup invokes the dyplsapi.CreateAxgGroup API synchronously
// api document: https://help.aliyun.com/api/dyplsapi/createaxggroup.html
func (client *Client) CreateAxgGroup(request *CreateAxgGroupRequest) (response *CreateAxgGroupResponse, err error) {
	response = CreateCreateAxgGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAxgGroupWithChan invokes the dyplsapi.CreateAxgGroup API asynchronously
// api document: https://help.aliyun.com/api/dyplsapi/createaxggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAxgGroupWithChan(request *CreateAxgGroupRequest) (<-chan *CreateAxgGroupResponse, <-chan error) {
	responseChan := make(chan *CreateAxgGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAxgGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAxgGroupWithCallback invokes the dyplsapi.CreateAxgGroup API asynchronously
// api document: https://help.aliyun.com/api/dyplsapi/createaxggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAxgGroupWithCallback(request *CreateAxgGroupRequest, callback func(response *CreateAxgGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAxgGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateAxgGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAxgGroupRequest is the request struct for api CreateAxgGroup
type CreateAxgGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Numbers              string           `position:"Query" name:"Numbers"`
	Remark               string           `position:"Query" name:"Remark"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateAxgGroupResponse is the response struct for api CreateAxgGroup
type CreateAxgGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	GroupId   int64  `json:"GroupId" xml:"GroupId"`
}

// CreateCreateAxgGroupRequest creates a request to invoke CreateAxgGroup API
func CreateCreateAxgGroupRequest() (request *CreateAxgGroupRequest) {
	request = &CreateAxgGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "CreateAxgGroup", "dypls", "openAPI")
	return
}

// CreateCreateAxgGroupResponse creates a response to parse from CreateAxgGroup response
func CreateCreateAxgGroupResponse() (response *CreateAxgGroupResponse) {
	response = &CreateAxgGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
