package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRobotv2AllList invokes the dyvmsapi.QueryRobotv2AllList API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/queryrobotv2alllist.html
func (client *Client) QueryRobotv2AllList(request *QueryRobotv2AllListRequest) (response *QueryRobotv2AllListResponse, err error) {
	response = CreateQueryRobotv2AllListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRobotv2AllListWithChan invokes the dyvmsapi.QueryRobotv2AllList API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/queryrobotv2alllist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRobotv2AllListWithChan(request *QueryRobotv2AllListRequest) (<-chan *QueryRobotv2AllListResponse, <-chan error) {
	responseChan := make(chan *QueryRobotv2AllListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRobotv2AllList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRobotv2AllListWithCallback invokes the dyvmsapi.QueryRobotv2AllList API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/queryrobotv2alllist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRobotv2AllListWithCallback(request *QueryRobotv2AllListRequest, callback func(response *QueryRobotv2AllListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRobotv2AllListResponse
		var err error
		defer close(result)
		response, err = client.QueryRobotv2AllList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRobotv2AllListRequest is the request struct for api QueryRobotv2AllList
type QueryRobotv2AllListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryRobotv2AllListResponse is the response struct for api QueryRobotv2AllList
type QueryRobotv2AllListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateQueryRobotv2AllListRequest creates a request to invoke QueryRobotv2AllList API
func CreateQueryRobotv2AllListRequest() (request *QueryRobotv2AllListRequest) {
	request = &QueryRobotv2AllListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "QueryRobotv2AllList", "dyvms", "openAPI")
	return
}

// CreateQueryRobotv2AllListResponse creates a response to parse from QueryRobotv2AllList response
func CreateQueryRobotv2AllListResponse() (response *QueryRobotv2AllListResponse) {
	response = &QueryRobotv2AllListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
