package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartRobotTask invokes the dyvmsapi.StartRobotTask API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/startrobottask.html
func (client *Client) StartRobotTask(request *StartRobotTaskRequest) (response *StartRobotTaskResponse, err error) {
	response = CreateStartRobotTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StartRobotTaskWithChan invokes the dyvmsapi.StartRobotTask API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/startrobottask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartRobotTaskWithChan(request *StartRobotTaskRequest) (<-chan *StartRobotTaskResponse, <-chan error) {
	responseChan := make(chan *StartRobotTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartRobotTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartRobotTaskWithCallback invokes the dyvmsapi.StartRobotTask API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/startrobottask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartRobotTaskWithCallback(request *StartRobotTaskRequest, callback func(response *StartRobotTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartRobotTaskResponse
		var err error
		defer close(result)
		response, err = client.StartRobotTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartRobotTaskRequest is the request struct for api StartRobotTask
type StartRobotTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ScheduleTime         string           `position:"Query" name:"ScheduleTime"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
}

// StartRobotTaskResponse is the response struct for api StartRobotTask
type StartRobotTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateStartRobotTaskRequest creates a request to invoke StartRobotTask API
func CreateStartRobotTaskRequest() (request *StartRobotTaskRequest) {
	request = &StartRobotTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "StartRobotTask", "dyvms", "openAPI")
	return
}

// CreateStartRobotTaskResponse creates a response to parse from StartRobotTask response
func CreateStartRobotTaskResponse() (response *StartRobotTaskResponse) {
	response = &StartRobotTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
