package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDegradeControl invokes the edas.DeleteDegradeControl API synchronously
// api document: https://help.aliyun.com/api/edas/deletedegradecontrol.html
func (client *Client) DeleteDegradeControl(request *DeleteDegradeControlRequest) (response *DeleteDegradeControlResponse, err error) {
	response = CreateDeleteDegradeControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDegradeControlWithChan invokes the edas.DeleteDegradeControl API asynchronously
// api document: https://help.aliyun.com/api/edas/deletedegradecontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDegradeControlWithChan(request *DeleteDegradeControlRequest) (<-chan *DeleteDegradeControlResponse, <-chan error) {
	responseChan := make(chan *DeleteDegradeControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDegradeControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDegradeControlWithCallback invokes the edas.DeleteDegradeControl API asynchronously
// api document: https://help.aliyun.com/api/edas/deletedegradecontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDegradeControlWithCallback(request *DeleteDegradeControlRequest, callback func(response *DeleteDegradeControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDegradeControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteDegradeControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDegradeControlRequest is the request struct for api DeleteDegradeControl
type DeleteDegradeControlRequest struct {
	*requests.RoaRequest
	AppId  string `position:"Query" name:"AppId"`
	RuleId string `position:"Query" name:"RuleId"`
}

// DeleteDegradeControlResponse is the response struct for api DeleteDegradeControl
type DeleteDegradeControlResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDegradeControlRequest creates a request to invoke DeleteDegradeControl API
func CreateDeleteDegradeControlRequest() (request *DeleteDegradeControlRequest) {
	request = &DeleteDegradeControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteDegradeControl", "/pop/v5/degradeControl", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteDegradeControlResponse creates a response to parse from DeleteDegradeControl response
func CreateDeleteDegradeControlResponse() (response *DeleteDegradeControlResponse) {
	response = &DeleteDegradeControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
