package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDeployGroup invokes the edas.DeleteDeployGroup API synchronously
// api document: https://help.aliyun.com/api/edas/deletedeploygroup.html
func (client *Client) DeleteDeployGroup(request *DeleteDeployGroupRequest) (response *DeleteDeployGroupResponse, err error) {
	response = CreateDeleteDeployGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDeployGroupWithChan invokes the edas.DeleteDeployGroup API asynchronously
// api document: https://help.aliyun.com/api/edas/deletedeploygroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDeployGroupWithChan(request *DeleteDeployGroupRequest) (<-chan *DeleteDeployGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteDeployGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDeployGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDeployGroupWithCallback invokes the edas.DeleteDeployGroup API asynchronously
// api document: https://help.aliyun.com/api/edas/deletedeploygroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDeployGroupWithCallback(request *DeleteDeployGroupRequest, callback func(response *DeleteDeployGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDeployGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteDeployGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDeployGroupRequest is the request struct for api DeleteDeployGroup
type DeleteDeployGroupRequest struct {
	*requests.RoaRequest
	AppId     string `position:"Query" name:"AppId"`
	GroupName string `position:"Query" name:"GroupName"`
}

// DeleteDeployGroupResponse is the response struct for api DeleteDeployGroup
type DeleteDeployGroupResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDeployGroupRequest creates a request to invoke DeleteDeployGroup API
func CreateDeleteDeployGroupRequest() (request *DeleteDeployGroupRequest) {
	request = &DeleteDeployGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteDeployGroup", "/pop/v5/deploy_group", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteDeployGroupResponse creates a response to parse from DeleteDeployGroup response
func CreateDeleteDeployGroupResponse() (response *DeleteDeployGroupResponse) {
	response = &DeleteDeployGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
