package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllNode invokes the elasticsearch.ListAllNode API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/listallnode.html
func (client *Client) ListAllNode(request *ListAllNodeRequest) (response *ListAllNodeResponse, err error) {
	response = CreateListAllNodeResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllNodeWithChan invokes the elasticsearch.ListAllNode API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/listallnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAllNodeWithChan(request *ListAllNodeRequest) (<-chan *ListAllNodeResponse, <-chan error) {
	responseChan := make(chan *ListAllNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllNodeWithCallback invokes the elasticsearch.ListAllNode API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/listallnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAllNodeWithCallback(request *ListAllNodeRequest, callback func(response *ListAllNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllNodeResponse
		var err error
		defer close(result)
		response, err = client.ListAllNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllNodeRequest is the request struct for api ListAllNode
type ListAllNodeRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListAllNodeResponse is the response struct for api ListAllNode
type ListAllNodeResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListAllNodeRequest creates a request to invoke ListAllNode API
func CreateListAllNodeRequest() (request *ListAllNodeRequest) {
	request = &ListAllNodeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListAllNode", "/openapi/instances/[InstanceId]/nodes", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAllNodeResponse creates a response to parse from ListAllNode response
func CreateListAllNodeResponse() (response *ListAllNodeResponse) {
	response = &ListAllNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
