package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UninstallLogstashPlugin invokes the elasticsearch.UninstallLogstashPlugin API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/uninstalllogstashplugin.html
func (client *Client) UninstallLogstashPlugin(request *UninstallLogstashPluginRequest) (response *UninstallLogstashPluginResponse, err error) {
	response = CreateUninstallLogstashPluginResponse()
	err = client.DoAction(request, response)
	return
}

// UninstallLogstashPluginWithChan invokes the elasticsearch.UninstallLogstashPlugin API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/uninstalllogstashplugin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UninstallLogstashPluginWithChan(request *UninstallLogstashPluginRequest) (<-chan *UninstallLogstashPluginResponse, <-chan error) {
	responseChan := make(chan *UninstallLogstashPluginResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UninstallLogstashPlugin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UninstallLogstashPluginWithCallback invokes the elasticsearch.UninstallLogstashPlugin API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/uninstalllogstashplugin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UninstallLogstashPluginWithCallback(request *UninstallLogstashPluginRequest, callback func(response *UninstallLogstashPluginResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UninstallLogstashPluginResponse
		var err error
		defer close(result)
		response, err = client.UninstallLogstashPlugin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UninstallLogstashPluginRequest is the request struct for api UninstallLogstashPlugin
type UninstallLogstashPluginRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// UninstallLogstashPluginResponse is the response struct for api UninstallLogstashPlugin
type UninstallLogstashPluginResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Result    []string `json:"Result" xml:"Result"`
}

// CreateUninstallLogstashPluginRequest creates a request to invoke UninstallLogstashPlugin API
func CreateUninstallLogstashPluginRequest() (request *UninstallLogstashPluginRequest) {
	request = &UninstallLogstashPluginRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UninstallLogstashPlugin", "/openapi/logstashes/[InstanceId]/plugins/actions/uninstall", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUninstallLogstashPluginResponse creates a response to parse from UninstallLogstashPlugin response
func CreateUninstallLogstashPluginResponse() (response *UninstallLogstashPluginResponse) {
	response = &UninstallLogstashPluginResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
